/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.net.URL;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IResourceKeyDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class TemplateDescriptorProvider
extends AbstractDescriptorProvider
implements IResourceKeyDescriptorProvider {
    private Object input;

    @Override
    public String getBrowseText() {
        return Messages.getString((String)"ResourceKeyDescriptor.text.Browse");
    }

    @Override
    public String getResetText() {
        return Messages.getString((String)"ResourceKeyDescriptor.text.Reset");
    }

    @Override
    public boolean isEnable() {
        return DEUtil.getInputSize((Object)this.input) <= 1;
    }

    @Override
    public String getDisplayName() {
        return Messages.getString((String)"TemplateReportItemPageGenerator.List.TextKey");
    }

    @Override
    public Object load() {
        String key = "";
        if (DEUtil.getInputSize((Object)this.input) == 1 && DEUtil.getInputFirstElement((Object)this.input) instanceof TemplateReportItemHandle) {
            TemplateReportItemHandle handle = (TemplateReportItemHandle)DEUtil.getInputFirstElement((Object)this.input);
            key = handle.getDescriptionKey() == null ? "" : handle.getDescriptionKey().trim();
        }
        return key;
    }

    @Override
    public void save(Object value) throws SemanticException {
        TemplateReportItemHandle handle;
        if (DEUtil.getInputSize((Object)this.input) == 1 && DEUtil.getInputFirstElement((Object)this.input) instanceof TemplateReportItemHandle && (handle = (TemplateReportItemHandle)DEUtil.getInputFirstElement((Object)this.input)) != null) {
            String key = null;
            if (value instanceof String) {
                key = value.toString();
            }
            if (handle.getDescriptionKey() != null && handle.getDescriptionKey().equals(value)) {
                return;
            }
            handle.setDescriptionKey(key);
        }
    }

    @Override
    public void setInput(Object input) {
        this.input = input;
    }

    @Override
    public String getBrowseTooltipText() {
        return Messages.getString((String)"ResourceKeyDescriptor.button.browse.tooltip");
    }

    @Override
    public String getResetTooltipText() {
        return Messages.getString((String)"ResourceKeyDescriptor.button.reset.tooltip");
    }

    @Override
    public String[] getBaseNames() {
        List resources = SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResources();
        if (resources == null) {
            return null;
        }
        return resources.toArray(new String[0]);
    }

    @Override
    public URL[] getResourceURLs() {
        String[] baseNames = this.getBaseNames();
        if (baseNames == null) {
            return null;
        }
        URL[] urls = new URL[baseNames.length];
        int i = 0;
        while (i < baseNames.length) {
            urls[i] = SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(baseNames[i], 5);
            ++i;
        }
        return urls;
    }
}

