/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.birt.report.designer.ui.util.PixelConverter;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class LayoutConfigurationBlock
extends OptionsConfigurationBlock {
    private final OptionsConfigurationBlock.Key PREF_DEFAULT_UNIT = this.getReportKey("report.designer.ui.preferences.default.unit");
    private final OptionsConfigurationBlock.Key PREF_DEFAULT_LAYOUT = this.getReportKey("report.designer.ui.preferences.default.layout");
    private final OptionsConfigurationBlock.Key PREF_DEFAULT_ORIENTATION = this.getReportKey("report.designer.ui.preferences.default.orientation");
    private static final String UNIT_AUTO = Messages.getString((String)"LayoutConfigurationBlock.Default.Unit.Auto");
    private static final String DEFAULT_UNIT = Messages.getString((String)"LayoutConfigurationBlock.Default.Unit.Label");
    private static final String DEFAULT_LAYOUT = Messages.getString((String)"LayoutConfigurationBlock.Default.Layout.Label");
    private static final String DEFAULT_ORIENTATION = Messages.getString((String)"LayoutConfigurationBlock.Default.Orientation.Label");
    public final int LTR_DIRECTION_INDX = 0;
    public final int RTL_DIRECTION_INDX = 1;
    private PixelConverter fPixelConverter;

    public LayoutConfigurationBlock(IStatusChangeListener context, IProject project) {
        super(context, ReportPlugin.getDefault(), project);
        this.setKeys(this.getKeys());
    }

    private OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{this.PREF_DEFAULT_UNIT, this.PREF_DEFAULT_LAYOUT, this.PREF_DEFAULT_ORIENTATION};
        return keys;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite othersComposite = this.createBuildPathTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        othersComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createBuildPathTabContent(Composite parent) {
        Composite pageContent = new Composite(parent, 0);
        GridData data = new GridData(1810);
        data.grabExcessHorizontalSpace = true;
        pageContent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        pageContent.setLayout((Layout)layout);
        IChoiceSet unitChoiceSet = ChoiceSetFactory.getElementChoiceSet("ReportDesign", "units");
        int unitChoiceSetLen = unitChoiceSet.getChoices().length;
        String[] unitValues = new String[unitChoiceSetLen + 1];
        String[] unitNames = new String[unitChoiceSetLen + 1];
        unitNames[0] = UNIT_AUTO;
        unitValues[0] = "Auto";
        int i = 0;
        while (i < unitChoiceSetLen) {
            IChoice ch = unitChoiceSet.getChoices()[i];
            unitValues[i + 1] = ch.getName();
            unitNames[i + 1] = ch.getDisplayName();
            ++i;
        }
        this.addComboBox(pageContent, DEFAULT_UNIT, this.PREF_DEFAULT_UNIT, unitValues, unitNames, 0);
        IChoiceSet layoutChoiceSet = ChoiceSetFactory.getElementChoiceSet("ReportDesign", "layoutPreference");
        int layoutChoiceSetLen = layoutChoiceSet.getChoices().length;
        String[] layoutValues = new String[layoutChoiceSetLen];
        String[] layoutNames = new String[layoutChoiceSetLen];
        int i2 = 0;
        while (i2 < layoutChoiceSetLen) {
            IChoice ch = layoutChoiceSet.getChoices()[i2];
            layoutValues[i2] = ch.getName();
            layoutNames[i2] = ch.getDisplayName();
            ++i2;
        }
        this.addComboBox(pageContent, DEFAULT_LAYOUT, this.PREF_DEFAULT_LAYOUT, layoutValues, layoutNames, 0);
        IChoiceSet orientationChoiceSet = ChoiceSetFactory.getElementChoiceSet("MasterPage", "orientation");
        int orientationChoiceSetLen = orientationChoiceSet.getChoices().length;
        String[] orientationValues = new String[orientationChoiceSetLen];
        String[] orientationNames = new String[orientationChoiceSetLen];
        int i3 = 0;
        while (i3 < orientationChoiceSetLen) {
            IChoice ch = orientationChoiceSet.getChoices()[i3];
            orientationValues[i3] = ch.getName();
            orientationNames[i3] = ch.getDisplayName();
            ++i3;
        }
        this.addComboBox(pageContent, DEFAULT_ORIENTATION, this.PREF_DEFAULT_ORIENTATION, orientationValues, orientationNames, 0);
        return pageContent;
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
    }

    @Override
    public void useProjectSpecificSettings(boolean enable) {
        super.useProjectSpecificSettings(enable);
    }
}

