/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import org.eclipse.birt.report.designer.ui.dialogs.InputParameterDialog;
import org.eclipse.birt.report.designer.ui.dialogs.SelectionParameterControlHelper;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;

class ListParameterControlHelper
extends SelectionParameterControlHelper {
    private ListViewer listViewer;

    @Override
    Control getControl() {
        return this.listViewer.getList();
    }

    public ListParameterControlHelper(InputParameterDialog dialog) {
        super(dialog);
    }

    @Override
    protected void createParameterControl() {
        this.initControlLabelLayout();
        this.createListParamer();
    }

    public void createListParamer() {
        this.createRawListViewer();
        this.initListViewer();
    }

    private void initControlLabelLayout() {
        GridData labelLayout = new GridData(2);
        this.controlLabel.setLayoutData((Object)labelLayout);
    }

    private void createRawListViewer() {
        this.listViewer = new ListViewer(this.parent);
        GridData gd = new GridData(768);
        gd.heightHint = 70;
        this.listViewer.getList().setLayoutData((Object)gd);
        this.listViewer.getList().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                List list = (List)e.getSource();
                String[] strs = list.getSelection();
                if (strs != null && strs.length > 0) {
                    Object[] selectDatas = new Object[strs.length];
                    int i = 0;
                    while (i < strs.length) {
                        selectDatas[i] = list.getData(strs[i]);
                        ++i;
                    }
                    ListParameterControlHelper.this.putConfigValue(ListParameterControlHelper.this.paramterHandleName, selectDatas);
                } else {
                    ListParameterControlHelper.this.removeConfigValue(ListParameterControlHelper.this.paramterHandleName);
                }
                ListParameterControlHelper.this.doWithCascadeGroup();
            }
        });
    }

    private void initListViewer() {
        for (IParameterSelectionChoice choice : this.valueList) {
            String label = this.getFormatLabelString(choice, this.parameter);
            if (label == null) continue;
            this.listViewer.getList().add(label);
            this.listViewer.getList().setData(label, choice.getValue());
            this.addItemForControlReset(label);
        }
        if (this.defaultValue == null && !this.isRequired) {
            this.listViewer.getList().select(this.listViewer.getList().getItemCount() - 1);
        } else {
            this.initListValue(this.defaultValue, this.listViewer.getList(), this.parameter);
        }
        this.addCascadeParamterRelation();
    }
}

