/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.script;

import java.util.Stack;
import org.eclipse.birt.report.designer.internal.ui.script.JSObjectMetaData;
import org.eclipse.birt.report.designer.internal.ui.script.JSSyntaxContext;

public class JSExpression {
    private String expr;
    private int isParsed = -1;
    protected Stack codeStack = new Stack();
    private JSSyntaxContext context;

    public JSExpression(JSSyntaxContext context, String expr) {
        this.context = context;
        this.expr = expr;
    }

    public Object getReturnType() {
        return this.parse();
    }

    private Object parse() {
        Object fragment;
        if (this.expr == null) {
            return null;
        }
        if (this.isParsed < 0) {
            this.parse(this.expr);
        }
        if (this.isParsed == 0) {
            return null;
        }
        JSObjectMetaData objectMeta = null;
        String currentCode = null;
        String preCode = "";
        block2: while (!this.codeStack.isEmpty() && (fragment = this.codeStack.pop()) != null) {
            int i;
            currentCode = (String)fragment;
            if (this.isMethod(currentCode) && objectMeta != null) {
                String methodName = this.getMethodName(currentCode);
                JSObjectMetaData.JSMethod[] methods = objectMeta.getMethods();
                i = 0;
                while (i < methods.length) {
                    if (methods[i].getName().equals(methodName)) {
                        objectMeta = methods[i].getReturn();
                        continue block2;
                    }
                    ++i;
                }
                objectMeta = null;
            } else if (this.isField(currentCode)) {
                if (preCode != null && objectMeta == null) {
                    try {
                        objectMeta = this.getFieldObjectMeta(currentCode, preCode);
                    }
                    catch (ClassNotFoundException e) {
                        objectMeta = null;
                    }
                } else {
                    String fieldName = this.getFieldName(currentCode);
                    JSObjectMetaData.JSField[] fields = objectMeta.getFields();
                    i = 0;
                    while (i < fields.length) {
                        if (fields[i].getName().equals(fieldName)) {
                            objectMeta = fields[i].getType();
                            continue block2;
                        }
                        ++i;
                    }
                    if (!".".equals(currentCode)) {
                        objectMeta = null;
                    }
                }
            } else if (this.isArray(currentCode) && objectMeta != null) {
                objectMeta = objectMeta.getComponentType();
            } else if (objectMeta == null && !".".equals(currentCode)) {
                objectMeta = this.context.getVariableMeta(currentCode);
                if (objectMeta == null) {
                    objectMeta = JSSyntaxContext.getEnginJSObject(currentCode);
                }
                if (objectMeta == null && this.codeStack.isEmpty()) {
                    return JSSyntaxContext.getAllEnginJSObjects();
                }
            }
            preCode = String.valueOf(preCode) + currentCode;
        }
        return objectMeta;
    }

    protected JSObjectMetaData getFieldObjectMeta(String currentCode, String preCode) throws ClassNotFoundException {
        return JSSyntaxContext.getJavaClassMeta(String.valueOf(preCode) + currentCode);
    }

    private boolean isArray(String currentCode) {
        return currentCode.startsWith("[") && currentCode.endsWith("]");
    }

    private String getFieldName(String fieldCode) {
        return fieldCode.substring(1);
    }

    private boolean isField(String currentCode) {
        return currentCode.indexOf(".") == 0 && currentCode.lastIndexOf(")") == -1;
    }

    private boolean isMethod(String currentCode) {
        return currentCode.indexOf(".") == 0 && currentCode.lastIndexOf(")") == currentCode.length() - 1;
    }

    private String getMethodName(String methodCode) {
        return methodCode.substring(1, methodCode.indexOf("("));
    }

    protected void parse(String expression) {
        int endOffset;
        Stack<String> bracketStack = new Stack<String>();
        int startOffset = endOffset = expression.length();
        while (startOffset > 0 && this.isParsed < 1) {
            char currentChar;
            if ((currentChar = this.expr.charAt(--startOffset)) == ')') {
                bracketStack.push(")");
                continue;
            }
            if (currentChar == ']') {
                bracketStack.push("]");
                continue;
            }
            if (currentChar == '(') {
                if (bracketStack.isEmpty()) {
                    this.codeStack.push(expression.substring(++startOffset, endOffset).trim());
                    this.isParsed = 1;
                    return;
                }
                if (bracketStack.pop().equals(")")) continue;
                this.isParsed = 0;
                return;
            }
            if (currentChar == '[') {
                if (bracketStack.size() > 0 && bracketStack.pop().equals("]")) {
                    this.codeStack.push(expression.substring(startOffset, endOffset).trim());
                    endOffset = startOffset;
                    continue;
                }
                this.isParsed = 0;
                return;
            }
            if (currentChar != '.' || !bracketStack.isEmpty()) continue;
            this.codeStack.push(expression.substring(startOffset, endOffset).trim());
            endOffset = startOffset;
        }
        this.codeStack.push(expression.substring(startOffset, endOffset).trim());
        this.isParsed = 1;
    }
}

