/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionButtonProvider;
import org.eclipse.birt.report.designer.internal.ui.expressions.ExpressionSupportManager;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionBuilder;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionSupport;
import org.eclipse.birt.report.designer.internal.ui.script.JSExpressionSupport;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.swt.graphics.Image;

public class ExpressionButtonProvider
implements IExpressionButtonProvider {
    private static final String CONSTANT = Messages.getString((String)"ExpressionButtonProvider.Constant");
    private ExpressionButton input;
    private Map<String, IExpressionSupport> supports = new HashMap<String, IExpressionSupport>();
    private String[] supportedTypes;
    private boolean showLeafOnlyInThirdColumn = false;

    public ExpressionButtonProvider(boolean allowConstant) {
        IExpressionSupport[] exts;
        ArrayList<String> types = new ArrayList<String>();
        if (allowConstant) {
            types.add("constant");
        }
        if ((exts = ExpressionSupportManager.getExpressionSupports()) != null) {
            IExpressionSupport[] iExpressionSupportArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IExpressionSupport ex = iExpressionSupportArray[n2];
                types.add(ex.getName());
                this.supports.put(ex.getName(), ex);
                ++n2;
            }
        }
        this.supportedTypes = types.toArray(new String[types.size()]);
    }

    @Override
    public void setInput(ExpressionButton input) {
        this.input = input;
    }

    @Override
    public String[] getExpressionTypes() {
        return this.supportedTypes;
    }

    @Override
    public Image getImage(String exprType) {
        if ("constant".equals(exprType)) {
            return ReportPlatformUIImages.getImage("Enable Expression Constant");
        }
        IExpressionSupport spt = this.supports.get(exprType);
        if (spt != null) {
            return spt.getImage();
        }
        return null;
    }

    @Override
    public String getText(String exprType) {
        if ("constant".equals(exprType)) {
            return CONSTANT;
        }
        IExpressionSupport spt = this.supports.get(exprType);
        if (spt != null) {
            return spt.getDisplayName();
        }
        return "";
    }

    @Override
    public String getTooltipText(String exprType) {
        return this.getText(exprType);
    }

    @Override
    public void handleSelectionEvent(String exprType) {
        IExpressionSupport spt = this.supports.get(exprType);
        String sOldExpr = this.input.getExpression();
        if (spt != null) {
            IExpressionBuilder builder = null;
            builder = spt instanceof JSExpressionSupport ? ((JSExpressionSupport)spt).createBuilder(this.input.getControl().getShell(), null, this.showLeafOnlyInThirdColumn) : spt.createBuilder(this.input.getControl().getShell(), null);
            if (builder != null) {
                if (this.input.openExpressionBuilder(builder, exprType) == 0) {
                    this.input.notifyExpressionChangeEvent(sOldExpr, this.input.getExpression());
                }
            } else {
                this.input.setExpressionType(exprType);
                this.input.notifyExpressionChangeEvent(sOldExpr, this.input.getExpression());
            }
        } else {
            this.input.setExpressionType(exprType);
            this.input.notifyExpressionChangeEvent(sOldExpr, this.input.getExpression());
        }
    }

    @Override
    public IExpressionSupport getExpressionSupport(String exprType) {
        return this.supports.get(exprType);
    }

    public void setShowLeafOnlyInThirdColumn(boolean leafOnly) {
        this.showLeafOnlyInThirdColumn = leafOnly;
    }
}

