/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatAdapter;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.FormatDateTimePattern;

public final class FormatDateTimeAdapter
extends FormatAdapter {
    private static final String[] DATETIME_FORMAT_TYPES = new String[]{"General Date", "Long Date", "Medium Date", "Short Date", "Long Time", "Medium Time", "Short Time"};
    private static final String[] DATE_FORMAT_TYPES = new String[]{"General Date", "Long Date", "Medium Date", "Short Date"};
    private static final String[] TIME_FORMAT_TYPES = new String[]{"Long Time", "Medium Time", "Short Time"};
    private static String UNFORMATTED_DISPLAYNAME;
    private static String CUSTOM;
    private static String UNFORMATTED_NAME;
    private int type;
    private Date defaultDate = new Date();
    private String[][] categoryChoiceArray = null;
    private String[] formatTypes = null;

    public FormatDateTimeAdapter(int type) {
        this.type = type;
        this.init();
    }

    private void init() {
        switch (this.type) {
            case 3: {
                UNFORMATTED_DISPLAYNAME = "Unformatted";
                CUSTOM = "Custom";
                UNFORMATTED_NAME = "DateTimeUnformatted";
                break;
            }
            case 4: {
                UNFORMATTED_DISPLAYNAME = "Unformatted";
                CUSTOM = "Custom";
                UNFORMATTED_NAME = "DateUnformatted";
                break;
            }
            case 5: {
                UNFORMATTED_DISPLAYNAME = "Unformatted";
                CUSTOM = "Custom";
                UNFORMATTED_NAME = "TimeUnformatted";
            }
        }
    }

    public String[] getSimpleDateTimeFormatTypes() {
        if (this.type == 3) {
            return DATETIME_FORMAT_TYPES;
        }
        if (this.type == 4) {
            return DATE_FORMAT_TYPES;
        }
        if (this.type == 5) {
            return TIME_FORMAT_TYPES;
        }
        return new String[0];
    }

    public String[][] getFormatTypeChoiceSet() {
        String property;
        String structName;
        if (this.type == 3) {
            structName = "DateTimeFormatValue";
            property = "category";
        } else if (this.type == 4) {
            structName = "DateFormatValue";
            property = "category";
        } else {
            structName = "TimeFormatValue";
            property = "category";
        }
        return FormatDateTimeAdapter.getChoiceArray(structName, property);
    }

    @Override
    public String[][] initChoiceArray() {
        if (this.categoryChoiceArray == null) {
            switch (this.type) {
                default: {
                    this.categoryChoiceArray = FormatDateTimeAdapter.getChoiceArray("DateTimeFormatValue", "category");
                    break;
                }
                case 4: {
                    this.categoryChoiceArray = FormatDateTimeAdapter.getChoiceArray("DateFormatValue", "category");
                    break;
                }
                case 5: {
                    this.categoryChoiceArray = FormatDateTimeAdapter.getChoiceArray("TimeFormatValue", "category");
                }
            }
        }
        return this.categoryChoiceArray;
    }

    @Override
    public String getCategory4DisplayName(String displayName) {
        if (this.initChoiceArray() != null) {
            int i = 0;
            while (i < this.categoryChoiceArray.length) {
                if (this.formatTypes[i].equals(displayName)) {
                    return this.categoryChoiceArray[i][1];
                }
                ++i;
            }
        }
        return displayName;
    }

    @Override
    public String getDisplayName4Category(String category) {
        return ChoiceSetFactory.getStructDisplayName("DateTimeFormatValue", "category", category);
    }

    @Override
    public String[] getFormatTypes(ULocale locale) {
        if (this.initChoiceArray() != null) {
            this.formatTypes = new String[this.categoryChoiceArray.length];
            int i = 0;
            while (i < this.categoryChoiceArray.length) {
                String fmtStr = "";
                String category = this.categoryChoiceArray[i][1];
                if (category.equals(CUSTOM) || category.equals(UNFORMATTED_DISPLAYNAME)) {
                    fmtStr = this.categoryChoiceArray[i][0];
                } else {
                    String pattern = FormatDateTimePattern.getPatternForCategory((String)category);
                    fmtStr = new DateFormatter(pattern, locale).format(this.defaultDate);
                }
                this.formatTypes[i] = fmtStr;
                ++i;
            }
        } else {
            this.formatTypes = new String[0];
        }
        return this.formatTypes;
    }

    @Override
    public int getIndexOfCategory(String category) {
        if (this.initChoiceArray() != null) {
            int i = 0;
            while (i < this.categoryChoiceArray.length) {
                if (this.categoryChoiceArray[i][1].equals(category)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    @Override
    public String getPattern4DisplayName(String displayName, ULocale locale) {
        String category = ChoiceSetFactory.getStructPropValue("DateTimeFormatValue", "category", displayName);
        return FormatDateTimePattern.getPatternForCategory((String)category);
    }

    public String getUnformattedCategoryDisplayName() {
        return UNFORMATTED_DISPLAYNAME;
    }

    public String getCustomCategoryName() {
        return CUSTOM;
    }

    public String getUnformattedCategoryName() {
        return UNFORMATTED_NAME;
    }
}

