/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.ConnectionCreation;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.HierarchyNodeEditPart;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.NodeEditPartHelper;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editpolicies.ColumnSelectionEditPolicy;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editpolicies.ConnectionCreationEditPolicy;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.figures.ColumnFigure;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.DimensionJoinConditionHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class HierarchyColumnEditPart
extends NodeEditPartHelper
implements Listener {
    protected Label label;
    private TabularCubeHandle cube;

    public HierarchyColumnEditPart(EditPart parent, ResultSetColumnHandle column) {
        this.setParent(parent);
        this.setModel(column);
        this.cube = ((HierarchyNodeEditPart)this.getParent()).getCube();
    }

    public TabularCubeHandle getCube() {
        return this.cube;
    }

    @Override
    protected IFigure createFigure() {
        ColumnFigure columnFigure = new ColumnFigure();
        FlowLayout layout = new FlowLayout();
        layout.setMinorSpacing(2);
        columnFigure.setLayoutManager((LayoutManager)layout);
        columnFigure.setOpaque(true);
        String name = OlapUtil.getDataFieldDisplayName(this.getColumn());
        this.label = new Label(name);
        columnFigure.add((IFigure)this.label);
        return columnFigure;
    }

    private ResultSetColumnHandle getColumn() {
        return (ResultSetColumnHandle)this.getModel();
    }

    @Override
    protected void createEditPolicies() {
        ColumnSelectionEditPolicy colEditPol = new ColumnSelectionEditPolicy();
        this.installEditPolicy("Selection Policy", (EditPolicy)colEditPol);
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ConnectionCreationEditPolicy());
    }

    public DragTracker getDragTracker(Request request) {
        List connectionList = this.getModelSourceConnections();
        int i = 0;
        while (i < connectionList.size()) {
            DimensionJoinConditionHandle joinCondition = (DimensionJoinConditionHandle)connectionList.get(i);
            if (joinCondition.getHierarchyKey().equals(this.getColumn().getColumnName())) {
                return super.getDragTracker(request);
            }
            ++i;
        }
        ConnectionCreation connection = new ConnectionCreation((EditPart)this);
        return connection;
    }

    @Override
    public IFigure getChopFigure() {
        return ((AbstractGraphicalEditPart)this.getParent()).getFigure();
    }

    @Override
    protected List getModelSourceConnections() {
        ArrayList<DimensionJoinConditionHandle> sourcejoins = new ArrayList<DimensionJoinConditionHandle>();
        HierarchyNodeEditPart hierarchyEditpart = (HierarchyNodeEditPart)this.getParent();
        Iterator iter = hierarchyEditpart.getCube().joinConditionsIterator();
        while (iter.hasNext()) {
            DimensionConditionHandle condition = (DimensionConditionHandle)iter.next();
            HierarchyHandle conditionHierarchy = condition.getHierarchy();
            if (!ModuleUtil.isEqualHierarchiesForJointCondition((HierarchyHandle)conditionHierarchy, (HierarchyHandle)((HierarchyHandle)hierarchyEditpart.getModel()))) continue;
            for (DimensionJoinConditionHandle joinCondition : condition.getJoinConditions()) {
                if (!joinCondition.getHierarchyKey().equals(this.getColumn().getColumnName()) || OlapUtil.getDataField(this.cube.getDataSet(), joinCondition.getCubeKey()) == null) continue;
                sourcejoins.add(joinCondition);
            }
        }
        return sourcejoins;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.isActive() && !this.isDelete()) {
            this.refreshSourceConnections();
        }
    }

    public void deactivate() {
        super.deactivate();
        this.cube.removeListener((Listener)this);
    }

    public void activate() {
        super.activate();
        this.cube.addListener((Listener)this);
    }

    public String getColumnName() {
        return this.getColumn().getColumnName();
    }
}

