/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Map;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DummyPreparedQuery;
import org.eclipse.birt.data.engine.impl.IQueryContextVisitor;
import org.eclipse.birt.data.engine.impl.NoRecalculateQueryUtil;
import org.eclipse.birt.data.engine.impl.PLSUtil;
import org.eclipse.birt.data.engine.impl.PreparedIVDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.QueryCompUtil;
import org.eclipse.birt.data.engine.impl.QueryContextVisitorUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedCubeQuery;

public class QueryPrepareUtil {
    public static IPreparedQuery prepareQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext, IQueryContextVisitor contextVisitor) throws DataException {
        return null;
    }

    public static IPreparedQuery preparePresentationQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext, IQueryContextVisitor contextVisitor) throws DataException {
        return null;
    }

    public static IPreparedQuery prepareIVGenerationQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext, IQueryContextVisitor contextVisitor) throws DataException {
        String queryResultID = queryDefn.getQueryResultsID();
        String rootQueryResultID = QueryResultIDUtil.get1PartID(queryResultID);
        String parentQueryResultID = null;
        if (rootQueryResultID != null) {
            parentQueryResultID = QueryResultIDUtil.get2PartID(queryResultID);
        } else {
            rootQueryResultID = queryResultID;
        }
        QueryResultInfo queryResultInfo = new QueryResultInfo(rootQueryResultID, parentQueryResultID, null, null, -1);
        RDLoad rdLoad = RDUtil.newLoad(dataEngine.getSession().getTempDir(), dataEngine.getContext(), queryResultInfo);
        IBaseQueryDefinition previousQueryDefn = rdLoad.loadQueryDefn(0, 1);
        if (QueryCompUtil.isIVQueryDefnEqual(dataEngine.getContext().getMode(), previousQueryDefn, queryDefn)) {
            return new DummyPreparedQuery(queryDefn, dataEngine.getSession(), dataEngine.getContext(), PLSUtil.isPLSEnabled(queryDefn) ? queryDefn.getQueryExecutionHints().getTargetGroupInstances() : null);
        }
        if (NoRecalculateQueryUtil.isOptimizableIVQuery(previousQueryDefn, queryDefn, queryResultID)) {
            return NoRecalculateQueryUtil.getPreparedIVQuery(dataEngine, previousQueryDefn, queryDefn, queryResultID, appContext);
        }
        if (queryDefn.isSummaryQuery()) {
            IResultClass rsMeta = rdLoad.loadResultClass();
            PreparedQueryUtil.populateSummaryBinding(queryDefn, rsMeta);
        }
        return new PreparedIVDataSourceQuery(dataEngine, queryDefn, QueryContextVisitorUtil.createQueryContextVisitor(queryDefn, appContext));
    }

    public static IPreparedCubeQuery prepareQuery(Map<String, String> cubeDataSourceMap, Map<String, String> cubeDataObjectMap, DataEngineSession session, DataEngineContext context, ICubeQueryDefinition cubeQuery, Map appContext) throws DataException {
        return new PreparedCubeQuery(cubeQuery, session, context, appContext);
    }

    public static void clear(DataEngineSession session) {
    }
}

