/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheConfig;
import org.eclipse.birt.data.engine.executor.DataSourceAndDataSet;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ShutdownHook;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class CacheMapManager {
    private static Map JVMLevelCacheMap = Collections.synchronizedMap(new HashMap());
    private static Map<DataSourceAndDataSet, Integer> lockedDataSetCacheMap = Collections.synchronizedMap(new HashMap());
    private Map<DataSourceAndDataSet, IDataSetCacheObject> cacheMap;
    private Map<DataSourceAndDataSet, IDataSetCacheObject> tempDataSetCacheMap;
    private boolean useJVMLevelCache;

    static {
        new ShutdownHook(JVMLevelCacheMap);
    }

    CacheMapManager(boolean useJVMLevelCache) {
        this.useJVMLevelCache = useJVMLevelCache;
        this.cacheMap = useJVMLevelCache ? JVMLevelCacheMap : new HashMap<DataSourceAndDataSet, IDataSetCacheObject>();
        this.tempDataSetCacheMap = new HashMap<DataSourceAndDataSet, IDataSetCacheObject>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesSaveToCache(DataSourceAndDataSet dsAndDs, DataSetCacheConfig dscc) throws DataException {
        Map<DataSourceAndDataSet, IDataSetCacheObject> map = this.cacheMap;
        synchronized (map) {
            IDataSetCacheObject cacheObject = this.cacheMap.get(dsAndDs);
            if (cacheObject != null) {
                return cacheObject.needUpdateCache(dscc.getCacheCapability());
            }
            if (!this.tempDataSetCacheMap.containsKey(dsAndDs)) {
                IDataSetCacheObject dsco = dscc.createDataSetCacheObject();
                this.tempDataSetCacheMap.put(dsAndDs, dsco);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesLoadFromCache(DataSourceAndDataSet dsAndDs, int requiredCapability) {
        Map<DataSourceAndDataSet, IDataSetCacheObject> map = this.cacheMap;
        synchronized (map) {
            IDataSetCacheObject cacheObject = this.cacheMap.get(dsAndDs);
            if (cacheObject != null) {
                boolean reusable = cacheObject.isCachedDataReusable(requiredCapability);
                if (!reusable) {
                    if (this.useJVMLevelCache) {
                        Map<DataSourceAndDataSet, Integer> map2 = lockedDataSetCacheMap;
                        synchronized (map2) {
                            if (lockedDataSetCacheMap.containsKey(dsAndDs)) {
                                try {
                                    lockedDataSetCacheMap.wait(60000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                lockedDataSetCacheMap.remove(dsAndDs);
                            }
                        }
                    }
                    cacheObject.release();
                    this.tempDataSetCacheMap.remove(dsAndDs);
                    this.cacheMap.remove(dsAndDs);
                } else if (this.useJVMLevelCache && !lockedDataSetCacheMap.containsKey(dsAndDs)) {
                    lockedDataSetCacheMap.put(dsAndDs, 0);
                }
                return reusable;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IDataSetCacheObject getSavedCacheObject(DataSourceAndDataSet dsAndDs) {
        Map<DataSourceAndDataSet, IDataSetCacheObject> map = this.cacheMap;
        synchronized (map) {
            return this.tempDataSetCacheMap.get(dsAndDs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFinishOnCache(DataSourceAndDataSet dsAndDs, IDataSetCacheObject dsco) {
        Map<DataSourceAndDataSet, IDataSetCacheObject> map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.put(dsAndDs, dsco);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadStart(DataSourceAndDataSet dsAndDs) throws DataException {
        if (this.useJVMLevelCache) {
            Map<DataSourceAndDataSet, Integer> map = lockedDataSetCacheMap;
            synchronized (map) {
                if (lockedDataSetCacheMap.containsKey(dsAndDs)) {
                    Integer count = lockedDataSetCacheMap.get(dsAndDs);
                    lockedDataSetCacheMap.put(dsAndDs, count + 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFinishOnCache(DataSourceAndDataSet dsAndDs) throws DataException {
        if (this.useJVMLevelCache) {
            Map<DataSourceAndDataSet, Integer> map = lockedDataSetCacheMap;
            synchronized (map) {
                if (lockedDataSetCacheMap.containsKey(dsAndDs)) {
                    Integer count = lockedDataSetCacheMap.get(dsAndDs);
                    if (count <= 1) {
                        lockedDataSetCacheMap.remove(dsAndDs);
                        lockedDataSetCacheMap.notifyAll();
                    } else {
                        lockedDataSetCacheMap.put(dsAndDs, count - 1);
                    }
                }
            }
        }
    }

    IDataSetCacheObject getloadedCacheObject(DataSourceAndDataSet dsAndDs) {
        return this.cacheMap.get(dsAndDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(DataSourceAndDataSet dsAndDs) {
        ArrayList<IDataSetCacheObject> cacheObjects = new ArrayList<IDataSetCacheObject>();
        Map<DataSourceAndDataSet, IDataSetCacheObject> map = this.cacheMap;
        synchronized (map) {
            Object key = this.getKey(dsAndDs);
            while (key != null) {
                cacheObjects.add(this.cacheMap.remove(key));
                this.tempDataSetCacheMap.remove(key);
                key = this.getKey(dsAndDs);
            }
        }
        int i = 0;
        while (i < cacheObjects.size()) {
            IDataSetCacheObject cacheObject = (IDataSetCacheObject)cacheObjects.get(i);
            cacheObject.release();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetForTest() {
        CacheMapManager cacheMapManager = this;
        synchronized (cacheMapManager) {
            this.cacheMap.clear();
            this.tempDataSetCacheMap.clear();
        }
    }

    IResultClass getCachedResultClass(DataSourceAndDataSet dsAndDs) throws DataException {
        IDataSetCacheObject cacheObject = null;
        Object key = this.getKey(dsAndDs);
        if (key != null) {
            cacheObject = this.cacheMap.get(key);
        }
        if (cacheObject != null) {
            return cacheObject.getResultClass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getKey(DataSourceAndDataSet dsAndDs) {
        Map<DataSourceAndDataSet, IDataSetCacheObject> map = this.cacheMap;
        synchronized (map) {
            for (DataSourceAndDataSet temp : this.cacheMap.keySet()) {
                if (!temp.isDataSourceDataSetEqual(dsAndDs, false)) continue;
                return temp;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(Set<String> cacheIDs) {
        DataSourceAndDataSet[] keyArray;
        ArrayList<IDataSetCacheObject> removed = new ArrayList<IDataSetCacheObject>();
        DataSourceAndDataSet[] dataSourceAndDataSetArray = keyArray = JVMLevelCacheMap.keySet().toArray(new DataSourceAndDataSet[0]);
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSourceAndDataSet dsAndDs = dataSourceAndDataSetArray[n2];
            if (cacheIDs.contains(dsAndDs.getCacheScopeID())) {
                Map<DataSourceAndDataSet, Integer> map = lockedDataSetCacheMap;
                synchronized (map) {
                    if (lockedDataSetCacheMap.containsKey(dsAndDs)) {
                        try {
                            lockedDataSetCacheMap.wait(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        lockedDataSetCacheMap.remove(dsAndDs);
                    }
                }
                IDataSetCacheObject cacheObj = (IDataSetCacheObject)JVMLevelCacheMap.remove(dsAndDs);
                if (cacheObj != null) {
                    removed.add(cacheObj);
                }
            }
            ++n2;
        }
        for (IDataSetCacheObject dataSetCacheObject : removed) {
            dataSetCacheObject.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache() {
        ArrayList<IDataSetCacheObject> cacheObjects = new ArrayList<IDataSetCacheObject>();
        Map<DataSourceAndDataSet, IDataSetCacheObject> map = this.cacheMap;
        synchronized (map) {
            DataSourceAndDataSet[] dataSourceAndDataSetArray = this.cacheMap.keySet().toArray(new DataSourceAndDataSet[0]);
            int n = dataSourceAndDataSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataSourceAndDataSet dataSetAndSource = dataSourceAndDataSetArray[n2];
                cacheObjects.add(this.cacheMap.remove(dataSetAndSource));
                this.tempDataSetCacheMap.remove(dataSetAndSource);
                ++n2;
            }
        }
        int i = 0;
        while (i < cacheObjects.size()) {
            IDataSetCacheObject cacheObject = (IDataSetCacheObject)cacheObjects.get(i);
            cacheObject.release();
            ++i;
        }
    }
}

