/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import com.lowagie.text.Image;
import java.awt.Color;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.RegionLayoutEngine;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.FixedLayoutPageHintGenerator;
import org.eclipse.birt.report.engine.nLayout.area.impl.RegionArea;
import org.eclipse.birt.report.engine.nLayout.area.style.BackgroundImageInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.BorderInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.BoxStyle;
import org.eclipse.birt.report.engine.util.ResourceLocatorWrapper;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.core.Module;

public class PageArea
extends BlockContainerArea {
    static final int DEFAULT_PAGE_WIDTH = 595275;
    static final int DEFAULT_PAGE_HEIGHT = 841889;
    private transient boolean extendToMultiplePages = false;
    private transient boolean enlargePageSize = false;
    protected ContainerArea root;
    protected ContainerArea body;
    protected RegionArea header;
    protected RegionArea footer;
    protected transient IPageContent pageContent;
    protected transient LayoutEmitterAdapter emitter;
    private transient int pageContentWidth = 595275;
    private transient int pageContentHeight = 841889;
    private transient int rootWidth;
    private transient int rootHeight;
    private transient int rootLeft;
    private transient int rootTop;

    public PageArea(LayoutContext context, IContent content, LayoutEmitterAdapter emitter) {
        super(null, context, content);
        this.emitter = emitter;
        this.pageContent = (IPageContent)content;
    }

    public PageArea(PageArea area) {
        super(area);
    }

    public IContainerArea getHeader() {
        return this.header;
    }

    public boolean isExtendToMultiplePages() {
        return this.extendToMultiplePages;
    }

    public void removeHeader() {
        this.root.removeChild(this.header);
        this.header = null;
    }

    public void removeFooter() {
        this.root.removeChild(this.footer);
        this.footer = null;
    }

    public IContainerArea getFooter() {
        return this.footer;
    }

    public IContainerArea getBody() {
        return this.body;
    }

    public IContainerArea getRoot() {
        return this.root;
    }

    public void setRoot(ContainerArea root) {
        this.root = root;
        this.children.add(root);
    }

    public void setBody(ContainerArea body) {
        if (this.body != null) {
            body.setPosition(this.body.getX(), this.body.getY());
            this.root.children.remove(this.body);
        }
        this.root.children.add(body);
        body.setParent(this.root);
        this.body = body;
    }

    public void removeBody() {
        this.root.children.remove(this.body);
        this.body = null;
    }

    public void setHeader(RegionArea header) {
        this.header = header;
    }

    public void setFooter(RegionArea footer) {
        this.footer = footer;
    }

    public boolean isEnlargePageSize() {
        return this.enlargePageSize;
    }

    public void setEnlargePageSize(boolean enlargePageSize) {
        this.enlargePageSize = enlargePageSize;
    }

    @Override
    public PageArea cloneArea() {
        return new PageArea(this);
    }

    protected BoxStyle buildRootStyle() {
        IStyle style = this.pageContent.getStyle();
        if (style != null && !style.isEmpty()) {
            BoxStyle boxStyle = new BoxStyle();
            IStyle cs = this.pageContent.getComputedStyle();
            int borderWidth = this.getDimensionValue(cs.getProperty(42), this.width);
            if (borderWidth > 0) {
                boxStyle.setLeftBorder(new BorderInfo(cs.getProperty(46), cs.getProperty(52), borderWidth));
            }
            if ((borderWidth = this.getDimensionValue(cs.getProperty(10), this.width)) > 0) {
                boxStyle.setRightBorder(new BorderInfo(cs.getProperty(14), cs.getProperty(21), borderWidth));
            }
            if ((borderWidth = this.getDimensionValue(cs.getProperty(41), this.width)) > 0) {
                boxStyle.setTopBorder(new BorderInfo(cs.getProperty(13), cs.getProperty(49), borderWidth));
            }
            if ((borderWidth = this.getDimensionValue(cs.getProperty(11), this.width)) > 0) {
                boxStyle.setBottomBorder(new BorderInfo(cs.getProperty(15), cs.getProperty(22), borderWidth));
            }
            return boxStyle;
        }
        return BoxStyle.DEFAULT;
    }

    @Override
    public void initialize() throws BirtException {
        this.createRoot();
        Color backgroundColor = PropertyUtil.getColor(this.pageContent.getComputedStyle().getProperty(8));
        ReportDesignHandle designHandle = this.pageContent.getReportContent().getDesign().getReportDesign();
        IStyle style = this.pageContent.getStyle();
        String imageUrl = EmitterUtil.getBackgroundImageUrl(style, designHandle, this.pageContent.getReportContent().getReportContext() == null ? null : this.pageContent.getReportContent().getReportContext().getAppContext());
        if (backgroundColor != null || imageUrl != null) {
            this.boxStyle = new BoxStyle();
            this.boxStyle.setBackgroundColor(backgroundColor);
            if (imageUrl != null) {
                this.boxStyle.setBackgroundImage(this.createBackgroundImage(imageUrl, designHandle.getModule()));
            }
        }
        this.context.setMaxHeight(this.root.getHeight());
        this.context.setMaxWidth(this.root.getWidth());
        this.context.setMaxBP(this.root.getHeight());
        this.layoutHeader();
        this.layoutFooter();
        this.updateBodySize();
        this.context.setMaxHeight(this.body.getHeight());
        this.context.setMaxWidth(this.body.getWidth());
        int overFlowType = this.context.getPageOverflow();
        if (overFlowType == 2 || overFlowType == 8) {
            this.context.setMaxBP(Integer.MAX_VALUE);
        } else {
            this.context.setMaxBP(this.body.getHeight());
        }
        this.maxAvaWidth = this.context.getMaxWidth();
        this.context.resetUnresolvedRowHints();
    }

    protected BackgroundImageInfo createBackgroundImage(String url, Module module) {
        ResourceLocatorWrapper rl = null;
        ExecutionContext exeContext = ((ReportContent)this.content.getReportContent()).getExecutionContext();
        if (exeContext != null) {
            rl = exeContext.getResourceLocator();
        }
        IStyle cs = this.pageContent.getComputedStyle();
        BackgroundImageInfo backgroundImage = null;
        backgroundImage = new BackgroundImageInfo(url, cs.getProperty(9), 0, 0, 0, 0, rl, module, cs.getProperty(61));
        Image img = backgroundImage.getImageInstance();
        IStyle style = this.pageContent.getStyle();
        String widthStr = style.getBackgroundWidth();
        String heightStr = style.getBackgroundHeight();
        if (img != null) {
            int resolutionX = img.getDpiX();
            int resolutionY = img.getDpiY();
            if (resolutionX == 0 || resolutionY == 0) {
                resolutionX = 96;
                resolutionY = 96;
            }
            float imageWidth = img.getPlainWidth() / (float)resolutionX * 72.0f * 1000.0f;
            float imageHeight = img.getPlainHeight() / (float)resolutionY * 72.0f * 1000.0f;
            int actualWidth = (int)imageWidth;
            int actualHeight = (int)imageHeight;
            if (widthStr != null && widthStr.length() > 0 || heightStr != null && heightStr.length() > 0) {
                if ("contain".equals(widthStr) || "contain".equals(heightStr)) {
                    float rh = imageHeight / (float)this.height;
                    float rw = imageWidth / (float)this.width;
                    if (rh > rw) {
                        actualHeight = this.height;
                        actualWidth = (int)(imageWidth * (float)this.height / imageHeight);
                    } else {
                        actualWidth = this.width;
                        actualHeight = (int)(imageHeight * (float)this.width / imageWidth);
                    }
                } else if ("cover".equals(widthStr) || "cover".equals(heightStr)) {
                    float rh = imageHeight / (float)this.height;
                    float rw = imageWidth / (float)this.width;
                    if (rh > rw) {
                        actualWidth = this.width;
                        actualHeight = (int)(imageHeight * (float)this.width / imageWidth);
                    } else {
                        actualHeight = this.height;
                        actualWidth = (int)(imageWidth * (float)this.height / imageHeight);
                    }
                } else {
                    DimensionType widthDim = DimensionType.parserUnit(widthStr);
                    DimensionType heightDim = DimensionType.parserUnit(heightStr);
                    if (widthDim != null) {
                        actualWidth = PropertyUtil.getDimensionValue(this.content, widthDim);
                        actualHeight = heightDim == null ? (int)(imageHeight * (float)actualWidth / imageWidth) : PropertyUtil.getDimensionValue(this.content, heightDim);
                    } else if (heightDim != null) {
                        actualHeight = PropertyUtil.getDimensionValue(this.content, heightDim);
                        actualWidth = widthDim == null ? (int)(imageWidth * (float)actualHeight / imageHeight) : PropertyUtil.getDimensionValue(this.content, widthDim);
                    } else {
                        actualHeight = (int)imageHeight;
                        actualWidth = (int)imageWidth;
                    }
                }
            }
            backgroundImage.setXOffset(this.getDimensionValue(cs.getProperty(32), this.width - actualWidth));
            backgroundImage.setYOffset(this.getDimensionValue(cs.getProperty(37), this.height - actualHeight));
            backgroundImage.setHeight(actualHeight);
            backgroundImage.setWidth(actualWidth);
            return backgroundImage;
        }
        return null;
    }

    protected void updateBodySize() {
        if (this.header != null && this.header.getHeight() >= this.root.getHeight()) {
            this.removeHeader();
            this.header = null;
        }
        if (this.footer != null && this.footer.getHeight() >= this.root.getHeight()) {
            this.removeFooter();
            this.footer = null;
        }
        if (this.header != null && this.footer != null && this.footer.getHeight() + this.header.getHeight() >= this.root.getHeight()) {
            this.removeHeader();
        }
        this.body.setHeight(this.root.getContentHeight() - (this.header == null ? 0 : this.header.getHeight()) - (this.footer == null ? 0 : this.footer.getHeight()));
        this.body.setPosition(this.body.getX(), (this.header == null ? 0 : this.header.getHeight()) + this.root.getBoxStyle().getTopBorderWidth());
        if (this.footer != null) {
            this.footer.setPosition(this.footer.getX(), (this.header == null ? 0 : this.header.getHeight()) + this.root.getBoxStyle().getTopBorderWidth() + (this.body == null ? 0 : this.body.getHeight()));
        }
    }

    protected void layoutHeader() {
        IContent headerContent = this.pageContent.getPageHeader();
        if (headerContent != null) {
            DimensionType h = this.pageContent.getHeaderHeight();
            if (h == null) {
                h = new DimensionType(0.5, "in");
            }
            headerContent.setHeight(h);
            this.header.content = headerContent;
            boolean autoPageBreak = this.context.isAutoPageBreak();
            this.context.setAutoPageBreak(false);
            RegionLayoutEngine rle = new RegionLayoutEngine(this.header, this.context);
            try {
                rle.layout(headerContent);
            }
            catch (BirtException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            this.context.setAutoPageBreak(autoPageBreak);
        }
    }

    protected void layoutFooter() {
        IContent footerContent = this.pageContent.getPageFooter();
        if (footerContent != null) {
            DimensionType h = this.pageContent.getFooterHeight();
            if (h == null) {
                h = new DimensionType(0.5, "in");
            }
            footerContent.setHeight(h);
            this.footer.content = footerContent;
            boolean autoPageBreak = this.context.isAutoPageBreak();
            this.context.setAutoPageBreak(false);
            RegionLayoutEngine rle = new RegionLayoutEngine(this.footer, this.context);
            try {
                rle.layout(footerContent);
            }
            catch (BirtException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            this.context.setAutoPageBreak(autoPageBreak);
        }
    }

    public void floatingFooter(PageArea page) {
        ContainerArea footer = (ContainerArea)page.getFooter();
        IContainerArea body = page.getBody();
        IContainerArea header = page.getHeader();
        if (footer != null) {
            footer.setPosition(footer.getX(), (header == null ? 0 : header.getHeight()) + (body == null ? 0 : body.getHeight()));
        }
    }

    protected void createRoot() {
        int overFlowType = this.context.getPageOverflow();
        this.pageContentWidth = this.getDimensionValue(this.pageContent, this.pageContent.getPageWidth()) - this.boxStyle.getLeftBorderWidth() - this.boxStyle.getRightBorderWidth();
        this.pageContentHeight = this.getDimensionValue(this.pageContent, this.pageContent.getPageHeight()) - this.boxStyle.getTopBorderWidth() - this.boxStyle.getBottomBorderWidth();
        if (this.pageContentWidth <= 0) {
            this.pageContentWidth = 595275;
        }
        if (this.pageContentHeight <= 0) {
            this.pageContentHeight = 841889;
        }
        this.setWidth(this.pageContentWidth);
        this.setHeight(this.pageContentHeight);
        BlockContainerArea pageRoot = new BlockContainerArea();
        BoxStyle boxStyle = this.buildRootStyle();
        if (boxStyle != BoxStyle.DEFAULT) {
            pageRoot.hasStyle = true;
        }
        pageRoot.setBoxStyle(boxStyle);
        this.rootLeft = this.getDimensionValue(this.pageContent, this.pageContent.getMarginLeft(), this.pageContentWidth);
        this.rootTop = this.getDimensionValue(this.pageContent, this.pageContent.getMarginTop(), this.pageContentHeight);
        this.rootLeft = Math.max(0, this.rootLeft);
        this.rootLeft = Math.min(this.pageContentWidth, this.rootLeft);
        this.rootTop = Math.max(0, this.rootTop);
        this.rootTop = Math.min(this.pageContentHeight, this.rootTop);
        pageRoot.setPosition(this.rootLeft, this.rootTop);
        int rootRight = this.getDimensionValue(this.pageContent, this.pageContent.getMarginRight(), this.pageContentWidth);
        int rootBottom = this.getDimensionValue(this.pageContent, this.pageContent.getMarginBottom(), this.pageContentWidth);
        rootRight = Math.max(0, rootRight);
        rootBottom = Math.max(0, rootBottom);
        if (this.rootLeft + rootRight > this.pageContentWidth) {
            rootRight = 0;
        }
        if (this.rootTop + rootBottom > this.pageContentHeight) {
            rootBottom = 0;
        }
        this.rootWidth = this.pageContentWidth - this.rootLeft - rootRight;
        this.rootHeight = this.pageContentHeight - this.rootTop - rootBottom;
        pageRoot.setWidth(this.rootWidth);
        pageRoot.setHeight(this.rootHeight);
        this.setRoot(pageRoot);
        pageRoot.setParent(this);
        int headerHeight = this.getDimensionValue(this.pageContent, this.pageContent.getHeaderHeight(), pageRoot.getHeight());
        int headerWidth = pageRoot.getWidth() - boxStyle.getLeftBorderWidth() - boxStyle.getRightBorderWidth();
        headerHeight = Math.max(0, headerHeight);
        headerHeight = Math.min(pageRoot.getHeight(), headerHeight);
        RegionArea header = new RegionArea();
        header.setHeight(headerHeight);
        header.setWidth(headerWidth);
        header.context = this.context;
        header.needClip = true;
        header.setPosition(boxStyle.getLeftBorderWidth(), boxStyle.getTopBorderWidth());
        pageRoot.addChild(header);
        this.setHeader(header);
        header.setParent(pageRoot);
        int footerHeight = this.getDimensionValue(this.pageContent, this.pageContent.getFooterHeight(), pageRoot.getHeight());
        int footerWidth = pageRoot.getWidth() - boxStyle.getLeftBorderWidth() - boxStyle.getRightBorderWidth();
        footerHeight = Math.max(0, footerHeight);
        footerHeight = Math.min(pageRoot.getHeight() - headerHeight, footerHeight);
        RegionArea footer = new RegionArea();
        footer.setHeight(footerHeight);
        footer.setWidth(footerWidth);
        footer.context = this.context;
        footer.needClip = true;
        footer.setPosition(boxStyle.getLeftBorderWidth(), pageRoot.getHeight() - boxStyle.getBottomBorderWidth() - footerHeight);
        pageRoot.addChild(footer);
        this.setFooter(footer);
        footer.setParent(pageRoot);
        BlockContainerArea body = new BlockContainerArea();
        int bodyLeft = this.getDimensionValue(this.pageContent, this.pageContent.getLeftWidth(), pageRoot.getWidth());
        bodyLeft = Math.max(0, bodyLeft);
        bodyLeft = Math.min(pageRoot.getWidth(), bodyLeft);
        body.setPosition(boxStyle.getLeftBorderWidth() + bodyLeft, headerHeight + boxStyle.getRightBorderWidth());
        int bodyRight = this.getDimensionValue(this.pageContent, this.pageContent.getRightWidth(), pageRoot.getWidth());
        bodyRight = Math.max(0, bodyRight);
        bodyRight = Math.min(pageRoot.getWidth() - bodyLeft, bodyRight);
        body.setWidth(pageRoot.getWidth() - bodyLeft - bodyRight - boxStyle.getLeftBorderWidth() - boxStyle.getRightBorderWidth());
        body.setHeight(pageRoot.getHeight() - headerHeight - footerHeight - boxStyle.getTopBorderWidth() - boxStyle.getBottomBorderWidth());
        this.setBody(body);
        if (overFlowType == 1 || overFlowType == 4) {
            pageRoot.setNeedClip(true);
            body.setNeedClip(true);
        } else {
            pageRoot.setNeedClip(false);
        }
    }

    @Override
    public void close() throws BirtException {
        int overFlowType = this.context.getPageOverflow();
        if (overFlowType == 2) {
            float scale = this.calculatePageScale(this);
            if (1.0f == scale) {
                this.pageContent.setExtension(1, this);
                this.outputPage(this.pageContent);
                return;
            }
            this.setScale(scale);
            this.getBody().setNeedClip(false);
            this.updatePageDimension(scale, this);
        } else if (overFlowType == 8) {
            this.getBody().setNeedClip(false);
            this.updatePageDimension(this);
        }
        this.pageContent.setExtension(1, this);
        this.outputPage(this.pageContent);
        this.finished = true;
    }

    public boolean isPageEmpty() {
        return this.body.getChildrenCount() <= 0;
    }

    public void outputPage(IPageContent page) throws BirtException {
        FixedLayoutPageHintGenerator gen = this.context.getPageHintGenerator();
        if (gen != null) {
            gen.generatePageHints(page);
        }
        this.emitter.outputPage(page);
    }

    private float calculatePageScale(PageArea page) {
        float scale = 1.0f;
        if (page != null && page.getRoot().getChildrenCount() > 0) {
            int maxWidth = this.context.getMaxWidth();
            int maxHeight = this.context.getMaxHeight();
            int prefWidth = this.context.getPreferenceWidth();
            int prefHeight = this.body.getHeight();
            Iterator<IArea> iter = page.getBody().getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                prefWidth = Math.max(prefWidth, area.getAllocatedX() + area.getAllocatedWidth());
            }
            if (prefHeight > maxHeight) {
                ((ContainerArea)page.getBody()).setHeight(prefHeight);
                this.floatingFooter(page);
            }
            if (prefWidth > maxWidth || prefHeight > maxHeight) {
                scale = Math.min((float)maxWidth / (float)prefWidth, (float)maxHeight / (float)prefHeight);
            }
        }
        return scale;
    }

    protected void updatePageDimension(float scale, PageArea page) {
        page.setHeight((int)((float)this.pageContentHeight / scale));
        page.setWidth((int)((float)this.pageContentWidth / scale));
        ContainerArea pageRoot = (ContainerArea)page.getRoot();
        pageRoot.setPosition((int)((float)this.rootLeft / scale), (int)((float)this.rootTop / scale));
        pageRoot.setHeight((int)((float)this.rootHeight / scale));
        pageRoot.setWidth((int)((float)this.rootWidth / scale));
    }

    protected void updatePageDimension(PageArea page) {
        if (page != null && page.getRoot().getChildrenCount() > 0) {
            ContainerArea pageRoot;
            int maxWidth = this.context.getMaxWidth();
            int maxHeight = this.context.getMaxHeight();
            int prefWidth = this.context.getPreferenceWidth();
            int prefHeight = page.getBody().getHeight();
            Iterator<IArea> iter = page.getBody().getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                prefWidth = Math.max(prefWidth, area.getAllocatedX() + area.getAllocatedWidth());
            }
            if (prefHeight > maxHeight) {
                ((ContainerArea)page.getBody()).setHeight(prefHeight);
                this.floatingFooter(page);
                int deltaHeight = prefHeight - maxHeight;
                pageRoot = (ContainerArea)page.getRoot();
                pageRoot.setHeight(pageRoot.getHeight() + deltaHeight);
                page.setHeight(this.pageContentHeight + deltaHeight);
            }
            if (prefWidth > maxWidth) {
                ((ContainerArea)page.getBody()).setWidth(prefWidth);
                int deltaWidth = prefWidth - maxWidth;
                pageRoot = (ContainerArea)page.getRoot();
                pageRoot.setWidth(pageRoot.getWidth() + deltaWidth);
                page.setWidth(this.pageContentWidth + deltaWidth);
            }
        }
    }
}

