/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceSelectionValidator;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.jface.action.Action;

public class ImportLibraryAction
extends Action {
    public static final String ID = "UseLibraryAction";
    public static final String ACTION_TEXT = Messages.getString((String)"UseLibraryAction.Text");
    public static final String DIALOG_TITLE = Messages.getString((String)"ImportLibraryAction.Dialog.Titile");
    public static final String DIALOG_MESSAGE = Messages.getString((String)"ImportLibraryAction.Dialog.Message");
    private static final String[] LIBRARY_FILE_TYPE = new String[]{".rptlibrary"};
    private static final String[] LIBRARY_FILE_PATTERN = new String[]{"*.rptlibrary"};

    public ImportLibraryAction() {
        this.setText(ACTION_TEXT);
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        ResourceFileFolderSelectionDialog dialog = new ResourceFileFolderSelectionDialog(true, LIBRARY_FILE_PATTERN);
        dialog.setTitle(DIALOG_TITLE);
        dialog.setMessage(DIALOG_MESSAGE);
        dialog.setAllowImportFile(true);
        ResourceSelectionValidator validator = new ResourceSelectionValidator(LIBRARY_FILE_TYPE);
        dialog.setValidator(validator);
        if (dialog.open() == 0) {
            try {
                String filename = dialog.getPath();
                ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                UIUtil.includeLibrary(moduleHandle, filename);
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private void coypFile(File org, File dest) throws IOException {
        if (dest.exists() || dest.createNewFile()) {
            FileInputStream in = new FileInputStream(org);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] bytes = new byte[64];
            int length = 0;
            while ((length = in.read(bytes)) != -1) {
                out.write(bytes, 0, length);
            }
            in.close();
            out.close();
        }
    }
}

