/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util.graphics;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class TransformUtil {
    public static Rectangle transformRect(AffineTransform af, Rectangle rect) {
        Rectangle rt = new Rectangle(0, 0, 0, 0);
        rect = TransformUtil.redressRect(rect);
        Point p1 = new Point(rect.x, rect.y);
        p1 = TransformUtil.transformPoint(af, p1);
        rt.x = p1.x;
        rt.y = p1.y;
        rt.width = (int)((double)rect.width * af.getScaleX());
        rt.height = (int)((double)rect.height * af.getScaleY());
        return rt;
    }

    public static Rectangle inverseTransformRect(AffineTransform af, Rectangle rect) {
        Rectangle rt = new Rectangle(0, 0, 0, 0);
        rect = TransformUtil.redressRect(rect);
        Point p1 = new Point(rect.x, rect.y);
        p1 = TransformUtil.inverseTransformPoint(af, p1);
        rt.x = p1.x;
        rt.y = p1.y;
        rt.width = (int)((double)rect.width / af.getScaleX());
        rt.height = (int)((double)rect.height / af.getScaleY());
        return rt;
    }

    public static Point transformPoint(AffineTransform af, Point pt) {
        Point2D.Float src = new Point2D.Float(pt.x, pt.y);
        Point2D dest = af.transform(src, null);
        Point point = new Point((int)Math.floor(dest.getX()), (int)Math.floor(dest.getY()));
        return point;
    }

    public static Point inverseTransformPoint(AffineTransform af, Point pt) {
        Point2D.Float src = new Point2D.Float(pt.x, pt.y);
        try {
            Point2D dest = af.inverseTransform(src, null);
            return new Point((int)Math.floor(dest.getX()), (int)Math.floor(dest.getY()));
        }
        catch (Exception e) {
            return new Point(0, 0);
        }
    }

    public static Rectangle redressRect(Rectangle rect) {
        Rectangle rt = new Rectangle(0, 0, 0, 0);
        if (rect.width < 0) {
            rt.x = rect.x + rect.width + 1;
            rt.width = -rect.width;
        } else {
            rt.x = rect.x;
            rt.width = rect.width;
        }
        if (rect.height < 0) {
            rt.y = rect.y + rect.height + 1;
            rt.height = -rect.height;
        } else {
            rt.y = rect.y;
            rt.height = rect.height;
        }
        return rt;
    }
}

