/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.processor;

import org.eclipse.birt.report.designer.internal.ui.dialogs.TableOptionBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.TableOptionDialog;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.processor.AbstractElementProcessor;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class TableGridProcessor
extends AbstractElementProcessor {
    TableGridProcessor(String elementType) {
        super(elementType);
    }

    @Override
    public DesignElementHandle createElement(Object extendedData) {
        boolean isTable = "Table".equals(this.getElementType());
        if (isTable) {
            TableOptionBindingDialog dialog = new TableOptionBindingDialog(UIUtil.getDefaultShell());
            if (dialog.open() == 0) {
                Object[] result = (Object[])dialog.getResult();
                Object[] data = (Object[])result[0];
                boolean isSummaryTable = data.length > 2 && data[2] != null && (Boolean)data[2] != false;
                Object[] datasetInfo = (Object[])result[1];
                int columnCount = (Integer)data[1];
                int bindingCount = 0;
                if (datasetInfo != null && datasetInfo[1] instanceof Object[] && (bindingCount = ((Object[])datasetInfo[1]).length) > 0) {
                    columnCount = bindingCount;
                }
                TableHandle table = DesignElementFactory.getInstance().newTableItem(null, columnCount, 1, isSummaryTable ? 0 : (Integer)data[0], 1);
                InsertInLayoutUtil.setInitWidth(table);
                if (datasetInfo != null && datasetInfo[0] != null) {
                    try {
                        DataSetHandle dataSetHandle = (DataSetHandle)datasetInfo[0];
                        table.setDataSet(dataSetHandle);
                        DataSetColumnBindingsFormHandleProvider provider = new DataSetColumnBindingsFormHandleProvider();
                        provider.setBindingObject((ReportElementHandle)table);
                        if (datasetInfo[1] instanceof Object[]) {
                            Object[] selectedColumns = (Object[])datasetInfo[1];
                            provider.generateBindingColumns(selectedColumns);
                            if (bindingCount > 0) {
                                ResultSetColumnHandle[] columns = new ResultSetColumnHandle[bindingCount];
                                int i = 0;
                                while (i < selectedColumns.length) {
                                    columns[i] = (ResultSetColumnHandle)selectedColumns[i];
                                    ++i;
                                }
                                InsertInLayoutUtil.insertToCell(dataSetHandle, table, table.getHeader(), columns, true);
                                if (!isSummaryTable) {
                                    InsertInLayoutUtil.insertToCell(dataSetHandle, table, table.getDetail(), columns, false);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(e);
                    }
                }
                if (isSummaryTable) {
                    try {
                        table.setIsSummaryTable(((Boolean)data[2]).booleanValue());
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                }
                return table;
            }
        } else {
            TableOptionDialog dialog = new TableOptionDialog(UIUtil.getDefaultShell(), isTable);
            if (dialog.open() == 0 && dialog.getResult() instanceof Object[]) {
                Object[] data = (Object[])dialog.getResult();
                GridHandle handle = DesignElementFactory.getInstance().newGridItem(TableGridProcessor.getNewName(extendedData), (Integer)data[1], (Integer)data[0]);
                InsertInLayoutUtil.setInitWidth(handle);
                return handle;
            }
        }
        return null;
    }

    @Override
    public boolean editElement(DesignElementHandle handle) {
        return false;
    }
}

