/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTextArray;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.pdf.PDFPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.AbstractPage;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.engine.util.FlashFile;
import org.eclipse.birt.report.engine.util.SvgFile;
import org.w3c.dom.css.CSSValue;

public class PDFPage
extends AbstractPage {
    protected PdfWriter writer = null;
    protected PdfContentByte contentByte = null;
    protected static Logger logger = Logger.getLogger(PDFPage.class.getName());
    protected float containerHeight;
    protected PDFPageDevice pageDevice;
    private static float MIN_FONT_SIZE = 1.0E-4f;
    private static Pattern PAGE_LINK_PATTERN = Pattern.compile("^((([a-zA-Z]:))(/(\\w[\\w ]*.*))+\\.(pdf|PDF))+#page=(\\d+)$");
    static HashMap<Integer, Float> fontWeightLineWidthMap = new HashMap();

    static {
        fontWeightLineWidthMap.put(500, Float.valueOf(0.1f));
        fontWeightLineWidthMap.put(600, Float.valueOf(0.185f));
        fontWeightLineWidthMap.put(700, Float.valueOf(0.225f));
        fontWeightLineWidthMap.put(800, Float.valueOf(0.3f));
        fontWeightLineWidthMap.put(900, Float.valueOf(0.5f));
    }

    public PDFPage(int pageWidth, int pageHeight, Document document, PdfWriter writer, PDFPageDevice pageDevice) {
        super(pageWidth, pageHeight);
        this.writer = writer;
        this.pageDevice = pageDevice;
        this.containerHeight = this.pageHeight;
        Rectangle pageSize = new Rectangle(this.pageWidth, this.pageHeight);
        document.setPageSize(pageSize);
        if (!document.isOpen()) {
            document.open();
        } else {
            document.newPage();
        }
        this.contentByte = writer.getDirectContent();
    }

    protected void clip(float startX, float startY, float width, float height) {
        startY = this.transformY(startY, height);
        this.contentByte.rectangle(startX, startY, width, height);
        this.contentByte.clip();
        this.contentByte.newPath();
    }

    protected void restoreState() {
        this.contentByte.restoreState();
    }

    protected void saveState() {
        this.contentByte.saveState();
    }

    public void dispose() {
    }

    protected void drawBackgroundColor(Color color, float x, float y, float width, float height) {
        if (color == null) {
            return;
        }
        y = this.transformY(y, height);
        this.contentByte.saveState();
        this.contentByte.setColorFill(color);
        this.contentByte.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, x, y);
        this.contentByte.rectangle(0.0f, 0.0f, width, height);
        this.contentByte.fill();
        this.contentByte.restoreState();
    }

    protected void drawBackgroundImage(float x, float y, float width, float height, float imageWidth, float imageHeight, int repeat, String imageUrl, byte[] imageData, float offsetX, float offsetY) throws Exception {
        this.contentByte.saveState();
        this.clip(x, y, width, height);
        PdfTemplate image = null;
        if (imageUrl != null && this.pageDevice.getImageCache().containsKey(imageUrl)) {
            image = this.pageDevice.getImageCache().get(imageUrl);
        }
        if (image == null) {
            Image img = Image.getInstance((byte[])imageData);
            if (imageHeight == 0.0f || imageWidth == 0.0f) {
                int resolutionX = img.getDpiX();
                int resolutionY = img.getDpiY();
                if (resolutionX == 0 || resolutionY == 0) {
                    resolutionX = 96;
                    resolutionY = 96;
                }
                imageWidth = img.getPlainWidth() / (float)resolutionX * 72.0f;
                imageHeight = img.getPlainHeight() / (float)resolutionY * 72.0f;
            }
            image = this.contentByte.createTemplate(imageWidth, imageHeight);
            image.addImage(img, imageWidth, 0.0f, 0.0f, imageHeight, 0.0f, 0.0f);
            if (imageUrl != null && image != null) {
                this.pageDevice.getImageCache().put(imageUrl, image);
            }
        }
        boolean xExtended = (repeat & 1) == 1;
        boolean yExtended = (repeat & 2) == 2;
        imageWidth = image.getWidth();
        imageHeight = image.getHeight();
        float originalX = offsetX;
        float originalY = offsetY;
        if (xExtended) {
            while (originalX > 0.0f) {
                originalX -= imageWidth;
            }
        }
        if (yExtended) {
            while (originalY > 0.0f) {
                originalY -= imageHeight;
            }
        }
        float startY = originalY;
        do {
            float startX = originalX;
            do {
                this.drawImage(image, x + startX, y + startY, imageWidth, imageHeight);
            } while ((startX += imageWidth) < width && xExtended);
        } while ((startY += imageHeight) < height && yExtended);
        this.contentByte.restoreState();
    }

    protected void drawImage(String imageId, byte[] imageData, String extension, float imageX, float imageY, float height, float width, String helpText, Map params) throws Exception {
        if (FlashFile.isFlash(null, null, (String)extension)) {
            this.embedFlash(null, imageData, imageX, imageY, height, width, helpText, params);
            return;
        }
        PdfTemplate template = null;
        if (imageId != null) {
            if (this.pageDevice.getImageCache().containsKey(imageId)) {
                template = this.pageDevice.getImageCache().get(imageId);
            }
            if (template != null) {
                this.drawImage(template, imageX, imageY, height, width, helpText);
                return;
            }
        }
        if (SvgFile.isSvg(null, null, (String)extension)) {
            template = this.generateTemplateFromSVG(null, imageData, imageX, imageY, height, width, helpText);
        } else {
            Image image = Image.getInstance((byte[])imageData);
            if (imageId == null) {
                this.drawImage(image, imageX, imageY, height, width, helpText);
                return;
            }
            template = this.contentByte.createTemplate(width, height);
            template.addImage(image, width, 0.0f, 0.0f, height, 0.0f, 0.0f);
        }
        if (imageId != null && template != null) {
            this.pageDevice.getImageCache().put(imageId, template);
        }
        if (template != null) {
            this.drawImage(template, imageX, imageY, height, width, helpText);
        }
    }

    @Deprecated
    protected void drawImage(String uri, String extension, float imageX, float imageY, float height, float width, String helpText, Map params) throws Exception {
    }

    protected void drawLine(float startX, float startY, float endX, float endY, float width, Color color, int lineStyle) {
        if (color == null || 0.0f == width || 28 == lineStyle) {
            return;
        }
        this.contentByte.saveState();
        if (21 == lineStyle) {
            this.drawRawLine(startX, startY, endX, endY, width, color, this.contentByte);
        } else if (22 == lineStyle) {
            this.contentByte.setLineDash(3.0f * width, 2.0f * width, 0.0f);
            this.drawRawLine(startX, startY, endX, endY, width, color, this.contentByte);
        } else if (20 == lineStyle) {
            this.contentByte.setLineDash(width, width, 0.0f);
            this.drawRawLine(startX, startY, endX, endY, width, color, this.contentByte);
        } else {
            if (23 == lineStyle) {
                return;
            }
            this.drawRawLine(startX, startY, endX, endY, width, color, this.contentByte);
        }
        this.contentByte.restoreState();
    }

    protected void drawText(String text, float textX, float textY, float baseline, float width, float height, TextStyle textStyle) {
        this.drawText1(text, textX, textY + baseline, textStyle.getFontInfo(), this.convertToPoint(textStyle.getLetterSpacing()), this.convertToPoint(textStyle.getWordSpacing()), textStyle.getColor(), textStyle.getAlign());
        if (textStyle.isHasHyperlink()) {
            FontInfo fontInfo = textStyle.getFontInfo();
            float lineWidth = fontInfo.getLineWidth();
            Color color = textStyle.getColor();
            this.drawDecorationLine(textX, textY, width, lineWidth, this.convertToPoint(fontInfo.getUnderlinePosition()), color);
        }
    }

    private void drawText1(String text, float textX, float textY, FontInfo fontInfo, float characterSpacing, float wordSpacing, Color color, CSSValue align) {
        this.drawText(text, textX, textY, fontInfo, characterSpacing, wordSpacing, color, align);
    }

    public void drawTotalPage(String text, int textX, int textY, int width, int height, TextStyle textInfo, float scale) {
        PdfTemplate template = this.pageDevice.getPDFTemplate(Float.valueOf(scale));
        if (template != null) {
            PdfContentByte tempCB = this.contentByte;
            this.containerHeight = template.getHeight();
            this.contentByte = template;
            this.drawText(text, textX, textY, width, height, textInfo);
            this.contentByte = tempCB;
            this.containerHeight = this.pageHeight;
        }
    }

    public void createBookmark(String bookmark, int x, int y, int width, int height) {
        this.createBookmark(bookmark, this.convertToPoint(y));
    }

    private void createBookmark(String bookmark, float y) {
        this.contentByte.localDestination(bookmark, new PdfDestination(0, -1.0f, this.transformY(y), 0.0f));
    }

    public void createHyperlink(String hyperlink, String bookmark, String targetWindow, int type, int x, int y, int width, int height) {
        this.createHyperlink(hyperlink, bookmark, targetWindow, type, this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height));
    }

    private void createHyperlink(String hyperlink, String bookmark, String targetWindow, int type, float x, float y, float width, float height) {
        y = this.transformY(y, height);
        this.writer.addAnnotation(new PdfAnnotation(this.writer, x, y, x + width, y + height, this.createPdfAction(hyperlink, bookmark, targetWindow, type)));
    }

    public void createTotalPageTemplate(int x, int y, int width, int height, float scale) {
        this.createTotalPageTemplate(this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height), scale);
    }

    private void createTotalPageTemplate(float x, float y, float width, float height, float scale) {
        PdfTemplate template = null;
        if (this.pageDevice.hasTemplate(Float.valueOf(scale))) {
            template = this.pageDevice.getPDFTemplate(Float.valueOf(scale));
        } else {
            template = this.contentByte.createTemplate(width, height);
            this.pageDevice.setPDFTemplate(Float.valueOf(scale), template);
        }
        y = this.transformY(y, height);
        this.contentByte.saveState();
        this.contentByte.addTemplate(template, x, y);
        this.contentByte.restoreState();
    }

    private void drawRawLine(float startX, float startY, float endX, float endY, float width, Color color, PdfContentByte contentByte) {
        startY = this.transformY(startY);
        endY = this.transformY(endY);
        contentByte.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, startX, startY);
        contentByte.moveTo(0.0f, 0.0f);
        contentByte.lineTo(endX - startX, endY - startY);
        contentByte.setLineWidth(width);
        contentByte.setColorStroke(color);
        contentByte.stroke();
    }

    private void drawText(String text, float textX, float textY, FontInfo fontInfo, float characterSpacing, float wordSpacing, Color color, CSSValue align) {
        this.contentByte.saveState();
        this.contentByte.beginText();
        if (color != null && !Color.BLACK.equals(color)) {
            this.contentByte.setColorFill(color);
            this.contentByte.setColorStroke(color);
        }
        BaseFont font = this.getBaseFont(fontInfo);
        float fontSize = fontInfo.getFontSize();
        try {
            this.contentByte.setFontAndSize(font, fontSize);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, e.getMessage());
            this.contentByte.setFontAndSize(font, MIN_FONT_SIZE * 2.0f);
        }
        if (characterSpacing != 0.0f) {
            this.contentByte.setCharacterSpacing(characterSpacing);
        }
        if (wordSpacing != 0.0f) {
            this.contentByte.setWordSpacing(wordSpacing);
        }
        this.setTextMatrix(this.contentByte, fontInfo, textX, this.transformY(textY, 0.0f, this.containerHeight));
        if (font.getFontType() == 3 && CSSValueConstants.JUSTIFY_VALUE.equals(align) && wordSpacing > 0.0f) {
            int idx = text.indexOf(32);
            if (idx >= 0) {
                float spaceCorrection = -wordSpacing * 1000.0f / fontSize;
                PdfTextArray textArray = new PdfTextArray(text.substring(0, idx));
                int lastIdx = idx;
                while ((idx = text.indexOf(32, lastIdx + 1)) >= 0) {
                    textArray.add(spaceCorrection);
                    textArray.add(text.substring(lastIdx, idx));
                    lastIdx = idx;
                }
                textArray.add(spaceCorrection);
                textArray.add(text.substring(lastIdx));
                this.contentByte.showText(textArray);
            } else {
                this.contentByte.showText(text);
            }
        } else {
            this.contentByte.showText(text);
        }
        this.contentByte.endText();
        this.contentByte.restoreState();
    }

    protected BaseFont getBaseFont(FontInfo fontInfo) {
        return fontInfo.getBaseFont();
    }

    private PdfAction createPdfAction(String hyperlink, String bookmark, String target, int type) {
        if ("_top".equalsIgnoreCase(target) || "_parent".equalsIgnoreCase(target) || "_blank".equalsIgnoreCase(target) || "_self".equalsIgnoreCase(target)) {
            Matcher matcher;
            boolean isUrl;
            if (hyperlink == null) {
                hyperlink = "";
            }
            if (!(isUrl = hyperlink.startsWith("http")) && (matcher = PAGE_LINK_PATTERN.matcher(hyperlink)).find()) {
                String fileName = matcher.group(1);
                String pageNumber = matcher.group(matcher.groupCount());
                return new PdfAction(fileName, Integer.parseInt(pageNumber));
            }
            return new PdfAction(hyperlink);
        }
        if (type == 2) {
            return PdfAction.gotoLocalPage((String)bookmark, (boolean)false);
        }
        return PdfAction.gotoRemotePage((String)hyperlink, (String)bookmark, (boolean)false, (boolean)false);
    }

    private void setTextMatrix(PdfContentByte cb, FontInfo fi, float x, float y) {
        cb.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, x, y);
        if (!fi.getSimulation()) {
            cb.setTextMatrix(0.0f, 0.0f);
            return;
        }
        switch (fi.getFontStyle()) {
            case 2: {
                this.simulateItalic(cb);
                break;
            }
            case 1: {
                this.simulateBold(cb, fi.getFontWeight());
                break;
            }
            case 3: {
                this.simulateBold(cb, fi.getFontWeight());
                this.simulateItalic(cb);
            }
        }
    }

    private void simulateBold(PdfContentByte cb, int fontWeight) {
        cb.setTextRenderingMode(2);
        if (fontWeightLineWidthMap.containsKey(fontWeight)) {
            cb.setLineWidth(fontWeightLineWidthMap.get(fontWeight).floatValue());
        } else {
            cb.setLineWidth(0.225f);
        }
        cb.setTextMatrix(0.0f, 0.0f);
    }

    private void simulateItalic(PdfContentByte cb) {
        float beta = EmitterUtil.ITALIC_HORIZONTAL_COEFFICIENT;
        cb.setTextMatrix(1.0f, 0.0f, beta, 1.0f, 0.0f, 0.0f);
    }

    public void showHelpText(String helpText, float x, float y, float width, float height) {
        this.showHelpText(x, this.transformY(y, height), width, height, helpText);
    }

    protected void showHelpText(float x, float y, float width, float height, String helpText) {
        Rectangle rectangle = new Rectangle(x, y, x + width, y + height);
        PdfAnnotation annotation = PdfAnnotation.createSquareCircle((PdfWriter)this.writer, (Rectangle)rectangle, (String)helpText, (boolean)true);
        PdfBorderDictionary borderStyle = new PdfBorderDictionary(0.0f, 0, null);
        annotation.setBorderStyle(borderStyle);
        annotation.setFlags(288);
        this.writer.addAnnotation(annotation);
    }

    protected void drawImage(PdfTemplate image, float imageX, float imageY, float height, float width, String helpText) throws DocumentException {
        imageY = this.transformY(imageY, height);
        this.contentByte.saveState();
        this.contentByte.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, imageX, imageY);
        float w = image.getWidth();
        float h = image.getHeight();
        this.contentByte.addTemplate(image, width / w, 0.0f / w, 0.0f / h, height / h, 0.0f, 0.0f);
        if (helpText != null) {
            this.showHelpText(imageX, imageY, width, height, helpText);
        }
        this.contentByte.restoreState();
    }

    private void drawImage(PdfTemplate image, float imageX, float imageY, float width, float height) throws DocumentException {
        this.drawImage(image, imageX, imageY, height, width, null);
    }

    protected void drawImage(Image image, float imageX, float imageY, float height, float width, String helpText) throws DocumentException {
        imageY = this.transformY(imageY, height);
        this.contentByte.saveState();
        this.contentByte.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, imageX, imageY);
        this.contentByte.addImage(image, width, 0.0f, 0.0f, height, 0.0f, 0.0f);
        if (helpText != null) {
            this.showHelpText(imageX, imageY, width, height, helpText);
        }
        this.contentByte.restoreState();
    }

    protected void embedFlash(String flashPath, byte[] flashData, float x, float y, float height, float width, String helpText, Map params) throws IOException {
        y = this.transformY(y, height);
        this.contentByte.saveState();
        PdfFileSpecification fs = PdfFileSpecification.fileEmbedded((PdfWriter)this.writer, (String)flashPath, (String)helpText, (byte[])flashData);
        PdfAnnotation annot = PdfAnnotation.createScreen((PdfWriter)this.writer, (Rectangle)new Rectangle(x, y, x + width, y + height), (String)helpText, (PdfFileSpecification)fs, (String)"application/x-shockwave-flash", (boolean)true);
        this.writer.addAnnotation(annot);
        if (helpText != null) {
            this.showHelpText(x, y, width, height, helpText);
        }
        this.contentByte.restoreState();
    }

    protected PdfTemplate generateTemplateFromSVG(String svgPath, byte[] svgData, float x, float y, float height, float width, String helpText) throws Exception {
        return this.transSVG(null, svgData, x, y, height, width, helpText);
    }

    protected PdfTemplate transSVG(String svgPath, byte[] svgData, float x, float y, float height, float width, String helpText) throws IOException, DocumentException {
        PdfTemplate template = this.contentByte.createTemplate(width, height);
        Graphics2D g2D = template.createGraphics(width, height);
        PrintTranscoder transcoder = new PrintTranscoder();
        if (svgData != null && svgData.length > 0) {
            transcoder.transcode(new TranscoderInput((InputStream)new ByteArrayInputStream(svgData)), null);
        } else if (svgPath != null) {
            transcoder.transcode(new TranscoderInput(svgPath), null);
        }
        PageFormat pg = new PageFormat();
        Paper p = new Paper();
        p.setSize(width, height);
        p.setImageableArea(0.0, 0.0, width, height);
        pg.setPaper(p);
        transcoder.print((Graphics)g2D, pg, 0);
        g2D.dispose();
        return template;
    }
}

