/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.GeneralFontPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.LibraryDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.FormTextSection;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.SeperatorSection;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.TextSection;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class GeneralPage
extends GeneralFontPage {
    private TextSection librarySection;
    private SeperatorSection seperatorSection;
    private FormTextSection noteSection;

    @Override
    public void buildUI(Composite parent) {
        super.buildUI(parent);
        this.container.setLayout((Layout)WidgetUtil.createGridLayout((int)6, (int)15));
        LibraryDescriptorProvider provider = new LibraryDescriptorProvider();
        this.librarySection = new TextSection(provider.getDisplayName(), this.container, true);
        this.librarySection.setWidth(500);
        this.librarySection.setFillText(false);
        this.librarySection.setProvider(provider);
        this.addSection("GENERAL_LIBRARY", this.librarySection);
        this.noteSection = new FormTextSection("", this.container, true);
        this.noteSection.setWidth(500);
        this.noteSection.setFillText(false);
        this.noteSection.setText("<form><p><span color=\"color\">" + Messages.getFormattedString((String)"GeneralPage.Library.Modified.Note", (Object[])new Object[]{"</span> <img href=\"image\"/> <span color=\"color\">"}) + "</span></p></form>");
        this.noteSection.setImage("image", ReportPlatformUIImages.getImage((String)"Enable Resotre Properties"));
        this.noteSection.setColor("color", ColorManager.getColor((int)127, (int)127, (int)127));
        this.addSection("GENERAL_LIBRARY_NOTE", this.noteSection);
        this.seperatorSection = new SeperatorSection(this.container, 256);
        this.addSection("GENERAL_SEPERATOR", this.seperatorSection);
        this.buildContent();
        this.createSections();
        this.layoutSections();
    }

    @Override
    public void refresh() {
        if (this.input instanceof List && DEUtil.getMultiSelectionHandle((List)((List)this.input)).isExtendedElements()) {
            this.librarySection.setHidden(false);
            if (this.hasLocalProperties()) {
                this.noteSection.setHidden(false);
                Font font = JFaceResources.getDialogFont();
                FontData fData = font.getFontData()[0];
                fData.setHeight(fData.getHeight() - 1);
                this.noteSection.getTextControl().setFont(FontManager.getFont((FontData)fData));
            } else {
                this.noteSection.setHidden(true);
            }
            this.seperatorSection.setHidden(false);
            this.librarySection.load();
        } else {
            this.librarySection.setHidden(true);
            this.noteSection.setHidden(true);
            this.seperatorSection.setHidden(true);
        }
        super.refresh();
        this.container.layout(true);
        this.container.redraw();
    }

    private boolean hasLocalProperties() {
        GroupElementHandle groupHandle = DEUtil.getGroupElementHandle((List)((List)this.input));
        return groupHandle.hasLocalPropertiesForExtendedElements();
    }

    protected abstract void buildContent();
}

