/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart;

import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.UnitsOfMeasurement;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartNumberEditor;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.ChartSpinner;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextNumberEditorAssistField;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class GeneralPropertiesChartSheet
extends AbstractPopupSheet
implements Listener,
ModifyListener,
SelectionListener {
    private Composite cmpContent;
    private ExternalizedTextEditorComposite txtDescription;
    private Text txtType;
    private Text txtSubType;
    private ChartSpinner txtUnitSpacing;
    private ChartCombo cmbUnits;
    private Label lblSeriesThickness;
    private AbstractChartNumberEditor txtSeriesThickness;
    private ChartSpinner iscColumnCount;
    private String sOldUnits = "";

    public GeneralPropertiesChartSheet(String title, ChartWizardContext context) {
        super(title, context, false);
    }

    @Override
    protected void bindHelp(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.ChartGeneralProperties_ID");
    }

    @Override
    protected Composite getComponent(Composite parent) {
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.cmpContent.setLayout((Layout)glContent);
        GridLayout glGeneral = new GridLayout();
        glGeneral.numColumns = 3;
        glGeneral.horizontalSpacing = 5;
        glGeneral.verticalSpacing = 5;
        glGeneral.marginHeight = 7;
        glGeneral.marginWidth = 7;
        this.createDescriptionArea(this.cmpContent);
        Group grpGeneral = new Group(this.cmpContent, 0);
        GridData gdGRPGeneral = new GridData(770);
        grpGeneral.setLayoutData((Object)gdGRPGeneral);
        grpGeneral.setLayout((Layout)glGeneral);
        grpGeneral.setText(Messages.getString("AttributeSheetImpl.Lbl.ChartProperties"));
        Label lblType = new Label((Composite)grpGeneral, 0);
        GridData gdLBLType = new GridData();
        gdLBLType.horizontalIndent = 1;
        lblType.setLayoutData((Object)gdLBLType);
        lblType.setText(Messages.getString("AttributeSheetImpl.Lbl.Type"));
        this.txtType = new Text((Composite)grpGeneral, 2056);
        GridData gdTXTType = new GridData(768);
        gdTXTType.horizontalSpan = 2;
        this.txtType.setLayoutData((Object)gdTXTType);
        this.txtType.setText(this.getContext().getChartType().getDisplayName());
        Label lblSubType = new Label((Composite)grpGeneral, 0);
        GridData gdLBLSubType = new GridData();
        gdLBLSubType.horizontalIndent = 1;
        lblSubType.setLayoutData((Object)gdLBLSubType);
        lblSubType.setText(Messages.getString("AttributeSheetImpl.Lbl.Subtype"));
        this.txtSubType = new Text((Composite)grpGeneral, 2056);
        GridData gdTXTSubType = new GridData(768);
        gdTXTSubType.horizontalSpan = 2;
        this.txtSubType.setLayoutData((Object)gdTXTSubType);
        this.txtSubType.setText("");
        Orientation orientation = Orientation.VERTICAL_LITERAL;
        if (this.getChart() instanceof ChartWithAxes) {
            orientation = ((ChartWithAxes)this.getChart()).getOrientation();
        }
        Vector vSubType = (Vector)this.getContext().getChartType().getChartSubtypes(this.getChart().getDimension().getName(), orientation);
        for (IChartSubType cSubType : vSubType) {
            if (!cSubType.getName().equals(this.getChart().getSubType())) continue;
            this.txtSubType.setText(cSubType.getDisplayName());
            break;
        }
        this.createMisc(grpGeneral);
        return this.cmpContent;
    }

    protected void createMisc(Group grpGeneral) {
        if (this.getChart().getDimension().getValue() == 1) {
            Label lblUnit = new Label((Composite)grpGeneral, 0);
            GridData gdLBLUnit = new GridData();
            gdLBLUnit.horizontalIndent = 1;
            lblUnit.setLayoutData((Object)gdLBLUnit);
            lblUnit.setText(Messages.getString("AttributeSheetImpl.Lbl.Units"));
            this.cmbUnits = this.getContext().getUIFactory().createChartCombo((Composite)grpGeneral, 12, (EObject)this.getChart(), "units", ChartDefaultValueUtil.getDefaultValueChart((Chart)this.getChart()).getUnits());
            GridData gdCMBUnits = new GridData(768);
            gdCMBUnits.horizontalSpan = 2;
            this.cmbUnits.setLayoutData((Object)gdCMBUnits);
            this.cmbUnits.addSelectionListener((SelectionListener)this);
            this.lblSeriesThickness = new Label((Composite)grpGeneral, 0);
            GridData gdLBLSeriesThickness = new GridData();
            gdLBLSeriesThickness.horizontalIndent = 1;
            this.lblSeriesThickness.setLayoutData((Object)gdLBLSeriesThickness);
            this.txtSeriesThickness = this.getContext().getUIFactory().createChartNumberEditor((Composite)grpGeneral, 2052, null, (EObject)this.getChart(), "seriesThickness");
            new TextNumberEditorAssistField(this.txtSeriesThickness.getTextControl(), null);
            GridData gdTXTSeriesThickness = new GridData(768);
            gdTXTSeriesThickness.horizontalSpan = 2;
            this.txtSeriesThickness.setLayoutData((Object)gdTXTSeriesThickness);
            double dblPoints = this.getChart().getSeriesThickness();
            double dblCurrent = this.getContext().getUIServiceProvider().getConvertedValue(dblPoints, "Points", this.getUnits());
            this.txtSeriesThickness.setValue(dblCurrent);
            this.txtSeriesThickness.addModifyListener((ModifyListener)this);
            this.populateLists();
        }
        if (this.getChart() instanceof ChartWithoutAxes) {
            Label lblColumnCount = new Label((Composite)grpGeneral, 0);
            GridData gdLBLColumnCount = new GridData();
            gdLBLColumnCount.horizontalIndent = 1;
            lblColumnCount.setLayoutData((Object)gdLBLColumnCount);
            lblColumnCount.setText(Messages.getString("AttributeSheetImpl.Lbl.ColumnCount"));
            this.iscColumnCount = this.getContext().getUIFactory().createChartSpinner((Composite)grpGeneral, 2048, (EObject)this.getChart(), "gridColumnCount", true);
            GridData gdISCColumnCount = new GridData(768);
            gdISCColumnCount.horizontalSpan = 2;
            this.iscColumnCount.setLayoutData((Object)gdISCColumnCount);
            this.iscColumnCount.getWidget().setMinimum(0);
            this.iscColumnCount.getWidget().setMaximum(5);
            this.iscColumnCount.getWidget().setSelection(this.getChart().getGridColumnCount());
        } else if (this.getChart() instanceof ChartWithAxes) {
            Label lblUnitSpacing = new Label((Composite)grpGeneral, 0);
            GridData gdUnitSpacing = new GridData();
            gdUnitSpacing.horizontalIndent = 1;
            lblUnitSpacing.setLayoutData((Object)gdUnitSpacing);
            lblUnitSpacing.setText(Messages.getString("AttributeSheetImpl.Lbl.UnitSpacing"));
            this.txtUnitSpacing = this.getContext().getUIFactory().createChartSpinner((Composite)grpGeneral, 2048, (EObject)this.getChart(), "unitSpacing", true);
            GridData gdTXTUnitSpacing = new GridData(768);
            gdTXTUnitSpacing.horizontalSpan = 2;
            this.txtUnitSpacing.setLayoutData((Object)gdTXTUnitSpacing);
            this.txtUnitSpacing.getWidget().setMinimum(0);
            this.txtUnitSpacing.getWidget().setMaximum(100);
            this.txtUnitSpacing.getWidget().setIncrement(1);
            double unitSpacing = ((ChartWithAxes)this.getChart()).getUnitSpacing();
            this.txtUnitSpacing.getWidget().setSelection((int)unitSpacing);
        }
    }

    private void createDescriptionArea(Composite parent) {
        Composite cmpDesp = new Composite(parent, 0);
        cmpDesp.setLayout((Layout)new GridLayout(2, false));
        GridData griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.widthHint = 300;
        cmpDesp.setLayoutData((Object)griddata);
        List keys = null;
        if (this.getContext().getUIServiceProvider() != null) {
            keys = this.getContext().getUIServiceProvider().getRegisteredKeys();
        }
        Label lblDescription = new Label(cmpDesp, 0);
        GridData gdLBLDescription = new GridData(2);
        gdLBLDescription.horizontalIndent = 2;
        gdLBLDescription.grabExcessHorizontalSpace = false;
        lblDescription.setLayoutData((Object)gdLBLDescription);
        lblDescription.setText(Messages.getString("GeneralSheetImpl.Lbl.Description"));
        String sDescription = "";
        if (this.getChart().getDescription() != null) {
            sDescription = this.getChart().getDescription().getValue();
        }
        this.txtDescription = new ExternalizedTextEditorComposite(cmpDesp, 2114, 65, -1, keys, this.getContext().getUIServiceProvider(), sDescription);
        GridData gdTXTDescription = new GridData(768);
        gdTXTDescription.heightHint = 65;
        this.txtDescription.setLayoutData(gdTXTDescription);
        this.txtDescription.addListener(this);
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.unitsOfMeasurementSet;
        this.cmbUnits.setItems(ns.getDisplayNames());
        this.cmbUnits.setItemData(ns.getNames());
        this.cmbUnits.setSelection(this.getUnits());
        this.sOldUnits = this.cmbUnits.getSelectedItemData();
        if (this.sOldUnits == null) {
            this.sOldUnits = ChartDefaultValueUtil.getDefaultUnits((Chart)this.getChart());
        }
        this.lblSeriesThickness.setText(new MessageFormat(Messages.getString("GeneralSheetImpl.Lbl.SeriesWidth")).format(new Object[]{LiteralHelper.unitsOfMeasurementSet.getDisplayNameByName(this.getUnits())}));
    }

    private String getUnits() {
        String units = this.getChart().getUnits();
        if (units == null) {
            units = ChartDefaultValueUtil.getDefaultUnits((Chart)this.getChart());
        }
        return units;
    }

    private double recalculateUnitDependentValues(double value) {
        return this.getContext().getUIServiceProvider().getConvertedValue(value, this.sOldUnits, this.cmbUnits.getSelectedItemData() == null ? ChartDefaultValueUtil.getDefaultUnits((Chart)this.getChart()) : this.cmbUnits.getSelectedItemData());
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget.equals(this.txtSeriesThickness) && !"Reset".equals(e.data)) {
            this.updateToSeriesThickness();
        }
    }

    protected void updateToSeriesThickness() {
        double dblCurrent = this.txtSeriesThickness.getValue();
        String selectUnits = this.cmbUnits.getSelectedItemData();
        double dblPoints = this.getContext().getUIServiceProvider().getConvertedValue(dblCurrent, selectUnits == null ? ChartDefaultValueUtil.getDefaultUnits((Chart)this.getChart()) : selectUnits, UnitsOfMeasurement.POINTS_LITERAL.getName());
        this.getChart().setSeriesThickness(dblPoints);
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.txtDescription)) {
            if (this.getChart().getDescription() != null) {
                this.getChart().getDescription().setValue(this.txtDescription.getText());
            } else {
                org.eclipse.birt.chart.model.attribute.Text description = TextImpl.create((String)this.txtDescription.getText());
                this.getChart().setDescription(description);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmbUnits)) {
            String selectedUnits = this.cmbUnits.getSelectedItemData();
            if (selectedUnits != null) {
                this.getChart().setUnits(selectedUnits);
                this.txtSeriesThickness.setValue(this.recalculateUnitDependentValues(this.txtSeriesThickness.getValue()));
            }
            this.lblSeriesThickness.setText(new MessageFormat(Messages.getString("GeneralSheetImpl.Lbl.SeriesWidth")).format(new Object[]{LiteralHelper.unitsOfMeasurementSet.getDisplayNameByName(this.getUnits())}));
            this.sOldUnits = this.getUnits();
        }
    }
}

