/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.util.sessionlog.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.eclipse.app4mc.util.sessionlog.SessionLogEntry;
import org.eclipse.app4mc.util.sessionlog.SessionLogWriter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

@Component
public class SessionLogFileWriter
implements SessionLogWriter {
    LoggerFactory factory;
    Logger logger;

    public void write(File sessionLogFile, List<SessionLogEntry> log) {
        block16: {
            Path parentPath = Paths.get(sessionLogFile.getAbsolutePath(), new String[0]).getParent();
            if (!Files.exists(parentPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(parentPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    if (this.logger == null) break block16;
                    this.logger.error("Failed to create the output folder for the session log file", (Object)e);
                }
            }
        }
        try {
            Throwable e = null;
            Object var5_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(sessionLogFile));){
                for (SessionLogEntry logEntry : log) {
                    writer.append(logEntry.message);
                    writer.newLine();
                    if (logEntry.throwable == null) continue;
                    writer.append(logEntry.getStackTrace());
                    writer.newLine();
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.error("Failed to write session log file!", (Object)e);
            }
            e.printStackTrace();
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    void setLogger(LoggerFactory factory) {
        this.factory = factory;
        this.logger = factory.getLogger(this.getClass());
    }

    void unsetLogger(LoggerFactory loggerFactory) {
        if (this.factory == loggerFactory) {
            this.factory = null;
            this.logger = null;
        }
    }
}

