#!/bin/bash

OLDFILES="cutmp3.tk"
PROGS="xcutmp3 xcutmp3.pl"
DESKTOPFILES="xcutmp3.desktop"
APPLNKS="cutwithxcutmp3.desktop"

function check_environ {
#Check to see if we can coax kde-config into the PATH
echo "Checking for kde-config..."
if [ -z "$(type 'kde-config' 2> /dev/null)" ]; then #Odd way of checking if kde-config is in $PATH
  kdialog --error "kde-config not found, checking for \$KDEDIR to compensate..."
  if [ ! -z $KDEDIR ]; then
    export PATH=$PATH:$KDEDIR/bin
  else
    KDEDIR=$(kdialog --title Where\ is\ KDE\ installed\? --getexistingdirectory / )
    test -z $KDEDIR && exit 1
    export PATH=$PATH:$KDEDIR/bin
  fi
fi
echo "Okay."
}

function deletefiles {
    rm -f /usr/bin/${1}
    rm -f $(kde-config --prefix)/share/applnk/Multimedia/${1}
    rm -f $(kde-config --prefix)/share/apps/konqueror/servicemenus/${1}
}

if [ -z $1 ]
then option="--$(kdialog --menu Please\ select\ installation\ type global install  remove uninstall removeold uninstall\ outdated\ files  2> /dev/null)"
else option=$1
fi


case $option in
  "--global" )
    if [ "$(id -u)" != "0" ]
    then exec kdesu "$0 --global"
    fi
    check_environ
    PREFIX=$(kde-config --prefix)
    echo "Installing desktop file in $PREFIX ..."
    ;;
  "-h" )
    echo "Usage: $0 [--global|--remove|--removeold]"
    echo
    echo "--global       system-wide installation."
    echo "--remove       attempts to remove previous installations."
    echo "--removeold    attempts to remove obsolete files."
    echo
    exit 0
    ;;
  "--help" )
    echo "Usage: $0 [--global|--remove|--removeold]"
    echo
    echo "--global       system-wide installation."
    echo "--remove       attempts to remove previous installations."
    echo "--removeold    attempts to remove obsolete files."
    echo
    exit 0
    ;;
  "--remove" )
    if [ "$(id -u)" != "0" ]
    then exec kdesu "$0 --remove"
    fi
    check_environ
    echo "Attempting to remove installation."
    for file in $OLDFILES
    do
    deletefiles "$file"
    done
    for file in $PROGS
    do
    deletefiles "$file"
    done
    for file in $DESKTOPFILES
    do
    deletefiles "$file"
    done
    for file in $APPLNKS
    do
    deletefiles "$file"
    done
    echo "Uninstall finished."
    exit 0
    ;;
  "--removeold" )
    check_environ
    echo "Attempting to remove obsolete files."
    if [ "$(id -u)" != "0" ]
    then exec kdesu "$0 --removeold"
    fi
    for file in $OLDFILES
    do
    deletefiles "$file"
    done
    echo "Obsolete files deleting finished."
    exit 0
    ;;
  * )
    echo "Installation cancelled."
    exit 1
esac

test ! -z "$PREFIX" && cp -vf $DESKTOPFILES $PREFIX/share/applnk/Multimedia/
test ! -z "$PREFIX" && cp -vf $APPLNKS $PREFIX/share/apps/konqueror/servicemenus/
cp -vf $PROGS /usr/bin/

echo "Done."
