#pragma once

#ifndef XSHROWVIEWER_H
#define XSHROWVIEWER_H

#include <QWidget>

// forward declaration
class XsheetViewer;
class QMenu;

namespace XsheetGUI {

class DragTool;

//=============================================================================
// RowArea
//-----------------------------------------------------------------------------

//! La classe si occupa della visualizzazione dell'area che gestisce le righe.
class RowArea final : public QWidget {
  Q_OBJECT
  XsheetViewer *m_viewer;
  int m_row;

  enum ShowOnionToSetFlag {
    None = 0,
    Fos,
    Mos,
    ShiftTraceGhost
  } m_showOnionToSet;

  enum Direction { up = 0, down };

  // Play ranges
  int m_r0;
  int m_r1;

  QPoint m_pos;
  bool m_playRangeActiveInMousePress;
  int m_mousePressRow;
  QString m_tooltip;

  // panning by middle-drag
  bool m_isPanning;

  // returns true if the frame area can have extra space
  bool checkExpandFrameArea();
  void drawRows(QPainter &p, int r0, int r1);
  void drawPlayRangeBackground(QPainter &p, int r0, int r1);
  void drawPlayRange(QPainter &p, int r0, int r1);
  void drawCurrentRowGadget(QPainter &p, int r0, int r1);
  void drawOnionSkinBackground(QPainter &p, int r0, int r1);
  void drawOnionSkinSelection(QPainter &p);
  void drawPinnedCenterKeys(QPainter &p, int r0, int r1);
  void drawCurrentTimeIndicator(QPainter &p);
  void drawCurrentTimeLine(QPainter &p);
  void drawShiftTraceMarker(QPainter &p);

#if defined(x64)
  void drawStopMotionCameraIndicator(QPainter &p);
#endif

  void drawNavigationTags(QPainter &p, int r0, int r1);

  DragTool *getDragTool() const;
  void setDragTool(DragTool *dragTool);

  // Return when the item-menu setAutoMarkers can be enabled.
  bool canSetAutoMarkers();
  // Return the number of the last non-empty cell found. You can set the
  // direction of the search.
  int getNonEmptyCell(int row, int column, Direction);

public:
  RowArea(XsheetViewer *parent, Qt::WindowFlags flags = Qt::WindowFlags());
  ~RowArea();

protected:
  void paintEvent(QPaintEvent *) override;

  void mousePressEvent(QMouseEvent *event) override;
  void mouseMoveEvent(QMouseEvent *event) override;
  void mouseReleaseEvent(QMouseEvent *event) override;
  void contextMenuEvent(QContextMenuEvent *event) override;
  void mouseDoubleClickEvent(QMouseEvent *event) override;
  bool event(QEvent *event) override;

  void setMarker(int index);

protected slots:

  void onSetStartMarker();
  void onSetStopMarker();
  void onRemoveMarkers();

  // Set start and end marker automatically respect the current row and column.
  void onSetAutoMarkers();

  // set both the from and to markers at the specified row
  void onPreviewThis();

protected slots:
  void onJumpToTag();
};

}  // namespace XsheetGUI

#endif  // XSHROWVIEWER_H
