/*
  Definition of constant tables
  This module contains most of the constant data that can be stored in ROM.
*/

#include <stdio.h>

#include "aacplusenc.h"


#ifdef _WIN32
#pragma warning(disable : 4305) /* disable truncation from double to float warning */
#endif

/*
  MDCT constants, constants for mdct 1024 and 128 point transforms and
  windowing operation
*/

const float LongWindowSine [FRAME_LEN_LONG] ={
  +7.66990318742704e-004,+2.30096915142581e-003,+3.83494256970623e-003,+5.36890696399634e-003,
  +6.90285872472976e-003,+8.43679424236980e-003,+9.97070990741803e-003,+1.15046021104227e-002,
  +1.30384672419873e-002,+1.45723016927791e-002,+1.61061018535373e-002,+1.76398641150821e-002,
  +1.91735848683226e-002,+2.07072605042659e-002,+2.22408874140250e-002,+2.37744619888276e-002,
  +2.53079806200246e-002,+2.68414396990985e-002,+2.83748356176721e-002,+2.99081647675166e-002,
  +3.14414235405603e-002,+3.29746083288973e-002,+3.45077155247958e-002,+3.60407415207062e-002,
  +3.75736827092705e-002,+3.91065354833299e-002,+4.06392962359337e-002,+4.21719613603479e-002,
  +4.37045272500634e-002,+4.52369902988046e-002,+4.67693469005379e-002,+4.83015934494801e-002,
  +4.98337263401073e-002,+5.13657419671626e-002,+5.28976367256653e-002,+5.44294070109191e-002,
  +5.59610492185206e-002,+5.74925597443676e-002,+5.90239349846679e-002,+6.05551713359478e-002,
  +6.20862651950601e-002,+6.36172129591931e-002,+6.51480110258788e-002,+6.66786557930016e-002,
  +6.82091436588063e-002,+6.97394710219073e-002,+7.12696342812964e-002,+7.27996298363517e-002,
  +7.43294540868458e-002,+7.58591034329544e-002,+7.73885742752650e-002,+7.89178630147849e-002,
  +8.04469660529500e-002,+8.19758797916331e-002,+8.35046006331524e-002,+8.50331249802803e-002,
  +8.65614492362512e-002,+8.80895698047705e-002,+8.96174830900230e-002,+9.11451854966810e-002,
  +9.26726734299133e-002,+9.41999432953932e-002,+9.57269914993072e-002,+9.72538144483633e-002,
  +9.87804085497996e-002,+1.00306770211393e-001,+1.01832895841467e-001,+1.03358781848900e-001,
  +1.04884424643135e-001,+1.06409820634188e-001,+1.07934966232654e-001,+1.09459857849718e-001,
  +1.10984491897163e-001,+1.12508864787379e-001,+1.14032972933367e-001,+1.15556812748755e-001,
  +1.17080380647801e-001,+1.18603673045401e-001,+1.20126686357102e-001,+1.21649416999106e-001,
  +1.23171861388280e-001,+1.24694015942168e-001,+1.26215877078990e-001,+1.27737441217662e-001,
  +1.29258704777796e-001,+1.30779664179712e-001,+1.32300315844445e-001,+1.33820656193755e-001,
  +1.35340681650134e-001,+1.36860388636816e-001,+1.38379773577784e-001,+1.39898832897777e-001,
  +1.41417563022303e-001,+1.42935960377643e-001,+1.44454021390860e-001,+1.45971742489812e-001,
  +1.47489120103154e-001,+1.49006150660348e-001,+1.50522830591677e-001,+1.52039156328246e-001,
  +1.53555124301993e-001,+1.55070730945701e-001,+1.56585972692998e-001,+1.58100845978377e-001,
  +1.59615347237193e-001,+1.61129472905679e-001,+1.62643219420950e-001,+1.64156583221016e-001,
  +1.65669560744784e-001,+1.67182148432073e-001,+1.68694342723617e-001,+1.70206140061078e-001,
  +1.71717536887050e-001,+1.73228529645070e-001,+1.74739114779627e-001,+1.76249288736168e-001,
  +1.77759047961107e-001,+1.79268388901836e-001,+1.80777308006729e-001,+1.82285801725153e-001,
  +1.83793866507478e-001,+1.85301498805082e-001,+1.86808695070359e-001,+1.88315451756732e-001,
  +1.89821765318656e-001,+1.91327632211631e-001,+1.92833048892205e-001,+1.94338011817989e-001,
  +1.95842517447658e-001,+1.97346562240966e-001,+1.98850142658750e-001,+2.00353255162940e-001,
  +2.01855896216568e-001,+2.03358062283773e-001,+2.04859749829814e-001,+2.06360955321076e-001,
  +2.07861675225075e-001,+2.09361906010474e-001,+2.10861644147085e-001,+2.12360886105878e-001,
  +2.13859628358994e-001,+2.15357867379746e-001,+2.16855599642633e-001,+2.18352821623346e-001,
  +2.19849529798779e-001,+2.21345720647031e-001,+2.22841390647421e-001,+2.24336536280494e-001,
  +2.25831154028026e-001,+2.27325240373039e-001,+2.28818791799802e-001,+2.30311804793845e-001,
  +2.31804275841965e-001,+2.33296201432232e-001,+2.34787578054001e-001,+2.36278402197920e-001,
  +2.37768670355934e-001,+2.39258379021300e-001,+2.40747524688588e-001,+2.42236103853696e-001,
  +2.43724113013852e-001,+2.45211548667628e-001,+2.46698407314942e-001,+2.48184685457075e-001,
  +2.49670379596669e-001,+2.51155486237742e-001,+2.52640001885696e-001,+2.54123923047321e-001,
  +2.55607246230807e-001,+2.57089967945753e-001,+2.58572084703170e-001,+2.60053593015495e-001,
  +2.61534489396596e-001,+2.63014770361779e-001,+2.64494432427802e-001,+2.65973472112876e-001,
  +2.67451885936678e-001,+2.68929670420357e-001,+2.70406822086545e-001,+2.71883337459360e-001,
  +2.73359213064419e-001,+2.74834445428844e-001,+2.76309031081271e-001,+2.77782966551858e-001,
  +2.79256248372291e-001,+2.80728873075797e-001,+2.82200837197148e-001,+2.83672137272668e-001,
  +2.85142769840249e-001,+2.86612731439348e-001,+2.88082018611004e-001,+2.89550627897843e-001,
  +2.91018555844085e-001,+2.92485798995554e-001,+2.93952353899685e-001,+2.95418217105532e-001,
  +2.96883385163778e-001,+2.98347854626741e-001,+2.99811622048383e-001,+3.01274683984318e-001,
  +3.02737036991819e-001,+3.04198677629829e-001,+3.05659602458966e-001,+3.07119808041533e-001,
  +3.08579290941525e-001,+3.10038047724638e-001,+3.11496074958276e-001,+3.12953369211560e-001,
  +3.14409927055337e-001,+3.15865745062184e-001,+3.17320819806422e-001,+3.18775147864118e-001,
  +3.20228725813100e-001,+3.21681550232957e-001,+3.23133617705052e-001,+3.24584924812532e-001,
  +3.26035468140330e-001,+3.27485244275178e-001,+3.28934249805612e-001,+3.30382481321983e-001,
  +3.31829935416461e-001,+3.33276608683048e-001,+3.34722497717581e-001,+3.36167599117745e-001,
  +3.37611909483075e-001,+3.39055425414970e-001,+3.40498143516697e-001,+3.41940060393402e-001,
  +3.43381172652115e-001,+3.44821476901759e-001,+3.46260969753160e-001,+3.47699647819051e-001,
  +3.49137507714085e-001,+3.50574546054838e-001,+3.52010759459819e-001,+3.53446144549481e-001,
  +3.54880697946223e-001,+3.56314416274402e-001,+3.57747296160342e-001,+3.59179334232337e-001,
  +3.60610527120662e-001,+3.62040871457584e-001,+3.63470363877364e-001,+3.64899001016267e-001,
  +3.66326779512574e-001,+3.67753696006582e-001,+3.69179747140620e-001,+3.70604929559052e-001,
  +3.72029239908285e-001,+3.73452674836780e-001,+3.74875230995058e-001,+3.76296905035705e-001,
  +3.77717693613386e-001,+3.79137593384847e-001,+3.80556601008929e-001,+3.81974713146567e-001,
  +3.83391926460809e-001,+3.84808237616813e-001,+3.86223643281863e-001,+3.87638140125373e-001,
  +3.89051724818894e-001,+3.90464394036127e-001,+3.91876144452922e-001,+3.93286972747296e-001,
  +3.94696875599434e-001,+3.96105849691696e-001,+3.97513891708632e-001,+3.98920998336983e-001,
  +4.00327166265690e-001,+4.01732392185905e-001,+4.03136672790995e-001,+4.04540004776553e-001,
  +4.05942384840403e-001,+4.07343809682608e-001,+4.08744276005481e-001,+4.10143780513590e-001,
  +4.11542319913765e-001,+4.12939890915108e-001,+4.14336490228999e-001,+4.15732114569105e-001,
  +4.17126760651388e-001,+4.18520425194110e-001,+4.19913104917844e-001,+4.21304796545480e-001,
  +4.22695496802233e-001,+4.24085202415652e-001,+4.25473910115624e-001,+4.26861616634386e-001,
  +4.28248318706532e-001,+4.29634013069016e-001,+4.31018696461167e-001,+4.32402365624690e-001,
  +4.33785017303679e-001,+4.35166648244619e-001,+4.36547255196401e-001,+4.37926834910323e-001,
  +4.39305384140100e-001,+4.40682899641873e-001,+4.42059378174215e-001,+4.43434816498138e-001,
  +4.44809211377105e-001,+4.46182559577030e-001,+4.47554857866293e-001,+4.48926103015743e-001,
  +4.50296291798709e-001,+4.51665420991002e-001,+4.53033487370932e-001,+4.54400487719304e-001,
  +4.55766418819435e-001,+4.57131277457157e-001,+4.58495060420826e-001,+4.59857764501330e-001,
  +4.61219386492092e-001,+4.62579923189087e-001,+4.63939371390839e-001,+4.65297727898435e-001,
  +4.66654989515531e-001,+4.68011153048360e-001,+4.69366215305738e-001,+4.70720173099072e-001,
  +4.72073023242369e-001,+4.73424762552242e-001,+4.74775387847917e-001,+4.76124895951244e-001,
  +4.77473283686698e-001,+4.78820547881394e-001,+4.80166685365088e-001,+4.81511692970190e-001,
  +4.82855567531766e-001,+4.84198305887549e-001,+4.85539904877947e-001,+4.86880361346047e-001,
  +4.88219672137627e-001,+4.89557834101157e-001,+4.90894844087815e-001,+4.92230698951486e-001,
  +4.93565395548775e-001,+4.94898930739011e-001,+4.96231301384258e-001,+4.97562504349319e-001,
  +4.98892536501745e-001,+5.00221394711841e-001,+5.01549075852675e-001,+5.02875576800087e-001,
  +5.04200894432690e-001,+5.05525025631885e-001,+5.06847967281863e-001,+5.08169716269615e-001,
  +5.09490269484936e-001,+5.10809623820439e-001,+5.12127776171555e-001,+5.13444723436543e-001,
  +5.14760462516501e-001,+5.16074990315367e-001,+5.17388303739929e-001,+5.18700399699835e-001,
  +5.20011275107596e-001,+5.21320926878596e-001,+5.22629351931097e-001,+5.23936547186249e-001,
  +5.25242509568095e-001,+5.26547236003579e-001,+5.27850723422555e-001,+5.29152968757791e-001,
  +5.30453968944976e-001,+5.31753720922733e-001,+5.33052221632619e-001,+5.34349468019138e-001,
  +5.35645457029741e-001,+5.36940185614843e-001,+5.38233650727822e-001,+5.39525849325029e-001,
  +5.40816778365797e-001,+5.42106434812444e-001,+5.43394815630285e-001,+5.44681917787635e-001,
  +5.45967738255818e-001,+5.47252274009174e-001,+5.48535522025067e-001,+5.49817479283891e-001,
  +5.51098142769075e-001,+5.52377509467096e-001,+5.53655576367479e-001,+5.54932340462810e-001,
  +5.56207798748740e-001,+5.57481948223992e-001,+5.58754785890368e-001,+5.60026308752760e-001,
  +5.61296513819151e-001,+5.62565398100627e-001,+5.63832958611378e-001,+5.65099192368714e-001,
  +5.66364096393064e-001,+5.67627667707986e-001,+5.68889903340176e-001,+5.70150800319470e-001,
  +5.71410355678857e-001,+5.72668566454481e-001,+5.73925429685651e-001,+5.75180942414845e-001,
  +5.76435101687722e-001,+5.77687904553123e-001,+5.78939348063082e-001,+5.80189429272832e-001,
  +5.81438145240810e-001,+5.82685493028668e-001,+5.83931469701276e-001,+5.85176072326730e-001,
  +5.86419297976361e-001,+5.87661143724737e-001,+5.88901606649676e-001,+5.90140683832249e-001,
  +5.91378372356788e-001,+5.92614669310891e-001,+5.93849571785434e-001,+5.95083076874570e-001,
  +5.96315181675744e-001,+5.97545883289693e-001,+5.98775178820459e-001,+6.00003065375389e-001,
  +6.01229540065149e-001,+6.02454600003724e-001,+6.03678242308430e-001,+6.04900464099920e-001,
  +6.06121262502186e-001,+6.07340634642573e-001,+6.08558577651779e-001,+6.09775088663868e-001,
  +6.10990164816272e-001,+6.12203803249798e-001,+6.13416001108639e-001,+6.14626755540375e-001,
  +6.15836063695985e-001,+6.17043922729850e-001,+6.18250329799760e-001,+6.19455282066924e-001,
  +6.20658776695972e-001,+6.21860810854965e-001,+6.23061381715401e-001,+6.24260486452221e-001,
  +6.25458122243814e-001,+6.26654286272029e-001,+6.27848975722176e-001,+6.29042187783036e-001,
  +6.30233919646864e-001,+6.31424168509402e-001,+6.32612931569877e-001,+6.33800206031017e-001,
  +6.34985989099049e-001,+6.36170277983712e-001,+6.37353069898259e-001,+6.38534362059467e-001,
  +6.39714151687640e-001,+6.40892436006621e-001,+6.42069212243793e-001,+6.43244477630086e-001,
  +6.44418229399988e-001,+6.45590464791549e-001,+6.46761181046384e-001,+6.47930375409685e-001,
  +6.49098045130226e-001,+6.50264187460366e-001,+6.51428799656060e-001,+6.52591878976862e-001,
  +6.53753422685936e-001,+6.54913428050056e-001,+6.56071892339618e-001,+6.57228812828643e-001,
  +6.58384186794785e-001,+6.59538011519339e-001,+6.60690284287242e-001,+6.61841002387087e-001,
  +6.62990163111121e-001,+6.64137763755260e-001,+6.65283801619087e-001,+6.66428274005865e-001,
  +6.67571178222540e-001,+6.68712511579748e-001,+6.69852271391821e-001,+6.70990454976794e-001,
  +6.72127059656412e-001,+6.73262082756133e-001,+6.74395521605139e-001,+6.75527373536339e-001,
  +6.76657635886375e-001,+6.77786305995632e-001,+6.78913381208238e-001,+6.80038858872079e-001,
  +6.81162736338795e-001,+6.82285010963796e-001,+6.83405680106259e-001,+6.84524741129142e-001,
  +6.85642191399187e-001,+6.86758028286926e-001,+6.87872249166686e-001,+6.88984851416597e-001,
  +6.90095832418600e-001,+6.91205189558448e-001,+6.92312920225718e-001,+6.93419021813812e-001,
  +6.94523491719966e-001,+6.95626327345255e-001,+6.96727526094601e-001,+6.97827085376777e-001,
  +6.98925002604414e-001,+7.00021275194006e-001,+7.01115900565919e-001,+7.02208876144392e-001,
  +7.03300199357549e-001,+7.04389867637400e-001,+7.05477878419852e-001,+7.06564229144710e-001,
  +7.07648917255684e-001,+7.08731940200401e-001,+7.09813295430401e-001,+7.10892980401152e-001,
  +7.11970992572050e-001,+7.13047329406429e-001,+7.14121988371565e-001,+7.15194966938680e-001,
  +7.16266262582953e-001,+7.17335872783522e-001,+7.18403795023490e-001,+7.19470026789933e-001,
  +7.20534565573905e-001,+7.21597408870444e-001,+7.22658554178576e-001,+7.23717999001323e-001,
  +7.24775740845711e-001,+7.25831777222770e-001,+7.26886105647545e-001,+7.27938723639099e-001,
  +7.28989628720519e-001,+7.30038818418926e-001,+7.31086290265474e-001,+7.32132041795361e-001,
  +7.33176070547833e-001,+7.34218374066188e-001,+7.35258949897787e-001,+7.36297795594053e-001,
  +7.37334908710483e-001,+7.38370286806649e-001,+7.39403927446206e-001,+7.40435828196898e-001,
  +7.41465986630563e-001,+7.42494400323139e-001,+7.43521066854669e-001,+7.44545983809307e-001,
  +7.45569148775325e-001,+7.46590559345117e-001,+7.47610213115205e-001,+7.48628107686245e-001,
  +7.49644240663033e-001,+7.50658609654511e-001,+7.51671212273768e-001,+7.52682046138055e-001,
  +7.53691108868781e-001,+7.54698398091524e-001,+7.55703911436036e-001,+7.56707646536246e-001,
  +7.57709601030268e-001,+7.58709772560407e-001,+7.59708158773163e-001,+7.60704757319237e-001,
  +7.61699565853535e-001,+7.62692582035178e-001,+7.63683803527502e-001,+7.64673227998067e-001,
  +7.65660853118662e-001,+7.66646676565310e-001,+7.67630696018273e-001,+7.68612909162058e-001,
  +7.69593313685423e-001,+7.70571907281381e-001,+7.71548687647206e-001,+7.72523652484441e-001,
  +7.73496799498899e-001,+7.74468126400671e-001,+7.75437630904130e-001,+7.76405310727940e-001,
  +7.77371163595056e-001,+7.78335187232733e-001,+7.79297379372530e-001,+7.80257737750317e-001,
  +7.81216260106276e-001,+7.82172944184913e-001,+7.83127787735057e-001,+7.84080788509870e-001,
  +7.85031944266848e-001,+7.85981252767830e-001,+7.86928711779002e-001,+7.87874319070900e-001,
  +7.88818072418420e-001,+7.89759969600819e-001,+7.90700008401722e-001,+7.91638186609126e-001,
  +7.92574502015408e-001,+7.93508952417327e-001,+7.94441535616031e-001,+7.95372249417061e-001,
  +7.96301091630359e-001,+7.97228060070269e-001,+7.98153152555544e-001,+7.99076366909352e-001,
  +7.99997700959282e-001,+8.00917152537344e-001,+8.01834719479981e-001,+8.02750399628069e-001,
  +8.03664190826924e-001,+8.04576090926307e-001,+8.05486097780429e-001,+8.06394209247956e-001,
  +8.07300423192014e-001,+8.08204737480195e-001,+8.09107149984558e-001,+8.10007658581641e-001,
  +8.10906261152460e-001,+8.11802955582515e-001,+8.12697739761799e-001,+8.13590611584799e-001,
  +8.14481568950499e-001,+8.15370609762391e-001,+8.16257731928477e-001,+8.17142933361273e-001,
  +8.18026211977813e-001,+8.18907565699659e-001,+8.19786992452899e-001,+8.20664490168157e-001,
  +8.21540056780598e-001,+8.22413690229926e-001,+8.23285388460400e-001,+8.24155149420829e-001,
  +8.25022971064580e-001,+8.25888851349587e-001,+8.26752788238349e-001,+8.27614779697938e-001,
  +8.28474823700007e-001,+8.29332918220788e-001,+8.30189061241102e-001,+8.31043250746362e-001,
  +8.31895484726578e-001,+8.32745761176359e-001,+8.33594078094925e-001,+8.34440433486103e-001,
  +8.35284825358337e-001,+8.36127251724692e-001,+8.36967710602857e-001,+8.37806200015151e-001,
  +8.38642717988527e-001,+8.39477262554579e-001,+8.40309831749541e-001,+8.41140423614298e-001,
  +8.41969036194388e-001,+8.42795667540004e-001,+8.43620315706004e-001,+8.44442978751911e-001,
  +8.45263654741918e-001,+8.46082341744897e-001,+8.46899037834397e-001,+8.47713741088654e-001,
  +8.48526449590593e-001,+8.49337161427831e-001,+8.50145874692685e-001,+8.50952587482176e-001,
  +8.51757297898029e-001,+8.52560004046684e-001,+8.53360704039295e-001,+8.54159395991739e-001,
  +8.54956078024615e-001,+8.55750748263254e-001,+8.56543404837720e-001,+8.57334045882816e-001,
  +8.58122669538086e-001,+8.58909273947824e-001,+8.59693857261073e-001,+8.60476417631632e-001,
  +8.61256953218062e-001,+8.62035462183687e-001,+8.62811942696600e-001,+8.63586392929668e-001,
  +8.64358811060534e-001,+8.65129195271624e-001,+8.65897543750149e-001,+8.66663854688111e-001,
  +8.67428126282307e-001,+8.68190356734331e-001,+8.68950544250582e-001,+8.69708687042266e-001,
  +8.70464783325398e-001,+8.71218831320811e-001,+8.71970829254158e-001,+8.72720775355914e-001,
  +8.73468667861385e-001,+8.74214505010706e-001,+8.74958285048852e-001,+8.75700006225635e-001,
  +8.76439666795714e-001,+8.77177265018596e-001,+8.77912799158642e-001,+8.78646267485068e-001,
  +8.79377668271953e-001,+8.80106999798240e-001,+8.80834260347742e-001,+8.81559448209144e-001,
  +8.82282561676009e-001,+8.83003599046781e-001,+8.83722558624790e-001,+8.84439438718254e-001,
  +8.85154237640285e-001,+8.85866953708893e-001,+8.86577585246987e-001,+8.87286130582383e-001,
  +8.87992588047806e-001,+8.88696955980892e-001,+8.89399232724196e-001,+8.90099416625192e-001,
  +8.90797506036281e-001,+8.91493499314791e-001,+8.92187394822982e-001,+8.92879190928052e-001,
  +8.93568886002136e-001,+8.94256478422316e-001,+8.94941966570621e-001,+8.95625348834030e-001,
  +8.96306623604480e-001,+8.96985789278864e-001,+8.97662844259041e-001,+8.98337786951834e-001,
  +8.99010615769039e-001,+8.99681329127424e-001,+9.00349925448736e-001,+9.01016403159702e-001,
  +9.01680760692038e-001,+9.02342996482444e-001,+9.03003108972617e-001,+9.03661096609248e-001,
  +9.04316957844028e-001,+9.04970691133653e-001,+9.05622294939825e-001,+9.06271767729258e-001,
  +9.06919107973678e-001,+9.07564314149833e-001,+9.08207384739489e-001,+9.08848318229439e-001,
  +9.09487113111505e-001,+9.10123767882542e-001,+9.10758281044438e-001,+9.11390651104122e-001,
  +9.12020876573568e-001,+9.12648955969794e-001,+9.13274887814868e-001,+9.13898670635912e-001,
  +9.14520302965104e-001,+9.15139783339685e-001,+9.15757110301957e-001,+9.16372282399289e-001,
  +9.16985298184123e-001,+9.17596156213973e-001,+9.18204855051431e-001,+9.18811393264170e-001,
  +9.19415769424947e-001,+9.20017982111607e-001,+9.20618029907084e-001,+9.21215911399409e-001,
  +9.21811625181708e-001,+9.22405169852210e-001,+9.22996544014246e-001,+9.23585746276257e-001,
  +9.24172775251791e-001,+9.24757629559514e-001,+9.25340307823206e-001,+9.25920808671770e-001,
  +9.26499130739231e-001,+9.27075272664740e-001,+9.27649233092581e-001,+9.28221010672169e-001,
  +9.28790604058057e-001,+9.29358011909936e-001,+9.29923232892640e-001,+9.30486265676150e-001,
  +9.31047108935595e-001,+9.31605761351258e-001,+9.32162221608574e-001,+9.32716488398140e-001,
  +9.33268560415712e-001,+9.33818436362211e-001,+9.34366114943726e-001,+9.34911594871516e-001,
  +9.35454874862015e-001,+9.35995953636831e-001,+9.36534829922756e-001,+9.37071502451759e-001,
  +9.37605969961000e-001,+9.38138231192824e-001,+9.38668284894770e-001,+9.39196129819570e-001,
  +9.39721764725153e-001,+9.40245188374651e-001,+9.40766399536396e-001,+9.41285396983929e-001,
  +9.41802179495998e-001,+9.42316745856564e-001,+9.42829094854803e-001,+9.43339225285108e-001,
  +9.43847135947093e-001,+9.44352825645595e-001,+9.44856293190677e-001,+9.45357537397632e-001,
  +9.45856557086984e-001,+9.46353351084491e-001,+9.46847918221148e-001,+9.47340257333192e-001,
  +9.47830367262101e-001,+9.48318246854599e-001,+9.48803894962658e-001,+9.49287310443502e-001,
  +9.49768492159607e-001,+9.50247438978705e-001,+9.50724149773790e-001,+9.51198623423113e-001,
  +9.51670858810194e-001,+9.52140854823816e-001,+9.52608610358033e-001,+9.53074124312172e-001,
  +9.53537395590833e-001,+9.53998423103894e-001,+9.54457205766513e-001,+9.54913742499131e-001,
  +9.55368032227470e-001,+9.55820073882545e-001,+9.56269866400658e-001,+9.56717408723403e-001,
  +9.57162699797670e-001,+9.57605738575646e-001,+9.58046524014819e-001,+9.58485055077976e-001,
  +9.58921330733213e-001,+9.59355349953931e-001,+9.59787111718840e-001,+9.60216615011963e-001,
  +9.60643858822638e-001,+9.61068842145519e-001,+9.61491563980579e-001,+9.61912023333112e-001,
  +9.62330219213737e-001,+9.62746150638399e-001,+9.63159816628371e-001,+9.63571216210257e-001,
  +9.63980348415994e-001,+9.64387212282854e-001,+9.64791806853448e-001,+9.65194131175725e-001,
  +9.65594184302977e-001,+9.65991965293841e-001,+9.66387473212299e-001,+9.66780707127683e-001,
  +9.67171666114677e-001,+9.67560349253314e-001,+9.67946755628988e-001,+9.68330884332445e-001,
  +9.68712734459795e-001,+9.69092305112506e-001,+9.69469595397413e-001,+9.69844604426715e-001,
  +9.70217331317979e-001,+9.70587775194144e-001,+9.70955935183518e-001,+9.71321810419786e-001,
  +9.71685400042009e-001,+9.72046703194624e-001,+9.72405719027450e-001,+9.72762446695689e-001,
  +9.73116885359925e-001,+9.73469034186131e-001,+9.73818892345666e-001,+9.74166459015280e-001,
  +9.74511733377116e-001,+9.74854714618708e-001,+9.75195401932990e-001,+9.75533794518291e-001,
  +9.75869891578341e-001,+9.76203692322271e-001,+9.76535195964614e-001,+9.76864401725313e-001,
  +9.77191308829712e-001,+9.77515916508569e-001,+9.77838223998050e-001,+9.78158230539735e-001,
  +9.78475935380617e-001,+9.78791337773106e-001,+9.79104436975029e-001,+9.79415232249635e-001,
  +9.79723722865591e-001,+9.80029908096990e-001,+9.80333787223348e-001,+9.80635359529608e-001,
  +9.80934624306142e-001,+9.81231580848750e-001,+9.81526228458665e-001,+9.81818566442553e-001,
  +9.82108594112514e-001,+9.82396310786085e-001,+9.82681715786241e-001,+9.82964808441396e-001,
  +9.83245588085407e-001,+9.83524054057571e-001,+9.83800205702631e-001,+9.84074042370776e-001,
  +9.84345563417642e-001,+9.84614768204313e-001,+9.84881656097324e-001,+9.85146226468662e-001,
  +9.85408478695768e-001,+9.85668412161538e-001,+9.85926026254321e-001,+9.86181320367928e-001,
  +9.86434293901627e-001,+9.86684946260147e-001,+9.86933276853678e-001,+9.87179285097874e-001,
  +9.87422970413855e-001,+9.87664332228206e-001,+9.87903369972978e-001,+9.88140083085693e-001,
  +9.88374471009341e-001,+9.88606533192386e-001,+9.88836269088764e-001,+9.89063678157882e-001,
  +9.89288759864625e-001,+9.89511513679355e-001,+9.89731939077911e-001,+9.89950035541609e-001,
  +9.90165802557248e-001,+9.90379239617108e-001,+9.90590346218950e-001,+9.90799121866020e-001,
  +9.91005566067049e-001,+9.91209678336254e-001,+9.91411458193339e-001,+9.91610905163495e-001,
  +9.91808018777406e-001,+9.92002798571245e-001,+9.92195244086674e-001,+9.92385354870852e-001,
  +9.92573130476429e-001,+9.92758570461551e-001,+9.92941674389860e-001,+9.93122441830496e-001,
  +9.93300872358093e-001,+9.93476965552789e-001,+9.93650721000219e-001,+9.93822138291520e-001,
  +9.93991217023329e-001,+9.94157956797790e-001,+9.94322357222546e-001,+9.94484417910748e-001,
  +9.94644138481051e-001,+9.94801518557617e-001,+9.94956557770116e-001,+9.95109255753726e-001,
  +9.95259612149133e-001,+9.95407626602535e-001,+9.95553298765638e-001,+9.95696628295664e-001,
  +9.95837614855342e-001,+9.95976258112918e-001,+9.96112557742151e-001,+9.96246513422316e-001,
  +9.96378124838200e-001,+9.96507391680111e-001,+9.96634313643870e-001,+9.96758890430818e-001,
  +9.96881121747814e-001,+9.97001007307235e-001,+9.97118546826980e-001,+9.97233740030466e-001,
  +9.97346586646633e-001,+9.97457086409942e-001,+9.97565239060376e-001,+9.97671044343441e-001,
  +9.97774502010168e-001,+9.97875611817110e-001,+9.97974373526347e-001,+9.98070786905482e-001,
  +9.98164851727646e-001,+9.98256567771495e-001,+9.98345934821212e-001,+9.98432952666508e-001,
  +9.98517621102622e-001,+9.98599939930320e-001,+9.98679908955899e-001,+9.98757527991183e-001,
  +9.98832796853528e-001,+9.98905715365818e-001,+9.98976283356470e-001,+9.99044500659429e-001,
  +9.99110367114175e-001,+9.99173882565716e-001,+9.99235046864596e-001,+9.99293859866888e-001,
  +9.99350321434199e-001,+9.99404431433671e-001,+9.99456189737977e-001,+9.99505596225325e-001,
  +9.99552650779457e-001,+9.99597353289648e-001,+9.99639703650710e-001,+9.99679701762988e-001,
  +9.99717347532362e-001,+9.99752640870249e-001,+9.99785581693599e-001,+9.99816169924900e-001,
  +9.99844405492175e-001,+9.99870288328983e-001,+9.99893818374418e-001,+9.99914995573113e-001,
  +9.99933819875236e-001,+9.99950291236490e-001,+9.99964409618118e-001,+9.99976174986898e-001,
  +9.99985587315143e-001,+9.99992646580707e-001,+9.99997352766978e-001,+9.99999705862882e-001
}; 

const float ShortWindowSine [FRAME_LEN_SHORT] ={
  +6.13588464915448e-003,+1.84067299058048e-002,+3.06748031766366e-002,+4.29382569349408e-002,
  +5.51952443496899e-002,+6.74439195636641e-002,+7.96824379714301e-002,+9.19089564971327e-002,
  +1.04121633872055e-001,+1.16318630911905e-001,+1.28498110793793e-001,+1.40658239332849e-001,
  +1.52797185258443e-001,+1.64913120489970e-001,+1.77004220412149e-001,+1.89068664149806e-001,
  +2.01104634842092e-001,+2.13110319916091e-001,+2.25083911359793e-001,+2.37023605994367e-001,
  +2.48927605745720e-001,+2.60794117915276e-001,+2.72621355449949e-001,+2.84407537211272e-001,
  +2.96150888243624e-001,+3.07849640041535e-001,+3.19502030816016e-001,+3.31106305759876e-001,
  +3.42660717311994e-001,+3.54163525420490e-001,+3.65612997804774e-001,+3.77007410216418e-001,
  +3.88345046698826e-001,+3.99624199845647e-001,+4.10843171057904e-001,+4.22000270799800e-001,
  +4.33093818853152e-001,+4.44122144570429e-001,+4.55083587126344e-001,+4.65976495767966e-001,
  +4.76799230063322e-001,+4.87550160148436e-001,+4.98227666972782e-001,+5.08830142543107e-001,
  +5.19355990165590e-001,+5.29803624686295e-001,+5.40171472729893e-001,+5.50457972936605e-001,
  +5.60661576197336e-001,+5.70780745886967e-001,+5.80813958095765e-001,+5.90759701858874e-001,
  +6.00616479383869e-001,+6.10382806276309e-001,+6.20057211763289e-001,+6.29638238914927e-001,
  +6.39124444863776e-001,+6.48514401022112e-001,+6.57806693297079e-001,+6.66999922303637e-001,
  +6.76092703575316e-001,+6.85083667772700e-001,+6.93971460889654e-001,+7.02754744457225e-001,
  +7.11432195745216e-001,+7.20002507961382e-001,+7.28464390448225e-001,+7.36816568877370e-001,
  +7.45057785441466e-001,+7.53186799043612e-001,+7.61202385484262e-001,+7.69103337645580e-001,
  +7.76888465673232e-001,+7.84556597155575e-001,+7.92106577300212e-001,+7.99537269107905e-001,
  +8.06847553543799e-001,+8.14036329705948e-001,+8.21102514991105e-001,+8.28045045257756e-001,
  +8.34862874986380e-001,+8.41554977436898e-001,+8.48120344803297e-001,+8.54557988365401e-001,
  +8.60866938637767e-001,+8.67046245515693e-001,+8.73094978418290e-001,+8.79012226428633e-001,
  +8.84797098430938e-001,+8.90448723244758e-001,+8.95966249756185e-001,+9.01348847046022e-001,
  +9.06595704514915e-001,+9.11706032005430e-001,+9.16679059921043e-001,+9.21514039342042e-001,
  +9.26210242138311e-001,+9.30766961078984e-001,+9.35183509938948e-001,+9.39459223602190e-001,
  +9.43593458161960e-001,+9.47585591017741e-001,+9.51435020969008e-001,+9.55141168305771e-001,
  +9.58703474895872e-001,+9.62121404269042e-001,+9.65394441697689e-001,+9.68522094274417e-001,
  +9.71503890986252e-001,+9.74339382785576e-001,+9.77028142657754e-001,+9.79569765685441e-001,
  +9.81963869109555e-001,+9.84210092386929e-001,+9.86308097244599e-001,+9.88257567730749e-001,
  +9.90058210262297e-001,+9.91709753669100e-001,+9.93211949234795e-001,+9.94564570734255e-001,
  +9.95767414467660e-001,+9.96820299291166e-001,+9.97723066644192e-001,+9.98475580573295e-001,
  +9.99077727752645e-001,+9.99529417501093e-001,+9.99830581795823e-001,+9.99981175282601e-001,
};


const float LongWindowKBD [FRAME_LEN_LONG]={
  +2.92561538963610e-004,+4.29985673530470e-004,+5.46740745895400e-004,+6.54823042997920e-004,
  +7.58701950687470e-004,+8.60593317133360e-004,+9.61775414390100e-004,+1.06306094108780e-003,
  +1.16500363081320e-003,+1.26800121941480e-003,+1.37235172329560e-003,+1.47828641091360e-003,
  +1.58599019767190e-003,+1.69561482523730e-003,+1.80728769035170e-003,+1.92111794055140e-003,
  +2.03720079242150e-003,+2.15562065917540e-003,+2.27645345996140e-003,+2.39976835409950e-003,
  +2.52562906311560e-003,+2.65409489208310e-003,+2.78522152814030e-003,+2.91906167153310e-003,
  +3.05566554432230e-003,+3.19508129433910e-003,+3.33735532403920e-003,+3.48253255869300e-003,
  +3.63065666991990e-003,+3.78177026046460e-003,+3.93591501797190e-003,+4.09313184372600e-003,
  +4.25346096100260e-003,+4.41694200669640e-003,+4.58361410913410e-003,+4.75351595440860e-003,
  +4.92668584312140e-003,+5.10316173906980e-003,+5.28298131113350e-003,+5.46618196939750e-003,
  +5.65280089636820e-003,+5.84287507399430e-003,+6.03644130708820e-003,+6.23353624364920e-003,
  +6.43419639250790e-003,+6.63845813865030e-003,+6.84635775652180e-003,+7.05793142157150e-003,
  +7.27321522025590e-003,+7.49224515869090e-003,+7.71505717011620e-003,+7.94168712131150e-003,
  +8.17217081808570e-003,+8.40654400994580e-003,+8.64484239403630e-003,+8.88710161842910e-003,
  +9.13335728483450e-003,+9.38364495079390e-003,+9.63800013140860e-003,+9.89645830065170e-003,
  +1.01590548923060e-002,+1.04258253005610e-002,+1.06968048803100e-002,+1.09720289471670e-002,
  +1.12515327772360e-002,+1.15353516066460e-002,+1.18235206308970e-002,+1.21160750039930e-002,
  +1.24130498374290e-002,+1.27144801989990e-002,+1.30204011114780e-002,+1.33308475511610e-002,
  +1.36458544462880e-002,+1.39654566753520e-002,+1.42896890653140e-002,+1.46185863897120e-002,
  +1.49521833666970e-002,+1.52905146569760e-002,+1.56336148616880e-002,+1.59815185202140e-002,
  +1.63342601079150e-002,+1.66918740338170e-002,+1.70543946382410e-002,+1.74218561903800e-002,
  +1.77942928858320e-002,+1.81717388440850e-002,+1.85542281059620e-002,+1.89417946310320e-002,
  +1.93344722949800e-002,+1.97322948869470e-002,+2.01352961068390e-002,+2.05435095626040e-002,
  +2.09569687674880e-002,+2.13757071372570e-002,+2.17997579874070e-002,+2.22291545303430e-002,
  +2.26639298725400e-002,+2.31041170116890e-002,+2.35497488338160e-002,+2.40008581103980e-002,
  +2.44574774954510e-002,+2.49196395226130e-002,+2.53873766022070e-002,+2.58607210182950e-002,
  +2.63397049257260e-002,+2.68243603471600e-002,+2.73147191701000e-002,+2.78108131439000e-002,
  +2.83126738767750e-002,+2.88203328328010e-002,+2.93338213289050e-002,+2.98531705318590e-002,
  +3.03784114552550e-002,+3.09095749564900e-002,+3.14466917337390e-002,+3.19897923229260e-002,
  +3.25389070946930e-002,+3.30940662513690e-002,+3.36552998239350e-002,+3.42226376689910e-002,
  +3.47961094657170e-002,+3.53757447128440e-002,+3.59615727256160e-002,+3.65536226327580e-002,
  +3.71519233734460e-002,+3.77565036942770e-002,+3.83673921462430e-002,+3.89846170817110e-002,
  +3.96082066513980e-002,+4.02381888013590e-002,+4.08745912699760e-002,+4.15174415849500e-002,
  +4.21667670603010e-002,+4.28225947933760e-002,+4.34849516618520e-002,+4.41538643207600e-002,
  +4.48293591995090e-002,+4.55114624989130e-002,+4.62002001882340e-002,+4.68955980022280e-002,
  +4.75976814382010e-002,+4.83064757530740e-002,+4.90220059604550e-002,+4.97442968277250e-002,
  +5.04733728731290e-002,+5.12092583628790e-002,+5.19519773082730e-002,+5.27015534628130e-002,
  +5.34580103193500e-002,+5.42213711072230e-002,+5.49916587894280e-002,+5.57688960597870e-002,
  +5.65531053401340e-002,+5.73443087775130e-002,+5.81425282413930e-002,+5.89477853208930e-002,
  +5.97601013220190e-002,+6.05794972649260e-002,+6.14059938811800e-002,+6.22396116110490e-002,
  +6.30803706007990e-002,+6.39282907000120e-002,+6.47833914589190e-002,+6.56456921257470e-002,
  +6.65152116440860e-002,+6.73919686502690e-002,+6.82759814707770e-002,+6.91672681196520e-002,
  +7.00658462959350e-002,+7.09717333811210e-002,+7.18849464366300e-002,+7.28055022012990e-002,
  +7.37334170888960e-002,+7.46687071856490e-002,+7.56113882477940e-002,+7.65614756991520e-002,
  +7.75189846287150e-002,+7.84839297882610e-002,+7.94563255899860e-002,+8.04361861041620e-002,
  +8.14235250568080e-002,+8.24183558273920e-002,+8.34206914465530e-002,+8.44305445938410e-002,
  +8.54479275954830e-002,+8.64728524221780e-002,+8.75053306869000e-002,+8.85453736427440e-002,
  +8.95929921807800e-002,+9.06481968279370e-002,+9.17109977449190e-002,+9.27814047241310e-002,
  +9.38594271876400e-002,+9.49450741851630e-002,+9.60383543920690e-002,+9.71392761074230e-002,
  +9.82478472520410e-002,+9.93640753665800e-002,+1.00487967609650e-001,+1.01619530755970e-001,
  +1.02758771194510e-001,+1.03905694926710e-001,+1.05060307564690e-001,+1.06222614329490e-001,
  +1.07392620049410e-001,+1.08570329158210e-001,+1.09755745693570e-001,+1.10948873295340e-001,
  +1.12149715204020e-001,+1.13358274259140e-001,+1.14574552897720e-001,+1.15798553152740e-001,
  +1.17030276651700e-001,+1.18269724615100e-001,+1.19516897855040e-001,+1.20771796773830e-001,
  +1.22034421362630e-001,+1.23304771200080e-001,+1.24582845451020e-001,+1.25868642865230e-001,
  +1.27162161776150e-001,+1.28463400099710e-001,+1.29772355333120e-001,+1.31089024553750e-001,
  +1.32413404418010e-001,+1.33745491160250e-001,+1.35085280591730e-001,+1.36432768099610e-001,
  +1.37787948645950e-001,+1.39150816766770e-001,+1.40521366571140e-001,+1.41899591740270e-001,
  +1.43285485526710e-001,+1.44679040753490e-001,+1.46080249813360e-001,+1.47489104668040e-001,
  +1.48905596847500e-001,+1.50329717449290e-001,+1.51761457137900e-001,+1.53200806144140e-001,
  +1.54647754264590e-001,+1.56102290861000e-001,+1.57564404859870e-001,+1.59034084751930e-001,
  +1.60511318591700e-001,+1.61996093997120e-001,+1.63488398149170e-001,+1.64988217791560e-001,
  +1.66495539230420e-001,+1.68010348334040e-001,+1.69532630532700e-001,+1.71062370818420e-001,
  +1.72599553744840e-001,+1.74144163427140e-001,+1.75696183541930e-001,+1.77255597327200e-001,
  +1.78822387582380e-001,+1.80396536668300e-001,+1.81978026507330e-001,+1.83566838583430e-001,
  +1.85162953942330e-001,+1.86766353191740e-001,+1.88377016501480e-001,+1.89994923603840e-001,
  +1.91620053793800e-001,+1.93252385929400e-001,+1.94891898432090e-001,+1.96538569287140e-001,
  +1.98192376044090e-001,+1.99853295817210e-001,+2.01521305286050e-001,+2.03196380695940e-001,
  +2.04878497858650e-001,+2.06567632152980e-001,+2.08263758525400e-001,+2.09966851490830e-001,
  +2.11676885133300e-001,+2.13393833106780e-001,+2.15117668635980e-001,+2.16848364517190e-001,
  +2.18585893119220e-001,+2.20330226384250e-001,+2.22081335828870e-001,+2.23839192545030e-001,
  +2.25603767201110e-001,+2.27375030043000e-001,+2.29152950895170e-001,+2.30937499161890e-001,
  +2.32728643828380e-001,+2.34526353462010e-001,+2.36330596213640e-001,+2.38141339818830e-001,
  +2.39958551599250e-001,+2.41782198464030e-001,+2.43612246911140e-001,+2.45448663028900e-001,
  +2.47291412497400e-001,+2.49140460590070e-001,+2.50995772175220e-001,+2.52857311717630e-001,
  +2.54725043280190e-001,+2.56598930525560e-001,+2.58478936717880e-001,+2.60365024724510e-001,
  +2.62257157017810e-001,+2.64155295676920e-001,+2.66059402389660e-001,+2.67969438454390e-001,
  +2.69885364781900e-001,+2.71807141897420e-001,+2.73734729942560e-001,+2.75668088677360e-001,
  +2.77607177482380e-001,+2.79551955360710e-001,+2.81502380940210e-001,+2.83458412475570e-001,
  +2.85420007850590e-001,+2.87387124580380e-001,+2.89359719813640e-001,+2.91337750334920e-001,
  +2.93321172567040e-001,+2.95309942573380e-001,+2.97304016060340e-001,+2.99303348379740e-001,
  +3.01307894531320e-001,+3.03317609165210e-001,+3.05332446584520e-001,+3.07352360747850e-001,
  +3.09377305271950e-001,+3.11407233434300e-001,+3.13442098175830e-001,+3.15481852103560e-001,
  +3.17526447493410e-001,+3.19575836292880e-001,+3.21629970123900e-001,+3.23688800285650e-001,
  +3.25752277757380e-001,+3.27820353201340e-001,+3.29892976965660e-001,+3.31970099087360e-001,
  +3.34051669295230e-001,+3.36137637012950e-001,+3.38227951362030e-001,+3.40322561164950e-001,
  +3.42421414948200e-001,+3.44524460945470e-001,+3.46631647100720e-001,+3.48742921071430e-001,
  +3.50858230231810e-001,+3.52977521675980e-001,+3.55100742221290e-001,+3.57227838411600e-001,
  +3.59358756520600e-001,+3.61493442555140e-001,+3.63631842258640e-001,+3.65773901114440e-001,
  +3.67919564349300e-001,+3.70068776936760e-001,+3.72221483600700e-001,+3.74377628818780e-001,
  +3.76537156826030e-001,+3.78700011618340e-001,+3.80866136956070e-001,+3.83035476367660e-001,
  +3.85207973153220e-001,+3.87383570388210e-001,+3.89562210927080e-001,+3.91743837407010e-001,
  +3.93928392251570e-001,+3.96115817674490e-001,+3.98306055683420e-001,+4.00499048083700e-001,
  +4.02694736482180e-001,+4.04893062291010e-001,+4.07093966731530e-001,+4.09297390838100e-001,
  +4.11503275461970e-001,+4.13711561275240e-001,+4.15922188774720e-001,+4.18135098285940e-001,
  +4.20350229967020e-001,+4.22567523812740e-001,+4.24786919658480e-001,+4.27008357184230e-001,
  +4.29231775918660e-001,+4.31457115243140e-001,+4.33684314395800e-001,+4.35913312475640e-001,
  +4.38144048446580e-001,+4.40376461141610e-001,+4.42610489266880e-001,+4.44846071405890e-001,
  +4.47083146023590e-001,+4.49321651470570e-001,+4.51561525987270e-001,+4.53802707708130e-001,
  +4.56045134665810e-001,+4.58288744795430e-001,+4.60533475938800e-001,+4.62779265848610e-001,
  +4.65026052192770e-001,+4.67273772558610e-001,+4.69522364457180e-001,+4.71771765327520e-001,
  +4.74021912541000e-001,+4.76272743405570e-001,+4.78524195170090e-001,+4.80776205028690e-001,
  +4.83028710125050e-001,+4.85281647556740e-001,+4.87534954379620e-001,+4.89788567612120e-001,
  +4.92042424239660e-001,+4.94296461218980e-001,+4.96550615482500e-001,+4.98804823942730e-001,
  +5.01059023496650e-001,+5.03313151030040e-001,+5.05567143421940e-001,+5.07820937549010e-001,
  +5.10074470289900e-001,+5.12327678529710e-001,+5.14580499164330e-001,+5.16832869104890e-001,
  +5.19084725282130e-001,+5.21336004650830e-001,+5.23586644194200e-001,+5.25836580928320e-001,
  +5.28085751906480e-001,+5.30334094223670e-001,+5.32581545020920e-001,+5.34828041489740e-001,
  +5.37073520876520e-001,+5.39317920486900e-001,+5.41561177690210e-001,+5.43803229923850e-001,
  +5.46044014697660e-001,+5.48283469598350e-001,+5.50521532293840e-001,+5.52758140537680e-001,
  +5.54993232173380e-001,+5.57226745138830e-001,+5.59458617470620e-001,+5.61688787308420e-001,
  +5.63917192899300e-001,+5.66143772602140e-001,+5.68368464891880e-001,+5.70591208363900e-001,
  +5.72811941738350e-001,+5.75030603864390e-001,+5.77247133724580e-001,+5.79461470439120e-001,
  +5.81673553270120e-001,+5.83883321625910e-001,+5.86090715065280e-001,+5.88295673301730e-001,
  +5.90498136207700e-001,+5.92698043818790e-001,+5.94895336338020e-001,+5.97089954139960e-001,
  +5.99281837774950e-001,+6.01470927973290e-001,+6.03657165649370e-001,+6.05840491905820e-001,
  +6.08020848037640e-001,+6.10198175536320e-001,+6.12372416093930e-001,+6.14543511607180e-001,
  +6.16711404181550e-001,+6.18876036135270e-001,+6.21037350003360e-001,+6.23195288541670e-001,
  +6.25349794730880e-001,+6.27500811780420e-001,+6.29648283132500e-001,+6.31792152465970e-001,
  +6.33932363700300e-001,+6.36068860999460e-001,+6.38201588775770e-001,+6.40330491693790e-001,
  +6.42455514674130e-001,+6.44576602897290e-001,+6.46693701807400e-001,+6.48806757116070e-001,
  +6.50915714806030e-001,+6.53020521134940e-001,+6.55121122639060e-001,+6.57217466136890e-001,
  +6.59309498732890e-001,+6.61397167821020e-001,+6.63480421088420e-001,+6.65559206518920e-001,
  +6.67633472396640e-001,+6.69703167309470e-001,+6.71768240152600e-001,+6.73828640131960e-001,
  +6.75884316767680e-001,+6.77935219897510e-001,+6.79981299680170e-001,+6.82022506598760e-001,
  +6.84058791464030e-001,+6.86090105417740e-001,+6.88116399935880e-001,+6.90137626831950e-001,
  +6.92153738260120e-001,+6.94164686718490e-001,+6.96170425052140e-001,+6.98170906456340e-001,
  +7.00166084479580e-001,+7.02155913026640e-001,+7.04140346361630e-001,+7.06119339110960e-001,
  +7.08092846266300e-001,+7.10060823187510e-001,+7.12023225605540e-001,+7.13980009625300e-001,
  +7.15931131728420e-001,+7.17876548776130e-001,+7.19816218011950e-001,+7.21750097064450e-001,
  +7.23678143949900e-001,+7.25600317074960e-001,+7.27516575239270e-001,+7.29426877638030e-001,
  +7.31331183864570e-001,+7.33229453912800e-001,+7.35121648179750e-001,+7.37007727467960e-001,
  +7.38887652987870e-001,+7.40761386360200e-001,+7.42628889618270e-001,+7.44490125210270e-001,
  +7.46345056001520e-001,+7.48193645276630e-001,+7.50035856741750e-001,+7.51871654526610e-001,
  +7.53701003186680e-001,+7.55523867705150e-001,+7.57340213495000e-001,+7.59150006400950e-001,
  +7.60953212701370e-001,+7.62749799110190e-001,+7.64539732778750e-001,+7.66322981297570e-001,
  +7.68099512698190e-001,+7.69869295454810e-001,+7.71632298486040e-001,+7.73388491156510e-001,
  +7.75137843278490e-001,+7.76880325113400e-001,+7.78615907373400e-001,+7.80344561222830e-001,
  +7.82066258279610e-001,+7.83780970616670e-001,+7.85488670763300e-001,+7.87189331706430e-001,
  +7.88882926891890e-001,+7.90569430225640e-001,+7.92248816074940e-001,+7.93921059269490e-001,
  +7.95586135102490e-001,+7.97244019331700e-001,+7.98894688180460e-001,+8.00538118338580e-001,
  +8.02174286963340e-001,+8.03803171680280e-001,+8.05424750584050e-001,+8.07039002239200e-001,
  +8.08645905680890e-001,+8.10245440415600e-001,+8.11837586421750e-001,+8.13422324150320e-001,
  +8.14999634525400e-001,+8.16569498944670e-001,+8.18131899279910e-001,+8.19686817877380e-001,
  +8.21234237558210e-001,+8.22774141618740e-001,+8.24306513830760e-001,+8.25831338441800e-001,
  +8.27348600175280e-001,+8.28858284230700e-001,+8.30360376283690e-001,+8.31854862486090e-001,
  +8.33341729465970e-001,+8.34820964327590e-001,+8.36292554651300e-001,+8.37756488493440e-001,
  +8.39212754386150e-001,+8.40661341337160e-001,+8.42102238829520e-001,+8.43535436821300e-001,
  +8.44960925745240e-001,+8.46378696508330e-001,+8.47788740491380e-001,+8.49191049548550e-001,
  +8.50585616006770e-001,+8.51972432665200e-001,+8.53351492794570e-001,+8.54722790136530e-001,
  +8.56086318902950e-001,+8.57442073775130e-001,+8.58790049902980e-001,+8.60130242904220e-001,
  +8.61462648863460e-001,+8.62787264331240e-001,+8.64104086323060e-001,+8.65413112318380e-001,
  +8.66714340259500e-001,+8.68007768550460e-001,+8.69293396055900e-001,+8.70571222099810e-001,
  +8.71841246464330e-001,+8.73103469388400e-001,+8.74357891566500e-001,+8.75604514147190e-001,
  +8.76843338731730e-001,+8.78074367372610e-001,+8.79297602572040e-001,+8.80513047280380e-001,
  +8.81720704894560e-001,+8.82920579256450e-001,+8.84112674651170e-001,+8.85296995805370e-001,
  +8.86473547885450e-001,+8.87642336495800e-001,+8.88803367676920e-001,+8.89956647903510e-001,
  +8.91102184082600e-001,+8.92239983551540e-001,+8.93370054076000e-001,+8.94492403847930e-001,
  +8.95607041483450e-001,+8.96713976020740e-001,+8.97813216917860e-001,+8.98904774050530e-001,
  +8.99988657709930e-001,+9.01064878600340e-001,+9.02133447836890e-001,+9.03194376943150e-001,
  +9.04247677848730e-001,+9.05293362886900e-001,+9.06331444792010e-001,+9.07361936697080e-001,
  +9.08384852131190e-001,+9.09400205016940e-001,+9.10408009667760e-001,+9.11408280785330e-001,
  +9.12401033456850e-001,+9.13386283152310e-001,+9.14364045721730e-001,+9.15334337392380e-001,
  +9.16297174765940e-001,+9.17252574815640e-001,+9.18200554883340e-001,+9.19141132676640e-001,
  +9.20074326265890e-001,+9.21000154081200e-001,+9.21918634909440e-001,+9.22829787891130e-001,
  +9.23733632517400e-001,+9.24630188626870e-001,+9.25519476402450e-001,+9.26401516368240e-001,
  +9.27276329386240e-001,+9.28143936653200e-001,+9.29004359697270e-001,+9.29857620374770e-001,
  +9.30703740866840e-001,+9.31542743676100e-001,+9.32374651623280e-001,+9.33199487843820e-001,
  +9.34017275784430e-001,+9.34828039199670e-001,+9.35631802148410e-001,+9.36428588990430e-001,
  +9.37218424382790e-001,+9.38001333276370e-001,+9.38777340912230e-001,+9.39546472818070e-001,
  +9.40308754804580e-001,+9.41064212961820e-001,+9.41812873655560e-001,+9.42554763523620e-001,
  +9.43289909472130e-001,+9.44018338671840e-001,+9.44740078554390e-001,+9.45455156808550e-001,
  +9.46163601376440e-001,+9.46865440449750e-001,+9.47560702465920e-001,+9.48249416104340e-001,
  +9.48931610282480e-001,+9.49607314152090e-001,+9.50276557095250e-001,+9.50939368720560e-001,
  +9.51595778859240e-001,+9.52245817561150e-001,+9.52889515090970e-001,+9.53526901924170e-001,
  +9.54158008743140e-001,+9.54782866433200e-001,+9.55401506078630e-001,+9.56013958958710e-001,
  +9.56620256543730e-001,+9.57220430491000e-001,+9.57814512640840e-001,+9.58402535012600e-001,
  +9.58984529800580e-001,+9.59560529370080e-001,+9.60130566253360e-001,+9.60694673145570e-001,
  +9.61252882900730e-001,+9.61805228527730e-001,+9.62351743186220e-001,+9.62892460182620e-001,
  +9.63427412966040e-001,+9.63956635124240e-001,+9.64480160379590e-001,+9.64998022584990e-001,
  +9.65510255719850e-001,+9.66016893886020e-001,+9.66517971303760e-001,+9.67013522307680e-001,
  +9.67503581342690e-001,+9.67988182959980e-001,+9.68467361812970e-001,+9.68941152653270e-001,
  +9.69409590326670e-001,+9.69872709769120e-001,+9.70330546002700e-001,+9.70783134131610e-001,
  +9.71230509338180e-001,+9.71672706878870e-001,+9.72109762080300e-001,+9.72541710335250e-001,
  +9.72968587098710e-001,+9.73390427883920e-001,+9.73807268258430e-001,+9.74219143840170e-001,
  +9.74626090293500e-001,+9.75028143325340e-001,+9.75425338681270e-001,+9.75817712141600e-001,
  +9.76205299517590e-001,+9.76588136647490e-001,+9.76966259392820e-001,+9.77339703634450e-001,
  +9.77708505268840e-001,+9.78072700204270e-001,+9.78432324357040e-001,+9.78787413647710e-001,
  +9.79138003997430e-001,+9.79484131324140e-001,+9.79825831538950e-001,+9.80163140542430e-001,
  +9.80496094220960e-001,+9.80824728443130e-001,+9.81149079056080e-001,+9.81469181881970e-001,
  +9.81785072714380e-001,+9.82096787314770e-001,+9.82404361409020e-001,+9.82707830683850e-001,
  +9.83007230783420e-001,+9.83302597305890e-001,+9.83593965799950e-001,+9.83881371761520e-001,
  +9.84164850630310e-001,+9.84444437786510e-001,+9.84720168547520e-001,+9.84992078164630e-001,
  +9.85260201819800e-001,+9.85524574622400e-001,+9.85785231606090e-001,+9.86042207725600e-001,
  +9.86295537853620e-001,+9.86545256777720e-001,+9.86791399197260e-001,+9.87033999720350e-001,
  +9.87273092860890e-001,+9.87508713035560e-001,+9.87740894560890e-001,+9.87969671650360e-001,
  +9.88195078411540e-001,+9.88417148843230e-001,+9.88635916832690e-001,+9.88851416152850e-001,
  +9.89063680459570e-001,+9.89272743288960e-001,+9.89478638054730e-001,+9.89681398045540e-001,
  +9.89881056422410e-001,+9.90077646216180e-001,+9.90271200325010e-001,+9.90461751511860e-001,
  +9.90649332402080e-001,+9.90833975480990e-001,+9.91015713091530e-001,+9.91194577431910e-001,
  +9.91370600553370e-001,+9.91543814357840e-001,+9.91714250595820e-001,+9.91881940864140e-001,
  +9.92046916603880e-001,+9.92209209098230e-001,+9.92368849470450e-001,+9.92525868681860e-001,
  +9.92680297529890e-001,+9.92832166646060e-001,+9.92981506494190e-001,+9.93128347368470e-001,
  +9.93272719391670e-001,+9.93414652513380e-001,+9.93554176508250e-001,+9.93691320974300e-001,
  +9.93826115331300e-001,+9.93958588819100e-001,+9.94088770496120e-001,+9.94216689237780e-001,
  +9.94342373735030e-001,+9.94465852492890e-001,+9.94587153829060e-001,+9.94706305872540e-001,
  +9.94823336562290e-001,+9.94938273646000e-001,+9.95051144678780e-001,+9.95161977022000e-001,
  +9.95270797842140e-001,+9.95377634109620e-001,+9.95482512597770e-001,+9.95585459881780e-001,
  +9.95686502337670e-001,+9.95785666141380e-001,+9.95882977267830e-001,+9.95978461490050e-001,
  +9.96072144378340e-001,+9.96164051299470e-001,+9.96254207415950e-001,+9.96342637685270e-001,
  +9.96429366859280e-001,+9.96514419483520e-001,+9.96597819896630e-001,+9.96679592229780e-001,
  +9.96759760406200e-001,+9.96838348140630e-001,+9.96915378938950e-001,+9.96990876097740e-001,
  +9.97064862703910e-001,+9.97137361634420e-001,+9.97208395555930e-001,+9.97277986924610e-001,
  +9.97346157985890e-001,+9.97412930774310e-001,+9.97478327113370e-001,+9.97542368615410e-001,
  +9.97605076681580e-001,+9.97666472501810e-001,+9.97726577054780e-001,+9.97785411107990e-001,
  +9.97842995217850e-001,+9.97899349729760e-001,+9.97954494778280e-001,+9.98008450287300e-001,
  +9.98061235970270e-001,+9.98112871330420e-001,+9.98163375661080e-001,+9.98212768045960e-001,
  +9.98261067359520e-001,+9.98308292267320e-001,+9.98354461226490e-001,+9.98399592486090e-001,
  +9.98443704087650e-001,+9.98486813865660e-001,+9.98528939448050e-001,+9.98570098256850e-001,
  +9.98610307508690e-001,+9.98649584215490e-001,+9.98687945185040e-001,+9.98725407021780e-001,
  +9.98761986127380e-001,+9.98797698701600e-001,+9.98832560742950e-001,+9.98866588049530e-001,
  +9.98899796219830e-001,+9.98932200653560e-001,+9.98963816552540e-001,+9.98994658921540e-001,
  +9.99024742569240e-001,+9.99054082109160e-001,+9.99082691960560e-001,+9.99110586349520e-001,
  +9.99137779309860e-001,+9.99164284684210e-001,+9.99190116125050e-001,+9.99215287095760e-001,
  +9.99239810871740e-001,+9.99263700541500e-001,+9.99286969007790e-001,+9.99309628988760e-001,
  +9.99331693019100e-001,+9.99353173451260e-001,+9.99374082456620e-001,+9.99394432026740e-001,
  +9.99414233974570e-001,+9.99433499935720e-001,+9.99452241369720e-001,+9.99470469561300e-001,
  +9.99488195621710e-001,+9.99505430490000e-001,+9.99522184934390e-001,+9.99538469553550e-001,
  +9.99554294778030e-001,+9.99569670871540e-001,+9.99584607932420e-001,+9.99599115894940e-001,
  +9.99613204530770e-001,+9.99626883450350e-001,+9.99640162104330e-001,+9.99653049784990e-001,
  +9.99665555627690e-001,+9.99677688612310e-001,+9.99689457564730e-001,+9.99700871158250e-001,
  +9.99711937915100e-001,+9.99722666207920e-001,+9.99733064261210e-001,+9.99743140152880e-001,
  +9.99752901815680e-001,+9.99762357038760e-001,+9.99771513469140e-001,+9.99780378613260e-001,
  +9.99788959838450e-001,+9.99797264374480e-001,+9.99805299315070e-001,+9.99813071619430e-001,
  +9.99820588113770e-001,+9.99827855492830e-001,+9.99834880321440e-001,+9.99841669036000e-001,
  +9.99848227946060e-001,+9.99854563235840e-001,+9.99860680965720e-001,+9.99866587073860e-001,
  +9.99872287377640e-001,+9.99877787575240e-001,+9.99883093247170e-001,+9.99888209857770e-001,
  +9.99893142756750e-001,+9.99897897180720e-001,+9.99902478254680e-001,+9.99906890993570e-001,
  +9.99911140303760e-001,+9.99915230984560e-001,+9.99919167729710e-001,+9.99922955128910e-001,
  +9.99926597669300e-001,+9.99930099736920e-001,+9.99933465618240e-001,+9.99936699501610e-001,
  +9.99939805478700e-001,+9.99942787546040e-001,+9.99945649606420e-001,+9.99948395470330e-001,
  +9.99951028857470e-001,+9.99953553398090e-001,+9.99955972634510e-001,+9.99958290022490e-001,
  +9.99960508932640e-001,+9.99962632651830e-001,+9.99964664384600e-001,+9.99966607254520e-001,
  +9.99968464305580e-001,+9.99970238503560e-001,+9.99971932737360e-001,+9.99973549820370e-001,
  +9.99975092491830e-001,+9.99976563418100e-001,+9.99977965194000e-001,+9.99979300344150e-001,
  +9.99980571324210e-001,+9.99981780522200e-001,+9.99982930259750e-001,+9.99984022793380e-001,
  +9.99985060315740e-001,+9.99986044956860e-001,+9.99986978785360e-001,+9.99987863809660e-001,
  +9.99988701979210e-001,+9.99989495185670e-001,+9.99990245264080e-001,+9.99990953994010e-001,
  +9.99991623100770e-001,+9.99992254256490e-001,+9.99992849081280e-001,+9.99993409144350e-001,
  +9.99993935965100e-001,+9.99994431014210e-001,+9.99994895714730e-001,+9.99995331443140e-001,
  +9.99995739530400e-001,+9.99996121263000e-001,+9.99996477883950e-001,+9.99996810593830e-001,
  +9.99997120551780e-001,+9.99997408876470e-001,+9.99997676647090e-001,+9.99997924904310e-001,
  +9.99998154651230e-001,+9.99998366854270e-001,+9.99998562444150e-001,+9.99998742316760e-001,
  +9.99998907334050e-001,+9.99999058324930e-001,+9.99999196086130e-001,+9.99999321383040e-001,
  +9.99999434950560e-001,+9.99999537493920e-001,+9.99999629689500e-001,+9.99999712185630e-001,
  +9.99999785603370e-001,+9.99999850537270e-001,+9.99999907556160e-001,+9.99999957203870e-001 
};


/*!
  \name    quantizer and inverse quantizer tables

  \brief   these tables are used for the non
           linear quantizer and inverse quantizer
           
*/

const float mTab_3_4[512] = {
0.5946035575013605,0.5954743463323537,0.5963447109054010,0.5972146522520084,
0.5980841713991768,0.5989532693694295,0.5998219471808410,0.6006902058470649,
0.6015580463773612,0.6024254697766240,0.6032924770454087,0.6041590691799589,
0.6050252471722334,0.6058910120099325,0.6067563646765247,0.6076213061512724,
0.6084858374092583,0.6093499594214108,0.6102136731545296,0.6110769795713108,
0.6119398796303728,0.6128023742862800,0.6136644644895687,0.6145261511867706,
0.6153874353204379,0.6162483178291670,0.6171087996476224,0.6179688817065610,
0.6188285649328548,0.6196878502495148,0.6205467385757143,0.6214052308268117,
0.6222633279143732,0.6231210307461956,0.6239783402263289,0.6248352572550985,
0.6256917827291271,0.6265479175413568,0.6274036625810712,0.6282590187339165,
0.6291139868819234,0.6299685679035282,0.6308227626735934,0.6316765720634299,
0.6325299969408164,0.6333830381700211,0.6342356966118216,0.6350879731235253,
0.6359398685589899,0.6367913837686431,0.6376425195995024,0.6384932768951952,
0.6393436564959779,0.6401936592387558,0.6410432859571019,0.6418925374812764,
0.6427414146382453,0.6435899182516999,0.6444380491420747,0.6452858081265664,
0.6461331960191526,0.6469802136306094,0.6478268617685301,0.6486731412373429,
0.6495190528383290,0.6503645973696403,0.6512097756263168,0.6520545884003046,
0.6528990364804727,0.6537431206526306,0.6545868416995453,0.6554302004009582,
0.6562731975336021,0.6571158338712180,0.6579581101845714,0.6588000272414690,
0.6596415858067755,0.6604827866424287,0.6613236305074570,0.6621641181579947,
0.6630042503472977,0.6638440278257601,0.6646834513409291,0.6655225216375209,
0.6663612394574361,0.6671996055397751,0.6680376206208535,0.6688752854342169,
0.6697126007106562,0.6705495671782221,0.6713861855622405,0.6722224565853270,
0.6730583809674010,0.6738939594257012,0.6747291926747990,0.6755640814266134,
0.6763986263904250,0.6772328282728901,0.6780666877780549,0.6789002056073690,
0.6797333824596995,0.6805662190313447,0.6813987160160480,0.6822308741050104,
0.6830626939869051,0.6838941763478904,0.6847253218716227,0.6855561312392700,
0.6863866051295244,0.6872167442186165,0.6880465491803259,0.6888760206859967,
0.6897051594045480,0.6905339660024878,0.6913624411439251,0.6921905854905822,
0.6930183997018076,0.6938458844345877,0.6946730403435594,0.6954998680810218,
0.6963263682969491,0.6971525416390011,0.6979783887525368,0.6988039102806248,
0.6996291068640559,0.7004539791413540,0.7012785277487883,0.7021027533203845,
0.7029266564879364,0.7037502378810168,0.7045734981269892,0.7053964378510188,
0.7062190576760837,0.7070413582229859,0.7078633401103618,0.7086850039546940,
0.7095063503703216,0.7103273799694508,0.7111480933621659,0.7119684911564396,
0.7127885739581438,0.7136083423710601,0.7144277969968899,0.7152469384352652,
0.7160657672837582,0.7168842841378922,0.7177024895911512,0.7185203842349905,
0.7193379686588460,0.7201552434501448,0.7209722091943148,0.7217888664747945,
0.7226052158730426,0.7234212579685481,0.7242369933388396,0.7250524225594950,
0.7258675462041508,0.7266823648445121,0.7274968790503610,0.7283110893895668,
0.7291249964280951,0.7299386007300168,0.7307519028575172,0.7315649033709054,
0.7323776028286229,0.7331900017872529,0.7340021008015294,0.7348139004243455,
0.7356254012067626,0.7364366036980192,0.7372475084455393,0.7380581159949413,
0.7388684268900465,0.7396784416728875,0.7404881608837172,0.7412975850610163,
0.7421067147415026,0.7429155504601389,0.7437240927501414,0.7445323421429878,
0.7453402991684255,0.7461479643544797,0.7469553382274619,0.7477624213119770,
0.7485692141309323,0.7493757172055449,0.7501819310553494,0.7509878561982062,
0.7517934931503091,0.7525988424261927,0.7534039045387408,0.7542086799991935,
0.7550131693171546,0.7558173730005999,0.7566212915558842,0.7574249254877485,
0.7582282752993285,0.7590313414921603,0.7598341245661894,0.7606366250197769,
0.7614388433497074,0.7622407800511952,0.7630424356178929,0.7638438105418973,
0.7646449053137571,0.7654457204224797,0.7662462563555381,0.7670465135988781,
0.7678464926369251,0.7686461939525907,0.7694456180272801,0.7702447653408983,
0.7710436363718570,0.7718422315970818,0.7726405514920179,0.7734385965306376,
0.7742363671854464,0.7750338639274900,0.7758310872263600,0.7766280375502012,
0.7774247153657176,0.7782211211381791,0.7790172553314274,0.7798131184078828,
0.7806087108285500,0.7814040330530249,0.7821990855395004,0.7829938687447726,
0.7837883831242473,0.7845826291319455,0.7853766072205103,0.7861703178412121,
0.7869637614439549,0.7877569384772827,0.7885498493883847,0.7893424946231018,
0.7901348746259321,0.7909269898400371,0.7917188407072467,0.7925104276680662,
0.7933017511616810,0.7940928116259627,0.7948836094974746,0.7956741452114780,
0.7964644192019365,0.7972544319015230,0.7980441837416245,0.7988336751523472,
0.7996229065625231,0.8004118783997146,0.8012005910902201,0.8019890450590795,
0.8027772407300795,0.8035651785257590,0.8043528588674144,0.8051402821751046,
0.8059274488676564,0.8067143593626702,0.8075010140765245,0.8082874134243810,
0.8090735578201906,0.8098594476766976,0.8106450834054451,0.8114304654167800,
0.8122155941198583,0.8130004699226497,0.8137850932319427,0.8145694644533497,
0.8153535839913114,0.8161374522491023,0.8169210696288354,0.8177044365314664,
0.8184875533567997,0.8192704205034920,0.8200530383690575,0.8208354073498730,
0.8216175278411823,0.8223994002371001,0.8231810249306182,0.8239624023136090,
0.8247435327768302,0.8255244167099298,0.8263050545014505,0.8270854465388338,
0.8278655932084251,0.8286454948954779,0.8294251519841581,0.8302045648575489,
0.8309837338976545,0.8317626594854051,0.8325413420006611,0.8333197818222173,
0.8340979793278073,0.8348759348941076,0.8356536488967423,0.8364311217102870,
0.8372083537082730,0.8379853452631917,0.8387620967464987,0.8395386085286180,
0.8403148809789458,0.8410909144658550,0.8418667093566995,0.8426422660178176,
0.8434175848145362,0.8441926661111756,0.8449675102710526,0.8457421176564844,
0.8465164886287939,0.8472906235483120,0.8480645227743823,0.8488381866653654,
0.8496116155786416,0.8503848098706164,0.8511577698967225,0.8519304960114253,
0.8527029885682255,0.8534752479196636,0.8542472744173231,0.8550190684118351,
0.8557906302528807,0.8565619602891964,0.8573330588685760,0.8581039263378759,
0.8588745630430175,0.8596449693289914,0.8604151455398611,0.8611850920187664,
0.8619548091079269,0.8627242971486459,0.8634935564813134,0.8642625874454102,
0.8650313903795110,0.8657999656212883,0.8665683135075151,0.8673364343740694,
0.8681043285559367,0.8688719963872140,0.8696394382011130,0.8704066543299636,
0.8711736451052168,0.8719404108574488,0.8727069519163638,0.8734732686107976,
0.8742393612687203,0.8750052302172406,0.8757708757826085,0.8765362982902181,
0.8773014980646118,0.8780664754294827,0.8788312307076784,0.8795957642212037,
0.8803600762912242,0.8811241672380689,0.8818880373812341,0.8826516870393860,
0.8834151165303638,0.8841783261711830,0.8849413162780384,0.8857040871663073,
0.8864666391505522,0.8872289725445242,0.8879910876611659,0.8887529848126141,
0.8895146643102035,0.8902761264644692,0.8910373715851493,0.8917983999811886,
0.8925592119607413,0.8933198078311734,0.8940801878990664,0.8948403524702198,
0.8956003018496537,0.8963600363416122,0.8971195562495661,0.8978788618762152,
0.8986379535234922,0.8993968314925641,0.9001554960838366,0.9009139475969555,
0.9016721863308103,0.9024302125835363,0.9031880266525182,0.9039456288343921,
0.9047030194250485,0.9054601987196350,0.9062171670125589,0.9069739245974900,
0.9077304717673633,0.9084868088143815,0.9092429360300174,0.9099988537050174,
0.9107545621294031,0.9115100615924746,0.9122653523828127,0.9130204347882818,
0.9137753090960319,0.9145299755925022,0.9152844345634222,0.9160386862938157,
0.9167927310680023,0.9175465691696003,0.9183002008815293,0.9190536264860122,
0.9198068462645783,0.9205598604980653,0.9213126694666221,0.9220652734497108,
0.9228176727261096,0.9235698675739149,0.9243218582705438,0.9250736450927365,
0.9258252283165587,0.9265766082174040,0.9273277850699960,0.9280787591483913,
0.9288295307259809,0.9295801000754933,0.9303304674689966,0.9310806331779006,
0.9318305974729593,0.9325803606242733,0.9333299229012916,0.9340792845728145,
0.9348284459069955,0.9355774071713433,0.9363261686327247,0.9370747305573661,
0.9378230932108564,0.9385712568581487,0.9393192217635624,0.9400669881907863,
0.9408145564028794,0.9415619266622742,0.9423090992307784,0.9430560743695771,
0.9438028523392348,0.9445494333996978,0.9452958178102959,0.9460420058297452,
0.9467879977161495,0.9475337937270026,0.9482793941191907,0.9490247991489940,
0.9497700090720891,0.9505150241435508,0.9512598446178545,0.9520044707488777,
0.9527489027899027,0.9534931409936177,0.9542371856121200,0.9549810368969171,
0.9557246950989286,0.9564681604684888,0.9572114332553487,0.9579545137086772,
0.9586974020770638,0.9594400986085199,0.9601826035504815,0.9609249171498104,
0.9616670396527968,0.9624089713051606,0.9631507123520534,0.9638922630380611,
0.9646336236072047,0.9653747943029430,0.9661157753681742,0.9668565670452375,
0.9675971695759156,0.9683375832014358,0.9690778081624725,0.9698178446991486,
0.9705576930510371,0.9712973534571641,0.9720368261560088,0.9727761113855071,
0.9735152093830520,0.9742541203854962,0.9749928446291536,0.9757313823498010,
0.9764697337826799,0.9772078991624986,0.9779458787234334,0.9786836726991308,
0.9794212813227086,0.9801587048267585,0.9808959434433471,0.9816329974040180,
0.9823698669397933,0.9831065522811754,0.9838430536581485,0.9845793713001808,
0.9853155054362254,0.9860514562947227,0.9867872241036013,0.9875228090902806,
0.9882582114816716,0.9889934315041790,0.9897284693837025,0.9904633253456390,
0.9911979996148833,0.9919324924158308,0.9926668039723782,0.9934009345079254,
0.9941348842453776,0.9948686534071458,0.9956022422151496,0.9963356508908177,
0.9970688796550901,0.9978019287284194,0.9985347983307729,0.9992674886816331
};

const float mTab_4_3[512]={
0.3968502629920499,0.3978840634868335,0.3989185359354711,0.3999536794661432,
0.4009894932098531,0.4020259763004115,0.4030631278744227,0.4041009470712695,
0.4051394330330996,0.4061785849048110,0.4072184018340380,0.4082588829711372,
0.4093000274691739,0.4103418344839078,0.4113843031737798,0.4124274326998980,
0.4134712222260245,0.4145156709185620,0.4155607779465400,0.4166065424816022,
0.4176529636979932,0.4187000407725452,0.4197477728846652,0.4207961592163222,
0.4218451989520345,0.4228948912788567,0.4239452353863673,0.4249962304666564,
0.4260478757143130,0.4271001703264124,0.4281531135025046,0.4292067044446017,
0.4302609423571658,0.4313158264470970,0.4323713559237216,0.4334275299987803,
0.4344843478864161,0.4355418088031630,0.4365999119679339,0.4376586566020096,
0.4387180419290272,0.4397780671749683,0.4408387315681480,0.4419000343392039,
0.4429619747210847,0.4440245519490388,0.4450877652606038,0.4461516138955953,
0.4472160970960963,0.4482812141064458,0.4493469641732286,0.4504133465452648,
0.4514803604735984,0.4525480052114875,0.4536162800143939,0.4546851841399719,
0.4557547168480591,0.4568248774006652,0.4578956650619623,0.4589670790982746,
0.4600391187780688,0.4611117833719430,0.4621850721526184,0.4632589843949278,
0.4643335193758069,0.4654086763742842,0.4664844546714713,0.4675608535505532,
0.4686378722967790,0.4697155101974522,0.4707937665419216,0.4718726406215713,
0.4729521317298118,0.4740322391620711,0.4751129622157845,0.4761943001903867,
0.4772762523873015,0.4783588181099338,0.4794419966636599,0.4805257873558190,
0.4816101894957042,0.4826952023945537,0.4837808253655421,0.4848670577237714,
0.4859538987862632,0.4870413478719488,0.4881294043016621,0.4892180673981298,
0.4903073364859640,0.4913972108916533,0.4924876899435545,0.4935787729718844,
0.4946704593087116,0.4957627482879484,0.4968556392453423,0.4979491315184684,
0.4990432244467211,0.5001379173713062,0.5012332096352328,0.5023291005833056,
0.5034255895621171,0.5045226759200399,0.5056203590072181,0.5067186381755611,
0.5078175127787346,0.5089169821721536,0.5100170457129749,0.5111177027600893,
0.5122189526741143,0.5133207948173868,0.5144232285539552,0.5155262532495726,
0.5166298682716894,0.5177340729894460,0.5188388667736652,0.5199442489968457,
0.5210502190331544,0.5221567762584198,0.5232639200501247,0.5243716497873989,
0.5254799648510130,0.5265888646233705,0.5276983484885021,0.5288084158320574,
0.5299190660412995,0.5310302985050975,0.5321421126139198,0.5332545077598274,
0.5343674833364678,0.5354810387390675,0.5365951733644262,0.5377098866109097,
0.5388251778784438,0.5399410465685075,0.5410574920841272,0.5421745138298695,
0.5432921112118353,0.5444102836376534,0.5455290305164744,0.5466483512589642,
0.5477682452772976,0.5488887119851529,0.5500097507977050,0.5511313611316194,
0.5522535424050467,0.5533762940376158,0.5544996154504284,0.5556235060660528,
0.5567479653085183,0.5578729926033087,0.5589985873773569,0.5601247490590389,
0.5612514770781683,0.5623787708659898,0.5635066298551742,0.5646350534798125,
0.5657640411754097,0.5668935923788799,0.5680237065285404,0.5691543830641059,
0.5702856214266832,0.5714174210587655,0.5725497814042271,0.5736827019083177,
0.5748161820176573,0.5759502211802304,0.5770848188453810,0.5782199744638067,
0.5793556874875542,0.5804919573700131,0.5816287835659116,0.5827661655313104,
0.5839041027235979,0.5850425946014850,0.5861816406250000,0.5873212402554834,
0.5884613929555826,0.5896020981892474,0.5907433554217242,0.5918851641195517,
0.5930275237505556,0.5941704337838434,0.5953138936897999,0.5964579029400819,
0.5976024610076139,0.5987475673665825,0.5998932214924321,0.6010394228618597,
0.6021861709528106,0.6033334652444733,0.6044813052172748,0.6056296903528761,
0.6067786201341671,0.6079280940452625,0.6090781115714966,0.6102286721994192,
0.6113797754167908,0.6125314207125777,0.6136836075769482,0.6148363355012674,
0.6159896039780929,0.6171434125011708,0.6182977605654305,0.6194526476669808,
0.6206080733031054,0.6217640369722584,0.6229205381740598,0.6240775764092919,
0.6252351511798939,0.6263932619889586,0.6275519083407275,0.6287110897405869,
0.6298708056950635,0.6310310557118203,0.6321918392996523,0.6333531559684823,
0.6345150052293571,0.6356773865944432,0.6368402995770224,0.6380037436914881,
0.6391677184533411,0.6403322233791856,0.6414972579867254,0.6426628217947594,
0.6438289143231779,0.6449955350929588,0.6461626836261636,0.6473303594459330,
0.6484985620764839,0.6496672910431047,0.6508365458721518,0.6520063260910459,
0.6531766312282679,0.6543474608133552,0.6555188143768979,0.6566906914505349,
0.6578630915669509,0.6590360142598715,0.6602094590640603,0.6613834255153149,
0.6625579131504635,0.6637329215073610,0.6649084501248851,0.6660844985429335,
0.6672610663024197,0.6684381529452691,0.6696157580144163,0.6707938810538011,
0.6719725216083646,0.6731516792240465,0.6743313534477807,0.6755115438274927,
0.6766922499120955,0.6778734712514865,0.6790552073965435,0.6802374578991223,
0.6814202223120524,0.6826035001891340,0.6837872910851345,0.6849715945557853,
0.6861564101577784,0.6873417374487629,0.6885275759873420,0.6897139253330697,
0.6909007850464473,0.6920881546889198,0.6932760338228737,0.6944644220116332,
0.6956533188194565,0.6968427238115332,0.6980326365539813,0.6992230566138435,
0.7004139835590845,0.7016054169585869,0.7027973563821499,0.7039898014004843,
0.7051827515852106,0.7063762065088554,0.7075701657448483,0.7087646288675196,
0.7099595954520960,0.7111550650746988,0.7123510373123402,0.7135475117429202,
0.7147444879452244,0.7159419654989200,0.7171399439845538,0.7183384229835486,
0.7195374020782005,0.7207368808516762,0.7219368588880097,0.7231373357720997,
0.7243383110897066,0.7255397844274496,0.7267417553728043,0.7279442235140992,
0.7291471884405130,0.7303506497420724,0.7315546070096487,0.7327590598349553,
0.7339640078105445,0.7351694505298055,0.7363753875869610,0.7375818185770647,
0.7387887430959987,0.7399961607404706,0.7412040711080108,0.7424124737969701,
0.7436213684065166,0.7448307545366334,0.7460406317881158,0.7472509997625686,
0.7484618580624036,0.7496732062908372,0.7508850440518872,0.7520973709503704,
0.7533101865919009,0.7545234905828862,0.7557372825305252,0.7569515620428062,
0.7581663287285035,0.7593815821971756,0.7605973220591619,0.7618135479255810,
0.7630302594083277,0.7642474561200708,0.7654651376742505,0.7666833036850760,
0.7679019537675227,0.7691210875373307,0.7703407046110011,0.7715608046057948,
0.7727813871397293,0.7740024518315765,0.7752239983008605,0.7764460261678551,
0.7776685350535814,0.7788915245798054,0.7801149943690360,0.7813389440445223,
0.7825633732302513,0.7837882815509458,0.7850136686320621,0.7862395340997874,
0.7874658775810378,0.7886926987034559,0.7899199970954088,0.7911477723859853,
0.7923760242049944,0.7936047521829623,0.7948339559511308,0.7960636351414546,
0.7972937893865995,0.7985244183199399,0.7997555215755570,0.8009870987882359,
0.8022191495934644,0.8034516736274301,0.8046846705270185,0.8059181399298110,
0.8071520814740822,0.8083864947987989,0.8096213795436166,0.8108567353488784,
0.8120925618556127,0.8133288587055308,0.8145656255410253,0.8158028620051674,
0.8170405677417053,0.8182787423950622,0.8195173856103341,0.8207564970332875,
0.8219960763103580,0.8232361230886477,0.8244766370159234,0.8257176177406150,
0.8269590649118125,0.8282009781792650,0.8294433571933784,0.8306862016052132,
0.8319295110664831,0.8331732852295520,0.8344175237474336,0.8356622262737878,
0.8369073924629202,0.8381530219697793,0.8393991144499545,0.8406456695596752,
0.8418926869558079,0.8431401662958544,0.8443881072379507,0.8456365094408642,
0.8468853725639923,0.8481346962673606,0.8493844802116208,0.8506347240580492,
0.8518854274685442,0.8531365901056253,0.8543882116324307,0.8556402917127157,
0.8568928300108512,0.8581458261918209,0.8593992799212207,0.8606531908652563,
0.8619075586907414,0.8631623830650962,0.8644176636563452,0.8656734001331161,
0.8669295921646375,0.8681862394207371,0.8694433415718407,0.8707008982889695,
0.8719589092437391,0.8732173741083574,0.8744762925556232,0.8757356642589241,
0.8769954888922352,0.8782557661301171,0.8795164956477146,0.8807776771207545,
0.8820393102255443,0.8833013946389704,0.8845639300384969,0.8858269161021629,
0.8870903525085819,0.8883542389369399,0.8896185750669933,0.8908833605790678,
0.8921485951540565,0.8934142784734187,0.8946804102191776,0.8959469900739191,
0.8972140177207906,0.8984814928434985,0.8997494151263077,0.9010177842540390,
0.9022865999120682,0.9035558617863242,0.9048255695632878,0.9060957229299895,
0.9073663215740092,0.9086373651834729,0.9099088534470528,0.9111807860539647,
0.9124531626939672,0.9137259830573594,0.9149992468349805,0.9162729537182071,
0.9175471033989524,0.9188216955696648,0.9200967299233258,0.9213722061534494,
0.9226481239540795,0.9239244830197896,0.9252012830456805,0.9264785237273793,
0.9277562047610376,0.9290343258433305,0.9303128866714547,0.9315918869431275,
0.9328713263565848,0.9341512046105802,0.9354315214043836,0.9367122764377792,
0.9379934694110648,0.9392751000250497,0.9405571679810542,0.9418396729809072,
0.9431226147269456,0.9444059929220124,0.9456898072694558,0.9469740574731275,
0.9482587432373810,0.9495438642670713,0.9508294202675522,0.9521154109446763,
0.9534018360047926,0.9546886951547455,0.9559759881018738,0.9572637145540087,
0.9585518742194732,0.9598404668070802,0.9611294920261317,0.9624189495864168,
0.9637088391982110,0.9649991605722750,0.9662899134198524,0.9675810974526697,
0.9688727123829343,0.9701647579233330,0.9714572337870316,0.9727501396876727,
0.9740434753393749,0.9753372404567313,0.9766314347548087,0.9779260579491460,
0.9792211097557527,0.9805165898911081,0.9818124980721600,0.9831088340163232,
0.9844055974414786,0.9857027880659716,0.9870004056086111,0.9882984497886684,
0.9895969203258759,0.9908958169404255,0.9921951393529680,0.9934948872846116,
0.9947950604569206,0.9960956585919144,0.9973966814120665,0.9986981286403025
};



const float quantTableQ[16] = {
  1.000000000000f,
  0.878126080187f,
  0.771105412704f,
  0.677127773468f,
  0.594603557501f,
  0.522136891214f,
  0.458502021602f,
  0.402622582987f,
  0.353553390593f,
  0.310464453018f,
  0.272626933166f,
  0.239400820175f,
  0.210224103813f,
  0.184603268242f,
  0.162104944331f,
  0.142348579345f
};

const float quantTableE[17] = {
  1.6777216000000000e+007f,
  2.0971520000000000e+006f,
  2.6214400000000000e+005f,
  3.2768000000000000e+004f,
  4.0960000000000000e+003f,
  5.1200000000000000e+002f,
  6.4000000000000000e+001f,
  8.0000000000000000e+000f,
  1.0000000000000000e+000f,
  1.2500000000000000e-001f,
  1.5625000000000000e-002f,
  1.9531250000000000e-003f,
  2.4414062500000000e-004f,
  3.0517578125000000e-005f,
  3.8146972656250000e-006f,
  4.7683715820312500e-007f,
  5.9604644775390625e-008f
};

const float invQuantTableQ[16] = {
  1.00000000000000f,
  1.18920711500272f,
  1.41421356237310f,
  1.68179283050743f,
  2.00000000000000f,
  2.37841423000544f,
  2.82842712474619f,
  3.36358566101486f,
  4.00000000000000f,
  4.75682846001088f,
  5.65685424949238f,
  6.72717132202972f,
  8.00000000000000f,
  9.51365692002177f,
  11.31370849898476f,
  13.45434264405943f
};

const float invQuantTableE[17] = {
  2.32830643653870e-10f,
  3.72529029846191e-09f,
  5.96046447753906e-08f,
  9.53674316406250e-07f,
  1.52587890625000e-05f,
  2.44140625000000e-04f,
  3.90625000000000e-03f,
  6.25000000000000e-02f,
  1.00000000000000e+00,
  1.60000000000000e+01,
  2.56000000000000e+02,
  4.09600000000000e+03,
  6.55360000000000e+04,
  1.04857600000000e+06,
  1.67772160000000e+07,
  2.68435456000000e+08,
  4.29496729600000e+09
};

const float pow4_3_tab[MAX_POW4_3_TABLE] = {
  0.00000000000000e+00f, 1.00000000000000e+00f, 2.51984216919425e+00f, 4.32674889980614e+00f, 
  6.34960455764957e+00f, 8.54988028017667e+00f, 1.09027243332463e+01f, 1.33905193148088e+01f, 
  1.60000013220734e+01f, 1.87207560419737e+01f, 2.15443488715515e+01f, 2.44637833272645e+01f, 
  2.74731445340144e+01f, 3.05673540558534e+01f, 3.37419952368653e+01f, 3.69931850957286e+01f, 
  4.03174780385242e+01f, 4.37117919623412e+01f, 4.71733505137632e+01f, 5.06996372576499e+01f, 
  5.42883587943680e+01f, 5.79374147131819e+01f, 6.16448728460723e+01f, 6.54089486861053e+01f, 
  6.92279881171778e+01f, 7.31004528053539e+01f, 7.70249077506303e+01f, 8.10000106081487e+01f, 
  8.50245024706046e+01f, 8.90971998664785e+01f, 9.32169877770252e+01f, 9.73828135124449e+01f, 
  1.01593681317036e+02f, 1.05848647596338e+02f, 1.10146816677754e+02f, 1.14487337031009e+02f, 
  1.18869397886762e+02f, 1.23292226201482e+02f, 1.27755083924678e+02f, 1.32257265531149e+02f, 
  1.36798095786396e+02f, 1.41376927717849e+02f, 1.45993140768371e+02f, 1.50646139111697e+02f, 
  1.55335350112151e+02f, 1.60060222913269e+02f, 1.64820227141911e+02f, 1.69614851716083e+02f, 
  1.74443603746143e+02f, 1.79306007520268e+02f, 1.84201603566125e+02f, 1.89129947781615e+02f, 
  1.94090610628335e+02f, 1.99083176382117e+02f, 2.04107242435595e+02f, 2.09162418648294e+02f, 
  2.14248326740190e+02f, 2.19364599725107e+02f, 2.24510881380681e+02f, 2.29686825751936e+02f, 
  2.34892096685813e+02f, 2.40126367394220e+02f, 2.45389320043438e+02f, 2.50680645367872e+02f
};

/*
  misc constants (sfb width)
*/


/*
    11025 Hz
*/
const unsigned char sfb_11025_long_1024[] = {
       8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
       8, 12, 12, 12, 12, 12, 12, 12, 12, 12,
      16, 16, 16, 16, 20, 20, 20, 24, 24, 28,
      28, 32, 36, 40, 40, 44, 48, 52, 56, 60,
      64, 64, 64
};
const unsigned char sfb_11025_short_128[] = {
      4,  4,  4,  4,  4,  4,  4,  4,  8,  8,
     12, 12, 16, 20, 20
};




/*
    12000 Hz
*/
const unsigned char sfb_12000_long_1024[] = {
       8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
       8, 12, 12, 12, 12, 12, 12, 12, 12, 12,
      16, 16, 16, 16, 20, 20, 20, 24, 24, 28,
      28, 32, 36, 40, 40, 44, 48, 52, 56, 60,
      64, 64, 64
};

const unsigned char sfb_12000_short_128[] = {
     4,  4,  4,  4,  4,  4,  4,  4,  8,  8,
     12, 12, 16, 20, 20
};



/*
    16000 Hz
*/
const unsigned char sfb_16000_long_1024[] = {
    
       8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
       8, 12, 12, 12, 12, 12, 12, 12, 12, 12,
      16, 16, 16, 16, 20, 20, 20, 24, 24, 28,
      28, 32, 36, 40, 40, 44, 48, 52, 56, 60,
      64, 64, 64
};

const unsigned char sfb_16000_short_128[] = {
     4,  4,  4,  4,  4,  4,  4,  4,  8,  8,
     12, 12, 16, 20, 20
};



/*
    22050 Hz
*/
const unsigned char sfb_22050_long_1024[] = {
      4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
      4,  8,  8,  8,  8,  8,  8,  8,  8,  8,
      8, 12, 12, 12, 12, 16, 16, 16, 20, 20,
     24, 24, 28, 28, 32, 36, 36, 40, 44, 48,
     52, 52, 64, 64, 64, 64, 64
    
};
const unsigned char sfb_22050_short_128[] = {
     4,  4,  4,  4,  4,  4,  4,  8,  8,  8,
     12, 12, 16, 16, 20
};


/*
    24000 Hz
*/
const unsigned char sfb_24000_long_1024[] = {
      4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
      4,  8,  8,  8,  8,  8,  8,  8,  8,  8,
      8, 12, 12, 12, 12, 16, 16, 16, 20, 20,
     24, 24, 28, 28, 32, 36, 36, 40, 44, 48,
     52, 52, 64, 64, 64, 64, 64
};
const unsigned char sfb_24000_short_128[] = {
     4,  4,  4,  4,  4,  4,  4,  8,  8,  8,
     12, 12, 16, 16, 20
};



/*
  these tables are used only for counting and 
  are stored in packed format
*/

const unsigned short huff_ltab1_2[3][3][3][3]=
{
  {
    {
      {0x0b09,0x0907,0x0b09},
      {0x0a08,0x0706,0x0a08},
      {0x0b09,0x0908,0x0b09}
    },
    {
      {0x0a08,0x0706,0x0a07},
      {0x0706,0x0505,0x0706},
      {0x0907,0x0706,0x0a08}
    },
    {
      {0x0b09,0x0907,0x0b08},
      {0x0908,0x0706,0x0908},
      {0x0b09,0x0907,0x0b09}
    }
  },
  {
    {
      {0x0908,0x0706,0x0907},
      {0x0706,0x0505,0x0706},
      {0x0907,0x0706,0x0908}
    },
    {
      {0x0706,0x0505,0x0706},
      {0x0505,0x0103,0x0505},
      {0x0706,0x0505,0x0706}
    },
    {
      {0x0908,0x0706,0x0907},
      {0x0706,0x0505,0x0706},
      {0x0908,0x0706,0x0908}
    }
  },
  {
    {
      {0x0b09,0x0907,0x0b09},
      {0x0908,0x0706,0x0908},
      {0x0b08,0x0907,0x0b09}
    },
    {
      {0x0a08,0x0706,0x0907},
      {0x0706,0x0504,0x0706},
      {0x0908,0x0706,0x0a07}
    },
    {
      {0x0b09,0x0907,0x0b09},
      {0x0a07,0x0706,0x0908},
      {0x0b09,0x0907,0x0b09}
    }
  }
};


const unsigned short huff_ltab3_4[3][3][3][3]=
{
  {
    {
      {0x0104,0x0405,0x0808},
      {0x0405,0x0504,0x0808},
      {0x0909,0x0908,0x0a0b}
    },
    {
      {0x0405,0x0605,0x0908},
      {0x0605,0x0604,0x0908},
      {0x0908,0x0907,0x0a0a}
    },
    {
      {0x0909,0x0a08,0x0d0b},
      {0x0908,0x0908,0x0b0a},
      {0x0b0b,0x0a0a,0x0c0b}
    }
  },
  {
    {
      {0x0404,0x0605,0x0a08},
      {0x0604,0x0704,0x0a08},
      {0x0a08,0x0a08,0x0c0a}
    },
    {
      {0x0504,0x0704,0x0b08},
      {0x0604,0x0704,0x0a07},
      {0x0908,0x0907,0x0b09}
    },
    {
      {0x0908,0x0a08,0x0d0a},
      {0x0807,0x0907,0x0c09},
      {0x0a0a,0x0b09,0x0c0a}
    }
  },
  {
    {
      {0x0808,0x0a08,0x0f0b},
      {0x0908,0x0b07,0x0f0a},
      {0x0d0b,0x0e0a,0x100c}
    },
    {
      {0x0808,0x0a07,0x0e0a},
      {0x0907,0x0a07,0x0e09},
      {0x0c0a,0x0c09,0x0f0b}
    },
    {
      {0x0b0b,0x0c0a,0x100c},
      {0x0a0a,0x0b09,0x0f0b},
      {0x0c0b,0x0c0a,0x0f0b}
    }
  }
};

const unsigned short huff_ltab5_6[9][9]=
{
  {0x0d0b,0x0c0a,0x0b09,0x0b09,0x0a09,0x0b09,0x0b09,0x0c0a,0x0d0b},
  {0x0c0a,0x0b09,0x0a08,0x0907,0x0807,0x0907,0x0a08,0x0b09,0x0c0a},
  {0x0c09,0x0a08,0x0906,0x0806,0x0706,0x0806,0x0906,0x0a08,0x0b09},
  {0x0b09,0x0907,0x0806,0x0504,0x0404,0x0504,0x0806,0x0907,0x0b09},
  {0x0a09,0x0807,0x0706,0x0404,0x0104,0x0404,0x0706,0x0807,0x0b09},
  {0x0b09,0x0907,0x0806,0x0504,0x0404,0x0504,0x0806,0x0907,0x0b09},
  {0x0b09,0x0a08,0x0906,0x0806,0x0706,0x0806,0x0906,0x0a08,0x0b09},
  {0x0c0a,0x0b09,0x0a08,0x0907,0x0807,0x0907,0x0a07,0x0b08,0x0c0a},
  {0x0d0b,0x0c0a,0x0c09,0x0b09,0x0a09,0x0a09,0x0b09,0x0c0a,0x0d0b}
};

const unsigned short huff_ltab7_8[8][8]=
{
  {0x0105,0x0304,0x0605,0x0706,0x0807,0x0908,0x0a09,0x0b0a},
  {0x0304,0x0403,0x0604,0x0705,0x0806,0x0807,0x0907,0x0908},
  {0x0605,0x0604,0x0704,0x0805,0x0806,0x0907,0x0907,0x0a08},
  {0x0706,0x0705,0x0805,0x0806,0x0906,0x0907,0x0a08,0x0a08},
  {0x0807,0x0806,0x0906,0x0906,0x0a07,0x0a07,0x0a08,0x0b09},
  {0x0908,0x0807,0x0906,0x0907,0x0a07,0x0a08,0x0b08,0x0b0a},
  {0x0a09,0x0907,0x0907,0x0a08,0x0a08,0x0b08,0x0c09,0x0c09},
  {0x0b0a,0x0a08,0x0a08,0x0a08,0x0b09,0x0b09,0x0c09,0x0c0a}
};

const unsigned short huff_ltab9_10[13][13]=
{
  {0x0106,0x0305,0x0606,0x0806,0x0907,0x0a08,0x0a09,0x0b0a,0x0b0a,0x0c0a,0x0c0b,0x0d0b,0x0d0c},
  {0x0305,0x0404,0x0604,0x0705,0x0806,0x0807,0x0907,0x0a08,0x0a08,0x0a09,0x0b0a,0x0c0a,0x0c0b},
  {0x0606,0x0604,0x0705,0x0805,0x0806,0x0906,0x0a07,0x0a08,0x0a08,0x0b09,0x0c09,0x0c0a,0x0c0a},
  {0x0806,0x0705,0x0805,0x0905,0x0906,0x0a07,0x0a07,0x0b08,0x0b08,0x0b09,0x0c09,0x0c0a,0x0d0a},
  {0x0907,0x0806,0x0906,0x0906,0x0a06,0x0a07,0x0b07,0x0b08,0x0b08,0x0c09,0x0c09,0x0c0a,0x0d0a},
  {0x0a08,0x0907,0x0906,0x0a07,0x0b07,0x0b07,0x0b08,0x0c08,0x0b08,0x0c09,0x0c0a,0x0d0a,0x0d0b},
  {0x0b09,0x0907,0x0a07,0x0b07,0x0b07,0x0b08,0x0c08,0x0c09,0x0c09,0x0c09,0x0d0a,0x0d0a,0x0d0b},
  {0x0b09,0x0a08,0x0a08,0x0b08,0x0b08,0x0c08,0x0c09,0x0d09,0x0d09,0x0d0a,0x0d0a,0x0d0b,0x0d0b},
  {0x0b09,0x0a08,0x0a08,0x0b08,0x0b08,0x0b08,0x0c09,0x0c09,0x0d0a,0x0d0a,0x0e0a,0x0d0b,0x0e0b},
  {0x0b0a,0x0a09,0x0b09,0x0b09,0x0c09,0x0c09,0x0c09,0x0c0a,0x0d0a,0x0d0a,0x0e0b,0x0e0b,0x0e0c},
  {0x0c0a,0x0b09,0x0b09,0x0c09,0x0c09,0x0c0a,0x0d0a,0x0d0a,0x0d0a,0x0e0b,0x0e0b,0x0e0b,0x0f0c},
  {0x0c0b,0x0b0a,0x0c09,0x0c0a,0x0c0a,0x0d0a,0x0d0a,0x0d0a,0x0d0b,0x0e0b,0x0e0b,0x0f0b,0x0f0c},
  {0x0d0b,0x0c0a,0x0c0a,0x0c0a,0x0d0a,0x0d0a,0x0d0a,0x0d0b,0x0e0b,0x0e0c,0x0e0c,0x0e0c,0x0f0c}
};

const unsigned short huff_ltab11[17][17]=
{
  {0x0004,0x0005,0x0006,0x0007,0x0008,0x0008,0x0009,0x000a,0x000a,0x000a,0x000b,0x000b,0x000c,0x000b,0x000c,0x000c,0x000a},
  {0x0005,0x0004,0x0005,0x0006,0x0007,0x0007,0x0008,0x0008,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000b,0x0008},
  {0x0006,0x0005,0x0005,0x0006,0x0007,0x0007,0x0008,0x0008,0x0008,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x0008},
  {0x0007,0x0006,0x0006,0x0006,0x0007,0x0007,0x0008,0x0008,0x0008,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x0008},
  {0x0008,0x0007,0x0007,0x0007,0x0007,0x0008,0x0008,0x0008,0x0008,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x0008},
  {0x0008,0x0007,0x0007,0x0007,0x0007,0x0008,0x0008,0x0008,0x0009,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x0008},
  {0x0009,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x0008},
  {0x0009,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x0008},
  {0x000a,0x0009,0x0008,0x0008,0x0009,0x0009,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x0008},
  {0x000a,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000b,0x0008},
  {0x000b,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000a,0x000b,0x000b,0x0008},
  {0x000b,0x000a,0x0009,0x0009,0x000a,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000b,0x000b,0x000b,0x000b,0x0008},
  {0x000b,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000b,0x000b,0x000b,0x000b,0x0009},
  {0x000b,0x000a,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000b,0x000b,0x000b,0x000b,0x000b,0x0009},
  {0x000b,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000b,0x000b,0x000b,0x000b,0x000b,0x0009},
  {0x000c,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000b,0x000b,0x000b,0x000b,0x000b,0x000c,0x000c,0x0009},
  {0x0009,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0009,0x0005}
};

const unsigned short huff_ltabscf[121]=
{
  0x0012,  0x0012,  0x0012,  0x0012,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,
  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0012,
  0x0013,  0x0012,  0x0011,  0x0011,  0x0010,  0x0011,  0x0010,  0x0010,  0x0010,  0x0010,
  0x000f,  0x000f,  0x000e,  0x000e,  0x000e,  0x000e,  0x000e,  0x000e,  0x000d,  0x000d,
  0x000c,  0x000c,  0x000c,  0x000b,  0x000c,  0x000b,  0x000a,  0x000a,  0x000a,  0x0009,
  0x0009,  0x0008,  0x0008,  0x0008,  0x0007,  0x0006,  0x0006,  0x0005,  0x0004,  0x0003,
  0x0001,  0x0004,  0x0004,  0x0005,  0x0006,  0x0006,  0x0007,  0x0007,  0x0008,  0x0008,
  0x0009,  0x0009,  0x000a,  0x000a,  0x000a,  0x000b,  0x000b,  0x000b,  0x000b,  0x000c,
  0x000c,  0x000d,  0x000d,  0x000d,  0x000e,  0x000e,  0x0010,  0x000f,  0x0010,  0x000f,
  0x0012,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,
  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,
  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,  0x0013,
  0x0013
};


const unsigned short huff_ctab1[3][3][3][3]=
{
  {
    {
      {0x07f8,0x01f1,0x07fd},
      {0x03f5,0x0068,0x03f0},
      {0x07f7,0x01ec,0x07f5}
    },
    {
      {0x03f1,0x0072,0x03f4},
      {0x0074,0x0011,0x0076},
      {0x01eb,0x006c,0x03f6}
    },
    {
      {0x07fc,0x01e1,0x07f1},
      {0x01f0,0x0061,0x01f6},
      {0x07f2,0x01ea,0x07fb}
    }
  },
  {
    {
      {0x01f2,0x0069,0x01ed},
      {0x0077,0x0017,0x006f},
      {0x01e6,0x0064,0x01e5}
    },
    {
      {0x0067,0x0015,0x0062},
      {0x0012,0x0000,0x0014},
      {0x0065,0x0016,0x006d}
    },
    {
      {0x01e9,0x0063,0x01e4},
      {0x006b,0x0013,0x0071},
      {0x01e3,0x0070,0x01f3}
    }
  },
  {
    {
      {0x07fe,0x01e7,0x07f3},
      {0x01ef,0x0060,0x01ee},
      {0x07f0,0x01e2,0x07fa}
    },
    {
      {0x03f3,0x006a,0x01e8},
      {0x0075,0x0010,0x0073},
      {0x01f4,0x006e,0x03f7}
    },
    {
      {0x07f6,0x01e0,0x07f9},
      {0x03f2,0x0066,0x01f5},
      {0x07ff,0x01f7,0x07f4}
    }
  }
};

const unsigned short huff_ctab2[3][3][3][3]=
{
  {
    {
      {0x01f3,0x006f,0x01fd},
      {0x00eb,0x0023,0x00ea},
      {0x01f7,0x00e8,0x01fa}
    },
    {
      {0x00f2,0x002d,0x0070},
      {0x0020,0x0006,0x002b},
      {0x006e,0x0028,0x00e9}
    },
    {
      {0x01f9,0x0066,0x00f8},
      {0x00e7,0x001b,0x00f1},
      {0x01f4,0x006b,0x01f5}
    }
  },
  {
    {
      {0x00ec,0x002a,0x006c},
      {0x002c,0x000a,0x0027},
      {0x0067,0x001a,0x00f5}
    },
    {
      {0x0024,0x0008,0x001f},
      {0x0009,0x0000,0x0007},
      {0x001d,0x000b,0x0030}
    },
    {
      {0x00ef,0x001c,0x0064},
      {0x001e,0x000c,0x0029},
      {0x00f3,0x002f,0x00f0}
    }
  },
  {
    {
      {0x01fc,0x0071,0x01f2},
      {0x00f4,0x0021,0x00e6},
      {0x00f7,0x0068,0x01f8}
    },
    {
      {0x00ee,0x0022,0x0065},
      {0x0031,0x0002,0x0026},
      {0x00ed,0x0025,0x006a}
    },
    {
      {0x01fb,0x0072,0x01fe},
      {0x0069,0x002e,0x00f6},
      {0x01ff,0x006d,0x01f6}
    }
  }
};

const unsigned short huff_ctab3[3][3][3][3]=
{
  {
    {
      {0x0000,0x0009,0x00ef},
      {0x000b,0x0019,0x00f0},
      {0x01eb,0x01e6,0x03f2}
    },
    {
      {0x000a,0x0035,0x01ef},
      {0x0034,0x0037,0x01e9},
      {0x01ed,0x01e7,0x03f3}
    },
    {
      {0x01ee,0x03ed,0x1ffa},
      {0x01ec,0x01f2,0x07f9},
      {0x07f8,0x03f8,0x0ff8}
    }
  },
  {
    {
      {0x0008,0x0038,0x03f6},
      {0x0036,0x0075,0x03f1},
      {0x03eb,0x03ec,0x0ff4}
    },
    {
      {0x0018,0x0076,0x07f4},
      {0x0039,0x0074,0x03ef},
      {0x01f3,0x01f4,0x07f6}
    },
    {
      {0x01e8,0x03ea,0x1ffc},
      {0x00f2,0x01f1,0x0ffb},
      {0x03f5,0x07f3,0x0ffc}
    }
  },
  {
    {
      {0x00ee,0x03f7,0x7ffe},
      {0x01f0,0x07f5,0x7ffd},
      {0x1ffb,0x3ffa,0xffff}
    },
    {
      {0x00f1,0x03f0,0x3ffc},
      {0x01ea,0x03ee,0x3ffb},
      {0x0ff6,0x0ffa,0x7ffc}
    },
    {
      {0x07f2,0x0ff5,0xfffe},
      {0x03f4,0x07f7,0x7ffb},
      {0x0ff7,0x0ff9,0x7ffa}
    }
  }
};

const unsigned short huff_ctab4[3][3][3][3]=
{
  {
    {
      {0x0007,0x0016,0x00f6},
      {0x0018,0x0008,0x00ef},
      {0x01ef,0x00f3,0x07f8}
    },
    {
      {0x0019,0x0017,0x00ed},
      {0x0015,0x0001,0x00e2},
      {0x00f0,0x0070,0x03f0}
    },
    {
      {0x01ee,0x00f1,0x07fa},
      {0x00ee,0x00e4,0x03f2},
      {0x07f6,0x03ef,0x07fd}
    }
  },
  {
    {
      {0x0005,0x0014,0x00f2},
      {0x0009,0x0004,0x00e5},
      {0x00f4,0x00e8,0x03f4}
    },
    {
      {0x0006,0x0002,0x00e7},
      {0x0003,0x0000,0x006b},
      {0x00e3,0x0069,0x01f3}
    },
    {
      {0x00eb,0x00e6,0x03f6},
      {0x006e,0x006a,0x01f4},
      {0x03ec,0x01f0,0x03f9}
    }
  },
  {
    {
      {0x00f5,0x00ec,0x07fb},
      {0x00ea,0x006f,0x03f7},
      {0x07f9,0x03f3,0x0fff}
    },
    {
      {0x00e9,0x006d,0x03f8},
      {0x006c,0x0068,0x01f5},
      {0x03ee,0x01f2,0x07f4}
    },
    {
      {0x07f7,0x03f1,0x0ffe},
      {0x03ed,0x01f1,0x07f5},
      {0x07fe,0x03f5,0x07fc}
    }
  }
};
const unsigned short huff_ctab5[9][9]=
{
  {0x1fff,0x0ff7,0x07f4,0x07e8,0x03f1,0x07ee,0x07f9,0x0ff8,0x1ffd},
  {0x0ffd,0x07f1,0x03e8,0x01e8,0x00f0,0x01ec,0x03ee,0x07f2,0x0ffa},
  {0x0ff4,0x03ef,0x01f2,0x00e8,0x0070,0x00ec,0x01f0,0x03ea,0x07f3},
  {0x07eb,0x01eb,0x00ea,0x001a,0x0008,0x0019,0x00ee,0x01ef,0x07ed},
  {0x03f0,0x00f2,0x0073,0x000b,0x0000,0x000a,0x0071,0x00f3,0x07e9},
  {0x07ef,0x01ee,0x00ef,0x0018,0x0009,0x001b,0x00eb,0x01e9,0x07ec},
  {0x07f6,0x03eb,0x01f3,0x00ed,0x0072,0x00e9,0x01f1,0x03ed,0x07f7},
  {0x0ff6,0x07f0,0x03e9,0x01ed,0x00f1,0x01ea,0x03ec,0x07f8,0x0ff9},
  {0x1ffc,0x0ffc,0x0ff5,0x07ea,0x03f3,0x03f2,0x07f5,0x0ffb,0x1ffe}
};

const unsigned short huff_ctab6[9][9]=
{
  {0x07fe,0x03fd,0x01f1,0x01eb,0x01f4,0x01ea,0x01f0,0x03fc,0x07fd},
  {0x03f6,0x01e5,0x00ea,0x006c,0x0071,0x0068,0x00f0,0x01e6,0x03f7},
  {0x01f3,0x00ef,0x0032,0x0027,0x0028,0x0026,0x0031,0x00eb,0x01f7},
  {0x01e8,0x006f,0x002e,0x0008,0x0004,0x0006,0x0029,0x006b,0x01ee},
  {0x01ef,0x0072,0x002d,0x0002,0x0000,0x0003,0x002f,0x0073,0x01fa},
  {0x01e7,0x006e,0x002b,0x0007,0x0001,0x0005,0x002c,0x006d,0x01ec},
  {0x01f9,0x00ee,0x0030,0x0024,0x002a,0x0025,0x0033,0x00ec,0x01f2},
  {0x03f8,0x01e4,0x00ed,0x006a,0x0070,0x0069,0x0074,0x00f1,0x03fa},
  {0x07ff,0x03f9,0x01f6,0x01ed,0x01f8,0x01e9,0x01f5,0x03fb,0x07fc}
};

const unsigned short huff_ctab7[8][8]=
{
  {0x0000,0x0005,0x0037,0x0074,0x00f2,0x01eb,0x03ed,0x07f7},
  {0x0004,0x000c,0x0035,0x0071,0x00ec,0x00ee,0x01ee,0x01f5},
  {0x0036,0x0034,0x0072,0x00ea,0x00f1,0x01e9,0x01f3,0x03f5},
  {0x0073,0x0070,0x00eb,0x00f0,0x01f1,0x01f0,0x03ec,0x03fa},
  {0x00f3,0x00ed,0x01e8,0x01ef,0x03ef,0x03f1,0x03f9,0x07fb},
  {0x01ed,0x00ef,0x01ea,0x01f2,0x03f3,0x03f8,0x07f9,0x07fc},
  {0x03ee,0x01ec,0x01f4,0x03f4,0x03f7,0x07f8,0x0ffd,0x0ffe},
  {0x07f6,0x03f0,0x03f2,0x03f6,0x07fa,0x07fd,0x0ffc,0x0fff}
};

const unsigned short huff_ctab8[8][8]=
{
  {0x000e,0x0005,0x0010,0x0030,0x006f,0x00f1,0x01fa,0x03fe},
  {0x0003,0x0000,0x0004,0x0012,0x002c,0x006a,0x0075,0x00f8},
  {0x000f,0x0002,0x0006,0x0014,0x002e,0x0069,0x0072,0x00f5},
  {0x002f,0x0011,0x0013,0x002a,0x0032,0x006c,0x00ec,0x00fa},
  {0x0071,0x002b,0x002d,0x0031,0x006d,0x0070,0x00f2,0x01f9},
  {0x00ef,0x0068,0x0033,0x006b,0x006e,0x00ee,0x00f9,0x03fc},
  {0x01f8,0x0074,0x0073,0x00ed,0x00f0,0x00f6,0x01f6,0x01fd},
  {0x03fd,0x00f3,0x00f4,0x00f7,0x01f7,0x01fb,0x01fc,0x03ff}
};

const unsigned short huff_ctab9[13][13]=
{
  {0x0000,0x0005,0x0037,0x00e7,0x01de,0x03ce,0x03d9,0x07c8,0x07cd,0x0fc8,0x0fdd,0x1fe4,0x1fec},
  {0x0004,0x000c,0x0035,0x0072,0x00ea,0x00ed,0x01e2,0x03d1,0x03d3,0x03e0,0x07d8,0x0fcf,0x0fd5},
  {0x0036,0x0034,0x0071,0x00e8,0x00ec,0x01e1,0x03cf,0x03dd,0x03db,0x07d0,0x0fc7,0x0fd4,0x0fe4},
  {0x00e6,0x0070,0x00e9,0x01dd,0x01e3,0x03d2,0x03dc,0x07cc,0x07ca,0x07de,0x0fd8,0x0fea,0x1fdb},
  {0x01df,0x00eb,0x01dc,0x01e6,0x03d5,0x03de,0x07cb,0x07dd,0x07dc,0x0fcd,0x0fe2,0x0fe7,0x1fe1},
  {0x03d0,0x01e0,0x01e4,0x03d6,0x07c5,0x07d1,0x07db,0x0fd2,0x07e0,0x0fd9,0x0feb,0x1fe3,0x1fe9},
  {0x07c4,0x01e5,0x03d7,0x07c6,0x07cf,0x07da,0x0fcb,0x0fda,0x0fe3,0x0fe9,0x1fe6,0x1ff3,0x1ff7},
  {0x07d3,0x03d8,0x03e1,0x07d4,0x07d9,0x0fd3,0x0fde,0x1fdd,0x1fd9,0x1fe2,0x1fea,0x1ff1,0x1ff6},
  {0x07d2,0x03d4,0x03da,0x07c7,0x07d7,0x07e2,0x0fce,0x0fdb,0x1fd8,0x1fee,0x3ff0,0x1ff4,0x3ff2},
  {0x07e1,0x03df,0x07c9,0x07d6,0x0fca,0x0fd0,0x0fe5,0x0fe6,0x1feb,0x1fef,0x3ff3,0x3ff4,0x3ff5},
  {0x0fe0,0x07ce,0x07d5,0x0fc6,0x0fd1,0x0fe1,0x1fe0,0x1fe8,0x1ff0,0x3ff1,0x3ff8,0x3ff6,0x7ffc},
  {0x0fe8,0x07df,0x0fc9,0x0fd7,0x0fdc,0x1fdc,0x1fdf,0x1fed,0x1ff5,0x3ff9,0x3ffb,0x7ffd,0x7ffe},
  {0x1fe7,0x0fcc,0x0fd6,0x0fdf,0x1fde,0x1fda,0x1fe5,0x1ff2,0x3ffa,0x3ff7,0x3ffc,0x3ffd,0x7fff}
};

const unsigned short huff_ctab10[13][13]=
{
  {0x0022,0x0008,0x001d,0x0026,0x005f,0x00d3,0x01cf,0x03d0,0x03d7,0x03ed,0x07f0,0x07f6,0x0ffd},
  {0x0007,0x0000,0x0001,0x0009,0x0020,0x0054,0x0060,0x00d5,0x00dc,0x01d4,0x03cd,0x03de,0x07e7},
  {0x001c,0x0002,0x0006,0x000c,0x001e,0x0028,0x005b,0x00cd,0x00d9,0x01ce,0x01dc,0x03d9,0x03f1},
  {0x0025,0x000b,0x000a,0x000d,0x0024,0x0057,0x0061,0x00cc,0x00dd,0x01cc,0x01de,0x03d3,0x03e7},
  {0x005d,0x0021,0x001f,0x0023,0x0027,0x0059,0x0064,0x00d8,0x00df,0x01d2,0x01e2,0x03dd,0x03ee},
  {0x00d1,0x0055,0x0029,0x0056,0x0058,0x0062,0x00ce,0x00e0,0x00e2,0x01da,0x03d4,0x03e3,0x07eb},
  {0x01c9,0x005e,0x005a,0x005c,0x0063,0x00ca,0x00da,0x01c7,0x01ca,0x01e0,0x03db,0x03e8,0x07ec},
  {0x01e3,0x00d2,0x00cb,0x00d0,0x00d7,0x00db,0x01c6,0x01d5,0x01d8,0x03ca,0x03da,0x07ea,0x07f1},
  {0x01e1,0x00d4,0x00cf,0x00d6,0x00de,0x00e1,0x01d0,0x01d6,0x03d1,0x03d5,0x03f2,0x07ee,0x07fb},
  {0x03e9,0x01cd,0x01c8,0x01cb,0x01d1,0x01d7,0x01df,0x03cf,0x03e0,0x03ef,0x07e6,0x07f8,0x0ffa},
  {0x03eb,0x01dd,0x01d3,0x01d9,0x01db,0x03d2,0x03cc,0x03dc,0x03ea,0x07ed,0x07f3,0x07f9,0x0ff9},
  {0x07f2,0x03ce,0x01e4,0x03cb,0x03d8,0x03d6,0x03e2,0x03e5,0x07e8,0x07f4,0x07f5,0x07f7,0x0ffb},
  {0x07fa,0x03ec,0x03df,0x03e1,0x03e4,0x03e6,0x03f0,0x07e9,0x07ef,0x0ff8,0x0ffe,0x0ffc,0x0fff}
};

const unsigned short huff_ctab11[17][17]=
{
  {0x0000,0x0006,0x0019,0x003d,0x009c,0x00c6,0x01a7,0x0390,0x03c2,0x03df,0x07e6,0x07f3,0x0ffb,0x07ec,0x0ffa,0x0ffe,0x038e},
  {0x0005,0x0001,0x0008,0x0014,0x0037,0x0042,0x0092,0x00af,0x0191,0x01a5,0x01b5,0x039e,0x03c0,0x03a2,0x03cd,0x07d6,0x00ae},
  {0x0017,0x0007,0x0009,0x0018,0x0039,0x0040,0x008e,0x00a3,0x00b8,0x0199,0x01ac,0x01c1,0x03b1,0x0396,0x03be,0x03ca,0x009d},
  {0x003c,0x0015,0x0016,0x001a,0x003b,0x0044,0x0091,0x00a5,0x00be,0x0196,0x01ae,0x01b9,0x03a1,0x0391,0x03a5,0x03d5,0x0094},
  {0x009a,0x0036,0x0038,0x003a,0x0041,0x008c,0x009b,0x00b0,0x00c3,0x019e,0x01ab,0x01bc,0x039f,0x038f,0x03a9,0x03cf,0x0093},
  {0x00bf,0x003e,0x003f,0x0043,0x0045,0x009e,0x00a7,0x00b9,0x0194,0x01a2,0x01ba,0x01c3,0x03a6,0x03a7,0x03bb,0x03d4,0x009f},
  {0x01a0,0x008f,0x008d,0x0090,0x0098,0x00a6,0x00b6,0x00c4,0x019f,0x01af,0x01bf,0x0399,0x03bf,0x03b4,0x03c9,0x03e7,0x00a8},
  {0x01b6,0x00ab,0x00a4,0x00aa,0x00b2,0x00c2,0x00c5,0x0198,0x01a4,0x01b8,0x038c,0x03a4,0x03c4,0x03c6,0x03dd,0x03e8,0x00ad},
  {0x03af,0x0192,0x00bd,0x00bc,0x018e,0x0197,0x019a,0x01a3,0x01b1,0x038d,0x0398,0x03b7,0x03d3,0x03d1,0x03db,0x07dd,0x00b4},
  {0x03de,0x01a9,0x019b,0x019c,0x01a1,0x01aa,0x01ad,0x01b3,0x038b,0x03b2,0x03b8,0x03ce,0x03e1,0x03e0,0x07d2,0x07e5,0x00b7},
  {0x07e3,0x01bb,0x01a8,0x01a6,0x01b0,0x01b2,0x01b7,0x039b,0x039a,0x03ba,0x03b5,0x03d6,0x07d7,0x03e4,0x07d8,0x07ea,0x00ba},
  {0x07e8,0x03a0,0x01bd,0x01b4,0x038a,0x01c4,0x0392,0x03aa,0x03b0,0x03bc,0x03d7,0x07d4,0x07dc,0x07db,0x07d5,0x07f0,0x00c1},
  {0x07fb,0x03c8,0x03a3,0x0395,0x039d,0x03ac,0x03ae,0x03c5,0x03d8,0x03e2,0x03e6,0x07e4,0x07e7,0x07e0,0x07e9,0x07f7,0x0190},
  {0x07f2,0x0393,0x01be,0x01c0,0x0394,0x0397,0x03ad,0x03c3,0x03c1,0x03d2,0x07da,0x07d9,0x07df,0x07eb,0x07f4,0x07fa,0x0195},
  {0x07f8,0x03bd,0x039c,0x03ab,0x03a8,0x03b3,0x03b9,0x03d0,0x03e3,0x03e5,0x07e2,0x07de,0x07ed,0x07f1,0x07f9,0x07fc,0x0193},
  {0x0ffd,0x03dc,0x03b6,0x03c7,0x03cc,0x03cb,0x03d9,0x03da,0x07d3,0x07e1,0x07ee,0x07ef,0x07f5,0x07f6,0x0ffc,0x0fff,0x019d},
  {0x01c2,0x00b5,0x00a1,0x0096,0x0097,0x0095,0x0099,0x00a0,0x00a2,0x00ac,0x00a9,0x00b1,0x00b3,0x00bb,0x00c0,0x018f,0x0004}
};

const unsigned long huff_ctabscf[121]=
{
  0x0003ffe8,  0x0003ffe6,  0x0003ffe7,  0x0003ffe5,  0x0007fff5,  0x0007fff1,  0x0007ffed,  0x0007fff6,
  0x0007ffee,  0x0007ffef,  0x0007fff0,  0x0007fffc,  0x0007fffd,  0x0007ffff,  0x0007fffe,  0x0007fff7,
  0x0007fff8,  0x0007fffb,  0x0007fff9,  0x0003ffe4,  0x0007fffa,  0x0003ffe3,  0x0001ffef,  0x0001fff0,
  0x0000fff5,  0x0001ffee,  0x0000fff2,  0x0000fff3,  0x0000fff4,  0x0000fff1,  0x00007ff6,  0x00007ff7,
  0x00003ff9,  0x00003ff5,  0x00003ff7,  0x00003ff3,  0x00003ff6,  0x00003ff2,  0x00001ff7,  0x00001ff5,
  0x00000ff9,  0x00000ff7,  0x00000ff6,  0x000007f9,  0x00000ff4,  0x000007f8,  0x000003f9,  0x000003f7,
  0x000003f5,  0x000001f8,  0x000001f7,  0x000000fa,  0x000000f8,  0x000000f6,  0x00000079,  0x0000003a,
  0x00000038,  0x0000001a,  0x0000000b,  0x00000004,  0x00000000,  0x0000000a,  0x0000000c,  0x0000001b,
  0x00000039,  0x0000003b,  0x00000078,  0x0000007a,  0x000000f7,  0x000000f9,  0x000001f6,  0x000001f9,
  0x000003f4,  0x000003f6,  0x000003f8,  0x000007f5,  0x000007f4,  0x000007f6,  0x000007f7,  0x00000ff5,
  0x00000ff8,  0x00001ff4,  0x00001ff6,  0x00001ff8,  0x00003ff8,  0x00003ff4,  0x0000fff0,  0x00007ff4,
  0x0000fff6,  0x00007ff5,  0x0003ffe2,  0x0007ffd9,  0x0007ffda,  0x0007ffdb,  0x0007ffdc,  0x0007ffdd,
  0x0007ffde,  0x0007ffd8,  0x0007ffd2,  0x0007ffd3,  0x0007ffd4,  0x0007ffd5,  0x0007ffd6,  0x0007fff2,
  0x0007ffdf,  0x0007ffe7,  0x0007ffe8,  0x0007ffe9,  0x0007ffea,  0x0007ffeb,  0x0007ffe6,  0x0007ffe0,
  0x0007ffe1,  0x0007ffe2,  0x0007ffe3,  0x0007ffe4,  0x0007ffe5,  0x0007ffd7,  0x0007ffec,  0x0007fff4,
  0x0007fff3
};

const float fftTwiddleTab[FFT_TWIDDLE_TABLE_SIZE+1] =
{
+0.00000000000000e+000,+3.06795676296598e-003,+6.13588464915448e-003,+9.20375478205982e-003,
+1.22715382857199e-002,+1.53392062849881e-002,+1.84067299058048e-002,+2.14740802754695e-002,
+2.45412285229123e-002,+2.76081457789657e-002,+3.06748031766366e-002,+3.37411718513776e-002,
+3.68072229413588e-002,+3.98729275877398e-002,+4.29382569349408e-002,+4.60031821309146e-002,
+4.90676743274180e-002,+5.21317046802833e-002,+5.51952443496899e-002,+5.82582645004358e-002,
+6.13207363022086e-002,+6.43826309298575e-002,+6.74439195636641e-002,+7.05045733896139e-002,
+7.35645635996674e-002,+7.66238613920315e-002,+7.96824379714301e-002,+8.27402645493757e-002,
+8.57973123444399e-002,+8.88535525825246e-002,+9.19089564971327e-002,+9.49634953296390e-002,
+9.80171403295606e-002,+1.01069862754828e-001,+1.04121633872055e-001,+1.07172424956809e-001,
+1.10222207293883e-001,+1.13270952177564e-001,+1.16318630911905e-001,+1.19365214810991e-001,
+1.22410675199216e-001,+1.25454983411546e-001,+1.28498110793793e-001,+1.31540028702883e-001,
+1.34580708507126e-001,+1.37620121586486e-001,+1.40658239332849e-001,+1.43695033150294e-001,
+1.46730474455362e-001,+1.49764534677322e-001,+1.52797185258443e-001,+1.55828397654265e-001,
+1.58858143333861e-001,+1.61886393780112e-001,+1.64913120489970e-001,+1.67938294974731e-001,
+1.70961888760301e-001,+1.73983873387464e-001,+1.77004220412149e-001,+1.80022901405700e-001,
+1.83039887955141e-001,+1.86055151663447e-001,+1.89068664149806e-001,+1.92080397049892e-001,
+1.95090322016128e-001,+1.98098410717954e-001,+2.01104634842092e-001,+2.04108966092817e-001,
+2.07111376192219e-001,+2.10111836880470e-001,+2.13110319916091e-001,+2.16106797076220e-001,
+2.19101240156870e-001,+2.22093620973204e-001,+2.25083911359793e-001,+2.28072083170886e-001,
+2.31058108280671e-001,+2.34041958583543e-001,+2.37023605994367e-001,+2.40003022448742e-001,
+2.42980179903264e-001,+2.45955050335795e-001,+2.48927605745720e-001,+2.51897818154217e-001,
+2.54865659604515e-001,+2.57831102162159e-001,+2.60794117915276e-001,+2.63754678974831e-001,
+2.66712757474898e-001,+2.69668325572915e-001,+2.72621355449949e-001,+2.75571819310958e-001,
+2.78519689385053e-001,+2.81464937925758e-001,+2.84407537211272e-001,+2.87347459544730e-001,
+2.90284677254462e-001,+2.93219162694259e-001,+2.96150888243624e-001,+2.99079826308040e-001,
+3.02005949319228e-001,+3.04929229735402e-001,+3.07849640041535e-001,+3.10767152749611e-001,
+3.13681740398892e-001,+3.16593375556166e-001,+3.19502030816016e-001,+3.22407678801070e-001,
+3.25310292162263e-001,+3.28209843579093e-001,+3.31106305759876e-001,+3.33999651442009e-001,
+3.36889853392220e-001,+3.39776884406827e-001,+3.42660717311994e-001,+3.45541324963989e-001,
+3.48418680249435e-001,+3.51292756085567e-001,+3.54163525420490e-001,+3.57030961233430e-001,
+3.59895036534988e-001,+3.62755724367397e-001,+3.65612997804774e-001,+3.68466829953372e-001,
+3.71317193951838e-001,+3.74164062971458e-001,+3.77007410216418e-001,+3.79847208924051e-001,
+3.82683432365090e-001,+3.85516053843919e-001,+3.88345046698826e-001,+3.91170384302254e-001,
+3.93992040061048e-001,+3.96809987416710e-001,+3.99624199845647e-001,+4.02434650859418e-001,
+4.05241314004990e-001,+4.08044162864979e-001,+4.10843171057904e-001,+4.13638312238435e-001,
+4.16429560097637e-001,+4.19216888363224e-001,+4.22000270799800e-001,+4.24779681209109e-001,
+4.27555093430282e-001,+4.30326481340083e-001,+4.33093818853152e-001,+4.35857079922255e-001,
+4.38616238538528e-001,+4.41371268731717e-001,+4.44122144570429e-001,+4.46868840162374e-001,
+4.49611329654607e-001,+4.52349587233771e-001,+4.55083587126344e-001,+4.57813303598877e-001,
+4.60538710958240e-001,+4.63259783551860e-001,+4.65976495767966e-001,+4.68688822035828e-001,
+4.71396736825998e-001,+4.74100214650550e-001,+4.76799230063322e-001,+4.79493757660153e-001,
+4.82183772079123e-001,+4.84869248000791e-001,+4.87550160148436e-001,+4.90226483288291e-001,
+4.92898192229784e-001,+4.95565261825773e-001,+4.98227666972782e-001,+5.00885382611241e-001,
+5.03538383725718e-001,+5.06186645345155e-001,+5.08830142543107e-001,+5.11468850437970e-001,
+5.14102744193222e-001,+5.16731799017650e-001,+5.19355990165590e-001,+5.21975292937154e-001,
+5.24589682678469e-001,+5.27199134781901e-001,+5.29803624686295e-001,+5.32403127877198e-001,
+5.34997619887097e-001,+5.37587076295645e-001,+5.40171472729893e-001,+5.42750784864516e-001,
+5.45324988422046e-001,+5.47894059173100e-001,+5.50457972936605e-001,+5.53016705580027e-001,
+5.55570233019602e-001,+5.58118531220556e-001,+5.60661576197336e-001,+5.63199344013834e-001,
+5.65731810783613e-001,+5.68258952670131e-001,+5.70780745886967e-001,+5.73297166698042e-001,
+5.75808191417845e-001,+5.78313796411656e-001,+5.80813958095765e-001,+5.83308652937698e-001,
+5.85797857456439e-001,+5.88281548222645e-001,+5.90759701858874e-001,+5.93232295039800e-001,
+5.95699304492433e-001,+5.98160706996342e-001,+6.00616479383869e-001,+6.03066598540348e-001,
+6.05511041404326e-001,+6.07949784967774e-001,+6.10382806276309e-001,+6.12810082429410e-001,
+6.15231590580627e-001,+6.17647307937804e-001,+6.20057211763289e-001,+6.22461279374150e-001,
+6.24859488142386e-001,+6.27251815495144e-001,+6.29638238914927e-001,+6.32018735939809e-001,
+6.34393284163645e-001,+6.36761861236284e-001,+6.39124444863776e-001,+6.41481012808583e-001,
+6.43831542889791e-001,+6.46176012983316e-001,+6.48514401022112e-001,+6.50846684996381e-001,
+6.53172842953777e-001,+6.55492852999615e-001,+6.57806693297079e-001,+6.60114342067420e-001,
+6.62415777590172e-001,+6.64710978203345e-001,+6.66999922303637e-001,+6.69282588346636e-001,
+6.71558954847018e-001,+6.73829000378756e-001,+6.76092703575316e-001,+6.78350043129861e-001,
+6.80600997795453e-001,+6.82845546385248e-001,+6.85083667772700e-001,+6.87315340891759e-001,
+6.89540544737067e-001,+6.91759258364158e-001,+6.93971460889654e-001,+6.96177131491463e-001,
+6.98376249408973e-001,+7.00568793943248e-001,+7.02754744457225e-001,+7.04934080375905e-001,
+7.07106781186547e-001,+7.09272826438866e-001,+7.11432195745216e-001,+7.13584868780794e-001,
+7.15730825283819e-001,+7.17870045055732e-001,+7.20002507961382e-001,+7.22128193929215e-001,
+7.24247082951467e-001,+7.26359155084346e-001,+7.28464390448225e-001,+7.30562769227828e-001,
+7.32654271672413e-001,+7.34738878095963e-001,+7.36816568877370e-001,+7.38887324460615e-001,
+7.40951125354959e-001,+7.43007952135122e-001,+7.45057785441466e-001,+7.47100605980180e-001,
+7.49136394523459e-001,+7.51165131909686e-001,+7.53186799043612e-001,+7.55201376896537e-001,
+7.57208846506484e-001,+7.59209188978388e-001,+7.61202385484262e-001,+7.63188417263381e-001,
+7.65167265622459e-001,+7.67138911935820e-001,+7.69103337645580e-001,+7.71060524261814e-001,
+7.73010453362737e-001,+7.74953106594874e-001,+7.76888465673232e-001,+7.78816512381476e-001,
+7.80737228572094e-001,+7.82650596166576e-001,+7.84556597155575e-001,+7.86455213599086e-001,
+7.88346427626606e-001,+7.90230221437310e-001,+7.92106577300212e-001,+7.93975477554337e-001,
+7.95836904608883e-001,+7.97690840943391e-001,+7.99537269107905e-001,+8.01376171723140e-001,
+8.03207531480645e-001,+8.05031331142964e-001,+8.06847553543799e-001,+8.08656181588175e-001,
+8.10457198252595e-001,+8.12250586585204e-001,+8.14036329705948e-001,+8.15814410806734e-001,
+8.17584813151584e-001,+8.19347520076797e-001,+8.21102514991105e-001,+8.22849781375826e-001,
+8.24589302785025e-001,+8.26321062845663e-001,+8.28045045257756e-001,+8.29761233794523e-001,
+8.31469612302545e-001,+8.33170164701913e-001,+8.34862874986380e-001,+8.36547727223512e-001,
+8.38224705554838e-001,+8.39893794195999e-001,+8.41554977436898e-001,+8.43208239641845e-001,
+8.44853565249707e-001,+8.46490938774052e-001,+8.48120344803297e-001,+8.49741768000852e-001,
+8.51355193105265e-001,+8.52960604930364e-001,+8.54557988365401e-001,+8.56147328375194e-001,
+8.57728610000272e-001,+8.59301818357008e-001,+8.60866938637767e-001,+8.62423956111041e-001,
+8.63972856121587e-001,+8.65513624090569e-001,+8.67046245515693e-001,+8.68570705971341e-001,
+8.70086991108711e-001,+8.71595086655951e-001,+8.73094978418290e-001,+8.74586652278176e-001,
+8.76070094195407e-001,+8.77545290207261e-001,+8.79012226428633e-001,+8.80470889052161e-001,
+8.81921264348355e-001,+8.83363338665732e-001,+8.84797098430938e-001,+8.86222530148881e-001,
+8.87639620402854e-001,+8.89048355854665e-001,+8.90448723244758e-001,+8.91840709392343e-001,
+8.93224301195515e-001,+8.94599485631383e-001,+8.95966249756185e-001,+8.97324580705418e-001,
+8.98674465693954e-001,+9.00015892016160e-001,+9.01348847046022e-001,+9.02673318237259e-001,
+9.03989293123443e-001,+9.05296759318119e-001,+9.06595704514915e-001,+9.07886116487666e-001,
+9.09167983090522e-001,+9.10441292258067e-001,+9.11706032005430e-001,+9.12962190428398e-001,
+9.14209755703531e-001,+9.15448716088268e-001,+9.16679059921043e-001,+9.17900775621390e-001,
+9.19113851690058e-001,+9.20318276709110e-001,+9.21514039342042e-001,+9.22701128333879e-001,
+9.23879532511287e-001,+9.25049240782678e-001,+9.26210242138311e-001,+9.27362525650401e-001,
+9.28506080473215e-001,+9.29640895843181e-001,+9.30766961078984e-001,+9.31884265581668e-001,
+9.32992798834739e-001,+9.34092550404259e-001,+9.35183509938948e-001,+9.36265667170278e-001,
+9.37339011912575e-001,+9.38403534063108e-001,+9.39459223602190e-001,+9.40506070593268e-001,
+9.41544065183021e-001,+9.42573197601447e-001,+9.43593458161960e-001,+9.44604837261480e-001,
+9.45607325380521e-001,+9.46600913083284e-001,+9.47585591017741e-001,+9.48561349915730e-001,
+9.49528180593037e-001,+9.50486073949482e-001,+9.51435020969008e-001,+9.52375012719766e-001,
+9.53306040354194e-001,+9.54228095109106e-001,+9.55141168305771e-001,+9.56045251349996e-001,
+9.56940335732209e-001,+9.57826413027533e-001,+9.58703474895872e-001,+9.59571513081985e-001,
+9.60430519415566e-001,+9.61280485811321e-001,+9.62121404269042e-001,+9.62953266873684e-001,
+9.63776065795440e-001,+9.64589793289813e-001,+9.65394441697689e-001,+9.66190003445413e-001,
+9.66976471044852e-001,+9.67753837093476e-001,+9.68522094274417e-001,+9.69281235356549e-001,
+9.70031253194544e-001,+9.70772140728950e-001,+9.71503890986252e-001,+9.72226497078936e-001,
+9.72939952205560e-001,+9.73644249650812e-001,+9.74339382785576e-001,+9.75025345066994e-001,
+9.75702130038529e-001,+9.76369731330021e-001,+9.77028142657754e-001,+9.77677357824510e-001,
+9.78317370719628e-001,+9.78948175319062e-001,+9.79569765685441e-001,+9.80182135968117e-001,
+9.80785280403230e-001,+9.81379193313755e-001,+9.81963869109555e-001,+9.82539302287441e-001,
+9.83105487431216e-001,+9.83662419211730e-001,+9.84210092386929e-001,+9.84748501801904e-001,
+9.85277642388941e-001,+9.85797509167567e-001,+9.86308097244599e-001,+9.86809401814185e-001,
+9.87301418157858e-001,+9.87784141644572e-001,+9.88257567730749e-001,+9.88721691960324e-001,
+9.89176509964781e-001,+9.89622017463201e-001,+9.90058210262297e-001,+9.90485084256457e-001,
+9.90902635427780e-001,+9.91310859846115e-001,+9.91709753669100e-001,+9.92099313142192e-001,
+9.92479534598710e-001,+9.92850414459865e-001,+9.93211949234795e-001,+9.93564135520595e-001,
+9.93906970002356e-001,+9.94240449453188e-001,+9.94564570734255e-001,+9.94879330794806e-001,
+9.95184726672197e-001,+9.95480755491927e-001,+9.95767414467660e-001,+9.96044700901252e-001,
+9.96312612182778e-001,+9.96571145790555e-001,+9.96820299291166e-001,+9.97060070339483e-001,
+9.97290456678690e-001,+9.97511456140303e-001,+9.97723066644192e-001,+9.97925286198596e-001,
+9.98118112900149e-001,+9.98301544933893e-001,+9.98475580573295e-001,+9.98640218180265e-001,
+9.98795456205172e-001,+9.98941293186857e-001,+9.99077727752645e-001,+9.99204758618364e-001,
+9.99322384588350e-001,+9.99430604555462e-001,+9.99529417501093e-001,+9.99618822495179e-001,
+9.99698818696204e-001,+9.99769405351215e-001,+9.99830581795823e-001,+9.99882347454213e-001,
+9.99924701839145e-001,+9.99957644551964e-001,+9.99981175282601e-001,+9.99995293809576e-001,
+1.00000000000000e+000,
};


/*
  TNS constants
*/

/* 3 bit resolution */
const float tnsCoeff3[8]=
{
-0.98480775F,
-0.86602539F,
-0.64278758F,
-0.34202015F,
 0.00000000F,
 0.43388373F,
 0.78183150F,
 0.97492790F,
};

const float tnsCoeff3Borders[8]={
-1.0f,
-0.9396926324f,
-0.7660444587f,
-0.5000000126f,
-0.1736481824f,
0.2225209400f,
0.6234898165f,
0.9009688814f,
};

/* 4 bit resolution */

const float tnsCoeff4[16]=
{
-0.99573418F,
-0.96182567F,
-0.89516330F,
-0.79801726F,
-0.67369568F,
-0.52643222F,
-0.36124170F,
-0.18374953F,
 0.00000000F,
 0.20791170F,
 0.40673664F,
 0.58778524F,
 0.74314481F,
 0.86602539F,
 0.95105654F,
 0.99452192F
};

const float tnsCoeff4Borders[16]=
{
  -1.0f,
  -0.9829731068f,
  -0.9324722415f,
  -0.8502171506f,
  -0.7390089328f,
  -0.6026346507f,
  -0.4457383673f,
  -0.2736629975f,
  -0.0922683620f,
  0.1045284662f,
  0.3090170027f,
  0.5000000126f,
  0.6691306215f,
  0.8090170098f,
  0.9135454707f,
  0.9781476086f
};


const TNS_CONFIG_TABULATED  p_8000_mono_long ={
  1.2f,
  1800,
  16000,
  0.6f
};
const TNS_CONFIG_TABULATED  p_8000_mono_short ={
  1.2f,
  2500,
  16000,
  0.6f
};
const TNS_CONFIG_TABULATED  p_8000_stereo_long ={
  1.2f,
  1800,
  16000,
  0.6f
};
const TNS_CONFIG_TABULATED  p_8000_stereo_short ={
  1.2f,
  2500,
  16000,
  0.6f
};
const TNS_CONFIG_TABULATED  p_16000_mono_long ={
  1.2f,
  2000,
  16000,
  0.6f
};
const TNS_CONFIG_TABULATED  p_16000_mono_short ={
  1.2f,
  3750,
  16000,
  0.6f
};
const TNS_CONFIG_TABULATED  p_16000_stereo_long ={
  1.41f,
  2500,
  16000,
  0.6f
};
const TNS_CONFIG_TABULATED p_16000_stereo_short ={
  1.41f,
  3750,
  16000,
  0.6f
};
const TNS_CONFIG_TABULATED p_24000_mono_long ={
  1.41f,
  2500,
  16000,
  0.5f
};
const TNS_CONFIG_TABULATED p_24000_mono_short ={
  1.41f,
  3750,
  16000,
  0.5f
};
const TNS_CONFIG_TABULATED p_24000_stereo_long ={
  1.41f,
  2500,
  16000,
  0.5f
};
const TNS_CONFIG_TABULATED p_24000_stereo_short ={
  1.41f,
  3750,
  16000,
  0.5f
};
const TNS_CONFIG_TABULATED p_32000_mono_long ={
  1.41f,
  2500,
  16000,
  0.8f
};
const TNS_CONFIG_TABULATED p_32000_mono_short ={
  1.41f,
  3750,
  16000,
  0.3f
};
const TNS_CONFIG_TABULATED p_32000_stereo_long ={
  1.41f,
  2500,
  16000,
  0.5f
};
const TNS_CONFIG_TABULATED p_32000_stereo_short ={
  1.41f,
  3750,
  16000,
  0.3f
};

const TNS_MAX_TAB_ENTRY
tnsMaxBandsTab[9] = {
  /* entry for each sampling rate
   * 1    long window
   * 2    short window */
  {48000,40, 14}, /* 48000 */
  {44100,42, 14}, /* 44100 */
  {32000,51, 14}, /* 32000 */
  {24000,46, 14}, /* 24000 */
  {22050,46, 14}, /* 22050 */
  {16000,42, 14}, /* 16000 */
  {12000,42, 14}, /* 12000 */
  {11025,42, 14}, /* 11025 */
  {8000, 39, 14}  /*  8000 */
};

/* this table describes which parameter set is used for which bitrate */
const TNS_INFO_TAB tnsInfoTab[4] = {
  {  4000, 12000, &p_8000_mono_long,  &p_8000_mono_short,  &p_8000_stereo_long,  &p_8000_stereo_short},
  { 12001, 20000, &p_16000_mono_long, &p_16000_mono_short, &p_16000_stereo_long, &p_16000_stereo_short},
  { 20001, 28000, &p_24000_mono_long, &p_24000_mono_short, &p_24000_stereo_long, &p_24000_stereo_short},
  { 28001, 44001, &p_32000_mono_long, &p_32000_mono_short, &p_32000_stereo_long, &p_32000_stereo_short},
};

