/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn;

import com.nulabinc.zxcvbn.Feedback;
import com.nulabinc.zxcvbn.WipeableString;
import com.nulabinc.zxcvbn.guesses.DictionaryGuess;
import com.nulabinc.zxcvbn.matchers.Match;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class FeedbackFactory {
    private static final List<String> NAME_DICTIONARIES = Arrays.asList("surnames", "male_names", "female_names");

    private FeedbackFactory() {
        throw new IllegalStateException("FeedbackFactory should not be instantiated");
    }

    static Feedback getFeedbackWithoutWarnings(String ... suggestions) {
        return new Feedback(null, suggestions);
    }

    static Feedback getEmptyFeedback() {
        return new Feedback(null, new String[0]);
    }

    static Feedback createMatchFeedback(Match match, boolean isSoleMatch) {
        switch (match.pattern) {
            case Dictionary: {
                return FeedbackFactory.createDictionaryMatchFeedback(match, isSoleMatch);
            }
            case Spatial: {
                return FeedbackFactory.createSpatialMatchFeedback(match);
            }
            case Repeat: {
                return FeedbackFactory.createRepeatMatchFeedback(match);
            }
            case Sequence: {
                return FeedbackFactory.createSequenceMatchFeedback();
            }
            case Regex: {
                return FeedbackFactory.createRegexMatchFeedback(match);
            }
            case Date: {
                return FeedbackFactory.createDateMatchFeedback();
            }
        }
        return FeedbackFactory.getFeedbackWithoutWarnings("feedback.extra.suggestions.addAnotherWord");
    }

    private static Feedback createSpatialMatchFeedback(Match match) {
        String warning = match.turns == 1 ? "feedback.spatial.warning.straightRowsOfKeys" : "feedback.spatial.warning.shortKeyboardPatterns";
        return new Feedback(warning, "feedback.extra.suggestions.addAnotherWord", "feedback.spatial.suggestions.UseLongerKeyboardPattern");
    }

    private static Feedback createRepeatMatchFeedback(Match match) {
        String warning = match.baseToken.length() == 1 ? "feedback.repeat.warning.likeAAA" : "feedback.repeat.warning.likeABCABCABC";
        return new Feedback(warning, "feedback.extra.suggestions.addAnotherWord", "feedback.repeat.suggestions.avoidRepeatedWords");
    }

    private static Feedback createSequenceMatchFeedback() {
        return new Feedback("feedback.sequence.warning.likeABCor6543", "feedback.extra.suggestions.addAnotherWord", "feedback.sequence.suggestions.avoidSequences");
    }

    private static Feedback createRegexMatchFeedback(Match match) {
        String warning = "recent_year".equals(match.regexName) ? "feedback.regex.warning.recentYears" : null;
        return new Feedback(warning, "feedback.extra.suggestions.addAnotherWord", "feedback.regex.suggestions.avoidRecentYears");
    }

    private static Feedback createDateMatchFeedback() {
        return new Feedback("feedback.date.warning.dates", "feedback.extra.suggestions.addAnotherWord", "feedback.date.suggestions.avoidDates");
    }

    private static Feedback createDictionaryMatchFeedback(Match match, boolean isSoleMatch) {
        String warning = FeedbackFactory.getWarningBasedOnMatch(match, isSoleMatch);
        List<String> suggestions = FeedbackFactory.generateSuggestions(match);
        return new Feedback(warning, suggestions.toArray(new String[0]));
    }

    private static String getWarningBasedOnMatch(Match match, boolean isSoleMatch) {
        if ("passwords".equals(match.dictionaryName)) {
            return FeedbackFactory.getPasswordWarning(match, isSoleMatch);
        }
        if ("english_wikipedia".equals(match.dictionaryName) && isSoleMatch) {
            return "feedback.dictionary.warning.englishWikipedia.itself";
        }
        if (NAME_DICTIONARIES.contains(match.dictionaryName)) {
            return FeedbackFactory.getNameDictionaryWarning(isSoleMatch);
        }
        return null;
    }

    private static String getPasswordWarning(Match match, boolean isSoleMatch) {
        if (isSoleMatch && !match.l33t && !match.reversed) {
            if (match.rank <= 10) {
                return "feedback.dictionary.warning.passwords.top10";
            }
            if (match.rank <= 100) {
                return "feedback.dictionary.warning.passwords.top100";
            }
            return "feedback.dictionary.warning.passwords.veryCommon";
        }
        if (match.guessesLog10 <= 4.0) {
            return "feedback.dictionary.warning.passwords.similar";
        }
        return null;
    }

    private static String getNameDictionaryWarning(boolean isSoleMatch) {
        if (isSoleMatch) {
            return "feedback.dictionary.warning.etc.namesThemselves";
        }
        return "feedback.dictionary.warning.etc.namesCommon";
    }

    private static List<String> generateSuggestions(Match match) {
        ArrayList<String> suggestions = new ArrayList<String>();
        suggestions.add("feedback.extra.suggestions.addAnotherWord");
        CharSequence word = match.token;
        WipeableString lower = WipeableString.lowerCase(word);
        if (DictionaryGuess.START_UPPER.matcher(word).find()) {
            suggestions.add("feedback.dictionary.suggestions.capitalization");
        }
        if (DictionaryGuess.ALL_UPPER.matcher(word).find() && !lower.equals(word)) {
            suggestions.add("feedback.dictionary.suggestions.allUppercase");
        }
        if (match.reversed && match.tokenLength() >= 4) {
            suggestions.add("feedback.dictionary.suggestions.reversed");
        }
        if (match.l33t) {
            suggestions.add("feedback.dictionary.suggestions.l33t");
        }
        lower.wipe();
        return suggestions;
    }
}

