/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.algorithm;

import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.threadpool.ThreadPool;

public class ClusterTrainingExecutor {
    @Generated
    private static final Logger log = LogManager.getLogger(ClusterTrainingExecutor.class);
    private ThreadPool threadpool = null;
    private static ClusterTrainingExecutor INSTANCE;

    public void initialize(ThreadPool threadPool) {
        this.threadpool = threadPool;
    }

    public static ClusterTrainingExecutor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClusterTrainingExecutor();
        }
        return INSTANCE;
    }

    public Executor getExecutor() {
        return this.threadpool.executor("seismic_thread_pool");
    }

    public void run(Runnable runnable) {
        this.threadpool.executor("seismic_thread_pool").execute(runnable);
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return this.threadpool.executor("seismic_thread_pool").submit(callable);
    }

    public static void updateThreadPoolSize(Integer availableProcessors, Integer userSettingNumber) {
        int newThreadQty = userSettingNumber <= availableProcessors ? userSettingNumber : availableProcessors;
        if (userSettingNumber > availableProcessors) {
            log.warn("User specified thread count ({}) exceeds available processors ({}). Limiting to available processor count.", (Object)userSettingNumber, (Object)availableProcessors);
        }
        Settings threadPoolSettings = Settings.builder().put(String.format(Locale.ROOT, "%s.size", "seismic_thread_pool"), newThreadQty).build();
        ClusterTrainingExecutor.INSTANCE.threadpool.setThreadPool(threadPoolSettings);
    }
}

