/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Map;
import oracle.ucp.ShardConnectionStatistics;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.common.UniversalConnectionPoolBase;

public class UniversalConnectionPoolStatisticsImpl
implements UniversalConnectionPoolStatistics {
    private final UniversalConnectionPoolBase connectionPool;

    protected UniversalConnectionPoolStatisticsImpl(UniversalConnectionPoolBase connectionPool) {
        assert (connectionPool != null);
        this.connectionPool = connectionPool;
    }

    @Override
    public int getTotalConnectionsCount() {
        return this.connectionPool.getTotalConnectionsCount();
    }

    @Override
    public int getAvailableConnectionsCount() {
        return this.connectionPool.getAvailableConnectionsCount();
    }

    @Override
    public int getBorrowedConnectionsCount() {
        return this.connectionPool.getBorrowedConnectionsCount();
    }

    @Override
    public int getAverageBorrowedConnectionsCount() {
        return this.connectionPool.getAverageBorrowedConnectionsCount();
    }

    @Override
    public int getPeakConnectionsCount() {
        return this.connectionPool.getPeakConnectionsCount();
    }

    @Override
    public int getPeakBorrowedConnectionsCount() {
        return this.connectionPool.getPeakBorrowedConnectionsCount();
    }

    @Override
    public int getRemainingPoolCapacityCount() {
        int count = this.connectionPool.getMaxPoolSize() - this.connectionPool.getTotalConnectionsCount();
        return count > 0 ? count : 0;
    }

    @Override
    public int getLabeledConnectionsCount() {
        return this.connectionPool.getLabeledConnectionsCount();
    }

    @Override
    public int getConnectionsCreatedCount() {
        return this.connectionPool.getConnectionsCreatedCount();
    }

    @Override
    public int getConnectionsClosedCount() {
        return this.connectionPool.getConnectionsClosedCount();
    }

    @Override
    public long getAverageConnectionWaitTime() {
        long averageConnectionWaitTime = 0L;
        long totalCount = this.connectionPool.getCumulativeSuccessfulConnectionWaitCount() + this.connectionPool.getCumulativeFailedConnectionWaitCount();
        if (totalCount > 0L) {
            long totalTime = this.connectionPool.getCumulativeSuccessfulConnectionWaitTime() + this.connectionPool.getCumulativeFailedConnectionWaitTime();
            averageConnectionWaitTime = Math.round(totalTime / totalCount);
        }
        return averageConnectionWaitTime;
    }

    @Override
    public long getPeakConnectionWaitTime() {
        return this.connectionPool.getPeakConnectionWaitTime();
    }

    @Override
    public int getAbandonedConnectionsCount() {
        return this.connectionPool.getAbandonedConnectionsCount();
    }

    @Override
    public int getPendingRequestsCount() {
        return this.connectionPool.getPendingRequestsCount();
    }

    @Override
    public long getCumulativeConnectionWaitTime() {
        return this.connectionPool.getCumulativeSuccessfulConnectionWaitTime() + this.connectionPool.getCumulativeFailedConnectionWaitTime();
    }

    @Override
    public long getCumulativeConnectionBorrowedCount() {
        return this.connectionPool.getCumulativeConnectionBorrowedCount();
    }

    @Override
    public long getCumulativeConnectionUseTime() {
        return this.connectionPool.getCumulativeConnectionUseTime();
    }

    @Override
    public long getCumulativeConnectionReturnedCount() {
        return this.connectionPool.getCumulativeConnectionReturnedCount();
    }

    @Override
    public long getCumulativeSuccessfulConnectionWaitTime() {
        return this.connectionPool.getCumulativeSuccessfulConnectionWaitTime();
    }

    @Override
    public long getCumulativeSuccessfulConnectionWaitCount() {
        return this.connectionPool.getCumulativeSuccessfulConnectionWaitCount();
    }

    @Override
    public long getCumulativeFailedConnectionWaitTime() {
        return this.connectionPool.getCumulativeFailedConnectionWaitTime();
    }

    @Override
    public long getCumulativeFailedConnectionWaitCount() {
        return this.connectionPool.getCumulativeFailedConnectionWaitCount();
    }

    @Override
    public long getCumulativeConnectionCreationAttemts() {
        return this.connectionPool.getCumulativeConnectionCreationAttempts();
    }

    @Override
    public long getConnectionCreationAttemptsSinceLastOutage() {
        return this.connectionPool.getConnectionCreationAttemptsSinceLastOutage();
    }

    @Override
    public Map<String, ShardConnectionStatistics> getShardConnectionStats() {
        return this.connectionPool.getShardConnectionStats();
    }

    public String toString() {
        return "[AvailableConnectionsCount=" + this.getAvailableConnectionsCount() + ", BorrowedConnectionsCount=" + this.getBorrowedConnectionsCount() + ", TotalConnectionsCount=" + this.getTotalConnectionsCount() + ", ConnectionsCreatedCount=" + this.getConnectionsCreatedCount() + ", ConnectionsClosedCount=" + this.getConnectionsClosedCount() + ", AbandonedConnectionsCount=" + this.getAbandonedConnectionsCount() + ", LabeledConnectionsCount=" + this.getLabeledConnectionsCount() + ", PendingRequestsCount=" + this.getPendingRequestsCount() + ", RemainingPoolCapacityCount=" + this.getRemainingPoolCapacityCount() + ", PeakConnectionsCount=" + this.getPeakConnectionsCount() + ", PeakConnectionWaitTime=" + this.getPeakConnectionWaitTime() + ", AverageBorrowedConnectionsCount=" + this.getAverageBorrowedConnectionsCount() + ", AverageConnectionWaitTime=" + this.getAverageConnectionWaitTime() + ", CumulativeConnectionBorrowedCount=" + this.getCumulativeConnectionBorrowedCount() + ", CumulativeConnectionReturnedCount=" + this.getCumulativeConnectionReturnedCount() + ", CumulativeConnectionUseTime=" + this.getCumulativeConnectionUseTime() + ", CumulativeConnectionWaitTime=" + this.getCumulativeConnectionWaitTime() + ", CumulativeSuccessfulConnectionWaitCount=" + this.getCumulativeSuccessfulConnectionWaitCount() + ", CumulativeSuccessfulConnectionWaitTime=" + this.getCumulativeSuccessfulConnectionWaitTime() + ", CumulativeFailedConnectionWaitCount=" + this.getCumulativeFailedConnectionWaitCount() + ", CumulativeFailedConnectionWaitTime=" + this.getCumulativeFailedConnectionWaitTime() + ", CumulativeConnectionCreationAttemts=" + this.getCumulativeConnectionCreationAttemts() + ", ConnectionCreationAttemptsSinceLastOutage=" + this.getConnectionCreationAttemptsSinceLastOutage() + ", ShardConnectionStats=" + this.getShardConnectionStats() + "]";
    }
}

