/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.OptionalDontShowMeAgainDialog;
import org.freeplane.core.util.TextUtils;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptingSecurityManager;

public class ScriptingPermissions {
    final Map<String, Boolean> permissions = new HashMap<String, Boolean>();
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_ASKING = "execute_scripts_without_asking";
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_READ_RESTRICTION = "execute_scripts_without_file_restriction";
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_WRITE_RESTRICTION = "execute_scripts_without_write_restriction";
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_EXEC_RESTRICTION = "execute_scripts_without_exec_restriction";
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_NETWORK_RESTRICTION = "execute_scripts_without_network_restriction";
    public static final String RESOURCES_SIGNED_SCRIPT_ARE_TRUSTED = "signed_script_are_trusted";
    public static final String RESOURCES_SCRIPT_USER_KEY_NAME_FOR_SIGNING = "script_user_key_name_for_signing";
    public static final String[] PERMISSION_NAMES = new String[]{"execute_scripts_without_asking", "execute_scripts_without_file_restriction", "execute_scripts_without_write_restriction", "execute_scripts_without_exec_restriction", "execute_scripts_without_network_restriction", "signed_script_are_trusted"};
    private static ScriptingPermissions formulaPermissions;
    private static ScriptingPermissions permissiveScriptingPermissions;

    public ScriptingPermissions() {
        for (String permissionName : PERMISSION_NAMES) {
            this.set(permissionName, false);
        }
    }

    public ScriptingPermissions(Properties properties) {
        this();
        for (String permissionName : PERMISSION_NAMES) {
            String valueString;
            Object value = properties.get(permissionName);
            if (value == null || "".equals(valueString = value.toString())) continue;
            this.set(permissionName, Boolean.parseBoolean(valueString));
        }
    }

    public ScriptingPermissions(Map<String, Boolean> permissions) {
        this();
        this.permissions.putAll(permissions);
    }

    public boolean get(String permissionName) {
        Boolean savedValue = this.permissions.get(permissionName);
        return savedValue != null && savedValue != false;
    }

    private void set(String permissionName, boolean value) {
        this.permissions.put(permissionName, value);
    }

    ScriptingSecurityManager getScriptingSecurityManager() {
        boolean readPerm = this.get(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_READ_RESTRICTION);
        boolean writePerm = this.get(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_WRITE_RESTRICTION);
        boolean networkPerm = this.get(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_NETWORK_RESTRICTION);
        boolean execPerm = this.get(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_EXEC_RESTRICTION);
        return new ScriptingSecurityManager(readPerm, writePerm, networkPerm, execPerm);
    }

    public static ScriptingPermissions getFormulaPermissions() {
        if (formulaPermissions == null) {
            formulaPermissions = new ScriptingPermissions();
            formulaPermissions.set(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_ASKING, true);
            if (ScriptResources.getClasspath() != null) {
                formulaPermissions.set(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_READ_RESTRICTION, ResourceController.getResourceController().getBooleanProperty(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_READ_RESTRICTION));
            }
        }
        return formulaPermissions;
    }

    ScriptingSecurityManager getPermissiveScriptingSecurityManager() {
        return new ScriptingSecurityManager(true, true, true, true);
    }

    public static ScriptingPermissions getPermissiveScriptingPermissions() {
        if (permissiveScriptingPermissions == null) {
            permissiveScriptingPermissions = new ScriptingPermissions();
            permissiveScriptingPermissions.set(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_ASKING, true);
            permissiveScriptingPermissions.set(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_READ_RESTRICTION, true);
            permissiveScriptingPermissions.set(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_WRITE_RESTRICTION, true);
            permissiveScriptingPermissions.set(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_NETWORK_RESTRICTION, true);
            permissiveScriptingPermissions.set(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_EXEC_RESTRICTION, true);
        }
        return permissiveScriptingPermissions;
    }

    boolean isExecuteSignedScriptsWithoutRestriction() {
        return this.get(RESOURCES_SIGNED_SCRIPT_ARE_TRUSTED);
    }

    private boolean executeScriptsWithoutAsking() {
        return this.get(RESOURCES_EXECUTE_SCRIPTS_WITHOUT_ASKING);
    }

    public static List<String> getPermissionNames() {
        return Arrays.asList(PERMISSION_NAMES);
    }

    public void assertScriptExecutionAllowed() {
        int showResult;
        if (!this.executeScriptsWithoutAsking() && (showResult = OptionalDontShowMeAgainDialog.show((String)"really_execute_script", (String)RESOURCES_EXECUTE_SCRIPTS_WITHOUT_ASKING, (OptionalDontShowMeAgainDialog.MessageType)OptionalDontShowMeAgainDialog.MessageType.BOTH_OK_AND_CANCEL_OPTIONS_ARE_STORED)) != 0) {
            throw new ExecuteScriptException(new SecurityException(TextUtils.getText((String)"script_execution_disabled")));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.permissions == null ? 0 : this.permissions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptingPermissions other = (ScriptingPermissions)obj;
        return !(this.permissions == null ? other.permissions != null : !this.permissions.equals(other.permissions));
    }
}

