/*
Copyright (C) 2011-2013 Yubico AB.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef COMMON_H
#define COMMON_H

#include <QtGui>

#include "otpdef.h"

typedef std::vector<int>::size_type size_t;

enum AccMode {
  Acc_None,
  Acc_Serial,
  Acc_Random,
};

#define MAX_SIZE                    256

#define SCHEME_INCR_ID_RAND_SECRET  0
#define SCHEME_RAND_SECRET          0
#define SCHEME_RAND_ALL             1
#define SCHEME_ID_FROM_SERIAL_RAND_SECRET 2
#define SCHEME_FIXED                2

#define GEN_SCHEME_FIXED            0
#define GEN_SCHEME_INCR             1
#define GEN_SCHEME_RAND             2
#define GEN_SCHEME_SERIAL           3

#define WRITE_CONFIG                0
#define EXPORT_CONFIG               1

#define SUPPORT_EMAIL               tr("mailto:support@yubico.com")
#define UPLOAD_URL                  tr("<!doctype html><html><title>upload</title></head><body><form action='https://upload.yubico.com/' method='post' id='upload'>serial:<input name='serial' value='%1'/><br/>prefix:<input name='prefix' value='%2'/><br/>uid:<input name='uid' value='%3'/><br/>aeskey:<input name='aeskey' value='%4'/><br/><input type='submit'/><br/></form><script type='text/javascript'>window.onload=function(){document.getElementById('upload').submit();}</script></body></html>")

#define ERR_NOERROR                 0
#define ERR_OTHER                   1
#define ERR_NOKEY                   2
#define ERR_MORETHANONE             3
#define ERR_UNKNOWN_FIRMWARE        4

//Timeouts

#define TIMEOUT_STATUS              10000
#define TIMEOUT_FINDER              1000


//Stylesheets

#define SS_MENU_CHECKED             "color:rgb(0,0,0);border:2px groove rgb(255,255,255);"
#define SS_MENU_UNCHECKED           "color:rgb(122,171,32);border:2px groove rgb(255,255,255);"
#define SS_MENU_DISABLED            "color:rgb(118,116,108);border:2px groove rgb(255,255,255);"

#define SS_STATUS_SUCCESS           "font:12px \"Verdana\";color:green;"
#define SS_STATUS_ERROR             "font:12px \"Verdana\";color:rgb(221,97,99);"

#define SS_YKSTATUS_SUCCESS         "font:11px \"Verdana\";font-weight:bold;color:rgb(122,171,32);"
#define SS_YKSTATUS_ERROR           "font:11px \"Verdana\";font-weight:bold;color:rgb(221, 97, 99);"

#define SS_COPY_BTN                 "background-image: url(:/res/images/clipboard.png); border-radius: 2px;"
#define SS_BLANK_BTN                "background-image: url(:/res/images/blank.png); border-radius: 2px;"

#define SS_LINK_ENABLED             "font: 12px \"Verdana\"; text-decoration: underline; text-align: left; color: rgb(5, 67, 168);"
#define SS_LINK_DISABLED            "font: 12px \"Verdana\"; text-decoration: underline; text-align: left; color: rgb(118,116,108);"


//Messages

#define SUCCESS                     tr("Success")
#define ERR                         tr("Error")
#define NA                          tr("N/A")
#define TOVERFLOW                   tr("Overflow")

#define KEY_FOUND                   tr("YubiKey is inserted")
#define NO_KEY_FOUND                tr("No YubiKey inserted")
#define MORE_THAN_ONE               tr("More than one\nYubiKey inserted")
#define OTHER_ERROR                 tr("Unknown error occurred")
#define UNKNOWN_FIRMWARE            tr("Unknown firmware")

#define KEY_CONFIGURED              tr("YubiKey%1 has been successfully configured")
#define KEY_EXPORTED                tr("YubiKey configuration has been successfully exported")
#define REMOVE_KEY                  tr("Please remove this YubiKey")
#define SETTINGS_SAVED              tr("Settings have been successfully saved")
#define SETTINGS_RESTORED           tr("Default settings have been restored")
#define VALUE_COPIED                tr("Value copied to clipboard")

#define ERR_KEY_NOT_FOUND           tr("YubiKey not found. Please insert YubiKey in USB port")
#define ERR_FEATURE_NOT_SUPPORTED   tr("Selected configuration is not supported by the YubiKey being programmed")
#define ERR_FIRMWARE_NOT_SUPPORTED  tr("This YubiKey firmware version is not supported")
#define ERR_PROCESSING              tr("YubiKey could not be configured. Perhaps protected with configuration protection access code?")
#define ERR_PROCESSING_CHALRESP     tr("Challenge response could not be performed. Perhaps the YubiKey is not configured for challenge-response?")
#define ERR_CONF_SLOT_NOT_SELECTED  tr("No configuration slot selected. Please select the configuration slot to be programmed")
#define ERR_CHAL_TYPE_NOT_SELECTED  tr("No Challenge-Response Type selected. Please select the one to use")

//Warnings

#define OVERWRITE_CONF_SLOT1        tr("Overwrite configuration slot 1?")
#define WARN_OVERWRITE_CONF_SLOT1   tr("By re-programming Slot 1 of your YubiKey, you will lose ALL abilities to authenticate against Yubico online severs, forum, Wiki, etc. (unless you upload your new configuration to Yubico server)\n\nAre you sure you want to overwrite the configuration slot 1?")

#define RESTORE_SETTING             tr("Restore default settings?")
#define WARN_RESTORE_SETTING        tr("Are you sure you want to restore the default settings?")

#define WARN_EMPTY_PASS             tr("No password set. Please set the password")

#define DIFF_PUBLIC_ID_LEN          tr("Change Public Identity length?")
#define WARN_DIFF_PUBLIC_ID_LEN     tr("Yubico OTP validation server requires Public Identity to be of 12 characters (6 bytes) in order to correctly extract the Secret Key. If you change the Public Identity to any other length, the Yubico OTP validation server won't be able to extract the Secret Key and the OTP validation will fail.\n\nAre you sure you want to change the default Public Idenity length?")

#define ENABLE_CONF_PROTECTION      tr("Enable configuration protection?")
#define WARN_ENABLE_CONF_PROTECTION tr("YubiKey Personalization Tool logging is currently disabled. It is not possible to retrieve the configuration protection access code from the YubiKey. If protection access code is forgotten, you may not be able to program the YubiKey again. Yubico highly recommends to enable logging and archive the relevant log records. \n\nAre you sure you still want to enable the configuration protection?")

#define NDEF_WITHOUT_HTTP           tr("Write NDEF without HTTP?")
#define WARN_NDEF_WITHOUT_HTTP      tr("The NDEF URI entered does not start with http, are you sure that is what you want?")

//Settings

#define SG_CUSTOMER_PREFIX_USED     "Customer/Used"
#define SG_CUSTOMER_PREFIX          "Customer/Prefix"

#define SG_LOG_DISABLED             "Log/Disabled"
#define SG_LOG_FILENAME             "Log/Filename"
#define SG_LOG_FORMAT               "Log/Format"
#define SG_LOG_FLEXIBLE             "Log/Flexible"

#define SG_EXPORT_FILENAME          "Export/Filename"
#define SG_IMPORT_FILENAME          "Import/Filename"

#define SG_TAB_FIRST                "Flag/TabTirst"
#define SG_APPEND_TAB1              "Flag/AppendTab1"
#define SG_APPEND_TAB2              "Flag/AppendTab2"
#define SG_APPEND_CR                "Flag/AppendCr"
#define SG_APPEND_DELAY1            "Flag/AppendDelay1"
#define SG_APPEND_DELAY2            "Flag/AppendDelay2"

#define SG_SR_BTN_VISIBLE           "Flag/SerialBtnVisible"
#define SG_SR_USB_VISIBLE           "Flag/serialUsbVisible"
#define SG_SR_API_VISIBLE           "Flag/serialApiVisible"

#define SG_PACING_10MS              "Flag/Pacing10ms"
#define SG_PACING_20MS              "Flag/Pacing20ms"

#define SG_MAN_UPDATE               "Flag/ManUpdate"

#define SG_ALLOW_UPDATE             "Flag/AllowUpdate"
#define SG_FAST_TRIG                "Flag/FastTrig"
#define SG_USE_NUMERIC_KEYPAD       "Flag/UseNumericKeypad"
#define SG_LED_INVERT               "Flag/LedInvert"

#define SG_OATH_HOTP8               "Flag/OathHotp8"
#define SG_REQUIRE_INPUT            "Flag/RequireInput"
#define SG_HMAC_LT64                "Flag/HmacLt64"

#define SG_STRONG_PW1               "Flag/StrongPw1"
#define SG_STRONG_PW2               "Flag/StrongPw2"
#define SG_STRONG_PW3               "Flag/StrongPw3"

#define SG_OVERWRITE_CONF_SLOT1     "DontAsk/Slot1Overwriting"
#define SG_DIFF_PUBLIC_ID_LEN       "DontAsk/PublicIdLen"
#define SG_ENABLE_CONF_PROTECTION   "DontAsk/ConfProtection"
#define SG_NDEF_WITHOUT_HTTP        "DontAsk/NdefWithoutHttp"

#define SG_ANIMATIONS_PREFERENCE    "Preference/Animations"
#define SG_EXPORT_PREFERENCE        "Preference/Export"

#endif // COMMON_H
