use ui;
use layout;
use core:info;
use core:geometry;

dialog LicenseDialog {
	layout Grid {
		expandCol: 1;
		expandRow: 3;

		Label b("Author:") {}
		Label author("") {}
		nextLine;

		Label a("Package:") {}
		Label pkg("") {}
		nextLine;

		Label c("License:") {}
		Label title("") {}
		nextLine;

		ScrollWindow scroll(Label(""), Size(100, 200)) { col: 0; colspan: 2; }
	}

	init(License license) {
		init("About ${license.name}") {}

		pkg.text = license.identifier();
		author.text = license.author();
		title.text = license.title();

		if (l = scroll.content as Label) {
			l.text = license.body();
		}
	}
}
