class PauseProducer(object):
	paused = False

	def pauseProducing(self):
		self.paused = True
		self.transport.pauseProducing()

	def resumeProducing(self):
		self.paused = False
		self.transport.resumeProducing()
		self.dataReceived('')

	def stopProducing(self):
		self.paused = True
		self.transport.stopProducing()

from twisted.protocols import basic
import struct
class Int32StringReceiver(basic.Int32StringReceiver, PauseProducer):
	def dataReceived(self, recd):
		self.recvd = self.recvd + recd
		while len(self.recvd) > 3 and not self.paused and not self.transport.disconnecting:
			length ,= struct.unpack("!i",self.recvd[:4])
			if length > self.MAX_LENGTH:
				self.transport.loseConnection()
				return
			if len(self.recvd) < length+4:
				break
			packet = self.recvd[4:length+4]
			self.recvd = self.recvd[length+4:]
			self.stringReceived(packet)

from twisted.internet import protocol, error, defer
class ReconnectingClientFactory(protocol.ReconnectingClientFactory):
	def clientConnectionFailed(self, connector, reason):
		if self.continueTrying:
			self.connector = connector
			self.retry()
