/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.serializers.compact;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.MaltegoGraphSnippet;
import com.paterva.maltego.serializers.compact.stubs.EntityStub;
import com.paterva.maltego.serializers.compact.stubs.LinkStub;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeserializedGraph {
    private final MaltegoGraphSnippet _graphSnippet = new MaltegoGraphSnippet();
    private final Map<EntityStub, MaltegoEntity> _entityMap = new HashMap<EntityStub, MaltegoEntity>();
    private final Map<LinkStub, MaltegoLink> _linkMap = new HashMap<LinkStub, MaltegoLink>();

    public MaltegoGraphSnippet getGraphSnippet() {
        return this._graphSnippet;
    }

    public void add(EntityStub stub, MaltegoEntity entity) {
        this._entityMap.put(stub, entity);
    }

    public void add(LinkStub stub, MaltegoLink link) {
        this._linkMap.put(stub, link);
    }

    public Map<EntityStub, MaltegoEntity> getEntityMap() {
        return Collections.unmodifiableMap(this._entityMap);
    }

    public Map<LinkStub, MaltegoLink> getLinkMap() {
        return Collections.unmodifiableMap(this._linkMap);
    }

    public Collection<MaltegoEntity> getEntities() {
        return this._graphSnippet.getEntities();
    }

    public Map<String, Map<EntityID, Point>> getCenters() {
        return this._graphSnippet.getCenters();
    }

    public Map<LinkID, LinkEntityIDs> getConnections() {
        return this._graphSnippet.getConnections();
    }

    public Collection<MaltegoLink> getLinks() {
        return this._graphSnippet.getLinks();
    }

    public Map<String, Map<LinkID, List<Point>>> getPaths() {
        return this._graphSnippet.getPaths();
    }
}

