/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.imex;

import com.paterva.maltego.automation.imex.MachineExistInfo;
import com.paterva.maltego.automation.imex.SelectableMachine;
import com.paterva.maltego.importexport.ConfigNode;
import java.awt.Image;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class MachineNode
extends ConfigNode {
    private boolean _isCheckEnabled = true;

    public MachineNode(SelectableMachine machine, MachineExistInfo existInfo) {
        this(machine, new InstanceContent(), existInfo);
    }

    private MachineNode(SelectableMachine machine, InstanceContent content, MachineExistInfo existInfo) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.addLookups(content, machine);
        String displayName = machine.getMachine().getDisplayName();
        if (existInfo != null && existInfo.exist(machine.getMachine())) {
            if (existInfo.isReadOnly(machine.getMachine())) {
                displayName = "<read-only> " + displayName;
                this._isCheckEnabled = false;
            } else {
                displayName = "<exist> " + displayName;
            }
        }
        this.setDisplayName(displayName);
        this.setShortDescription(machine.getMachine().getDescription());
        this.setSelectedNonRecursive(machine.isSelected());
    }

    public boolean isCheckEnabled() {
        return this._isCheckEnabled;
    }

    private void addLookups(InstanceContent content, SelectableMachine machine) {
        content.add((Object)machine);
        content.add((Object)this);
    }

    public final void setSelectedNonRecursive(Boolean selected) {
        if (!this.isSelected().equals(selected)) {
            super.setSelectedNonRecursive(selected);
            SelectableMachine machine = (SelectableMachine)this.getLookup().lookup(SelectableMachine.class);
            machine.setSelected(selected);
        }
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/Robot.png", (boolean)true);
    }
}

