/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions.userfilter;

import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.actions.userfilter.EntityChildFactory;
import com.paterva.maltego.automation.actions.userfilter.EntityNode;
import com.paterva.maltego.automation.actions.userfilter.UserFilterControl;
import com.paterva.maltego.automation.actions.userfilter.UserFilterDescriptor;
import com.paterva.maltego.automation.actions.userfilter.UserFilterManager;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.util.ui.dialog.FloatingWindowDescriptor;
import com.paterva.maltego.util.ui.dialog.FloatingWindowDisplayer;
import com.paterva.maltego.util.ui.dialog.WindowHandle;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import org.openide.explorer.view.CheckableNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DialogUserFilterManager
extends UserFilterManager
implements PropertyChangeListener {
    private WindowHandle _currentWindow;
    private EntityListUpdater _graphListener;
    private Map<AutomationContext, WindowHandle> _windows;
    private boolean _pclAttached = false;
    private Map<AutomationContext, Boolean> _freeze;

    @Override
    protected WindowHandle showOne(final UserFilterDescriptor descriptor, final UserFilterManager.UserFilterCallback cb) {
        final UserFilterControl filter = new UserFilterControl(descriptor.getHeading(), descriptor.showIncomingLinks(), descriptor.showOutgoingLinks(), descriptor.showGeneratedBy());
        FloatingWindowDescriptor windowDescriptor = new FloatingWindowDescriptor((Object)filter, descriptor.getWindowTitle());
        windowDescriptor.setCloseButtonVisible(false);
        windowDescriptor.setModal(false);
        windowDescriptor.setHeaderVisibile(true);
        windowDescriptor.setPosition(2);
        windowDescriptor.setPositionRelativeTo(1);
        final WindowHandle window = FloatingWindowDisplayer.getDefault().create(windowDescriptor);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogUserFilterManager.this.closeWindow(descriptor.getContext(), window);
                ArrayList<MaltegoEntity> selected = new ArrayList<MaltegoEntity>();
                ArrayList<MaltegoEntity> toDelete = new ArrayList<MaltegoEntity>();
                DialogUserFilterManager.getEntities(filter, selected, toDelete);
                cb.onResume(selected, toDelete);
            }
        };
        filter.setHeading(descriptor.getTitle());
        filter.setDescription(descriptor.getDescription());
        filter.setButtonText(descriptor.getButtonText());
        filter.setIcon(descriptor.getIcon());
        filter.setRemovePromptText(descriptor.getRemovePromptText());
        filter.setRemovePromptChecked(descriptor.getRemovePromptState());
        filter.setActionListener(listener);
        GraphID graphID = descriptor.getContext().getTargetGraphID();
        Set ids = GraphStoreHelper.getIds(descriptor.getPayload().getEntities());
        EntityChildFactory childFactory = new EntityChildFactory(graphID, ids);
        AbstractNode root = new AbstractNode(Children.create((ChildFactory)childFactory, (boolean)false));
        filter.getExplorerManager().setRootContext((Node)root);
        filter.setSelectionState(descriptor.getDefaultSelectionState());
        this.attachGraphListeners(graphID, childFactory);
        JLabel label = new JLabel();
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int width = fm.stringWidth(filter.getButtonText()) + fm.stringWidth(filter.getRemovePromptText()) + 140;
        Dimension fallback = new Dimension(350, 350);
        if (width > fallback.width) {
            fallback.width = width;
        }
        window.setSize(fallback);
        this.setPosition(window);
        this.addWindow(descriptor.getContext(), window);
        this.ensurePclAttached();
        this.checkWindowVisible();
        return window;
    }

    private void closeWindow(AutomationContext ctx, WindowHandle window) {
        this.removeWindow(ctx);
        this.checkDetachPcl();
        this.detachGraphListeners(ctx.getTargetGraphID());
        window.setVisible(false);
        if (window == this._currentWindow) {
            this._currentWindow = null;
        }
    }

    @Override
    protected boolean closeOne(WindowHandle handle) {
        WindowHandle window = handle;
        boolean visible = window.isVisible();
        AutomationContext ctx = this.findTarget(window);
        if (ctx != null) {
            this.closeWindow(ctx, window);
        }
        return visible;
    }

    private void addWindow(AutomationContext ctx, WindowHandle window) {
        if (this._windows == null) {
            this._windows = new HashMap<AutomationContext, WindowHandle>();
        }
        this._windows.put(ctx, window);
        this.freezeGraph(ctx);
    }

    private void removeWindow(AutomationContext ctx) {
        if (this._windows != null) {
            this._windows.remove(ctx);
        }
        this.restoreFreeze(ctx);
    }

    private WindowHandle getWindow(DataObject target) {
        if (this._windows != null) {
            for (Map.Entry<AutomationContext, WindowHandle> entry : this._windows.entrySet()) {
                if (!entry.getKey().getTarget().equals(target)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private boolean windowListEmpty() {
        if (this._windows == null) {
            return true;
        }
        return this._windows.isEmpty();
    }

    private void setPosition(WindowHandle window) {
        Mode editor = WindowManager.getDefault().findMode("editor");
        TopComponent tc = editor.getSelectedTopComponent();
        Point point = tc.getLocationOnScreen();
        int x = point.x + tc.getWidth() - window.getWidth();
        int y = point.y + tc.getHeight() - window.getHeight();
        if (x < point.x) {
            x = point.x;
        }
        if (y < point.y) {
            y = point.y;
        }
        window.setLocation(x, y);
    }

    private static void getEntities(UserFilterControl window, Collection<MaltegoEntity> selected, Collection<MaltegoEntity> deleted) {
        boolean deleteUnselected = window.deleteUnselected();
        Enumeration nodes = window.getExplorerManager().getRootContext().getChildren().nodes();
        while (nodes.hasMoreElements()) {
            Node node = (Node)nodes.nextElement();
            CheckableNode checkable = (CheckableNode)node.getLookup().lookup(CheckableNode.class);
            if (!(node instanceof EntityNode)) continue;
            EntityNode entityNode = (EntityNode)node;
            MaltegoEntity entity = entityNode.getEntity();
            if (checkable != null && checkable.isSelected().booleanValue()) {
                selected.add(entity);
                continue;
            }
            if (!deleteUnselected) continue;
            deleted.add(entity);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.checkWindowVisible();
    }

    private void checkWindowVisible() {
        DataObject target = this.getCurrentTarget();
        if (target != null) {
            this.setVisibleWindow(this.getWindow(target));
        } else {
            this.setVisibleWindow(null);
        }
    }

    private DataObject getCurrentTarget() {
        TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
        if (topmost != null) {
            return (DataObject)topmost.getLookup().lookup(DataObject.class);
        }
        return null;
    }

    private void attachGraphListeners(GraphID graphID, EntityChildFactory childFactory) {
        try {
            this._graphListener = new EntityListUpdater(childFactory);
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureStore structureStore = graphStore.getGraphStructureStore();
            structureStore.addPropertyChangeListener((PropertyChangeListener)this._graphListener);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void detachGraphListeners(GraphID graphID) {
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureStore structureStore = graphStore.getGraphStructureStore();
            structureStore.removePropertyChangeListener((PropertyChangeListener)this._graphListener);
            this._graphListener = null;
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void ensurePclAttached() {
        if (!this._pclAttached) {
            this._pclAttached = true;
            GraphEditorRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void checkDetachPcl() {
        if (this._pclAttached && this.windowListEmpty()) {
            GraphEditorRegistry.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            this._pclAttached = false;
        }
    }

    private void setVisibleWindow(WindowHandle window) {
        if (this._currentWindow != window) {
            if (this._currentWindow != null) {
                this._currentWindow.setVisible(false);
            }
            this._currentWindow = window;
            if (this._currentWindow != null) {
                this._currentWindow.setVisible(true);
            }
        }
    }

    private AutomationContext findTarget(WindowHandle window) {
        if (this._windows != null) {
            for (Map.Entry<AutomationContext, WindowHandle> entry : this._windows.entrySet()) {
                if (entry.getValue() != window) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private void freezeGraph(AutomationContext ctx) {
        GraphView graphView = this.getActiveGraphView(ctx);
        if (graphView != null) {
            if (this._freeze == null) {
                this._freeze = new HashMap<AutomationContext, Boolean>();
            }
            this._freeze.put(ctx, graphView.isFrozen());
            graphView.setFrozen(true);
        }
    }

    private void restoreFreeze(AutomationContext ctx) {
        Boolean freeze;
        GraphView graphView = this.getActiveGraphView(ctx);
        if (graphView != null && (freeze = this._freeze.get(ctx)) != null) {
            graphView.setFrozen(freeze.booleanValue());
            this._freeze.remove(ctx);
        }
    }

    private GraphView getActiveGraphView(AutomationContext ctx) {
        GraphViewCookie cookie;
        TopComponent topComponent = ctx.getTopComponent();
        if (topComponent != null && (cookie = (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class)) != null) {
            return cookie.getGraphView();
        }
        return null;
    }

    private static class EntityListUpdater
    implements PropertyChangeListener {
        private final EntityChildFactory _childFactory;

        public EntityListUpdater(EntityChildFactory childFactory) {
            this._childFactory = childFactory;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GraphStructureMods mods;
            if ("structureModified".equals(evt.getPropertyName()) && !(mods = (GraphStructureMods)evt.getNewValue()).getEntitiesRemoved().isEmpty()) {
                this._childFactory.refresh();
            }
        }
    }
}

