/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.lib2.highlighting.CoveringHighlightsSequence;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ReleasableHighlightsContainer;
import org.netbeans.spi.editor.highlighting.SplitOffsetHighlightsSequence;
import org.openide.util.WeakListeners;

public final class DirectMergeContainer
implements HighlightsContainer,
HighlightsChangeListener,
ReleasableHighlightsContainer {
    private static final Logger LOG = Logger.getLogger(DirectMergeContainer.class.getName());
    static final int MAX_EMPTY_HIGHLIGHT_COUNT = 10000;
    private final HighlightsContainer[] layers;
    private final boolean covering;
    private final List<HighlightsChangeListener> listeners = new CopyOnWriteArrayList<HighlightsChangeListener>();
    private final List<Reference<HlSequence>> activeHlSeqs = new ArrayList<Reference<HlSequence>>();
    private HighlightsChangeEvent layerEvent;

    public DirectMergeContainer(HighlightsContainer[] layers, boolean covering) {
        this.layers = layers;
        this.covering = covering;
        for (int i = 0; i < layers.length; ++i) {
            HighlightsContainer layer = layers[i];
            layer.addHighlightsChangeListener((HighlightsChangeListener)WeakListeners.create(HighlightsChangeListener.class, (EventListener)this, (Object)layer));
        }
    }

    public HighlightsContainer[] getLayers() {
        return this.layers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        HlSequence hs = new HlSequence(this.layers, startOffset, endOffset, this.covering);
        List<Reference<HlSequence>> list = this.activeHlSeqs;
        synchronized (list) {
            this.activeHlSeqs.add(new WeakReference<HlSequence>(hs));
        }
        return hs;
    }

    @Override
    public void addHighlightsChangeListener(HighlightsChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeHighlightsChangeListener(HighlightsChangeListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void highlightChanged(HighlightsChangeEvent event) {
        this.layerEvent = event;
        try {
            if (!this.listeners.isEmpty()) {
                HighlightsChangeEvent thisEvt = new HighlightsChangeEvent(this, event.getStartOffset(), event.getEndOffset());
                for (HighlightsChangeListener highlightsChangeListener : this.listeners) {
                    highlightsChangeListener.highlightChanged(thisEvt);
                }
            }
            List<Reference<HlSequence>> list = this.activeHlSeqs;
            synchronized (list) {
                for (Reference reference : this.activeHlSeqs) {
                    HlSequence seq = (HlSequence)reference.get();
                    if (seq == null) continue;
                    seq.notifyLayersChanged();
                }
                this.activeHlSeqs.clear();
            }
        }
        finally {
            this.layerEvent = null;
        }
    }

    public HighlightsChangeEvent layerEvent() {
        return this.layerEvent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        int digitCount = ArrayUtilities.digitCount((int)this.layers.length);
        for (int i = 0; i < this.layers.length; ++i) {
            ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
            sb.append(this.layers[i]);
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public void released() {
        for (HighlightsContainer layer : this.layers) {
            if (!(layer instanceof ReleasableHighlightsContainer)) continue;
            ((ReleasableHighlightsContainer)layer).released();
        }
    }

    static final class Wrapper {
        private final HlSequence parentSequence;
        final HighlightsContainer layer;
        final HighlightsSequence layerSequence;
        final SplitOffsetHighlightsSequence splitOffsetLayerSequence;
        final int endOffset;
        int hlStartOffset;
        int hlStartSplitOffset;
        int hlEndOffset;
        int hlEndSplitOffset;
        AttributeSet hlAttrs;
        int nextChangeOffset;
        int nextChangeSplitOffset;
        AttributeSet currentAttrs;
        int mergedNextChangeOffset;
        int mergedNextChangeSplitOffset;
        AttributeSet mAttrs;
        private int emptyHighlightCount;

        public Wrapper(HlSequence parent, HighlightsContainer layer, HighlightsSequence layerSequence, int endOffset) {
            this.parentSequence = parent;
            this.layer = layer;
            this.layerSequence = layerSequence;
            this.splitOffsetLayerSequence = layerSequence instanceof SplitOffsetHighlightsSequence ? (SplitOffsetHighlightsSequence)layerSequence : null;
            this.endOffset = endOffset;
        }

        boolean init(int startOffset) {
            do {
                if (this.fetchNextHighlight()) continue;
                return false;
            } while (this.hlEndOffset < startOffset || this.hlEndOffset == startOffset && this.hlEndSplitOffset == 0);
            this.updateCurrentState(startOffset, 0);
            return true;
        }

        boolean isNextChangeBelow(int offset, int splitOffset) {
            return this.nextChangeOffset < offset || this.nextChangeOffset == offset && this.nextChangeSplitOffset < splitOffset;
        }

        boolean isNextChangeBelowOrAt(int offset, int splitOffset) {
            return this.nextChangeOffset < offset || this.nextChangeOffset == offset && this.nextChangeSplitOffset <= splitOffset;
        }

        boolean isMergedNextChangeBelowOrAt(int offset, int splitOffset) {
            return this.mergedNextChangeOffset < offset || this.mergedNextChangeOffset == offset && this.mergedNextChangeSplitOffset <= splitOffset;
        }

        boolean updateCurrentState(int offset, int splitOffset) {
            if (offset < this.hlStartOffset) {
                this.currentAttrs = null;
                this.nextChangeOffset = this.hlStartOffset;
                this.nextChangeSplitOffset = this.hlStartSplitOffset;
                return false;
            }
            if (offset == this.hlStartOffset) {
                if (splitOffset < this.hlStartSplitOffset) {
                    this.currentAttrs = null;
                    this.nextChangeOffset = this.hlStartOffset;
                    this.nextChangeSplitOffset = this.hlStartSplitOffset;
                    return false;
                }
                if (offset < this.hlEndOffset || offset == this.hlEndOffset && splitOffset < this.hlEndSplitOffset) {
                    this.currentAttrs = this.hlAttrs;
                    this.nextChangeOffset = this.hlEndOffset;
                    this.nextChangeSplitOffset = this.hlEndSplitOffset;
                    return false;
                }
                return true;
            }
            if (offset < this.hlEndOffset || offset == this.hlEndOffset && splitOffset < this.hlEndSplitOffset) {
                this.currentAttrs = this.hlAttrs;
                this.nextChangeOffset = this.hlEndOffset;
                this.nextChangeSplitOffset = this.hlEndSplitOffset;
                return false;
            }
            return true;
        }

        boolean fetchNextHighlight() {
            while (this.layerSequence.moveNext()) {
                this.hlStartOffset = this.layerSequence.getStartOffset();
                if (this.hlStartOffset < this.hlEndOffset) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(this.parentSequence.dumpId() + ".wrapper.fetchNextHighlight: Disabled an invalid highlighting layer: hlStartOffset=" + this.hlStartOffset + " < previous hlEndOffset=" + this.hlEndOffset + " for layer=" + this.layer + '\n');
                    }
                    return false;
                }
                this.hlEndOffset = this.layerSequence.getEndOffset();
                if (this.splitOffsetLayerSequence != null) {
                    this.hlStartSplitOffset = this.splitOffsetLayerSequence.getStartSplitOffset();
                    this.hlEndSplitOffset = this.splitOffsetLayerSequence.getEndSplitOffset();
                }
                if (this.hlEndOffset <= this.hlStartOffset) {
                    if (this.hlEndOffset < this.hlStartOffset) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine(this.parentSequence.dumpId() + ".wrapper.fetchNextHighlight: Disabled an invalid highlighting layer: hlStartOffset=" + this.hlStartOffset + " > hlEndOffset=" + this.hlEndOffset + " for layer=" + this.layer + "\n");
                        }
                        return false;
                    }
                    if (this.hlEndSplitOffset <= this.hlStartSplitOffset) {
                        ++this.emptyHighlightCount;
                        if (this.emptyHighlightCount < 10000) continue;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine(this.parentSequence.dumpId() + ".wrapper.fetchNextHighlight: Disabled an invalid highlighting layer: too many empty highlights=" + this.emptyHighlightCount + "\n");
                        }
                        return false;
                    }
                }
                if (this.hlEndOffset > this.endOffset) {
                    if (this.hlStartOffset >= this.endOffset) {
                        return false;
                    }
                    this.hlEndOffset = this.endOffset;
                }
                this.hlAttrs = this.layerSequence.getAttributes();
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.fine("  " + this.parentSequence.dumpId() + " layer-highlight: <" + this.hlStartOffset + '_' + this.hlStartSplitOffset + "," + this.hlEndOffset + '_' + this.hlEndSplitOffset + "> for " + this.layer + '\n');
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "MergedChangeOffset(SplitOffset)=" + this.mergedNextChangeOffset + '(' + this.mergedNextChangeSplitOffset + "), NextCO(SO)=" + this.nextChangeOffset + '(' + this.nextChangeSplitOffset + "), HL:<" + this.hlStartOffset + '(' + this.hlStartSplitOffset + ")," + this.hlEndOffset + '(' + this.hlEndSplitOffset + ")>";
        }
    }

    static final class HlSequence
    implements CoveringHighlightsSequence {
        private final Wrapper[] wrappers;
        private final boolean covering;
        private int topWrapperIndex;
        final int endOffset;
        private int mergedHighlightStartOffset;
        private int mergedHighlightStartSplitOffset;
        private int mergedHighlightEndOffset;
        private int mergedHighlightEndSplitOffset;
        AttributeSet mergedAttrs;
        volatile boolean finished;

        public HlSequence(HighlightsContainer[] layers, int startOffset, int endOffset, boolean covering) {
            this.covering = covering;
            this.endOffset = endOffset;
            this.mergedHighlightStartOffset = startOffset;
            this.mergedHighlightEndOffset = startOffset;
            boolean log = LOG.isLoggable(Level.FINE);
            if (log) {
                LOG.fine(this.dumpId() + " NEW HlSequence for <" + startOffset + "," + endOffset + "> for layers:\n");
            }
            this.wrappers = new Wrapper[layers.length];
            for (int i = 0; i < layers.length; ++i) {
                HighlightsContainer container = layers[i];
                HighlightsSequence hlSequence = container.getHighlights(startOffset, endOffset);
                Wrapper wrapper = new Wrapper(this, container, hlSequence, endOffset);
                if (wrapper.init(startOffset)) {
                    if (log) {
                        LOG.fine("    " + this.dumpId() + " layer[" + this.topWrapperIndex + "]: " + container + '\n');
                    }
                    this.wrappers[this.topWrapperIndex++] = wrapper;
                    continue;
                }
                if (!log) continue;
                LOG.fine("    " + this.dumpId() + " Skipped layer (no highlights in the requested offset range) " + container + '\n');
            }
            --this.topWrapperIndex;
            this.updateMergeVars(-1, startOffset, 0);
        }

        @Override
        public boolean moveNext() {
            Wrapper topWrapper;
            if (this.finished) {
                return false;
            }
            int nextHighlightStartOffset = this.mergedHighlightEndOffset;
            int nextHighlightStartSplitOffset = this.mergedHighlightEndSplitOffset;
            while ((topWrapper = this.nextMerge(nextHighlightStartOffset, nextHighlightStartSplitOffset)) != null) {
                if (this.covering || topWrapper.mAttrs != null) {
                    this.mergedHighlightStartOffset = nextHighlightStartOffset;
                    this.mergedHighlightStartSplitOffset = nextHighlightStartSplitOffset;
                    this.mergedHighlightEndOffset = topWrapper.mergedNextChangeOffset;
                    this.mergedHighlightEndSplitOffset = topWrapper.mergedNextChangeSplitOffset;
                    this.mergedAttrs = topWrapper.mAttrs;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(this.dumpId() + ".moveNext: highlight <" + this.getStartOffset() + "_" + this.getStartSplitOffset() + "," + this.getEndOffset() + "_" + this.getEndSplitOffset() + "> attrs=" + this.getAttributes() + "\n");
                    }
                    return true;
                }
                nextHighlightStartOffset = topWrapper.mergedNextChangeOffset;
                nextHighlightStartSplitOffset = topWrapper.mergedNextChangeSplitOffset;
            }
            this.finished = true;
            return false;
        }

        @Override
        public boolean isCovering() {
            return this.covering;
        }

        @Override
        public int getStartOffset() {
            return this.mergedHighlightStartOffset;
        }

        @Override
        public int getStartSplitOffset() {
            return this.mergedHighlightStartSplitOffset;
        }

        @Override
        public int getEndOffset() {
            return this.mergedHighlightEndOffset;
        }

        @Override
        public int getEndSplitOffset() {
            return this.mergedHighlightEndSplitOffset;
        }

        @Override
        public AttributeSet getAttributes() {
            return this.mergedAttrs;
        }

        void notifyLayersChanged() {
            this.finished = true;
        }

        Wrapper nextMerge(int offset, int splitOffset) {
            int i;
            for (i = this.topWrapperIndex; i >= 0 && this.wrappers[i].isMergedNextChangeBelowOrAt(offset, splitOffset); --i) {
            }
            return this.updateMergeVars(i, offset, splitOffset);
        }

        Wrapper updateMergeVars(int startIndex, int offset, int splitOffset) {
            AttributeSet lastAttrs;
            int nextChangeSplitOffset;
            int nextChangeOffset;
            Wrapper wrapper = null;
            if (startIndex < 0) {
                nextChangeOffset = this.endOffset;
                nextChangeSplitOffset = 0;
                lastAttrs = null;
            } else {
                wrapper = this.wrappers[startIndex];
                nextChangeOffset = wrapper.mergedNextChangeOffset;
                nextChangeSplitOffset = wrapper.mergedNextChangeSplitOffset;
                lastAttrs = wrapper.mAttrs;
            }
            block0: for (int i = startIndex + 1; i <= this.topWrapperIndex; ++i) {
                wrapper = this.wrappers[i];
                if (wrapper.isNextChangeBelowOrAt(offset, splitOffset)) {
                    while (wrapper.updateCurrentState(offset, splitOffset)) {
                        if (wrapper.fetchNextHighlight()) continue;
                        this.removeWrapper(i);
                        if (--i != this.topWrapperIndex) continue block0;
                        wrapper = i >= 0 ? this.wrappers[i] : null;
                        break block0;
                    }
                }
                if (wrapper.isNextChangeBelow(nextChangeOffset, nextChangeSplitOffset)) {
                    nextChangeOffset = wrapper.nextChangeOffset;
                    nextChangeSplitOffset = wrapper.nextChangeSplitOffset;
                }
                wrapper.mergedNextChangeOffset = nextChangeOffset;
                wrapper.mergedNextChangeSplitOffset = nextChangeSplitOffset;
                wrapper.mAttrs = lastAttrs = lastAttrs != null ? (wrapper.currentAttrs != null ? AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{wrapper.currentAttrs, lastAttrs}) : lastAttrs) : wrapper.currentAttrs;
            }
            return wrapper;
        }

        private void removeWrapper(int index) {
            System.arraycopy(this.wrappers, index + 1, this.wrappers, index, this.topWrapperIndex - index);
            this.wrappers[this.topWrapperIndex] = null;
            --this.topWrapperIndex;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(200);
            sb.append("endO=").append(this.endOffset);
            if (this.finished) {
                sb.append("; FINISHED");
            } else {
                sb.append(" Merged <").append(this.mergedHighlightStartOffset).append('_').append(this.mergedHighlightStartSplitOffset).append(",").append(this.mergedHighlightEndOffset).append('_').append(this.mergedHighlightEndSplitOffset).append(">");
            }
            sb.append('\n');
            int digitCount = ArrayUtilities.digitCount((int)(this.topWrapperIndex + 1));
            for (int i = 0; i <= this.topWrapperIndex; ++i) {
                sb.append("  ");
                ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
                sb.append(this.wrappers[i]);
                sb.append('\n');
            }
            return sb.toString();
        }

        String dumpId() {
            return "DMC$HS@" + Integer.toHexString(System.identityHashCode(this));
        }
    }
}

