/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.chat.ChatRoomTopComponentRegistry;
import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.ChatRoomCookie;
import com.paterva.maltego.chatapi.session.ChatSessionRegistry;
import com.paterva.maltego.collab.graph.GraphChatRoom;
import com.paterva.maltego.collab.ui.ChatRoomCloseHandler;
import com.paterva.maltego.collab.ui.ShareGraphFormContainer;
import com.paterva.maltego.collab.ui.ShareNewGraphForm;
import com.paterva.maltego.collab.ui.SharedGraphBackgroundWorkerListener;
import com.paterva.maltego.ui.graph.GraphViewNotificationAdapter;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;

public final class ShareNewGraphAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        this.performAction();
    }

    public void performAction() {
        Dialog dialog;
        ShareGraphFormContainer formContainer = new ShareGraphFormContainer();
        final ShareNewGraphForm form = formContainer.getForm();
        final Dialog[] dialogHolder = formContainer.getDialogHolder();
        final JButton connectButton = formContainer.getConnectButton();
        final JButton cancelButton = formContainer.getCancelButton();
        formContainer.addBackgroundWorkerListener(new SharedGraphBackgroundWorkerListenerImpl(formContainer));
        ActionListener connectListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == connectButton) {
                    connectButton.setEnabled(false);
                    form.start("Establishing collaboration session...");
                } else if (e.getSource() == cancelButton) {
                    cancelButton.setEnabled(false);
                    if (form.isBusy()) {
                        form.cancel();
                    } else {
                        dialogHolder[0].setVisible(false);
                        dialogHolder[0].dispose();
                    }
                }
            }
        };
        DialogDescriptor dd = new DialogDescriptor((Object)form, "Share New Graph", true, new Object[]{connectButton, cancelButton}, (Object)connectButton, 0, HelpCtx.DEFAULT_HELP, connectListener);
        dialogHolder[0] = dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setMinimumSize(dialog.getPreferredSize());
        dialog.setVisible(true);
        form.storeInfo();
    }

    private class SharedGraphBackgroundWorkerListenerImpl
    extends SharedGraphBackgroundWorkerListener {
        private final Dialog[] _dialogHolder;

        public SharedGraphBackgroundWorkerListenerImpl(ShareGraphFormContainer shareGraphFormContainer) {
            super(shareGraphFormContainer);
            this._dialogHolder = shareGraphFormContainer.getDialogHolder();
        }

        public void workerCompleted(Object result) {
            final GraphChatRoom room = (GraphChatRoom)((Object)result);
            ChatRoomCloseHandler closeHandler = new ChatRoomCloseHandler(room);
            ChatRoomTopComponentRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)closeHandler);
            PropertyChangeListener viewCreatedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ChatRoom chatRoom;
                    GraphDataObject gdo;
                    ChatRoomCookie cookie;
                    Object newValue;
                    if (evt.getPropertyName().equals("graphLoadingDone") && (newValue = evt.getNewValue()) instanceof GraphDataObject && (cookie = (ChatRoomCookie)(gdo = (GraphDataObject)newValue).getLookup().lookup(ChatRoomCookie.class)) != null && (chatRoom = cookie.getChatRoom()).equals((Object)room)) {
                        GraphViewNotificationAdapter.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                        room.initializationComplete();
                        SharedGraphBackgroundWorkerListenerImpl.this._dialogHolder[0].setVisible(false);
                        SharedGraphBackgroundWorkerListenerImpl.this._dialogHolder[0].dispose();
                    }
                }
            };
            GraphViewNotificationAdapter.getDefault().addPropertyChangeListener(viewCreatedListener);
            ChatSessionRegistry.getDefault().addChatRoom((ChatRoom)room);
        }
    }
}

