/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.PandoraProperty;
import com.pinkmatter.pandora.PandoraSchema;
import com.pinkmatter.pandora.TypeUtils;
import com.pinkmatter.pandora.lucene.LuceneConnection;
import com.pinkmatter.pandora.lucene.PandoraQueryImpl;
import com.pinkmatter.pandora.lucene.SchemaProperty;
import com.pinkmatter.pandora.lucene.SchemaPropertyCollector;
import com.pinkmatter.pandora.lucene.serialize.FilterHelper;
import com.pinkmatter.pandora.lucene.serialize.TypeConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LuceneSchema
implements PandoraSchema {
    private final LuceneConnection _connection;
    private boolean _autoRefresh = true;
    private SchemaPropertyCollector _schema;
    private long _version = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(LuceneSchema.class);
    private final QueryHelper _queryHelper = new QueryHelper();
    private final FieldHelper _fieldHelper = new FieldHelper();

    public LuceneSchema(LuceneConnection connection) {
        this(connection, true);
    }

    public LuceneSchema(LuceneConnection connection, boolean autoRefresh) {
        this._connection = connection;
        this._autoRefresh = autoRefresh;
        this._schema = null;
        LOG.info("Created IndexSchema with auto refresh {}", (Object)this._autoRefresh);
    }

    QueryHelper getQueryHelper() {
        return this._queryHelper;
    }

    FieldHelper getFieldHelper() {
        return this._fieldHelper;
    }

    public void refresh() throws PandoraException {
        if (this.isDirty()) {
            this.readSchema();
        }
    }

    public boolean isAutoRefresh() {
        return this._autoRefresh;
    }

    public void setAutoRefresh(boolean auto) {
        this._autoRefresh = auto;
        LOG.info("Changed IndexSchema to auto commit {}", (Object)this._autoRefresh);
    }

    private boolean isDirty() {
        return this._version != this._connection.getVersion();
    }

    private SchemaPropertyCollector getSchema() throws PandoraException {
        if (this._schema == null || this._schema.isEmpty() || this._autoRefresh && this.isDirty()) {
            this.readSchema();
        }
        return this._schema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void readSchema() throws PandoraException {
        IndexSearcher searcher = null;
        try {
            LOG.debug("Reading index schema");
            this._version = this._connection.getVersion();
            searcher = this._connection.acquireWithRefresh();
            IndexReader reader = searcher.getIndexReader();
            SchemaPropertyCollector collector = new SchemaPropertyCollector();
            for (LeafReaderContext context : reader.leaves()) {
                for (String fieldName : context.reader().fields()) {
                    if (!TypeConverter.isStored(fieldName)) continue;
                    collector.collect(fieldName);
                }
            }
            this._schema = collector;
            if (searcher == null) return;
        }
        catch (IOException ex) {
            try {
                throw new PandoraException("Error while reading index schema.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                if (searcher == null) throw throwable;
                this._connection.release(searcher);
                throw throwable;
            }
        }
        this._connection.release(searcher);
        return;
    }

    public List<PandoraProperty> getMainProperties() throws PandoraException {
        return this.toPandoraProperties(this.getSchema().getSchemaProperties());
    }

    public List<PandoraProperty> getMainProperties(Class type) throws PandoraException {
        return this.toPandoraProperties(this.getSchema().getSchemaProperties(type));
    }

    public List<PandoraProperty> getProperties(String dottedName) throws PandoraException {
        return this.getProperties(dottedName, null);
    }

    public PandoraProperty getProperty(String dottedName) throws PandoraException {
        return this.getProperty(dottedName, null);
    }

    public List<PandoraProperty> getProperties(String dottedName, Class type) throws PandoraException {
        return this.toPandoraProperties(this.getSchemaProperties(dottedName, type));
    }

    public PandoraProperty getProperty(String dottedName, Class type) throws PandoraException {
        List<PandoraProperty> props = this.getProperties(dottedName, type);
        if (props.size() == 1) {
            return props.get(0);
        }
        if (props.isEmpty()) {
            return null;
        }
        throw new PandoraException(String.format("Property %s is ambiguous and cannot be resolved to a unique property.", dottedName));
    }

    private List<SchemaProperty> getSchemaProperties(String dottedProperty, Class type) throws PandoraException {
        ArrayList<SchemaProperty> result = new ArrayList<SchemaProperty>(1);
        this.getSchemaProperties(dottedProperty, type, this.getSchema(), result);
        return result;
    }

    private SchemaProperty getUniqueSchemaProperty(String dottedProperty, Class type) throws PandoraException {
        List<SchemaProperty> props = this.getSchemaProperties(dottedProperty, type);
        if (props.size() == 1) {
            return props.get(0);
        }
        if (props.isEmpty()) {
            return null;
        }
        throw new PandoraException(String.format("Property %s is ambiguous and cannot be resolved to a unique property.", dottedProperty));
    }

    private void getSchemaProperties(String shortName, Class type, SchemaPropertyCollector fromSchema, List<SchemaProperty> result) throws PandoraException {
        String[] names = shortName.split("\\.", 2);
        boolean end = names.length == 1;
        List<SchemaProperty> subSchemas = !end ? this.getSchemaProperties(names[0], null, fromSchema) : this.getSchemaProperties(names[0], type, fromSchema);
        for (SchemaProperty subSchema : subSchemas) {
            if (!end) {
                this.getSchemaProperties(names[1], type, subSchema, result);
                continue;
            }
            result.add(subSchema);
        }
    }

    private List<SchemaProperty> getSchemaProperties(String shortName, Class type, SchemaPropertyCollector fromSchema) throws PandoraException {
        if (type != null) {
            return Collections.singletonList(fromSchema.getSchemaProperty(shortName, type));
        }
        return fromSchema.getSchemaProperties(shortName);
    }

    private List<PandoraProperty> toPandoraProperties(List<SchemaProperty> schemaProperties) {
        ArrayList<PandoraProperty> properties = new ArrayList<PandoraProperty>();
        for (SchemaProperty schemaProp : schemaProperties) {
            properties.add(this.toPandoraProperty(schemaProp));
        }
        return properties;
    }

    private PandoraProperty toPandoraProperty(SchemaProperty schemaProp) {
        if (schemaProp == null) {
            return null;
        }
        List<PandoraProperty> children = this.toPandoraProperties(schemaProp.getSchemaProperties());
        return new PandoraProperty(schemaProp.getName(), schemaProp.getType(), children);
    }

    public static String getMainPropertyName(String dottedProperty) throws PandoraException {
        int dot = dottedProperty.indexOf(".");
        if (dot >= 0) {
            return dottedProperty.substring(0, dot);
        }
        return dottedProperty;
    }

    protected class FieldHelper {
        protected FieldHelper() {
        }

        public Set<String> getFields() throws PandoraException {
            return LuceneSchema.this.getSchema().getFields();
        }

        public Set<String> getFields(String dottedProperty) throws PandoraException {
            return this.getFields(dottedProperty, null);
        }

        public Set<String> getFields(String dottedProperty, Class type) throws PandoraException {
            SchemaProperty prop = this.getSchemaPropertyReadableAncestor(dottedProperty, type);
            if (prop != null) {
                return prop.getFields();
            }
            return Collections.EMPTY_SET;
        }

        private SchemaProperty getSchemaPropertyReadableAncestor(String dottedProperty, Class type) throws PandoraException {
            String[] names = dottedProperty.split("\\.");
            SchemaPropertyCollector schema = LuceneSchema.this.getSchema();
            for (int i = 0; i < names.length && (schema = i < names.length - 1 ? this.getUniqueSchemaProperty(names[i], null, schema) : this.getUniqueSchemaProperty(names[i], type, schema)) != null && schema.canReadChildren(); ++i) {
            }
            return (SchemaProperty)schema;
        }

        private SchemaProperty getUniqueSchemaProperty(String shortName, Class type, SchemaPropertyCollector fromSchema) throws PandoraException {
            List props = LuceneSchema.this.getSchemaProperties(shortName, type, fromSchema);
            if (props.size() == 1) {
                return (SchemaProperty)props.get(0);
            }
            if (props.isEmpty()) {
                return null;
            }
            throw new PandoraException(String.format("Property %s is ambiguous and cannot be resolved to a unique property.", shortName));
        }
    }

    protected class QueryHelper {
        protected QueryHelper() {
        }

        public SortField[] createSortFields(PandoraQueryImpl.SortProperty sorter) throws PandoraException {
            return this.createSortFields(sorter.getProperty(), sorter.getType(), !sorter.isAscending(), sorter.isEmptyFirst());
        }

        private SortField[] createSortFields(String dottedProperty, Class type, boolean reverse, boolean emptyFirst) throws PandoraException {
            SchemaProperty schemaProp = LuceneSchema.this.getUniqueSchemaProperty(dottedProperty, type);
            if (schemaProp == null) {
                LOG.debug("Creating empty sort fields for property {} of type {} because no such property found in index.", (Object)dottedProperty, (Object)type);
                return new SortField[0];
            }
            return TypeConverter.getSortFields(schemaProp.getType(), schemaProp.getFullName(), reverse, emptyFirst);
        }

        public Query createQuery(PandoraFilter descriptor) throws PandoraException {
            Query filter = null;
            if (descriptor instanceof PandoraFilter.SingleWrapper) {
                Query innerfilter = this.createQuery(((PandoraFilter.SingleWrapper)descriptor).getFilter());
                if (descriptor instanceof PandoraFilter.Not) {
                    filter = FilterHelper.createNotFilter(innerfilter);
                }
            } else if (descriptor instanceof PandoraFilter.BooleanWrapper) {
                Query[] innerFilters = this.createQueries(((PandoraFilter.BooleanWrapper)descriptor).getFilters());
                if (descriptor instanceof PandoraFilter.And) {
                    filter = FilterHelper.createAndFilter(innerFilters);
                } else if (descriptor instanceof PandoraFilter.Or) {
                    filter = FilterHelper.createOrQuery(innerFilters);
                }
            } else if (descriptor instanceof PandoraFilter.Simple) {
                filter = this.toPropertyAwareQuery((PandoraFilter.Simple)descriptor);
            }
            if (filter == null) {
                throw new PandoraException("Filter of type " + descriptor.getClass() + " is not supported.");
            }
            return filter;
        }

        private Query[] createQueries(PandoraFilter[] descriptors) throws PandoraException {
            Query[] filters = new Query[descriptors.length];
            int i = 0;
            for (PandoraFilter d : descriptors) {
                filters[i] = this.createQuery(d);
                ++i;
            }
            return filters;
        }

        private Query toPropertyAwareQuery(PandoraFilter.Simple descriptor) throws PandoraException {
            Query filter = null;
            SchemaProperty schemaProp = LuceneSchema.this.getUniqueSchemaProperty(descriptor.getProperty(), descriptor.getPropertyType());
            if (schemaProp != null) {
                PandoraFilter.Simple cloneParameters = (PandoraFilter.Simple)descriptor.clone();
                cloneParameters.setProperty(schemaProp.getFullName());
                filter = TypeConverter.getFilter(schemaProp.getType(), cloneParameters);
            } else {
                Object values;
                LOG.debug("Creating dummy filter for {} because no such property found in index.", (Object)descriptor);
                Class type = null;
                if (descriptor.getPropertyType() != null) {
                    type = descriptor.getPropertyType();
                } else if (descriptor.getType() != null && (values = descriptor.getValueAsObject()) != null) {
                    type = TypeUtils.getDeepType((Object)values);
                }
                if (type == null || type == Object.class) {
                    type = String.class;
                }
                filter = TypeConverter.getFilter(type, descriptor);
            }
            if (filter == null) {
                throw new PandoraException("Could not create filter " + descriptor + " because the property does not exists. Try specifying the filter property type if you want to do this.");
            }
            return filter;
        }
    }
}

