/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.types.TimeSpan;
import java.beans.PropertyEditorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeSpanPropertyEditor
extends PropertyEditorSupport {
    @Override
    public String getAsText() {
        TimeSpan timeSpan = (TimeSpan)this.getValue();
        if (timeSpan == null) {
            timeSpan = new TimeSpan(0L);
        }
        long millis = timeSpan.getMilliseconds();
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        double sec = (double)(millis % 60000L) / 1000.0;
        String text = String.format("%dd %dh%dm%.3fs", days, hours %= 24L, minutes %= 60L, sec);
        return text;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        Matcher matcher = Pattern.compile("(\\d+)d (\\d+)h(\\d+)m(\\d+(?:\\.\\d+)?)s").matcher(text);
        if (matcher.matches()) {
            long days = Long.parseLong(matcher.group(1));
            long hours = Long.parseLong(matcher.group(2));
            long minutes = Long.parseLong(matcher.group(3));
            long millis = (long)(1000.0 * Double.parseDouble(matcher.group(4)));
            long time = millis + 1000L * (60L * (minutes + 60L * (hours + 24L * days)));
            this.setValue(new TimeSpan(time));
        }
    }
}

