/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form.adapters;

import com.paterva.maltego.typing.editing.form.adapters.AbstractControlAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

class SpinnerAdapter<T>
extends AbstractControlAdapter<JSpinner, T> {
    private SpinnerModel _model;
    private T _defaultValue;

    public SpinnerAdapter(T defaultValue) {
        this._defaultValue = defaultValue;
    }

    @Override
    public JSpinner create() {
        final JSpinner spinner = new JSpinner();
        spinner.setValue(this._defaultValue);
        spinner.setPreferredSize(new Dimension(80, spinner.getPreferredSize().height));
        DefaultFormatter format = new DefaultFormatter();
        DefaultFormatterFactory dff = new DefaultFormatterFactory(format);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner, "0.#########################");
        JFormattedTextField textField = editor.getTextField();
        textField.setFormatterFactory(dff);
        spinner.setEditor(editor);
        if (this.getModel() != null) {
            spinner.setModel(this.getModel());
        }
        spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerAdapter.this.fireActionPerformed(spinner, 0, "valueChanged");
            }
        });
        spinner.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SpinnerAdapter.this.fireEditingFinished(spinner);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        return spinner;
    }

    @Override
    protected void set(JSpinner component, T value) {
        if (value != null) {
            component.setValue(value);
            ((JSpinner.NumberEditor)component.getEditor()).getTextField().setValue(value);
        }
    }

    @Override
    protected T get(JSpinner component) {
        return (T)component.getValue();
    }

    @Override
    protected boolean empty(JSpinner component) {
        return false;
    }

    public SpinnerModel getModel() {
        return this._model;
    }

    public void setModel(SpinnerModel model) {
        this._model = model;
    }

    @Override
    public void clear(JSpinner component) {
    }

    @Override
    protected void setBackground(JSpinner component, Color color) {
        component.getEditor().setBackground(color);
    }

    @Override
    protected Color getBackground(JSpinner component) {
        return component.getEditor().getBackground();
    }
}

