/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.painter;

import com.paterva.maltego.ui.graph.view2d.CollectionNodeLabel;
import com.paterva.maltego.ui.graph.view2d.EntityLabelConfigs;
import com.paterva.maltego.ui.graph.view2d.EntityValueLabel;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.ui.graph.view2d.NotesLabel;
import com.paterva.maltego.ui.graph.view2d.labels.EntityLabelProvider;
import com.paterva.maltego.ui.graph.view2d.labels.EntityPropertyLabel;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import javax.swing.UIDefaults;
import org.jdesktop.swingx.color.ColorUtil;
import yguard.A.J.BA;
import yguard.A.J.gB;

public class EntityLabels {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();

    public static gB createValueLabel(LightweightEntityRealizer realizer) {
        EntityValueLabel label = new EntityValueLabel(realizer);
        realizer.setLabel(label);
        label.setModel((byte)1);
        label.setPosition((byte)101);
        NodeRealizerSettings settings = NodeRealizerSettings.getDefault();
        label.setFont(settings.getValueLabelFont());
        label.setTextColor(settings.getValueLabelColor());
        label.setDistance(15.0);
        return label;
    }

    public static gB createCollectionNodeLabel(LightweightEntityRealizer realizer) {
        CollectionNodeLabel label = new CollectionNodeLabel();
        realizer.setLabel(label);
        label.setModel((byte)1);
        label.setPosition((byte)101);
        NodeRealizerSettings settings = NodeRealizerSettings.getDefault();
        label.setFont(settings.getValueLabelFont());
        label.setTextColor(settings.getValueLabelColor());
        label.setDistance(15.0);
        return label;
    }

    public static gB createBookmarkLabel(LightweightEntityRealizer realizer) {
        gB bookmarkLabel = realizer.createNodeLabel();
        bookmarkLabel.setModel((byte)4);
        bookmarkLabel.setConfiguration(EntityLabelConfigs.getBookmarkLabelConfig());
        bookmarkLabel.setVisible(false);
        realizer.addLabel(bookmarkLabel);
        return bookmarkLabel;
    }

    public static gB createNotesLabel(LightweightEntityRealizer realizer) {
        gB notesLabel = realizer.createNodeLabel();
        notesLabel.setModel((byte)4);
        notesLabel.setConfiguration(EntityLabelConfigs.getNotesLabelConfig());
        notesLabel.setBackgroundColor(ColorUtil.setAlpha((Color)LAF.getColor("note-overlay-empty-color"), (int)Integer.decode(LAF.getString("note-overlay-empty-aplha"))));
        notesLabel.setVisible(false);
        realizer.addLabel(notesLabel);
        return notesLabel;
    }

    public static gB createPinLabel(LightweightEntityRealizer realizer) {
        gB pinLabel = realizer.createNodeLabel();
        pinLabel.setModel((byte)4);
        pinLabel.setConfiguration(EntityLabelConfigs.getPinLabelConfig());
        pinLabel.setVisible(false);
        realizer.addLabel(pinLabel);
        return pinLabel;
    }

    public static gB createNotesEditLabel(LightweightEntityRealizer realizer) {
        NotesLabel notesEditLabel = new NotesLabel(realizer);
        notesEditLabel.setModel((byte)5);
        notesEditLabel.setPosition((byte)105);
        notesEditLabel.setConfiguration(EntityLabelConfigs.getNotesEditLabelConfig());
        notesEditLabel.setVisible(false);
        Color color = ColorUtil.setAlpha((Color)LAF.getColor("note-shadow-color"), (int)Integer.decode(LAF.getString("note-shadow-alpha")));
        notesEditLabel.setLineColor(color);
        notesEditLabel.setBackgroundColor(ColorUtil.setAlpha((Color)LAF.getColor("note-background-color"), (int)Integer.decode(LAF.getString("note-background-color-alpha"))));
        notesEditLabel.setAlignment((byte)0);
        notesEditLabel.setDistance(1.0);
        notesEditLabel.setTextColor(LAF.getColor("note-close-button-color"));
        realizer.addLabel(notesEditLabel);
        return notesEditLabel;
    }

    public static void createProviderLabels(LightweightEntityRealizer realizer) {
        for (EntityLabelProvider entityLabelProvider : EntityLabelProvider.getAll()) {
            for (gB label : entityLabelProvider.getLabels((BA)realizer)) {
                ((EntityPropertyLabel)label).setGraphEntity(realizer.getGraphEntity());
                realizer.addLabel(label);
            }
        }
    }
}

