/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.UserDataHolder;
import com.paterva.maltego.graph.cache.skeletons.LinkSkeletonProvider;
import com.paterva.maltego.graph.cache.skeletons.SkeletonProviders;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.actions.ShowLabels;
import com.paterva.maltego.ui.graph.view2d.LinkPresenter;
import com.paterva.maltego.ui.graph.view2d.NodeLabelUtils;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.ui.graph.view2d.PaintPruner;
import com.paterva.maltego.ui.graph.view2d.PopupAwareEditMode;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.fonts.FontFallbackStringPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.openide.util.Exceptions;
import yguard.A.I.M;
import yguard.A.J.E;
import yguard.A.J.GA;
import yguard.A.J.X;
import yguard.A.J.fA;
import yguard.A.J.q;
import yguard.A.J.s;

public class LinkEdgeRealizer
extends s
implements UserDataHolder {
    public static final Color DEFAULT_MANUAL_LINK_COLOR = MaltegoLinkSpec.getDefaultManualLinkColor();
    public static final fA DEFAULT_LINE_TYPE = fA.I;
    private static final boolean DEBUG = false;
    private static int _painted = 0;
    private final int _paintHash = PaintPruner.generatePaintHash();
    private GraphLink _link;
    private boolean _isUpToDate = false;
    private static boolean _updating = false;

    public LinkEdgeRealizer() {
        this.init();
    }

    public LinkEdgeRealizer(q er) {
        super(er);
        this.init();
    }

    public static void onPaintStart(Collection<q> edgeRealizersToPaint, boolean cacheSkeletons) throws GraphStoreException {
        _painted = 0;
        if (cacheSkeletons) {
            LinkEdgeRealizer.cacheLinksInBulk(edgeRealizersToPaint);
        }
    }

    private static void cacheLinksInBulk(Collection<q> edgeRealizersToPaint) throws GraphStoreException {
        if (!edgeRealizersToPaint.isEmpty()) {
            GraphID graphID = null;
            GraphWrapper wrapper = null;
            LinkedList<Guid> ids = new LinkedList<Guid>();
            for (q realizer : edgeRealizersToPaint) {
                LinkID id;
                LinkEdgeRealizer linkEdgeRealizer;
                Object obj;
                if (!(realizer instanceof LinkEdgeRealizer) || !((obj = (linkEdgeRealizer = (LinkEdgeRealizer)realizer).getUserData()) instanceof GraphLink)) continue;
                GraphLink graphLink = (GraphLink)obj;
                if (wrapper == null) {
                    graphID = graphLink.getGraphID();
                    wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
                }
                if (wrapper.isCollectionNodeLink(id = (LinkID)graphLink.getID())) continue;
                ids.add(graphLink.getID());
            }
            if (graphID != null) {
                LinkSkeletonProvider skeletonProvider = SkeletonProviders.linksForGraph(graphID);
                skeletonProvider.getLinkSkeletons(ids);
            }
        }
    }

    public int getPaintHash() {
        return this._paintHash;
    }

    private void init() {
        this.setSourceArrow(E.X);
        this.setSmoothedBends(true);
        this.setTargetArrow(E.f);
        this.setLineColor(DEFAULT_MANUAL_LINK_COLOR);
        this.setLineType(DEFAULT_LINE_TYPE);
    }

    private void removeLabels() {
        for (int i = this.labelCount() - 1; i >= 0; --i) {
            this.removeLabel(i);
        }
    }

    public q createCopy() {
        return this.createCopy((q)this);
    }

    public q createCopy(q nr) {
        return new LinkEdgeRealizer(nr);
    }

    public Object getUserData() {
        return this._link;
    }

    public void setUserData(Object data) {
        if (data instanceof GraphLink) {
            this._link = (GraphLink)data;
        } else {
            this._link = null;
            this.removeLabels();
            this.clearBends();
            this.clearPoints();
        }
    }

    private MaltegoLink getMaltegoLink() {
        MaltegoLink link = null;
        if (this._link != null) {
            link = GraphStoreHelper.getLink((GraphLink)this._link);
        }
        return link;
    }

    public void update(MaltegoLink link) {
        if (!_updating) {
            try {
                _updating = true;
                this.updateText(link);
                this.updateColor(link);
                this.updateLineType(link);
            }
            finally {
                _updating = false;
            }
        }
    }

    private void updateText(MaltegoLink link) {
        if (link != null) {
            String labelStr = this.getLabelText(link);
            if (!StringUtilities.isNullOrEmpty((String)labelStr)) {
                if (this.labelCount() == 0 || !(this.getLabel() instanceof LinkLabel)) {
                    this.removeLabels();
                    LinkLabel label = new LinkLabel();
                    label.setModel((byte)6);
                    this.addLabel(label);
                }
                ((LinkLabel)this.getLabel()).setTextInternal(labelStr);
                this.getLabel().setTextColor(LinkPresenter.getDefault().getColor(link));
            } else {
                this.removeLabels();
            }
        }
    }

    private String getLabelText(MaltegoLink link) {
        MaltegoLinkSpec spec;
        if (link.getShowLabel() != 2 && (spec = (MaltegoLinkSpec)LinkRegistry.getDefault().get(link.getTypeName())) != null) {
            boolean isManualLink = spec.equals((Object)MaltegoLinkSpec.getManualSpec());
            if (isManualLink) {
                return this.getManualLinkLabel(link);
            }
            return this.getTransformLinkLabel(link);
        }
        return null;
    }

    private String getManualLinkLabel(MaltegoLink link) {
        if (link.getShowLabel() == 1 || ShowLabels.instance().isShowLabelsForManualLinks()) {
            return InheritanceHelper.getDisplayString((SpecRegistry)LinkRegistry.getDefault(), (TypedPropertyBag)link);
        }
        return null;
    }

    private String getTransformLinkLabel(MaltegoLink link) {
        ShowLabels showLabels = ShowLabels.instance();
        String customLabel = this.getStringValue(link, "maltego.link.label");
        String transformLabel = this.getStringValue(link, "maltego.link.transform.display-name");
        if (link.getShowLabel() == 1) {
            return !StringUtilities.isNullOrEmpty((String)customLabel) ? customLabel : transformLabel;
        }
        if (showLabels.isShowLabelsForManualLinks() && !StringUtilities.isNullOrEmpty((String)customLabel)) {
            return customLabel;
        }
        if (showLabels.isShowLabelsForTransformLinks()) {
            return transformLabel;
        }
        return null;
    }

    private String getStringValue(MaltegoLink link, String property) {
        PropertyDescriptor labelPd = link.getProperties().get(property);
        if (labelPd != null) {
            return (String)link.getValue(labelPd);
        }
        return null;
    }

    private void updateColor(MaltegoLink link) {
        if (link != null) {
            Color color = LinkPresenter.getDefault().getColor(link);
            this.setLineColor(color);
            if (this.labelCount() > 0) {
                this.getLabel().setTextColor(color);
            }
        }
    }

    private void updateLineType(MaltegoLink link) {
        if (link != null) {
            this.setLineType(fA.B((int)LinkPresenter.getDefault().getThickness(link), (byte)((byte)LinkPresenter.getDefault().getStyle(link))));
        }
    }

    public void beforePaint() {
        LinkID linkID;
        GraphID graphID;
        GraphWrapper wrapper;
        if (!this._isUpToDate && !(wrapper = MaltegoGraphManager.getWrapper((GraphID)(graphID = this._link.getGraphID()))).isCollectionNodeLink(linkID = (LinkID)this._link.getID())) {
            LinkSkeletonProvider skeletonProvider = SkeletonProviders.linksForGraph((GraphID)graphID);
            try {
                MaltegoLink linkSkeleton = skeletonProvider.getLinkSkeleton(linkID);
                this.update(linkSkeleton);
                this._isUpToDate = true;
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void paintSloppy(Graphics2D g2D) {
        ++_painted;
        super.paintSloppy(g2D);
    }

    protected void paintLabels(Graphics2D g2D) {
        GraphicsUtil.setupTextAntialiasing((Graphics)g2D, null);
        super.paintLabels(g2D);
    }

    protected void paintBends(Graphics2D g2D) {
    }

    protected byte calculatePath(Point2D pd, Point2D pd1) {
        return super.calculatePath(pd, pd1);
    }

    protected void paintHighlightedBends(Graphics2D g2D) {
    }

    protected void paintPorts(Graphics2D g2D) {
    }

    private class LinkLabel
    extends GA
    implements PopupAwareEditMode.EditableLabel {
        boolean isInitilized = false;

        public LinkLabel() {
            this.setFont(NodeRealizerSettings.getDefault().getValueLinkFont());
        }

        @Override
        public boolean isEditable() {
            return LinkEdgeRealizer.this._link == null ? true : !this.getValueProperty().isReadonly();
        }

        public void setText(String text) {
            if (this.isInitilized) {
                PropertyDescriptor pd;
                this.setTextInternal(text);
                MaltegoLink link = LinkEdgeRealizer.this.getMaltegoLink();
                if (link != null && (pd = this.getValueProperty()) != null) {
                    Object value = Converter.convertFrom((String)text, (Class)pd.getType());
                    link.setValue(pd, value);
                }
            }
        }

        private PropertyDescriptor getValueProperty() {
            return InheritanceHelper.getValueProperty((SpecRegistry)LinkRegistry.getDefault(), (TypedPropertyBag)LinkEdgeRealizer.this.getMaltegoLink(), (boolean)true);
        }

        void setTextInternal(String text) {
            super.setText(text);
            if (!this.isInitilized) {
                this.isInitilized = true;
            }
        }

        public void setTextColor(Color color) {
            Color oldColor = this.getTextColor();
            if (!oldColor.equals(color)) {
                super.setTextColor(color);
                this.repaint();
            }
        }

        protected void paintContent(Graphics2D gd, double x2, double y2, double width, double height) {
            String text = this.getText();
            M textLocation = this.getTextLocation();
            Font font = this.getFont();
            float textX = (float)textLocation.A;
            float textY = (float)(textLocation.D + (double)font.getSize2D());
            Color color = this.getTextColor();
            FontFallbackStringPainter.paint((Graphics2D)gd, (String)text, (Font)font, (Color)color, (float)textX, (float)textY, (boolean)true);
        }

        public void calculateSize(FontRenderContext frc) {
            Rectangle2D size = NodeLabelUtils.calculateFontFallbackSize((X)this, frc);
            this.setContentSize(size.getWidth(), size.getHeight());
        }
    }
}

