/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.cache.skeletons.EntitySkeletonProvider;
import com.paterva.maltego.graph.cache.skeletons.SkeletonProviders;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.treelist.parts.PartsTreelistModel;
import com.paterva.maltego.treelist.parts.entity.EntityTable;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeComponent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openide.util.Exceptions;

public class CollectionNodeRenderInfo {
    public static final float BG_FONT_SIZE = 5.0f;
    public static final float BG_TYPE_FONT_SIZE = 9.0f;
    public static final int BG_LINES = 15;
    private final int _entityCount;
    private final CollectionNodeComponent _component;
    private final String _type;

    public CollectionNodeRenderInfo(int entityCount, CollectionNodeComponent table, String entityType) {
        this._entityCount = entityCount;
        this._component = table;
        this._type = entityType;
    }

    public int getEntityCount() {
        return this._entityCount;
    }

    public List<String> getBgText() {
        this._component.onShow();
        EntityTable table = this._component.getTable();
        PartsTreelistModel model = table.getTreelistModel();
        List sortedFilteredPartIDs = model.getSortedFilteredPartIDs();
        int entityCount = Math.min(15, sortedFilteredPartIDs.size());
        LinkedHashSet entityIDs = new LinkedHashSet(entityCount);
        for (int i = 0; i < entityCount; ++i) {
            entityIDs.add(sortedFilteredPartIDs.get(i));
        }
        EntitySkeletonProvider entitySkeletons = SkeletonProviders.entitiesForGraph((GraphID)model.getGraphID());
        this._component.onHide();
        ArrayList<String> allText = new ArrayList<String>(entityCount);
        try {
            Map entities = entitySkeletons.getEntitySkeletons(entityIDs);
            for (EntityID entityID : entityIDs) {
                allText.add(((MaltegoEntity)entities.get(entityID)).getDisplayString());
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return allText;
    }

    public String getType() {
        return this._type;
    }
}

