/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.view2d.MaltegoGraph2DRenderer;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.util.ColorUtilities;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIManager;
import yguard.A.J.LC;
import yguard.A.J.U;
import yguard.A.J.YA;

public class OverviewFactory {
    public static YA create(GraphID graphID, U view) {
        DynamicLAFOverview overview = new DynamicLAFOverview(view);
        MaltegoGraph2DRenderer maltegoGraph2DRenderer = new MaltegoGraph2DRenderer(view, false);
        maltegoGraph2DRenderer.setGraphID(graphID);
        maltegoGraph2DRenderer.setDrawEdgesFirst(true);
        maltegoGraph2DRenderer.setDrawSelectionOnTop(true);
        overview.setGraph2DRenderer((LC)maltegoGraph2DRenderer);
        overview.updateLAF();
        return overview;
    }

    private static class DynamicLAFOverview
    extends YA {
        private PropertyChangeListener _lookAndFeelListener;

        public DynamicLAFOverview(U gdv) {
            super(gdv);
        }

        public void addNotify() {
            super.addNotify();
            this._lookAndFeelListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    this.updateLAF();
                }
            };
            UIManager.addPropertyChangeListener(this._lookAndFeelListener);
        }

        public void removeNotify() {
            UIManager.removePropertyChangeListener(this._lookAndFeelListener);
            this._lookAndFeelListener = null;
            super.removeNotify();
        }

        public void updateLAF() {
            this.putClientProperty("Overview.AnimateScrollTo", Boolean.TRUE);
            this.putClientProperty("Overview.PaintStyle", "Funky");
            this.putClientProperty("Overview.Inverse", Boolean.TRUE);
            this.putClientProperty("Overview.funkyTheta", 0.8);
            NodeRealizerSettings settings = NodeRealizerSettings.getDefault();
            this.putClientProperty("Overview.BorderColor", settings.getOverviewFogColor());
            Color fog = ColorUtilities.makeTranslucent((Color)settings.getOverviewFogColor(), (int)150);
            this.putClientProperty("Overview.FogColor", fog);
        }
    }
}

