/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.edit;

import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.ui.graph.edit.DetailedEditPanel;
import com.paterva.maltego.ui.graph.edit.NotesSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class NotesPanel
extends JPanel {
    private final PropertyChangeListener _notesListener;
    private PreferenceChangeListener settingsListener;
    private MaltegoPart<? extends Guid> _part;
    private boolean _updatingNotes = false;
    private boolean _updatingWrap = false;
    private JTextArea _notesEditorPane;
    private JLabel _notesLabel;
    private JPanel _notesOuterPanel;
    private JScrollPane _notesScrollPane;
    private JPanel _notesTitlePanel;
    private JToggleButton _wordWrapToggleButton;
    private JPanel northPanel;

    public NotesPanel(MaltegoPart<? extends Guid> part) {
        this._part = part;
        this.initComponents();
        this._wordWrapToggleButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/edit/wrap_text.png", (boolean)true)));
        this._notesEditorPane.setWrapStyleWord(true);
        this._notesEditorPane.setLineWrap(true);
        this._notesEditorPane.setText(part.getNotes());
        this._notesEditorPane.getDocument().addDocumentListener(new NotesDocumentListener());
        this._notesListener = __ -> {
            if (!this._updatingNotes) {
                this._updatingNotes = true;
                this._notesEditorPane.setText(this._part.getNotes());
                this._updatingNotes = false;
            }
        };
        this._part.addNotesListener(WeakListeners.propertyChange((PropertyChangeListener)this._notesListener, this._part));
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        Color panelBg = laf.getColor("summary-view-notes-panels-bg");
        Color panelsFg = laf.getColor("summary-view-notes-panels-fg");
        Color editorBg = laf.getColor("summary-view-notes-editor-bg");
        Color editorFg = laf.getColor("summary-view-notes-editor-fg");
        Font font = laf.getFont("summary-view-notes-editor-font");
        DetailedEditPanel.setPanelColor(this._notesOuterPanel, panelBg);
        this._notesScrollPane.getViewport().setBackground(editorBg);
        this._notesEditorPane.setOpaque(false);
        this._notesEditorPane.setForeground(editorFg);
        this._notesEditorPane.setFont(font);
        this._notesEditorPane.setCaretColor(Color.WHITE);
        this._notesLabel.setForeground(panelsFg);
        this.updateWordWrap();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.settingsListener = __ -> this.updateWordWrap();
        NotesSettings.getInstance().addPreferenceChangeListener(this.settingsListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        NotesSettings.getInstance().removePreferenceChangeListener(this.settingsListener);
        this.settingsListener = null;
    }

    private void updateWordWrap() {
        boolean wordWrap = NotesSettings.getInstance().isWordWrap();
        if (!this._updatingWrap) {
            this._wordWrapToggleButton.setSelected(wordWrap);
        }
        this._notesEditorPane.setWrapStyleWord(wordWrap);
        this._notesEditorPane.setLineWrap(wordWrap);
    }

    private void initComponents() {
        this._notesOuterPanel = new JPanel();
        this._notesScrollPane = new JScrollPane();
        this._notesEditorPane = new JTextArea();
        this.northPanel = new JPanel();
        this._notesTitlePanel = new JPanel();
        this._notesLabel = new JLabel();
        this._wordWrapToggleButton = new JToggleButton();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this._notesOuterPanel.setBorder(BorderFactory.createLineBorder(UIManager.getLookAndFeelDefaults().getColor("darculaMod.borderColor")));
        this._notesOuterPanel.setLayout(new BorderLayout());
        this._notesEditorPane.setColumns(20);
        this._notesEditorPane.setRows(5);
        this._notesScrollPane.setViewportView(this._notesEditorPane);
        this._notesOuterPanel.add((Component)this._notesScrollPane, "Center");
        this.northPanel.setLayout(new BorderLayout());
        this._notesLabel.setFont(UIManager.getLookAndFeelDefaults().getFont("summary-view-notes-font"));
        this._notesLabel.setText(NbBundle.getMessage(NotesPanel.class, (String)"NotesPanel._notesLabel.text"));
        this._notesTitlePanel.add(this._notesLabel);
        this.northPanel.add((Component)this._notesTitlePanel, "Center");
        this._wordWrapToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/ui/graph/edit/wrap_text.png")));
        this._wordWrapToggleButton.setText(NbBundle.getMessage(NotesPanel.class, (String)"NotesPanel._wordWrapToggleButton.text"));
        this._wordWrapToggleButton.setToolTipText(NbBundle.getMessage(NotesPanel.class, (String)"NotesPanel._wordWrapToggleButton.toolTipText"));
        this._wordWrapToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesPanel.this._wordWrapToggleButtonActionPerformed(evt);
            }
        });
        this.northPanel.add((Component)this._wordWrapToggleButton, "East");
        this._notesOuterPanel.add((Component)this.northPanel, "North");
        this.add((Component)this._notesOuterPanel, "Center");
    }

    private void _wordWrapToggleButtonActionPerformed(ActionEvent evt) {
        this._updatingWrap = true;
        NotesSettings.getInstance().setWordWrap(this._wordWrapToggleButton.isSelected());
        this._updatingWrap = false;
    }

    private class NotesDocumentListener
    implements DocumentListener {
        private NotesDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            this.updatePart();
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            this.updatePart();
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
            this.updatePart();
        }

        private void updatePart() {
            if (!NotesPanel.this._updatingNotes) {
                NotesPanel.this._updatingNotes = true;
                NotesPanel.this._part.setNotes(NotesPanel.this._notesEditorPane.getText());
                NotesPanel.this._updatingNotes = false;
            }
        }
    }
}

