c###virtim.for
      SUBROUTINE VIRTIM
C--------------------------------
C
C     THIS ROUTINE EVALUATES TIME VARIATION OF LONG TERM PREDICTION MAPS
C
      COMMON /CON /D2R, DCL, GAMA, PI, PI2, PIO2, R2D, RZ, VOFL
      COMMON / TIME / IT, GMT, UTIME(24), GMTR, XLMT(24), ITIM, JTX
      COMMON / ONE /   IA(6), IB(6), IKIM(10,6), ESLCOF(5,55),
     1                 ESMCOF(7,61), ESUCOF(5,55), F2COF(13,76),
     2                 FM3COF(9,49), ERCOF(9,22)
      REAL*4 COFION(2604)
      EQUIVALENCE(ESLCOF,COFION)
      COMMON / TWO / F2D(16,6,6), P(29,16,8), ABP(2,9), DUD(5,12,5),
     A FAM(14,12), SYS(9,16,6), PERR(9,4,6)
      COMMON /TWO_AB/ AB(318)
      DIMENSION C (8), S (8), IC (6)
C.....START OF EACH TWO DIMENSIONAL ARRAY IN "COFION"
      DATA IC/1,56,117,172,248,297/
      TIME = (15. * GMT - 180.) * D2R
      C (1) = COS (TIME)
      S (1) = SIN (TIME)
      DO 100 JB = 2, 8
      C (JB) = C (1) * C (JB - 1) - S (1) * S (JB - 1)
  100 S (JB) = C (1) * S (JB - 1) + S (1) * C (JB - 1)
C.....FOURIER EXPANSION ON TIME VARIATION
      DO 110 IZ = 1, 6
C.....LIMITS FOR FOURIER EXPANSION
      J = IKIM (10, IZ)
      I = IKIM (9, IZ) + 1
      DO 105 JB = 1, I
C     COFION( 1,JB,IZ)  AND AB(JB,IZ)
C.....CALCULATE SUBSCRIPTS
      ISUBB = IA (IZ) + (JB - 1) * IB (IZ)
      ISUBA = IC (IZ) + JB - 1
      AB (ISUBA) = COFION (ISUBB)
      DO 105 KA = 1, J
C     COFION(2*KA,JB,IZ) AND COFION(2*KA+1,JB,IZ)
C.....CALCULATE SUBSCRIPT
      ISUBC = ISUBB + 2 * KA - 1
C.....ADD FOURIER EXPANSION
105   AB(ISUBA)=AB(ISUBA)+S(KA)*COFION(ISUBC)+C(KA)*COFION(ISUBC+1)
110   CONTINUE
C.....THE 5208 COEFFICIENTS WERE REDUCED TO 2604 BY THE SUNSPOT
C.....NUMBER INTERPOLATION.  THE TIME VARIATION EVALUATION HAS REDUCED
C.....THE NUMBER TO 318.
      RETURN
      END
C--------------------------------
