/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_07 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 2729, "epsg", 2729,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 111E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",111],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2729\"]]");
    p = add_epsg_def_ex (filter, first, last, 2730, "epsg", 2730,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 114E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 114E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",114],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2730\"]]");
    p = add_epsg_def_ex (filter, first, last, 2731, "epsg", 2731,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 117E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",117],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2731\"]]");
    p = add_epsg_def_ex (filter, first, last, 2732, "epsg", 2732,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 120E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 120E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",120],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2732\"]]");
    p = add_epsg_def_ex (filter, first, last, 2733, "epsg", 2733,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 123E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",123],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2733\"]]");
    p = add_epsg_def_ex (filter, first, last, 2734, "epsg", 2734,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 126E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 126E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",126],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2734\"]]");
    p = add_epsg_def_ex (filter, first, last, 2735, "epsg", 2735,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 129E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",129],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2735\"]]");
    p = add_epsg_def_ex (filter, first, last, 2736, "epsg", 2736,
        "Tete / UTM zone 36S", 0, 0,
        "Clarke 1866", "Greenwich",
        "Tete", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +ellps=clrk66 +towgs84=-80,-10");
    add_proj4text (p, 1,
        "0,-228,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tete / UTM zone 36S\",GEOGCS[\"Tete\",DATUM[\"T");
    add_srs_wkt (p, 1,
        "ete\",SPHEROID[\"Clarke 1866\",6378206.4,294.97869821389");
    add_srs_wkt (p, 2,
        "8,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"612");
    add_srs_wkt (p, 3,
        "7\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4127\"]],PROJECTION[\"T");
    add_srs_wkt (p, 6,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"central_meridian\",33],PARAMETER[\"scale_f");
    add_srs_wkt (p, 8,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2736\"]]");
    p = add_epsg_def_ex (filter, first, last, 2737, "epsg", 2737,
        "Tete / UTM zone 37S", 0, 0,
        "Clarke 1866", "Greenwich",
        "Tete", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +south +ellps=clrk66 +towgs84=-80,-10");
    add_proj4text (p, 1,
        "0,-228,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tete / UTM zone 37S\",GEOGCS[\"Tete\",DATUM[\"T");
    add_srs_wkt (p, 1,
        "ete\",SPHEROID[\"Clarke 1866\",6378206.4,294.97869821389");
    add_srs_wkt (p, 2,
        "8,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"612");
    add_srs_wkt (p, 3,
        "7\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4127\"]],PROJECTION[\"T");
    add_srs_wkt (p, 6,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"central_meridian\",39],PARAMETER[\"scale_f");
    add_srs_wkt (p, 8,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2737\"]]");
    p = add_epsg_def_ex (filter, first, last, 2738, "epsg", 2738,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 132E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 132E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",132],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2738\"]]");
    p = add_epsg_def_ex (filter, first, last, 2739, "epsg", 2739,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 135E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",135],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2739\"]]");
    p = add_epsg_def_ex (filter, first, last, 2740, "epsg", 2740,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 138E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 138E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",138],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2740\"]]");
    p = add_epsg_def_ex (filter, first, last, 2741, "epsg", 2741,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 141E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 141E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",141],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2741\"]]");
    p = add_epsg_def_ex (filter, first, last, 2742, "epsg", 2742,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 144E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 144E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",144],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2742\"]]");
    p = add_epsg_def_ex (filter, first, last, 2743, "epsg", 2743,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 147E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 147E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",147],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2743\"]]");
    p = add_epsg_def_ex (filter, first, last, 2744, "epsg", 2744,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 150E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 150E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",150],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2744\"]]");
    p = add_epsg_def_ex (filter, first, last, 2745, "epsg", 2745,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 153E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 153E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",153],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2745\"]]");
    p = add_epsg_def_ex (filter, first, last, 2746, "epsg", 2746,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 156E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 156E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",156],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2746\"]]");
    p = add_epsg_def_ex (filter, first, last, 2747, "epsg", 2747,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 159E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 159E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",159],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2747\"]]");
    p = add_epsg_def_ex (filter, first, last, 2748, "epsg", 2748,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 162E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 162E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",162],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2748\"]]");
    p = add_epsg_def_ex (filter, first, last, 2749, "epsg", 2749,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 165E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 165E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",165],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2749\"]]");
    p = add_epsg_def_ex (filter, first, last, 2750, "epsg", 2750,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 168E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 168E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",168],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2750\"]]");
    p = add_epsg_def_ex (filter, first, last, 2751, "epsg", 2751,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 171E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 171E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",171],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2751\"]]");
    p = add_epsg_def_ex (filter, first, last, 2752, "epsg", 2752,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 174E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 174E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",174],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2752\"]]");
    p = add_epsg_def_ex (filter, first, last, 2753, "epsg", 2753,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 177E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 177E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",177],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2753\"]]");
    p = add_epsg_def_ex (filter, first, last, 2754, "epsg", 2754,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 180E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 180E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",180],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2754\"]]");
    p = add_epsg_def_ex (filter, first, last, 2755, "epsg", 2755,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 177W", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 177W\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-177],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2755\"]]");
    p = add_epsg_def_ex (filter, first, last, 2756, "epsg", 2756,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 174W", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 174W\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-174],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2756\"]]");
    p = add_epsg_def_ex (filter, first, last, 2757, "epsg", 2757,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 171W", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 171W\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-171],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2757\"]]");
    p = add_epsg_def_ex (filter, first, last, 2758, "epsg", 2758,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 168W", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 168W\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-168],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2758\"]]");
    p = add_epsg_def_ex (filter, first, last, 2759, "epsg", 2759,
        "NAD83(HARN) / Alabama East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9996 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Alabama East\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",30.5],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-85.8333333333333],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.99996],PARAMETER[\"false_easting\",200000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2759\"]]");
    p = add_epsg_def_ex (filter, first, last, 2760, "epsg", 2760,
        "NAD83(HARN) / Alabama West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=6");
    add_proj4text (p, 1,
        "00000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Alabama West\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",30],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-87.5],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "33333],PARAMETER[\"false_easting\",600000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"2760\"]]");
    p = add_epsg_def_ex (filter, first, last, 2761, "epsg", 2761,
        "NAD83(HARN) / Arizona East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Arizona East\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-110.166666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9999],PARAMETER[\"false_easting\",213360],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"2761\"]]");
    p = add_epsg_def_ex (filter, first, last, 2762, "epsg", 2762,
        "NAD83(HARN) / Arizona Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Arizona Central\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-111.916666666667],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.9999],PARAMETER[\"false_easting\",213360],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2762\"]]");
    p = add_epsg_def_ex (filter, first, last, 2763, "epsg", 2763,
        "NAD83(HARN) / Arizona West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Arizona West\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-113.75],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "9933333],PARAMETER[\"false_easting\",213360],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"2763\"]]");
    p = add_epsg_def_ex (filter, first, last, 2764, "epsg", 2764,
        "NAD83(HARN) / Arkansas North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Arkansas North\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",34.33333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-92],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",36.2333333333333],PARAMETER[\"st");
    add_srs_wkt (p, 10,
        "andard_parallel_2\",34.9333333333333],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",400000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"276");
    add_srs_wkt (p, 14,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 2765, "epsg", 2765,
        "NAD83(HARN) / Arkansas South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Arkansas South\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",32.66666");
    add_srs_wkt (p, 8,
        "66666667],PARAMETER[\"central_meridian\",-92],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",34.7666666666667],PARAMETER[\"st");
    add_srs_wkt (p, 10,
        "andard_parallel_2\",33.3],PARAMETER[\"false_easting\",40");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",400000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2765\"]]");
    p = add_epsg_def_ex (filter, first, last, 2766, "epsg", 2766,
        "NAD83(HARN) / California zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California zone 1\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",39.33333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-122],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",41.6666666666667],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",40],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",500000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2766\"]]");
    p = add_epsg_def_ex (filter, first, last, 2767, "epsg", 2767,
        "NAD83(HARN) / California zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y");
    add_proj4text (p, 2,
        "_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California zone 2\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",37.66666");
    add_srs_wkt (p, 8,
        "66666667],PARAMETER[\"central_meridian\",-122],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",39.8333333333333],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",38.3333333333333],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",2000000],PARAMETER[\"false_northing\",500000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"2767\"]]");
    p = add_epsg_def_ex (filter, first, last, 2768, "epsg", 2768,
        "NAD83(HARN) / California zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California zone 3\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",36.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-120.5],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_1\",38.4333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",37.0666666666667],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",500000],UNIT[\"me");
    add_srs_wkt (p, 12,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2768\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2769, "epsg", 2769,
        "NAD83(HARN) / California zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California zone 4\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",35.33333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-119],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",37.25],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",36],PARAMETER[\"false_easting\",2000000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",500000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"2769\"]]");
    p = add_epsg_def_ex (filter, first, last, 2770, "epsg", 2770,
        "NAD83(HARN) / California zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California zone 5\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",33.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-118],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_1\",35.4666666666667],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_2\",34.0333333333333],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 11,
        "000000],PARAMETER[\"false_northing\",500000],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2770\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2771, "epsg", 2771,
        "NAD83(HARN) / California zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000");
    add_proj4text (p, 2,
        " +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California zone 6\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",32.16666");
    add_srs_wkt (p, 8,
        "66666667],PARAMETER[\"central_meridian\",-116.25],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",33.8833333333333],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_2\",32.7833333333333],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",2000000],PARAMETER[\"false_northing\",5000");
    add_srs_wkt (p, 12,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"2771\"]]");
    p = add_epsg_def_ex (filter, first, last, 2772, "epsg", 2772,
        "NAD83(HARN) / Colorado North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 3,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Colorado North\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",39.33333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-105.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",40.7833333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",39.7166666666667],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",914401.8289],PARAMETER[\"false_northing\",30");
    add_srs_wkt (p, 12,
        "4800.6096],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"2772\"]]");
    p = add_epsg_def_ex (filter, first, last, 2773, "epsg", 2773,
        "NAD83(HARN) / Colorado Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Colorado Central\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",37.83333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-105.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",39.75],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_2\",38.45],PARAMETER[\"false_easting\",914401.82");
    add_srs_wkt (p, 11,
        "89],PARAMETER[\"false_northing\",304800.6096],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2773\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2774, "epsg", 2774,
        "NAD83(HARN) / Colorado South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 3,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Colorado South\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",36.66666");
    add_srs_wkt (p, 8,
        "66666667],PARAMETER[\"central_meridian\",-105.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",38.4333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",37.2333333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",914401.8289],PARAMETER[\"false_northing\",30");
    add_srs_wkt (p, 12,
        "4800.6096],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"2774\"]]");
    p = add_epsg_def_ex (filter, first, last, 2775, "epsg", 2775,
        "NAD83(HARN) / Connecticut", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=1524");
    add_proj4text (p, 2,
        "00.3048 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Connecticut\",GEOGCS[\"NAD83(HARN");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_2SP\"],PARAMETER[\"latitude_of_origin\",40.83333333");
    add_srs_wkt (p, 8,
        "33333],PARAMETER[\"central_meridian\",-72.75],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",41.8666666666667],PARAMETER[\"st");
    add_srs_wkt (p, 10,
        "andard_parallel_2\",41.2],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 11,
        "4800.6096],PARAMETER[\"false_northing\",152400.3048],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "2775\"]]");
    p = add_epsg_def_ex (filter, first, last, 2776, "epsg", 2776,
        "NAD83(HARN) / Delaware", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Delaware\",GEOGCS[\"NAD83(HARN)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",38],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-75.4166666666667],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.999995],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"2776\"]]");
    p = add_epsg_def_ex (filter, first, last, 2777, "epsg", 2777,
        "NAD83(HARN) / Florida East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Florida East\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",24.3333333333333],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-81],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.999941177],PARAMETER[\"false_easting\",200000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2777\"]]");
    p = add_epsg_def_ex (filter, first, last, 2778, "epsg", 2778,
        "NAD83(HARN) / Florida West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Florida West\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",24.3333333333333],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-82],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.999941177],PARAMETER[\"false_easting\",200000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2778\"]]");
    p = add_epsg_def_ex (filter, first, last, 2779, "epsg", 2779,
        "NAD83(HARN) / Florida North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
        "9 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Florida North\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",29],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-84.5],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",30.75],PARAMETER[\"standard_parallel_2\",29.5");
    add_srs_wkt (p, 10,
        "833333333333],PARAMETER[\"false_easting\",600000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"2779\"]]");
    p = add_epsg_def_ex (filter, first, last, 2780, "epsg", 2780,
        "NAD83(HARN) / Georgia East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Georgia East\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",30],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-82.1666666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9999],PARAMETER[\"false_easting\",200000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"2780\"]]");
    p = add_epsg_def_ex (filter, first, last, 2781, "epsg", 2781,
        "NAD83(HARN) / Georgia West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Georgia West\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",30],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-84.1666666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9999],PARAMETER[\"false_easting\",700000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"2781\"]]");
    p = add_epsg_def_ex (filter, first, last, 2782, "epsg", 2782,
        "NAD83(HARN) / Hawaii zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.");
    add_proj4text (p, 1,
        "999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 2,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Hawaii zone 1\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",18.8333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-155.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.999966667],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2782\"]]");
    p = add_epsg_def_ex (filter, first, last, 2783, "epsg", 2783,
        "NAD83(HARN) / Hawaii zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Hawaii zone 2\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",20.3333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-156.666666666667],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999966667],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2783\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2784, "epsg", 2784,
        "NAD83(HARN) / Hawaii zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99");
    add_proj4text (p, 1,
        "999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Hawaii zone 3\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",21.1666666666667]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-158],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.99999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"2784\"]]");
    p = add_epsg_def_ex (filter, first, last, 2785, "epsg", 2785,
        "NAD83(HARN) / Hawaii zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.");
    add_proj4text (p, 1,
        "99999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Hawaii zone 4\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",21.8333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-159.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.99999],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"2785\"]]");
    p = add_epsg_def_ex (filter, first, last, 2786, "epsg", 2786,
        "NAD83(HARN) / Hawaii zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 2,
        ",0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Hawaii zone 5\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",21.6666666666667]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-160.166666666667],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2786\"]]");
    p = add_epsg_def_ex (filter, first, last, 2787, "epsg", 2787,
        "NAD83(HARN) / Idaho East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Idaho East\",GEOGCS[\"NAD83(HARN)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",41.6666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-112.166666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.999947368],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2787\"]]");
    p = add_epsg_def_ex (filter, first, last, 2788, "epsg", 2788,
        "NAD83(HARN) / Idaho Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
        "99473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Idaho Central\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",41.6666666666667]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-114],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999947368],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2788\"]]");
    p = add_epsg_def_ex (filter, first, last, 2789, "epsg", 2789,
        "NAD83(HARN) / Idaho West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0");
    add_proj4text (p, 1,
        ".999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Idaho West\",GEOGCS[\"NAD83(HARN)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",41.6666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-115.75],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.999933333],PARAMETER[\"false_easting\",800000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2789\"]]");
    p = add_epsg_def_ex (filter, first, last, 2790, "epsg", 2790,
        "NAD83(HARN) / Illinois East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Illinois East\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",36.6666666666667]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-88.3333333333333],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999975],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",300000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2790\"]]");
    p = add_epsg_def_ex (filter, first, last, 2791, "epsg", 2791,
        "NAD83(HARN) / Illinois West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Illinois West\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",36.6666666666667]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-90.1666666666667],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999941177],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",700000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2791\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2792, "epsg", 2792,
        "NAD83(HARN) / Indiana East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Indiana East\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",37.5],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-85.6666666666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.999966667],PARAMETER[\"false_easting\",100000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",250000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2792\"]]");
    p = add_epsg_def_ex (filter, first, last, 2793, "epsg", 2793,
        "NAD83(HARN) / Indiana West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Indiana West\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",37.5],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-87.0833333333333],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.999966667],PARAMETER[\"false_easting\",900000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",250000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2793\"]]");
    p = add_epsg_def_ex (filter, first, last, 2794, "epsg", 2794,
        "NAD83(HARN) / Iowa North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Iowa North\",GEOGCS[\"NAD83(HARN)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",41.5],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-93.5],PARAMETER[\"standard_para");
    add_srs_wkt (p, 9,
        "llel_1\",43.2666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 10,
        "_2\",42.0666666666667],PARAMETER[\"false_easting\",15000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2794\"]]");
    p = add_epsg_def_ex (filter, first, last, 2795, "epsg", 2795,
        "NAD83(HARN) / Iowa South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Iowa South\",GEOGCS[\"NAD83(HARN)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",40],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-93.5],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",41.7833333333333],PARAMETER[\"standard_parallel_2");
    add_srs_wkt (p, 10,
        "\",40.6166666666667],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2795\"]]");
    p = add_epsg_def_ex (filter, first, last, 2796, "epsg", 2796,
        "NAD83(HARN) / Kansas North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Kansas North\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_2SP\"],PARAMETER[\"latitude_of_origin\",38.33333333");
    add_srs_wkt (p, 8,
        "33333],PARAMETER[\"central_meridian\",-98],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_1\",39.7833333333333],PARAMETER[\"stand");
    add_srs_wkt (p, 10,
        "ard_parallel_2\",38.7166666666667],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",400000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 12,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2796\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2797, "epsg", 2797,
        "NAD83(HARN) / Kansas South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y");
    add_proj4text (p, 2,
        "_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Kansas South\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_2SP\"],PARAMETER[\"latitude_of_origin\",36.66666666");
    add_srs_wkt (p, 8,
        "66667],PARAMETER[\"central_meridian\",-98.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",38.5666666666667],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",37.2666666666667],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",400000],PARAMETER[\"false_northing\",400000],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "2797\"]]");
    p = add_epsg_def_ex (filter, first, last, 2798, "epsg", 2798,
        "NAD83(HARN) / Kentucky North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Kentucky North\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",37.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-84.25],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_1\",37.9666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",38.9666666666667],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2798\"]]");
    p = add_epsg_def_ex (filter, first, last, 2799, "epsg", 2799,
        "NAD83(HARN) / Kentucky South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000 +");
    add_proj4text (p, 2,
        "y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Kentucky South\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",36.33333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-85.75],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",37.9333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",36.7333333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",500000],PARAMETER[\"false_northing\",500000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"2799\"]]");
    p = add_epsg_def_ex (filter, first, last, 2800, "epsg", 2800,
        "NAD83(HARN) / Louisiana North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=30.5 +lon_0=-92.5 +x_0=1000000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Louisiana North\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",30.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-92.5],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",32.6666666666667],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",31.1666666666667],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "1000000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2800\"]]");
    p = add_epsg_def_ex (filter, first, last, 2801, "epsg", 2801,
        "NAD83(HARN) / Louisiana South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91");
    add_proj4text (p, 1,
        ".33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Louisiana South\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",28.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-91.3333333333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_1\",30.7],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",29.3],PARAMETER[\"false_easting\",1000000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2801\"]]");
    p = add_epsg_def_ex (filter, first, last, 2802, "epsg", 2802,
        "NAD83(HARN) / Maine East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine East\",GEOGCS[\"NAD83(HARN)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",43.6666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-68.5],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9999],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"2802\"]]");
    p = add_epsg_def_ex (filter, first, last, 2803, "epsg", 2803,
        "NAD83(HARN) / Maine West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine West\",GEOGCS[\"NAD83(HARN)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",42.8333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-70.1666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.999966667],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",900000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2803\"]]");
    p = add_epsg_def_ex (filter, first, last, 2804, "epsg", 2804,
        "NAD83(HARN) / Maryland", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-77 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maryland\",GEOGCS[\"NAD83(HARN)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 7,
        "c_2SP\"],PARAMETER[\"latitude_of_origin\",37.66666666666");
    add_srs_wkt (p, 8,
        "67],PARAMETER[\"central_meridian\",-77],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_1\",39.45],PARAMETER[\"standard_parallel_2");
    add_srs_wkt (p, 10,
        "\",38.3],PARAMETER[\"false_easting\",400000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"2804\"]]");
    p = add_epsg_def_ex (filter, first, last, 2805, "epsg", 2805,
        "NAD83(HARN) / Massachusetts Mainland", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41 +lon_0=-71.5 +x_0=200000 +y_0=750000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Massachusetts Mainland\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",41");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-71.5],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_1\",42.6833333333333],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_2\",41.7166666666667],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",200000],PARAMETER[\"false_northing\",750000],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"280");
    add_srs_wkt (p, 14,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 2806, "epsg", 2806,
        "NAD83(HARN) / Massachusetts Island", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-70.5 +x_0=500000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Massachusetts Island\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",41]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-70.5],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",41.4833333333333],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",41.2833333333333],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2806\"]]");
    p = add_epsg_def_ex (filter, first, last, 2807, "epsg", 2807,
        "NAD83(HARN) / Michigan North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=8000000 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Michigan North\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",44.78333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-87],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",47.0833333333333],PARAMETER[\"st");
    add_srs_wkt (p, 10,
        "andard_parallel_2\",45.4833333333333],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",8000000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 12,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 14,
        "807\"]]");
    p = add_epsg_def_ex (filter, first, last, 2808, "epsg", 2808,
        "NAD83(HARN) / Michigan Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43");
    add_proj4text (p, 1,
        ".31666666666667 +lon_0=-84.36666666666666 +x_0=6000000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Michigan Central\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",43.31666");
    add_srs_wkt (p, 8,
        "66666667],PARAMETER[\"central_meridian\",-84.36666666666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"standard_parallel_1\",45.7],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",44.1833333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",6000000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "2808\"]]");
    p = add_epsg_def_ex (filter, first, last, 2809, "epsg", 2809,
        "NAD83(HARN) / Michigan South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41");
    add_proj4text (p, 1,
        ".5 +lon_0=-84.36666666666666 +x_0=4000000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Michigan South\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",41.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-84.3666666666667],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_1\",43.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",42.1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "4000000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2809\"]]");
    p = add_epsg_def_ex (filter, first, last, 2810, "epsg", 2810,
        "NAD83(HARN) / Minnesota North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000 +y");
    add_proj4text (p, 2,
        "_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota North\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",46.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-93.1],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",48.6333333333333],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",47.0333333333333],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "800000],PARAMETER[\"false_northing\",100000],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2810\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2811, "epsg", 2811,
        "NAD83(HARN) / Minnesota Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000 +y_0=100000 +ellps=GRS80 +to");
    add_proj4text (p, 2,
        "wgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota Central\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",45],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-94.25],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_1\",47.05],PARAMETER[\"standard_parallel_2\",45");
    add_srs_wkt (p, 10,
        ".6166666666667],PARAMETER[\"false_easting\",800000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",100000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2811\"]]");
    p = add_epsg_def_ex (filter, first, last, 2812, "epsg", 2812,
        "NAD83(HARN) / Minnesota South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000 +y_0=100000 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota South\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",43],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-94],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_1\",45.2166666666667],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",43.7833333333333],PARAMETER[\"false_easting\",8000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",100000],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2812\"]]");
    p = add_epsg_def_ex (filter, first, last, 2813, "epsg", 2813,
        "NAD83(HARN) / Mississippi East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9995 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Mississippi East\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",29.5],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-88.8333333333333],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.99995],PARAMETER[\"false_easting\",300000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"2813\"]]");
    p = add_epsg_def_ex (filter, first, last, 2814, "epsg", 2814,
        "NAD83(HARN) / Mississippi West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9995 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Mississippi West\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",29.5],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-90.3333333333333],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.99995],PARAMETER[\"false_easting\",700000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"2814\"]]");
    p = add_epsg_def_ex (filter, first, last, 2815, "epsg", 2815,
        "NAD83(HARN) / Missouri East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Missouri East\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",35.8333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-90.5],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.999933333],PARAMETER[\"false_easting\",25000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2815\"]]");
    p = add_epsg_def_ex (filter, first, last, 2816, "epsg", 2816,
        "NAD83(HARN) / Missouri Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Missouri Central\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",35.8333333333333");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-92.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.999933333],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2816\"]]");
    p = add_epsg_def_ex (filter, first, last, 2817, "epsg", 2817,
        "NAD83(HARN) / Missouri West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.9");
    add_proj4text (p, 1,
        "99941177 +x_0=850000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Missouri West\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",36.1666666666667]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-94.5],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.999941177],PARAMETER[\"false_easting\",85000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2817\"]]");
    p = add_epsg_def_ex (filter, first, last, 2818, "epsg", 2818,
        "NAD83(HARN) / Montana", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5");
    add_proj4text (p, 1,
        " +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Montana\",GEOGCS[\"NAD83(HARN)\",");
    add_srs_wkt (p, 1,
        "DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"latitude_of_origin\",44.25],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-109.5],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",49],PARAMETER[\"standard_parallel_2\",45],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",600000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"2818\"]]");
    p = add_epsg_def_ex (filter, first, last, 2819, "epsg", 2819,
        "NAD83(HARN) / Nebraska", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nebraska\",GEOGCS[\"NAD83(HARN)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 7,
        "c_2SP\"],PARAMETER[\"latitude_of_origin\",39.83333333333");
    add_srs_wkt (p, 8,
        "33],PARAMETER[\"central_meridian\",-100],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",43],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",40],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"2819\"]]");
    p = add_epsg_def_ex (filter, first, last, 2820, "epsg", 2820,
        "NAD83(HARN) / Nevada East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=200000 +y_0=8000000 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nevada East\",GEOGCS[\"NAD83(HARN");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",34.75],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-115.583333333333],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.9999],PARAMETER[\"false_easting\",200000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",8000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2820\"]]");
    p = add_epsg_def_ex (filter, first, last, 2821, "epsg", 2821,
        "NAD83(HARN) / Nevada Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nevada Central\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",34.75],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-116.666666666667],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",6000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2821\"]]");
    p = add_epsg_def_ex (filter, first, last, 2822, "epsg", 2822,
        "NAD83(HARN) / Nevada West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=800000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nevada West\",GEOGCS[\"NAD83(HARN");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",34.75],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-118.583333333333],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.9999],PARAMETER[\"false_easting\",800000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",4000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2822\"]]");
    p = add_epsg_def_ex (filter, first, last, 2823, "epsg", 2823,
        "NAD83(HARN) / New Hampshire", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New Hampshire\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",42.5],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-71.6666666666667],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999966667],PARAMETER[\"false_easting\",300000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2823\"]]");
    p = add_epsg_def_ex (filter, first, last, 2824, "epsg", 2824,
        "NAD83(HARN) / New Jersey", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New Jersey\",GEOGCS[\"NAD83(HARN)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",38.8333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-74.5],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9999],PARAMETER[\"false_easting\",150000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"2824\"]]");
    p = add_epsg_def_ex (filter, first, last, 2825, "epsg", 2825,
        "NAD83(HARN) / New Mexico East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999");
    add_proj4text (p, 1,
        "909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New Mexico East\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-104.333333333333],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999909091],PARAMETER[\"false_easting\",165000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2825\"]]");
    p = add_epsg_def_ex (filter, first, last, 2826, "epsg", 2826,
        "NAD83(HARN) / New Mexico Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=5000");
    add_proj4text (p, 1,
        "00 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New Mexico Central\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",31],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-106.25],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9999],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"2826\"]]");
    p = add_epsg_def_ex (filter, first, last, 2827, "epsg", 2827,
        "NAD83(HARN) / New Mexico West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999");
    add_proj4text (p, 1,
        "916667 +x_0=830000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New Mexico West\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-107.833333333333],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999916667],PARAMETER[\"false_easting\",830000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2827\"]]");
    p = add_epsg_def_ex (filter, first, last, 2828, "epsg", 2828,
        "NAD83(HARN) / New York East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New York East\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",38.8333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-74.5],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",150000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"2828\"]]");
    p = add_epsg_def_ex (filter, first, last, 2829, "epsg", 2829,
        "NAD83(HARN) / New York Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New York Central\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",40],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-76.5833333333333],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.9999375],PARAMETER[\"false_easting\",250000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"2829\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

