#version 330

in vec3       Normal;
in vec3       nor;
in vec3       vert;
flat in int   _style;
flat in int   _an;
in float _ph;
flat in int   _sg;
flat in float _part;

uniform vec3  lightPos=vec3(1,1,1);
uniform float pmax =1.0;
uniform float pmin =0.0;
uniform float lmin =-2;
uniform float lmax = 2;
uniform vec3  atomColors[109];
uniform mat4  pmv;
uniform mat3  normalMatrix;
uniform float fiftypct=1.54;
uniform vec4  eye;
uniform bool  QPeakLegend = true;
uniform vec4  Qolor;
uniform bool hidePM1 = false;
uniform bool highlightParts = false;
uniform bool highlightEquivalents = false;
uniform int LOD = 2;

layout( location = 0 ) out vec4 fragColor;

#define HAS_WALLS 1
#define HAS_RINGS 2
#define HAS_SPHERE 4
#define IS_SOLID 8
#define HAS_WHITERING 16
#define HAS_NOLABEL 32
#define HAS_NOADP 64
#define HAS_PLAID 128
#define IS_METAL 256
#define IS_HIDDEN 512
#define IS_DEUTERIUM 1024
#define IS_ISO 2048

vec3 partColor(int part){
  const vec3 pc[] = vec3[199](
    vec3(1.000000, 0.000000, 1.000000), //part -99
    vec3(0.862745, 0.862745, 0.862745), //part -98
    vec3(0.972549, 0.972549, 1.000000), //part -97
    vec3(1.000000, 0.843137, 0.000000), //part -96
    vec3(0.854902, 0.647059, 0.125490), //part -95
    vec3(0.501961, 0.501961, 0.501961), //part -94
    vec3(0.000000, 0.501961, 0.000000), //part -93
    vec3(0.678431, 1.000000, 0.184314), //part -92
    vec3(0.501961, 0.501961, 0.501961), //part -91
    vec3(0.941176, 1.000000, 0.941176), //part -90
    vec3(1.000000, 0.411765, 0.705882), //part -89
    vec3(0.803922, 0.360784, 0.360784), //part -88
    vec3(0.294118, 0.000000, 0.509804), //part -87
    vec3(1.000000, 1.000000, 0.941176), //part -86
    vec3(0.941176, 0.901961, 0.549020), //part -85
    vec3(0.901961, 0.901961, 0.980392), //part -84
    vec3(1.000000, 0.941176, 0.960784), //part -83
    vec3(0.486275, 0.988235, 0.000000), //part -82
    vec3(1.000000, 0.980392, 0.803922), //part -81
    vec3(0.678431, 0.847059, 0.901961), //part -80
    vec3(0.941176, 0.501961, 0.501961), //part -79
    vec3(0.878431, 1.000000, 1.000000), //part -78
    vec3(0.980392, 0.980392, 0.823529), //part -77
    vec3(0.827451, 0.827451, 0.827451), //part -76
    vec3(0.564706, 0.933333, 0.564706), //part -75
    vec3(0.827451, 0.827451, 0.827451), //part -74
    vec3(1.000000, 0.713726, 0.756863), //part -73
    vec3(1.000000, 0.627451, 0.478431), //part -72
    vec3(0.125490, 0.698039, 0.666667), //part -71
    vec3(0.529412, 0.807843, 0.980392), //part -70
    vec3(0.466667, 0.533333, 0.600000), //part -69
    vec3(0.466667, 0.533333, 0.600000), //part -68
    vec3(0.690196, 0.768627, 0.870588), //part -67
    vec3(1.000000, 1.000000, 0.878431), //part -66
    vec3(0.000000, 1.000000, 0.000000), //part -65
    vec3(0.196078, 0.803922, 0.196078), //part -64
    vec3(0.980392, 0.941176, 0.901961), //part -63
    vec3(1.000000, 0.000000, 1.000000), //part -62
    vec3(0.501961, 0.000000, 0.000000), //part -61
    vec3(0.400000, 0.803922, 0.666667), //part -60
    vec3(0.000000, 0.000000, 0.803922), //part -59
    vec3(0.729412, 0.333333, 0.827451), //part -58
    vec3(0.576471, 0.439216, 0.858824), //part -57
    vec3(0.235294, 0.701961, 0.443137), //part -56
    vec3(0.482353, 0.407843, 0.933333), //part -55
    vec3(0.000000, 0.980392, 0.603922), //part -54
    vec3(0.282353, 0.819608, 0.800000), //part -53
    vec3(0.780392, 0.082353, 0.521569), //part -52
    vec3(0.098039, 0.098039, 0.439216), //part -51
    vec3(0.960784, 1.000000, 0.980392), //part -50
    vec3(1.000000, 0.894118, 0.882353), //part -49
    vec3(1.000000, 0.894118, 0.709804), //part -48
    vec3(1.000000, 0.870588, 0.678431), //part -47
    vec3(0.000000, 0.000000, 0.501961), //part -46
    vec3(0.992157, 0.960784, 0.901961), //part -45
    vec3(0.501961, 0.501961, 0.000000), //part -44
    vec3(0.419608, 0.556863, 0.137255), //part -43
    vec3(1.000000, 0.647059, 0.000000), //part -42
    vec3(1.000000, 0.270588, 0.000000), //part -41
    vec3(0.854902, 0.439216, 0.839216), //part -40
    vec3(0.933333, 0.909804, 0.666667), //part -39
    vec3(0.596078, 0.984314, 0.596078), //part -38
    vec3(0.686275, 0.933333, 0.933333), //part -37
    vec3(0.858824, 0.439216, 0.576471), //part -36
    vec3(1.000000, 0.937255, 0.835294), //part -35
    vec3(1.000000, 0.854902, 0.725490), //part -34
    vec3(0.803922, 0.521569, 0.247059), //part -33
    vec3(1.000000, 0.752941, 0.796078), //part -32
    vec3(0.866667, 0.627451, 0.866667), //part -31
    vec3(0.690196, 0.878431, 0.901961), //part -30
    vec3(0.501961, 0.000000, 0.501961), //part -29
    vec3(1.000000, 0.000000, 0.000000), //part -28
    vec3(0.737255, 0.560784, 0.560784), //part -27
    vec3(0.254902, 0.411765, 0.882353), //part -26
    vec3(0.545098, 0.270588, 0.074510), //part -25
    vec3(0.980392, 0.501961, 0.447059), //part -24
    vec3(0.956863, 0.643137, 0.376471), //part -23
    vec3(0.180392, 0.545098, 0.341176), //part -22
    vec3(1.000000, 0.960784, 0.933333), //part -21
    vec3(0.627451, 0.321569, 0.176471), //part -20
    vec3(0.752941, 0.752941, 0.752941), //part -19
    vec3(0.529412, 0.807843, 0.921569), //part -18
    vec3(0.415686, 0.352941, 0.803922), //part -17
    vec3(0.439216, 0.501961, 0.564706), //part -16
    vec3(0.439216, 0.501961, 0.564706), //part -15
    vec3(1.000000, 0.980392, 0.980392), //part -14
    vec3(0.000000, 1.000000, 0.498039), //part -13
    vec3(0.274510, 0.509804, 0.705882), //part -12
    vec3(0.823529, 0.705882, 0.549020), //part -11
    vec3(0.000000, 0.501961, 0.501961), //part -10
    vec3(0.847059, 0.749020, 0.847059), //part -9
    vec3(1.000000, 0.388235, 0.278431), //part -8
    vec3(0.000000, 0.000000, 0.000000), //part -7
    vec3(0.250980, 0.878431, 0.815686), //part -6
    vec3(0.933333, 0.509804, 0.933333), //part -5
    vec3(0.960784, 0.870588, 0.701961), //part -4
    vec3(1.000000, 0.894118, 0.768627), //part -3
    vec3(0.501961, 0.501961, 0.000000), //part -2
    vec3(0.498039, 1.000000, 0.831373), //part -1
    vec3(0.980392, 0.980392, 0.980392), //part 0
    vec3(0.529412, 0.807843, 0.980392), //part 1
    vec3(0.721569, 0.525490, 0.043137), //part 2
    vec3(0.000000, 0.501961, 0.000000), //part 3
    vec3(1.000000, 1.000000, 0.000000), //part 4
    vec3(1.000000, 0.647059, 0.000000), //part 5
    vec3(0.000000, 0.000000, 0.000000), //part 6
    vec3(1.000000, 0.627451, 0.478431), //part 7
    vec3(0.125490, 0.698039, 0.666667), //part 8
    vec3(0.000000, 0.000000, 1.000000), //part 9
    vec3(0.541176, 0.168627, 0.886275), //part 10
    vec3(0.647059, 0.164706, 0.164706), //part 11
    vec3(0.870588, 0.721569, 0.529412), //part 12
    vec3(0.372549, 0.619608, 0.627451), //part 13
    vec3(0.498039, 1.000000, 0.000000), //part 14
    vec3(0.823529, 0.411765, 0.117647), //part 15
    vec3(1.000000, 0.498039, 0.313726), //part 16
    vec3(0.392157, 0.584314, 0.929412), //part 17
    vec3(1.000000, 0.972549, 0.862745), //part 18
    vec3(0.862745, 0.078431, 0.235294), //part 19
    vec3(0.000000, 1.000000, 1.000000), //part 20
    vec3(0.000000, 0.000000, 0.545098), //part 21
    vec3(0.000000, 0.545098, 0.545098), //part 22
    vec3(0.721569, 0.525490, 0.043137), //part 23
    vec3(0.662745, 0.662745, 0.662745), //part 24
    vec3(0.000000, 0.392157, 0.000000), //part 25
    vec3(0.662745, 0.662745, 0.662745), //part 26
    vec3(0.741176, 0.717647, 0.419608), //part 27
    vec3(0.545098, 0.000000, 0.545098), //part 28
    vec3(0.333333, 0.419608, 0.184314), //part 29
    vec3(1.000000, 0.549020, 0.000000), //part 30
    vec3(0.600000, 0.196078, 0.800000), //part 31
    vec3(0.545098, 0.000000, 0.000000), //part 32
    vec3(0.913725, 0.588235, 0.478431), //part 33
    vec3(0.560784, 0.737255, 0.560784), //part 34
    vec3(0.282353, 0.239216, 0.545098), //part 35
    vec3(0.184314, 0.309804, 0.309804), //part 36
    vec3(0.184314, 0.309804, 0.309804), //part 37
    vec3(0.000000, 0.807843, 0.819608), //part 38
    vec3(0.580392, 0.000000, 0.827451), //part 39
    vec3(1.000000, 0.078431, 0.576471), //part 40
    vec3(0.000000, 0.749020, 1.000000), //part 41
    vec3(0.411765, 0.411765, 0.411765), //part 42
    vec3(0.411765, 0.411765, 0.411765), //part 43
    vec3(0.117647, 0.564706, 1.000000), //part 44
    vec3(0.698039, 0.133333, 0.133333), //part 45
    vec3(1.000000, 0.980392, 0.941176), //part 46
    vec3(0.133333, 0.545098, 0.133333), //part 47
    vec3(1.000000, 0.000000, 1.000000), //part 48
    vec3(0.862745, 0.862745, 0.862745), //part 49
    vec3(0.972549, 0.972549, 1.000000), //part 50
    vec3(1.000000, 0.843137, 0.000000), //part 51
    vec3(0.854902, 0.647059, 0.125490), //part 52
    vec3(0.501961, 0.501961, 0.501961), //part 53
    vec3(0.000000, 0.501961, 0.000000), //part 54
    vec3(0.678431, 1.000000, 0.184314), //part 55
    vec3(0.501961, 0.501961, 0.501961), //part 56
    vec3(0.941176, 1.000000, 0.941176), //part 57
    vec3(1.000000, 0.411765, 0.705882), //part 58
    vec3(0.803922, 0.360784, 0.360784), //part 59
    vec3(0.294118, 0.000000, 0.509804), //part 60
    vec3(1.000000, 1.000000, 0.941176), //part 61
    vec3(0.941176, 0.901961, 0.549020), //part 62
    vec3(0.901961, 0.901961, 0.980392), //part 63
    vec3(1.000000, 0.941176, 0.960784), //part 64
    vec3(0.486275, 0.988235, 0.000000), //part 65
    vec3(1.000000, 0.980392, 0.803922), //part 66
    vec3(0.678431, 0.847059, 0.901961), //part 67
    vec3(0.941176, 0.501961, 0.501961), //part 68
    vec3(0.878431, 1.000000, 1.000000), //part 69
    vec3(0.980392, 0.980392, 0.823529), //part 70
    vec3(0.827451, 0.827451, 0.827451), //part 71
    vec3(0.564706, 0.933333, 0.564706), //part 72
    vec3(0.827451, 0.827451, 0.827451), //part 73
    vec3(1.000000, 0.713726, 0.756863), //part 74
    vec3(1.000000, 0.627451, 0.478431), //part 75
    vec3(0.125490, 0.698039, 0.666667), //part 76
    vec3(0.529412, 0.807843, 0.980392), //part 77
    vec3(0.466667, 0.533333, 0.600000), //part 78
    vec3(0.466667, 0.533333, 0.600000), //part 79
    vec3(0.690196, 0.768627, 0.870588), //part 80
    vec3(1.000000, 1.000000, 0.878431), //part 81
    vec3(0.000000, 1.000000, 0.000000), //part 82
    vec3(0.196078, 0.803922, 0.196078), //part 83
    vec3(0.980392, 0.941176, 0.901961), //part 84
    vec3(1.000000, 0.000000, 1.000000), //part 85
    vec3(0.501961, 0.000000, 0.000000), //part 86
    vec3(0.400000, 0.803922, 0.666667), //part 87
    vec3(0.000000, 0.000000, 0.803922), //part 88
    vec3(0.729412, 0.333333, 0.827451), //part 89
    vec3(0.576471, 0.439216, 0.858824), //part 90
    vec3(0.235294, 0.701961, 0.443137), //part 91
    vec3(0.482353, 0.407843, 0.933333), //part 92
    vec3(0.000000, 0.980392, 0.603922), //part 93
    vec3(0.282353, 0.819608, 0.800000), //part 94
    vec3(0.780392, 0.082353, 0.521569), //part 95
    vec3(0.098039, 0.098039, 0.439216), //part 96
    vec3(0.960784, 1.000000, 0.980392), //part 97
    vec3(1.000000, 0.894118, 0.882353), //part 98
    vec3(1.000000, 0.894118, 0.709804) //part 99
    );
  return pc[part+99];
}

vec4 blinnPhongDirectional( vec3 n , vec4 kd) {
    vec4 ambient = vec4(kd.xyz*0.5,1);//Light.La * Material.Ka;
    vec4 intensity = vec4(0.8, 0.8, 0.8, 1.0);//specular and diffuse
    vec3 s = normalize(lightPos);// directional light
    float sDotN = dot(s,n);
    float abssDotN = abs(sDotN);
    vec4 diffuse = kd * abssDotN;
    vec4 spec = vec4(0.0, 0.0, 0.0, 1.0);
    float Shininess = 48.0;
    if ((LOD>4)&&(sDotN > 0.1)) {
      spec = vec4(1,1,1,1) * pow(sDotN, Shininess);
    }
    return ambient + intensity * (diffuse + spec);
}

vec4 farbverlauf(float wrt, float _min, float _max){
    if (_min+0.001>=_max)_max+=0.002;
    vec4 ff;
    int lauf=0;
    const vec4 farbe[]= vec4[6](
      vec4(1.0,0.0,0.0,1.0),
      vec4(1.0,1.0,0.0,1.0),
      vec4(0.0,1.0,0.0,1.0),
      vec4(0.0,1.0,1.0,1.0),
      vec4(0.0,0.0,1.0,1.0),
      vec4(1.0,0.0,1.0,1.0));
    float nwrt = (wrt - _min) / (_max - _min);
    nwrt=(nwrt >= 1.0)?0.99999:nwrt;
    nwrt=(nwrt <= 0.0)?0.00001:nwrt;
    lauf=(int (nwrt/0.2));
    nwrt-=(0.2*lauf);
    nwrt/=(0.2);
    ff=vec4((1.0-nwrt)*farbe[lauf][0]+farbe[lauf+1][0]*nwrt, (1.0-nwrt)*farbe[lauf][1]+farbe[lauf+1][1]*nwrt,
            (1.0-nwrt)*farbe[lauf][2]+farbe[lauf+1][2]*nwrt, 1.0);
    return ff;
}

void main(void){
    float cut = 0.08;
    vec4 col = vec4(1.0,0.7,0.2,1.0);
    if ((_sg<-40)&&((length(vert) < 0.88)||(length(vert) > 0.95))) discard;
    float R=0.866;
    if (((_style & HAS_PLAID)!=0) && (length(vert) > R)) discard;
    col = farbverlauf(_an,-1,80);
    if (_an==-1) col = (QPeakLegend)?farbverlauf(_ph, pmin, pmax):Qolor;
    else if (_an==-42) col = farbverlauf(_ph, lmin, lmax);
   // else if (_an==-88630) col =vec4(0.4,0.8,1.0,0.7);//in focus
    else if (_an==-66) col = vec4(0.6,0.3,0.1,0.7);
    else if (_an>=0) col = vec4(atomColors[_an], 1);
    //if ((_sg>20)&&(_mi>20)&&(_part>99)) discard; //just to avoid unused attributes for now
    //if(length(vert)>0.54) discard;
    //if ((_style&2048)>0) fragColor = blinnPhongDirectional(flatNormal, col);
    //else
    //*
    vec3 eyep = eye.xyz ;
    vec3 XYZ=abs(nor);

    if (((_style & HAS_RINGS)==HAS_RINGS)
            &&((_style & HAS_PLAID)==0)
            &&((_style & HAS_NOADP)==0)
            &&((min(XYZ.x,min(XYZ.y,XYZ.z))<=cut))) {
        col = mix(col, (((_style & HAS_WHITERING)==HAS_WHITERING)?vec4(1.0,1.0,1.0,1.0):vec4(0.0,0.0,0.0,1.0)), 0.7);
    }
    else if (((_style & HAS_WALLS)==HAS_WALLS)
            &&((_style & IS_SOLID)==0)
            &&((_style & HAS_NOADP)==0)){
                    int ep=0,np=0;
                    ep|=(eyep.x>=0.0)?1:0;
                    ep|=(eyep.y>=0.0)?2:0;
                    ep|=(eyep.z>=0.0)?4:0;
                    np|=(nor.x>=0.0)?1:0;
                    np|=(nor.y>=0.0)?2:0;
                    np|=(nor.z>=0.0)?4:0;
                    if (ep==np) discard;
                    }
    if ((_sg > 0)&&(_part<0)) if (hidePM1) discard; else col = mix(col,vec4(0,0,0.6,0.7),0.5);//
    else if ((_part != 0) && (highlightParts)){
        col = mix(col, vec4(partColor(int(_part)), 0.3), 0.7);
    }
    else if ((_sg>0 )&&(highlightEquivalents)) col = mix(col,vec4(1),0.3);// higlight symmetry equivalents
    if (gl_FrontFacing) fragColor = blinnPhongDirectional(Normal, col); //vec4(1,0,0,1);
    else fragColor = blinnPhongDirectional(-Normal, col);//,vec4(0,1,0,1),0.5);
}
