/*  RetroArch - A frontend for libretro.
 *  Copyright (C) 2010-2014 - Hans-Kristian Arntzen
 *  Copyright (C) 2011-2017 - Daniel De Matteis
 *  Copyright (C) 2016-2019 - Brad Parker
 *
 *  RetroArch is free software: you can redistribute it and/or modify it under the terms
 *  of the GNU General Public License as published by the Free Software Found-
 *  ation, either version 3 of the License, or (at your option) any later version.
 *
 *  RetroArch is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 *  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along with RetroArch.
 *  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __MSG_HASH_H
#define __MSG_HASH_H

#include <stdint.h>
#include <stddef.h>
#include <limits.h>
#include <boolean.h>
#include <retro_common_api.h>

#include "input/input_defines.h"

#define MSG_HASH(Id, str) case Id: return str;

#define MENU_LABEL(STR) \
   MENU_ENUM_LABEL_##STR, \
   MENU_ENUM_SUBLABEL_##STR, \
   MENU_ENUM_LABEL_VALUE_##STR

#define MENU_LBL_H(STR) \
   MENU_ENUM_LABEL_##STR, \
   MENU_ENUM_SUBLABEL_##STR, \
   MENU_ENUM_LABEL_VALUE_##STR, \
   MENU_ENUM_LABEL_HELP_##STR

RETRO_BEGIN_DECLS

enum msg_hash_action
{
   MSG_HASH_NONE = 0,
   MSG_HASH_USER_LANGUAGE
};

enum msg_file_type
{
   FILE_TYPE_NONE = 0,
   FILE_TYPE_PLAIN,
   FILE_TYPE_DIRECTORY,
   FILE_TYPE_PARENT_DIRECTORY,
   FILE_TYPE_PATH,
   FILE_TYPE_DEVICE,
   FILE_TYPE_CORE,
   FILE_TYPE_PLAYLIST_ENTRY,
   FILE_TYPE_CONTENTLIST_ENTRY,
   FILE_TYPE_SHADER_PRESET,
   FILE_TYPE_SHADER,
   FILE_TYPE_VIDEOFILTER,
   FILE_TYPE_AUDIOFILTER,
   FILE_TYPE_CHEAT,
   FILE_TYPE_OVERLAY,
   FILE_TYPE_FONT,
   FILE_TYPE_CONFIG,
   FILE_TYPE_USE_DIRECTORY,
   FILE_TYPE_SCAN_DIRECTORY,
   FILE_TYPE_CARCHIVE,
   FILE_TYPE_IN_CARCHIVE,
   FILE_TYPE_IMAGE,
   FILE_TYPE_IMAGEVIEWER,
   FILE_TYPE_REMAP,
   FILE_TYPE_DOWNLOAD_CORE,
   FILE_TYPE_DOWNLOAD_URL,
   FILE_TYPE_DOWNLOAD_CORE_CONTENT,
   FILE_TYPE_DOWNLOAD_CORE_INFO,
   FILE_TYPE_DOWNLOAD_THUMBNAIL_CONTENT,
   FILE_TYPE_DOWNLOAD_LAKKA,
   FILE_TYPE_RDB,
   FILE_TYPE_RDB_ENTRY,
   FILE_TYPE_RPL_ENTRY,
   FILE_TYPE_BOOL_ON,
   FILE_TYPE_BOOL_OFF,
   FILE_TYPE_RECORD_CONFIG,
   FILE_TYPE_STREAM_CONFIG,
   FILE_TYPE_PLAYLIST_COLLECTION,
   FILE_TYPE_PLAYLIST_ASSOCIATION,
   FILE_TYPE_MOVIE,
   FILE_TYPE_MUSIC,
   FILE_TYPE_SHADER_SLANG,
   FILE_TYPE_SHADER_GLSL,
   FILE_TYPE_SHADER_HLSL,
   FILE_TYPE_SHADER_CG,
   FILE_TYPE_SHADER_PRESET_GLSLP,
   FILE_TYPE_SHADER_PRESET_HLSLP,
   FILE_TYPE_SHADER_PRESET_CGP,
   FILE_TYPE_SHADER_PRESET_SLANGP,
   FILE_TYPE_DOWNLOAD_THUMBNAIL,
   FILE_TYPE_MORE,
   FILE_TYPE_COMPRESSED,
   FILE_TYPE_SHA1,
   FILE_TYPE_MD5,
   FILE_TYPE_CRC,
   FILE_TYPE_RGUI_THEME_PRESET,
   FILE_TYPE_VIDEO_LAYOUT,
   FILE_TYPE_WEBM,
   FILE_TYPE_F4F,
   FILE_TYPE_F4V,
   FILE_TYPE_OGM,
   FILE_TYPE_MKV,
   FILE_TYPE_AVI,
   FILE_TYPE_M4A,
   FILE_TYPE_3GP,
   FILE_TYPE_3G2,
   FILE_TYPE_MP4,
   FILE_TYPE_MP3,
   FILE_TYPE_FLAC,
   FILE_TYPE_OGG,
   FILE_TYPE_FLV,
   FILE_TYPE_WAV,
   FILE_TYPE_MOV,
   FILE_TYPE_WMA,
   FILE_TYPE_WMV,
   FILE_TYPE_MPG,
   FILE_TYPE_MPEG,
   FILE_TYPE_VOB,
   FILE_TYPE_ASF,
   FILE_TYPE_DIVX,
   FILE_TYPE_M2P,
   FILE_TYPE_M2TS,
   FILE_TYPE_PS,
   FILE_TYPE_TS,
   FILE_TYPE_MXF,

   FILE_TYPE_JPEG,
   FILE_TYPE_PNG,
   FILE_TYPE_TGA,
   FILE_TYPE_BMP,

   FILE_TYPE_MOD,
   FILE_TYPE_S3M,
   FILE_TYPE_XM,

   FILE_TYPE_CUE,
   FILE_TYPE_GDI,
   FILE_TYPE_ISO,
   FILE_TYPE_LUTRO,
   FILE_TYPE_CHD,
   FILE_TYPE_WBFS,
   FILE_TYPE_RVZ,
   FILE_TYPE_WIA,

   FILE_TYPE_DIRECT_LOAD,

   FILE_TYPE_GONG,

   /* Note: New entries must be added at the end, otherwise
    * menu_cbs_init_bind_get_string_representation_compare_type() breaks... */
   FILE_TYPE_DOWNLOAD_PL_THUMBNAIL_CONTENT,

   FILE_TYPE_MANUAL_SCAN_DIRECTORY,
   FILE_TYPE_MANUAL_SCAN_DAT,

   FILE_TYPE_SIDELOAD_CORE,

   FILE_TYPE_VIDEO_FONT,

   FILE_TYPE_DOWNLOAD_CORE_SYSTEM_FILES,

   FILE_TYPE_OSK_OVERLAY,

   FILE_TYPE_LAST
};

enum msg_hash_enums
{
   MSG_UNKNOWN = 0,
   MSG_ROOM_PASSWORDED,
   MSG_INTERNET,
   MSG_INTERNET_RELAY,
   MSG_INTERNET_NOT_CONNECTABLE,
   MSG_READ_WRITE,
   MSG_READ_ONLY,
   MSG_LOCAL,
   MSG_SETTING_DISK_IN_TRAY,
   MSG_FAILED_TO_SET_DISK,
   MSG_FAILED_TO_SET_INITIAL_DISK,
   MSG_NETPLAY_NEED_CONTENT_LOADED,
   MSG_FAILED_TO_CONNECT_TO_CLIENT,
   MSG_FAILED_TO_CONNECT_TO_HOST,
   MSG_NETPLAY_HOST_FULL,
   MSG_NETPLAY_BANNED,
   MSG_FAILED_TO_RECEIVE_HEADER_FROM_HOST,
   MSG_NETPLAY_FAILED,
   MSG_NETPLAY_UNSUPPORTED,
   MSG_UNKNOWN_NETPLAY_COMMAND_RECEIVED,
   MSG_CONNECTING_TO_NETPLAY_HOST,
   MSG_NETPLAY_LAN_SCAN_COMPLETE,
   MSG_NETPLAY_LAN_SCANNING,
   MSG_WAITING_FOR_CLIENT,
   MSG_ROOM_NOT_CONNECTABLE,
   MSG_NETPLAY_YOU_HAVE_LEFT_THE_GAME,
   MSG_NETPLAY_YOU_HAVE_JOINED_AS_PLAYER_N,
   MSG_NETPLAY_YOU_HAVE_JOINED_WITH_INPUT_DEVICES_S,
   MSG_NETPLAY_PLAYER_S_LEFT,
   MSG_NETPLAY_S_HAS_JOINED_AS_PLAYER_N,
   MSG_NETPLAY_S_HAS_JOINED_WITH_INPUT_DEVICES_S,
   MSG_NETPLAY_NOT_RETROARCH,
   MSG_NETPLAY_OUT_OF_DATE,
   MSG_NETPLAY_DIFFERENT_VERSIONS,
   MSG_NETPLAY_DIFFERENT_CORES,
   MSG_NETPLAY_DIFFERENT_CORE_VERSIONS,
   MSG_NETPLAY_ENDIAN_DEPENDENT,
   MSG_NETPLAY_PLATFORM_DEPENDENT,
   MSG_NETPLAY_ENTER_PASSWORD,
   MSG_NETPLAY_ENTER_CHAT,
   MSG_NETPLAY_INCORRECT_PASSWORD,
   MSG_NETPLAY_SERVER_NAMED_HANGUP,
   MSG_NETPLAY_SERVER_HANGUP,
   MSG_NETPLAY_CLIENT_HANGUP,
   MSG_NETPLAY_CANNOT_PLAY_UNPRIVILEGED,
   MSG_NETPLAY_CANNOT_PLAY_NO_SLOTS,
   MSG_NETPLAY_CANNOT_PLAY_NOT_AVAILABLE,
   MSG_NETPLAY_CANNOT_PLAY,
   MSG_NETPLAY_PEER_PAUSED,
   MSG_NETPLAY_CHANGED_NICK,
   MSG_NETPLAY_KICKED_CLIENT_S,
   MSG_NETPLAY_FAILED_TO_KICK_CLIENT_S,
   MSG_NETPLAY_BANNED_CLIENT_S,
   MSG_NETPLAY_FAILED_TO_BAN_CLIENT_S,
   MSG_NETPLAY_STATUS_PLAYING,
   MSG_NETPLAY_STATUS_SPECTATING,
   MSG_NETPLAY_CLIENT_DEVICES,
   MSG_NETPLAY_CHAT_SUPPORTED,
   MSG_NETPLAY_SLOWDOWNS_CAUSED,
   MSG_RESAMPLER_QUALITY_LOWEST,
   MSG_RESAMPLER_QUALITY_LOWER,
   MSG_RESAMPLER_QUALITY_NORMAL,
   MSG_RESAMPLER_QUALITY_HIGHER,
   MSG_RESAMPLER_QUALITY_HIGHEST,
   MSG_DISCORD_CONNECTION_REQUEST,
   MSG_ADDED_TO_FAVORITES,
   MSG_ADD_TO_FAVORITES_FAILED,
   MSG_SET_CORE_ASSOCIATION,
   MSG_RESET_CORE_ASSOCIATION,
   MSG_CORE_ASSOCIATION_RESET,
   MSG_AUTODETECT,
   MSG_AUDIO_VOLUME,
   MSG_AUDIO_MIXER_VOLUME,
   MSG_LIBRETRO_FRONTEND,
   MSG_CAPABILITIES,
   MSG_DEVICE_CONFIGURED_IN_PORT, /* deprecated */
   MSG_DEVICE_CONFIGURED_IN_PORT_NR,
   MSG_DEVICE_NOT_CONFIGURED,  /* deprecated */
   MSG_DEVICE_NOT_CONFIGURED_NR,
   MSG_DEVICE_NOT_CONFIGURED_FALLBACK, /* deprecated */
   MSG_DEVICE_NOT_CONFIGURED_FALLBACK_NR,
   MSG_DEVICE_DISCONNECTED_FROM_PORT, /* deprecated */
   MSG_DEVICE_DISCONNECTED_FROM_PORT_NR,
   MSG_NO_ARGUMENTS_SUPPLIED_AND_NO_MENU_BUILTIN,
   MSG_COMPILER,
   MSG_NATIVE,
   MSG_DYNAMIC,
   MSG_UNKNOWN_COMPILER,
   MSG_AUTOLOADING_SAVESTATE_FAILED,
   MSG_AUTOLOADING_SAVESTATE_SUCCEEDED,
   MSG_LOADING,
   MSG_FIRMWARE,
   MSG_CONNECTING_TO_PORT,
   MSG_CONNECTED_TO,
   MSG_FAILED_TO_LOAD,
   MSG_USING_CORE_NAME_FOR_NEW_CONFIG,
   MSG_SAVED_NEW_CONFIG_TO,
   MSG_FAILED_SAVING_CONFIG_TO,
   MSG_INFLATED_CHECKSUM_DID_NOT_MATCH_CRC32,
   MSG_FAILED_TO_EXTRACT_CONTENT_FROM_COMPRESSED_FILE,
   MSG_FILE_NOT_FOUND,
   MSG_VALUE_SHUTTING_DOWN,
   MSG_VALUE_REBOOTING,
   MSG_FAILED_TO_START_AUDIO_DRIVER,
   MSG_FOUND_LAST_STATE_SLOT,
   MSG_FOUND_LAST_REPLAY_SLOT,
   MSG_REPLAY_LOAD_STATE_HALT_INCOMPAT,
   MSG_REPLAY_LOAD_STATE_FAILED_INCOMPAT,
   MSG_RESTORED_OLD_SAVE_STATE,
   MSG_NO_STATE_HAS_BEEN_LOADED_YET,
   MSG_GOT_CONNECTION_FROM,
   MSG_GOT_CONNECTION_FROM_NAME,
   MSG_CONNECTION_SLOT,
   MSG_PUBLIC_ADDRESS,
   MSG_PRIVATE_OR_SHARED_ADDRESS,
   MSG_UPNP_FAILED,
   MSG_NO_SAVE_STATE_HAS_BEEN_OVERWRITTEN_YET,
   MSG_CANNOT_INFER_NEW_CONFIG_PATH,
   MSG_UNDID_LOAD_STATE,
   MSG_UNDID_SAVE_STATE,
   MSG_CONNECT_DEVICE_FROM_A_VALID_PORT,
   MSG_VALUE_CONNECT_DEVICE_FROM_A_VALID_PORT,
   MSG_DISCONNECT_DEVICE_FROM_A_VALID_PORT,
   MSG_DISCONNECTING_DEVICE_FROM_PORT, /* deprecated */
   MSG_VALUE_DISCONNECTING_DEVICE_FROM_PORT, /* deprecated */
   MSG_BRINGING_UP_COMMAND_INTERFACE_ON_PORT,
   MSG_FAILED_TO_ACCEPT_INCOMING_SPECTATOR,
   MSG_FAILED_TO_GET_NICKNAME_FROM_CLIENT,
   MSG_FAILED_TO_SEND_NICKNAME_TO_CLIENT,
   MSG_FAILED_TO_SEND_NICKNAME_TO_HOST,
   MSG_FAILED_TO_RECEIVE_NICKNAME_SIZE_FROM_HOST,
   MSG_FAILED_TO_RECEIVE_NICKNAME,
   MSG_FAILED_TO_RECEIVE_NICKNAME_FROM_HOST,
   MSG_FAILED_TO_RECEIVE_HEADER_FROM_CLIENT,
   MSG_FAILED_TO_RECEIVE_SRAM_DATA_FROM_HOST,
   MSG_FAILED_TO_SEND_NICKNAME_SIZE,
   MSG_FAILED_TO_SEND_NICKNAME,
   MSG_FAILED_TO_SEND_SRAM_DATA_TO_CLIENT,
   MSG_GAME_SPECIFIC_CORE_OPTIONS_FOUND_AT,
   MSG_FOLDER_SPECIFIC_CORE_OPTIONS_FOUND_AT,
   MSG_INVALID_NICKNAME_SIZE,
   MSG_VERSION_OF_LIBRETRO_API,
   MSG_COMPILED_AGAINST_API,
   MSG_ERROR_LIBRETRO_CORE_REQUIRES_SPECIAL_CONTENT,
   MSG_ERROR_LIBRETRO_CORE_REQUIRES_CONTENT,
   MSG_ERROR_LIBRETRO_CORE_REQUIRES_VFS,
   MSG_SEVERAL_PATCHES_ARE_EXPLICITLY_DEFINED,
   MSG_DID_NOT_FIND_A_VALID_CONTENT_PATCH,
   MSG_FAILED_TO_ALLOCATE_MEMORY_FOR_PATCHED_CONTENT,
   MSG_CONTENT_LOADING_SKIPPED_IMPLEMENTATION_WILL_DO_IT,
   MSG_PROGRAM,
   MSG_ERROR,
   MSG_FOUND_DISK_LABEL,
   MSG_READING_FIRST_DATA_TRACK,
   MSG_COULD_NOT_FIND_COMPATIBLE_SYSTEM,
   MSG_COMPARING_WITH_KNOWN_MAGIC_NUMBERS,
   MSG_COULD_NOT_FIND_VALID_DATA_TRACK,
   MSG_COULD_NOT_OPEN_DATA_TRACK,
   MSG_FOUND_FIRST_DATA_TRACK_ON_FILE,
   MSG_FRAMES,
   MSG_FOUND_SHADER,
   MSG_LOADING_HISTORY_FILE,
   MSG_LOADING_FAVORITES_FILE,
   MSG_COULD_NOT_READ_STATE_FROM_MOVIE,
   MSG_MOVIE_FILE_IS_NOT_A_VALID_REPLAY_FILE,
   MSG_OVERRIDES_NOT_SAVED,
   MSG_OVERRIDES_ACTIVE_NOT_SAVING,
   MSG_OVERRIDES_SAVED_SUCCESSFULLY,
   MSG_OVERRIDES_REMOVED_SUCCESSFULLY,
   MSG_OVERRIDES_UNLOADED_SUCCESSFULLY,
   MSG_OVERRIDES_ERROR_SAVING,
   MSG_OVERRIDES_ERROR_REMOVING,
   MSG_AUTOCONFIG_FILE_SAVED_SUCCESSFULLY,
   MSG_AUTOCONFIG_FILE_SAVED_SUCCESSFULLY_NAMED,
   MSG_AUTOCONFIG_FILE_ERROR_SAVING,
   MSG_FILE_ALREADY_EXISTS_SAVING_TO_BACKUP_BUFFER,
   MSG_AUTOLOADING_SAVESTATE_FROM,
   MSG_FOUND_AUTO_SAVESTATE_IN,
   MSG_SRAM_WILL_NOT_BE_SAVED,
   MSG_FAILED_TO_BIND_SOCKET,
   MSG_AUTO_SAVE_STATE_TO,
   MSG_RESTORING_DEFAULT_SHADER_PRESET_TO,
   MSG_SORRY_UNIMPLEMENTED_CORES_DONT_DEMAND_CONTENT_NETPLAY,
   MSG_LOADING_CONTENT_FILE,
   MSG_FATAL_ERROR_RECEIVED_IN,
   MSG_FAILED_TO_PATCH,
   MSG_COULD_NOT_READ_MOVIE_HEADER,
   MSG_CRC32_CHECKSUM_MISMATCH,
   MSG_USING_LIBRETRO_DUMMY_CORE_RECORDING_SKIPPED,
   MSG_FAILED_TO_OPEN_LIBRETRO_CORE,
   MSG_COULD_NOT_FIND_ANY_NEXT_DRIVER,
   MSG_MOVIE_FORMAT_DIFFERENT_SERIALIZER_VERSION,
   MSG_CONTENT_CRC32S_DIFFER,
   MSG_CONTENT_NETPACKET_CRC32S_DIFFER,
   MSG_PING_TOO_HIGH,
   MSG_RECORDING_TERMINATED_DUE_TO_RESIZE,
   MSG_FAILED_TO_START_RECORDING,
   MSG_REVERTING_SAVEFILE_DIRECTORY_TO,
   MSG_ERROR_PARSING_ARGUMENTS,
   MSG_REVERTING_SAVESTATE_DIRECTORY_TO,
   MSG_DOWNLOAD_FAILED,
   MSG_APPLYING_CHEAT,
   MSG_APPLYING_PATCH,
   MSG_INPUT_CHEAT,
   MSG_INPUT_CHEAT_FILENAME,
   MSG_INPUT_PRESET_FILENAME,
   MSG_INPUT_OVERRIDE_FILENAME,
   MSG_INPUT_REMAP_FILENAME,
   MSG_INPUT_RENAME_ENTRY,
   MSG_INPUT_ENABLE_SETTINGS_PASSWORD,
   MSG_INPUT_ENABLE_SETTINGS_PASSWORD_OK,
   MSG_INPUT_ENABLE_SETTINGS_PASSWORD_NOK,
   MSG_INPUT_KIOSK_MODE_PASSWORD,
   MSG_INPUT_KIOSK_MODE_PASSWORD_OK,
   MSG_INPUT_KIOSK_MODE_PASSWORD_NOK,
   MSG_REMAP_FILE_SAVED_SUCCESSFULLY,
   MSG_REMAP_FILE_REMOVED_SUCCESSFULLY,
   MSG_REMAP_FILE_RESET,
   MSG_INPUT_BIND_PRESS,
   MSG_INPUT_BIND_RELEASE,
   MSG_INPUT_BIND_TIMEOUT,
   MSG_INPUT_BIND_HOLD,
   MSG_OVERRIDE_UNLOAD,
   MSG_SHADER_PRESET_SAVED_SUCCESSFULLY,
   MSG_SHADER_PRESET_REMOVED_SUCCESSFULLY,
   MSG_ERROR_SAVING_REMAP_FILE,
   MSG_ERROR_REMOVING_REMAP_FILE,
   MSG_ERROR_SAVING_SHADER_PRESET,
   MSG_ERROR_REMOVING_SHADER_PRESET,
   MSG_FAILED_TO_CREATE_THE_DIRECTORY,
   MSG_ERROR_SAVING_CORE_OPTIONS_FILE,
   MSG_ERROR_REMOVING_CORE_OPTIONS_FILE,
   MSG_CORE_OPTIONS_FILE_CREATED_SUCCESSFULLY,
   MSG_CORE_OPTIONS_FILE_REMOVED_SUCCESSFULLY,
   MSG_CORE_OPTIONS_RESET,
   MSG_CORE_OPTIONS_FLUSHED,
   MSG_CORE_OPTIONS_FLUSH_FAILED,
   MSG_DECOMPRESSION_ALREADY_IN_PROGRESS,
   MSG_DECOMPRESSION_FAILED,
   MSG_DISK_EJECTED,
   MSG_DISK_CLOSED,
   MSG_REWIND_UNSUPPORTED,
   MSG_REWIND_INIT,
   MSG_REWIND_INIT_FAILED,
   MSG_REWIND_INIT_FAILED_THREADED_AUDIO,
   MSG_LIBRETRO_ABI_BREAK,
   MSG_DETECTED_VIEWPORT_OF,
   MSG_RECORDING_TO,
   MSG_HW_RENDERED_MUST_USE_POSTSHADED_RECORDING,
   MSG_VIEWPORT_SIZE_CALCULATION_FAILED,
   MSG_AUTOSAVE_FAILED,
   MSG_MOVIE_RECORD_STOPPED,
   MSG_MOVIE_PLAYBACK_ENDED,
   MSG_TAKING_SCREENSHOT,
   MSG_SCREENSHOT_SAVED,
   MSG_ACHIEVEMENT_UNLOCKED,
   MSG_RARE_ACHIEVEMENT_UNLOCKED,
   MSG_LEADERBOARD_STARTED,
   MSG_LEADERBOARD_FAILED,
   MSG_LEADERBOARD_SUBMISSION,
   MSG_LEADERBOARD_RANK,
   MSG_LEADERBOARD_BEST,
   MSG_CHANGE_THUMBNAIL_TYPE,
   MSG_TOGGLE_FULLSCREEN_THUMBNAILS,
   MSG_TOGGLE_CONTENT_METADATA,
   MSG_NO_THUMBNAIL_AVAILABLE,
   MSG_NO_THUMBNAIL_DOWNLOAD_POSSIBLE,
   MSG_PRESS_AGAIN_TO_QUIT,
   MSG_BLUETOOTH_PAIRING_REMOVED,
   MSG_BLUETOOTH_SCAN_COMPLETE,
   MSG_WIFI_SCAN_COMPLETE,
   MSG_WIFI_CONNECTING_TO,
   MSG_WIFI_EMPTY_SSID,
   MSG_SCANNING_BLUETOOTH_DEVICES,
   MSG_SCANNING_WIRELESS_NETWORKS,
   MSG_ENABLING_WIRELESS,
   MSG_DISABLING_WIRELESS,
   MSG_DISCONNECTING_WIRELESS,
   MSG_FAILED_TO_TAKE_SCREENSHOT,
   MSG_CUSTOM_TIMING_GIVEN,
   MSG_SAVING_STATE,
   MSG_UNDOING_SAVE_STATE,
   MSG_LOADING_STATE,
   MSG_FAILED_TO_SAVE_STATE_TO,
   MSG_FAILED_TO_SAVE_SRAM,
   MSG_FAILED_TO_LOAD_SRAM,
   MSG_STATE_SIZE,
   MSG_FAILED_TO_LOAD_CONTENT,
   MSG_COULD_NOT_READ_CONTENT_FILE,
   MSG_SAVED_SUCCESSFULLY_TO,
   MSG_BYTES,
   MSG_BLOCKING_SRAM_OVERWRITE,
   MSG_UNRECOGNIZED_COMMAND,
   MSG_SENDING_COMMAND,
   MSG_RESTARTING_RECORDING_DUE_TO_DRIVER_REINIT,
   MSG_REWINDING,
   MSG_SLOW_MOTION_REWIND,
   MSG_SLOW_MOTION,
   MSG_FAST_FORWARD,
   MSG_REWIND_REACHED_END,
   MSG_FAILED_TO_START_MOVIE_RECORD,
   MSG_STATE_SLOT,
   MSG_REPLAY_SLOT,
   MSG_STARTING_MOVIE_RECORD_TO,
   MSG_FAILED_TO_APPLY_SHADER,
   MSG_FAILED_TO_APPLY_SHADER_PRESET,
   MSG_APPLYING_SHADER,
   MSG_SHADER,
   MSG_REDIRECTING_SAVESTATE_TO,
   MSG_REDIRECTING_SAVEFILE_TO,
   MSG_REDIRECTING_CHEATFILE_TO,
   MSG_PREPARING_FOR_CONTENT_SCAN,
   MSG_SCANNING,
   MSG_SCANNING_OF_DIRECTORY_FINISHED,
   MSG_SCANNING_OF_FILE_FINISHED,
   MSG_LOADED_STATE_FROM_SLOT,
   MSG_LOADED_STATE_FROM_SLOT_AUTO,
   MSG_REMOVING_TEMPORARY_CONTENT_FILE,
   MSG_FAILED_TO_REMOVE_TEMPORARY_FILE,
   MSG_STARTING_MOVIE_PLAYBACK,
   MSG_APPENDED_DISK,
   MSG_FAILED_TO_APPEND_DISK,
   MSG_SKIPPING_SRAM_LOAD,
   MSG_CONFIG_DIRECTORY_NOT_SET,
   MSG_SAVED_STATE_TO_SLOT,
   MSG_SAVED_STATE_TO_SLOT_AUTO,
   MSG_CORE_DOES_NOT_SUPPORT_SAVESTATES,
   MSG_FAILED_TO_LOAD_STATE,
   MSG_FAILED_TO_UNDO_LOAD_STATE,
   MSG_FAILED_TO_UNDO_SAVE_STATE,
   MSG_RESET,
   MSG_AUDIO_MUTED,
   MSG_AUDIO_UNMUTED,
   MSG_FAILED_TO_UNMUTE_AUDIO,
   MSG_FAILED_TO_LOAD_OVERLAY,
   MSG_OSK_OVERLAY_NOT_SET,
   MSG_PAUSED,
   MSG_UNPAUSED,
   MSG_CORE_DOES_NOT_SUPPORT_DISK_OPTIONS,
   MSG_GRAB_MOUSE_STATE,
   MSG_GAME_FOCUS_ON,
   MSG_GAME_FOCUS_OFF,
   MSG_FAILED_TO_LOAD_MOVIE_FILE,
   MSG_FAILED_TO,
   MSG_SAVING_RAM_TYPE,
   MSG_TO,
   MSG_REMOVED_DISK_FROM_TRAY,
   MSG_FAILED_TO_REMOVE_DISK_FROM_TRAY,
   MSG_VIRTUAL_DISK_TRAY_EJECT,
   MSG_VIRTUAL_DISK_TRAY_CLOSE,
   MSG_GOT_INVALID_DISK_INDEX,
   MSG_INDEX_FILE,
   MSG_DOWNLOADING,
   MSG_EXTRACTING,
   MSG_EXTRACTING_FILE,
   MSG_NO_CONTENT_STARTING_DUMMY_CORE,
   MSG_CONFIG_OVERRIDE_LOADED,
   MSG_GAME_REMAP_FILE_LOADED,
   MSG_DIRECTORY_REMAP_FILE_LOADED,
   MSG_CORE_REMAP_FILE_LOADED,
   MSG_REMAP_FILE_FLUSHED,
   MSG_REMAP_FILE_FLUSH_FAILED,
   MSG_RUNAHEAD_ENABLED,
   MSG_RUNAHEAD_ENABLED_WITH_SECOND_INSTANCE,
   MSG_RUNAHEAD_DISABLED,
   MSG_RUNAHEAD_CORE_DOES_NOT_SUPPORT_SAVESTATES,
   MSG_RUNAHEAD_CORE_DOES_NOT_SUPPORT_RUNAHEAD,
   MSG_RUNAHEAD_FAILED_TO_SAVE_STATE,
   MSG_RUNAHEAD_FAILED_TO_LOAD_STATE,
   MSG_RUNAHEAD_FAILED_TO_CREATE_SECONDARY_INSTANCE,
   MSG_PREEMPT_ENABLED,
   MSG_PREEMPT_DISABLED,
   MSG_PREEMPT_CORE_DOES_NOT_SUPPORT_SAVESTATES,
   MSG_PREEMPT_CORE_DOES_NOT_SUPPORT_PREEMPT,
   MSG_PREEMPT_FAILED_TO_ALLOCATE,
   MSG_PREEMPT_FAILED_TO_SAVE_STATE,
   MSG_PREEMPT_FAILED_TO_LOAD_STATE,
   MSG_MISSING_ASSETS,
   MSG_RGUI_MISSING_FONTS,
   MSG_RGUI_INVALID_LANGUAGE,
#ifdef HAVE_LAKKA
   MSG_LOCALAP_SWITCHING_OFF,
   MSG_WIFI_DISCONNECT_FROM,
   MSG_LOCALAP_ALREADY_RUNNING,
   MSG_LOCALAP_NOT_RUNNING,
   MSG_LOCALAP_STARTING,
   MSG_LOCALAP_ERROR_CONFIG_CREATE,
   MSG_LOCALAP_ERROR_CONFIG_PARSE,
#endif
   MSG_UNSUPPORTED_VIDEO_MODE,
   MSG_CORE_INFO_CACHE_UNSUPPORTED,
   MSG_LOADING_ENTRY_STATE_FROM,
   MSG_FOUND_ENTRY_STATE_IN,
   MSG_FAILED_TO_ENTER_GAMEMODE,
   MSG_FAILED_TO_ENTER_GAMEMODE_LINUX,
   MSG_VRR_RUNLOOP_ENABLED,
   MSG_VRR_RUNLOOP_DISABLED,
   MSG_VIDEO_REFRESH_RATE_CHANGED,

   MSG_IOS_TOUCH_MOUSE_ENABLED,
   MSG_IOS_TOUCH_MOUSE_DISABLED,
   MSG_SDL2_MIC_NEEDS_SDL2_AUDIO,

   /* Add To Playlist*/
   MSG_ADDED_TO_PLAYLIST,
   MSG_ADD_TO_PLAYLIST_FAILED,
   MENU_ENUM_LABEL_ADD_ENTRY_TO_PLAYLIST,
   MENU_ENUM_LABEL_DEFERRED_ADD_TO_PLAYLIST_LIST,
   MENU_LABEL(ADD_TO_PLAYLIST),
   MENU_LABEL(CREATE_NEW_PLAYLIST),

   MENU_LABEL(MENU_XMB_ANIMATION_HORIZONTAL_HIGHLIGHT),
   MENU_LABEL(MENU_XMB_ANIMATION_MOVE_UP_DOWN),
   MENU_LABEL(MENU_XMB_ANIMATION_OPENING_MAIN_MENU),
   MENU_LABEL(SCAN_WITHOUT_CORE_MATCH),
   MENU_LABEL(SCAN_SERIAL_AND_CRC),
   MENU_LABEL(STREAMING_TITLE),
   MENU_LABEL(STREAMING_MODE),
   MENU_ENUM_LABEL_VALUE_VIDEO_STREAMING_MODE_TWITCH,
   MENU_ENUM_LABEL_VALUE_VIDEO_STREAMING_MODE_YOUTUBE,
   MENU_ENUM_LABEL_VALUE_VIDEO_STREAMING_MODE_FACEBOOK,
   MENU_ENUM_LABEL_VALUE_VIDEO_STREAMING_MODE_LOCAL,
   MENU_ENUM_LABEL_VALUE_VIDEO_STREAMING_MODE_CUSTOM,
   MENU_LABEL(VIDEO_RECORD_QUALITY),
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_RECORDING_CUSTOM,
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_RECORDING_LOW_QUALITY,
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_RECORDING_MED_QUALITY,
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_RECORDING_HIGH_QUALITY,
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_RECORDING_LOSSLESS_QUALITY,
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_RECORDING_WEBM_FAST,
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_RECORDING_WEBM_HIGH_QUALITY,
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_RECORDING_GIF,
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_RECORDING_APNG,
   MENU_LABEL(VIDEO_STREAM_QUALITY),
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_STREAMING_CUSTOM,
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_STREAMING_LOW_QUALITY,
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_STREAMING_MED_QUALITY,
   MENU_ENUM_LABEL_VALUE_VIDEO_RECORD_CONFIG_TYPE_STREAMING_HIGH_QUALITY,
   MENU_LABEL(STREAMING_URL),
   MENU_LABEL(UDP_STREAM_PORT),
   MENU_LABEL(MIXER_STREAM),
   MENU_LABEL(ADD_TO_MIXER),
   MENU_LABEL(ADD_TO_MIXER_AND_PLAY),
   MENU_LABEL(ADD_TO_MIXER_AND_COLLECTION),
   MENU_LABEL(ADD_TO_MIXER_AND_COLLECTION_AND_PLAY),
   MENU_ENUM_LABEL_VALUE_AUDIO_STREAM_STATE_NONE,
   MENU_ENUM_LABEL_VALUE_AUDIO_STREAM_STATE_STOPPED,
   MENU_ENUM_LABEL_VALUE_AUDIO_STREAM_STATE_PLAYING,
   MENU_ENUM_LABEL_VALUE_AUDIO_STREAM_STATE_PLAYING_LOOPED,
   MENU_ENUM_LABEL_VALUE_AUDIO_STREAM_STATE_PLAYING_SEQUENTIAL,
   MENU_LABEL(TWITCH_STREAM_KEY),
   MENU_LABEL(YOUTUBE_STREAM_KEY),
   MENU_LABEL(FACEBOOK_STREAM_KEY),
   MENU_ENUM_LABEL_MENU_TOGGLE,

   MENU_LABEL(FILTER_BY_CURRENT_CORE),

   MENU_LABEL(NO_HISTORY_AVAILABLE),
   MENU_LABEL(NO_MUSIC_AVAILABLE),
   MENU_LABEL(NO_VIDEOS_AVAILABLE),
   MENU_LABEL(NO_IMAGES_AVAILABLE),
   MENU_LABEL(NO_FAVORITES_AVAILABLE),

   MENU_ENUM_LABEL_DISCORD_IN_MENU,
   MENU_ENUM_LABEL_VALUE_DISCORD_IN_MENU,
   MENU_ENUM_LABEL_DISCORD_IN_GAME,
   MENU_ENUM_LABEL_VALUE_DISCORD_IN_GAME,
   MENU_ENUM_LABEL_DISCORD_IN_GAME_PAUSED,
   MENU_ENUM_LABEL_VALUE_DISCORD_IN_GAME_PAUSED,
   MENU_ENUM_LABEL_DISCORD_STATUS_PLAYING,
   MENU_ENUM_LABEL_VALUE_DISCORD_STATUS_PLAYING,
   MENU_ENUM_LABEL_DISCORD_STATUS_PAUSED,
   MENU_ENUM_LABEL_VALUE_DISCORD_STATUS_PAUSED,

   MENU_ENUM_LABEL_VALUE_CHEAT_FILE,
   MENU_ENUM_LABEL_VALUE_CHEAT_FILE_APPEND,

   MENU_ENUM_LABEL_HELP_INPUT_RETROPAD_BINDS,
   MENU_ENUM_LABEL_INPUT_HOTKEY_BIND_BEGIN,
   MENU_ENUM_LABEL_INPUT_HOTKEY_BIND_END   = MENU_ENUM_LABEL_INPUT_HOTKEY_BIND_BEGIN + RARCH_BIND_LIST_END,

   MENU_LABEL(MENU_SCALE_FACTOR),
   MENU_LABEL(MENU_WIDGET_SCALE_AUTO),
   MENU_LABEL(MENU_WIDGET_SCALE_FACTOR),
   MENU_LABEL(MENU_WIDGET_SCALE_FACTOR_FULLSCREEN),
   MENU_LABEL(MENU_WIDGET_SCALE_FACTOR_WINDOWED),
   MENU_LABEL(MENU_WALLPAPER_OPACITY),
   MENU_LABEL(MENU_FRAMEBUFFER_OPACITY),
   MENU_LABEL(MENU_USE_PREFERRED_SYSTEM_COLOR_THEME),

   MENU_ENUM_LABEL_VALUE_CONFIG,
   MENU_ENUM_LABEL_VALUE_OVERLAY,
   MENU_ENUM_LABEL_VALUE_AUTO,

   MENU_LABEL(MATERIALUI_ICONS_ENABLE),
   MENU_LABEL(MATERIALUI_SWITCH_ICONS),
   MENU_LABEL(MATERIALUI_PLAYLIST_ICONS_ENABLE),
   MENU_LABEL(MATERIALUI_SHOW_NAV_BAR),
   MENU_LABEL(MATERIALUI_AUTO_ROTATE_NAV_BAR),
   MENU_LABEL(MATERIALUI_DUAL_THUMBNAIL_LIST_VIEW_ENABLE),
   MENU_LABEL(MATERIALUI_THUMBNAIL_BACKGROUND_ENABLE),

   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_CUSTOM,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_CLASSIC_RED,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_CLASSIC_ORANGE,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_CLASSIC_YELLOW,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_CLASSIC_GREEN,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_CLASSIC_BLUE,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_CLASSIC_VIOLET,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_CLASSIC_GREY,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_LEGACY_RED,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_DARK_PURPLE,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_MIDNIGHT_BLUE,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_GOLDEN,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_ELECTRIC_BLUE,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_APPLE_GREEN,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_VOLCANIC_RED,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_LAGOON,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_BROGRAMMER,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_DRACULA,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_FAIRYFLOSS,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_FLATUI,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_GRUVBOX_DARK,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_GRUVBOX_LIGHT,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_HACKING_THE_KERNEL,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_NORD,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_NOVA,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_ONE_DARK,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_PALENIGHT,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_SOLARIZED_DARK,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_SOLARIZED_LIGHT,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_TANGO_DARK,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_TANGO_LIGHT,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_ZENBURN,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_ANTI_ZENBURN,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_FLUX,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_DYNAMIC,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_GRAY_DARK,
   MENU_ENUM_LABEL_VALUE_RGUI_MENU_COLOR_THEME_GRAY_LIGHT,

   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_BASIC_WHITE,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_BASIC_BLACK,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_NORD,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_GRUVBOX_DARK,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_BOYSENBERRY,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_HACKING_THE_KERNEL,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_TWILIGHT_ZONE,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_DRACULA,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_SELENIUM,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_SOLARIZED_DARK,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_SOLARIZED_LIGHT,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_GRAY_DARK,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_GRAY_LIGHT,
   MENU_ENUM_LABEL_VALUE_OZONE_COLOR_THEME_PURPLE_RAIN,

   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_MONOCHROME,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_MONOCHROME_INVERTED,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_FLATUI,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_FLATUX,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_RETROSYSTEM,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_PIXEL,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_SYSTEMATIC,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_DOTART,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_CUSTOM,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_AUTOMATIC,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_AUTOMATIC_INVERTED,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_DAITE,

   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_LEGACY_RED,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_DARK_PURPLE,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_MIDNIGHT_BLUE,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_GOLDEN,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_ELECTRIC_BLUE,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_APPLE_GREEN,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_UNDERSEA,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_VOLCANIC_RED,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_DARK,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_LIGHT,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_PLAIN,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_MORNING_BLUE,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_SUNBEAM,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_LIME,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_PIKACHU_YELLOW,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_GAMECUBE_PURPLE,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_FAMICOM_RED,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_FLAMING_HOT,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_ICE_COLD,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_MIDGAR,

   MENU_LABEL(SHADER_PIPELINE_RIBBON_SIMPLIFIED),
   MENU_LABEL(SHADER_PIPELINE_RIBBON),
   MENU_LABEL(SHADER_PIPELINE_SIMPLE_SNOW),
   MENU_LABEL(SHADER_PIPELINE_SNOW),
   MENU_LABEL(SHADER_PIPELINE_BOKEH),
   MENU_LABEL(SHADER_PIPELINE_SNOWFLAKE),

   MENU_LABEL(VIDEO_SHADERS_ENABLE),

   MENU_LABEL(MATERIALUI_MENU_HEADER_OPACITY),
   MENU_LABEL(MATERIALUI_MENU_FOOTER_OPACITY),
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_BLUE,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_BLUE_GREY,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_RED,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_GREEN,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_YELLOW,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_NVIDIA_SHIELD,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_DARK_BLUE,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_MATERIALUI,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_MATERIALUI_DARK,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_OZONE_DARK,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_NORD,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_GRUVBOX_DARK,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_SOLARIZED_DARK,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_CUTIE_BLUE,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_CUTIE_CYAN,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_CUTIE_GREEN,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_CUTIE_ORANGE,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_CUTIE_PINK,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_CUTIE_PURPLE,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_CUTIE_RED,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_VIRTUAL_BOY,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_HACKING_THE_KERNEL,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_GRAY_DARK,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_GRAY_LIGHT,

   MENU_LABEL(MATERIALUI_MENU_TRANSITION_ANIMATION),
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_TRANSITION_ANIM_AUTO,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_TRANSITION_ANIM_FADE,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_TRANSITION_ANIM_SLIDE,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_TRANSITION_ANIM_NONE,

   MENU_LABEL(MATERIALUI_MENU_THUMBNAIL_VIEW_PORTRAIT),
   MENU_LABEL(MATERIALUI_MENU_THUMBNAIL_VIEW_LANDSCAPE),

   MENU_ENUM_LABEL_VALUE_MATERIALUI_THUMBNAIL_VIEW_PORTRAIT_DISABLED,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_THUMBNAIL_VIEW_PORTRAIT_LIST_SMALL,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_THUMBNAIL_VIEW_PORTRAIT_LIST_MEDIUM,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_THUMBNAIL_VIEW_PORTRAIT_DUAL_ICON,

   MENU_ENUM_LABEL_VALUE_MATERIALUI_THUMBNAIL_VIEW_LANDSCAPE_DISABLED,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_THUMBNAIL_VIEW_LANDSCAPE_LIST_SMALL,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_THUMBNAIL_VIEW_LANDSCAPE_LIST_MEDIUM,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_THUMBNAIL_VIEW_LANDSCAPE_LIST_LARGE,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_THUMBNAIL_VIEW_LANDSCAPE_DESKTOP,

   MENU_LABEL(MATERIALUI_LANDSCAPE_LAYOUT_OPTIMIZATION),
   MENU_ENUM_LABEL_VALUE_MATERIALUI_LANDSCAPE_LAYOUT_OPTIMIZATION_DISABLED,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_LANDSCAPE_LAYOUT_OPTIMIZATION_ALWAYS,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_LANDSCAPE_LAYOUT_OPTIMIZATION_EXCLUDE_THUMBNAIL_VIEWS,

   MENU_ENUM_LABEL_VALUE_INPUT_POLL_TYPE_BEHAVIOR_LATE,
   MENU_ENUM_LABEL_VALUE_INPUT_POLL_TYPE_BEHAVIOR_NORMAL,
   MENU_ENUM_LABEL_VALUE_INPUT_POLL_TYPE_BEHAVIOR_EARLY,

   MENU_ENUM_LABEL_VALUE_RUNAHEAD_MODE_SINGLE_INSTANCE,
   MENU_ENUM_LABEL_VALUE_RUNAHEAD_MODE_SECOND_INSTANCE,
   MENU_ENUM_LABEL_VALUE_RUNAHEAD_MODE_PREEMPTIVE_FRAMES,

   MENU_LABEL(CHEEVOS_UNLOCKED_ENTRY),
   MENU_LABEL(CHEEVOS_UNLOCKED_ENTRY_HARDCORE),
   MENU_LABEL(CHEEVOS_LOCKED_ENTRY),
   MENU_LABEL(CHEEVOS_UNSUPPORTED_ENTRY),
   MENU_LABEL(CHEEVOS_UNOFFICIAL_ENTRY),
   MENU_ENUM_LABEL_VALUE_CHEEVOS_RECENTLY_UNLOCKED_ENTRY,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_ALMOST_THERE_ENTRY,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_ACTIVE_CHALLENGES_ENTRY,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_TRACKERS_ONLY,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_NOTIFICATIONS_ONLY,

   MENU_ENUM_LABEL_SHADER_PARAMETERS_ENTRY,
   MENU_ENUM_LABEL_RDB_ENTRY,
   MENU_ENUM_LABEL_URL_ENTRY,
   MENU_ENUM_LABEL_CORE_UPDATER_ENTRY,
   MENU_ENUM_LABEL_CORE_OPTION_ENTRY,
   MENU_ENUM_LABEL_NETWORK_INFO_ENTRY,
   MENU_ENUM_LABEL_SYSTEM_INFO_ENTRY,
   MENU_ENUM_LABEL_SYSTEM_INFO_CONTROLLER_ENTRY,
   MENU_ENUM_LABEL_CORE_INFO_ENTRY,
   MENU_ENUM_LABEL_CORE_MANAGER_ENTRY,
#ifdef HAVE_MIST
   MENU_ENUM_LABEL_CORE_MANAGER_STEAM_ENTRY,
#endif
   MENU_ENUM_LABEL_PLAYLIST_COLLECTION_ENTRY,
   MENU_ENUM_LABEL_PLAYLIST_ENTRY,

   MENU_LABEL(START_VIDEO_PROCESSOR),
   MENU_LABEL(START_NET_RETROPAD),
   MENU_LABEL(START_GONG),

   /* System information */
   MENU_LABEL(CPU_CORES),
   MENU_LABEL(CPU_ARCHITECTURE),
   MENU_LABEL(JIT_AVAILABLE),

   /* Input  */

   MENU_ENUM_LABEL_INPUT_LIBRETRO_DEVICE,
   MENU_ENUM_LABEL_INPUT_LIBRETRO_DEVICE_LAST = MENU_ENUM_LABEL_INPUT_LIBRETRO_DEVICE + MAX_USERS,
   MENU_ENUM_LABEL_INPUT_PLAYER_ANALOG_DPAD_MODE,
   MENU_ENUM_LABEL_INPUT_PLAYER_ANALOG_DPAD_MODE_LAST = MENU_ENUM_LABEL_INPUT_PLAYER_ANALOG_DPAD_MODE + MAX_USERS,
   MENU_ENUM_LABEL_INPUT_DEVICE_INDEX,
   MENU_ENUM_LABEL_INPUT_DEVICE_INDEX_LAST = MENU_ENUM_LABEL_INPUT_DEVICE_INDEX + MAX_USERS,
   MENU_ENUM_LABEL_INPUT_DEVICE_RESERVATION_TYPE,
   MENU_ENUM_LABEL_INPUT_DEVICE_RESERVATION_TYPE_LAST = MENU_ENUM_LABEL_INPUT_DEVICE_RESERVATION_TYPE + MAX_USERS,
   MENU_ENUM_LABEL_INPUT_DEVICE_RESERVED_DEVICE_NAME,
   MENU_ENUM_LABEL_INPUT_DEVICE_RESERVED_DEVICE_NAME_LAST = MENU_ENUM_LABEL_INPUT_DEVICE_RESERVED_DEVICE_NAME + MAX_USERS,
   MENU_ENUM_LABEL_INPUT_MOUSE_INDEX,
   MENU_ENUM_LABEL_INPUT_MOUSE_INDEX_LAST = MENU_ENUM_LABEL_INPUT_MOUSE_INDEX + MAX_USERS,
   MENU_ENUM_LABEL_INPUT_REMAP_PORT,
   MENU_ENUM_LABEL_INPUT_REMAP_PORT_LAST = MENU_ENUM_LABEL_INPUT_REMAP_PORT + MAX_USERS,

   MENU_ENUM_LABEL_INPUT_SETTINGS_BEGIN,

   MENU_LABEL(INPUT_RETROPAD_BINDS),
   MENU_LABEL(INPUT_HOTKEY_BINDS),
   MENU_LABEL(INPUT_HOTKEY_BLOCK_DELAY),
   MENU_LABEL(INPUT_HOTKEY_DEVICE_MERGE),
   MENU_LABEL(INPUT_SPLIT_JOYCON),

   MENU_ENUM_LABEL_INPUT_HOTKEY_BINDS_BEGIN,

   MENU_LABEL(INPUT_TURBO_PERIOD),
   MENU_LABEL(INPUT_TURBO_MODE),
   MENU_ENUM_LABEL_VALUE_TURBO_MODE_CLASSIC,
   MENU_ENUM_LABEL_VALUE_TURBO_MODE_CLASSIC_TOGGLE,
   MENU_ENUM_LABEL_VALUE_TURBO_MODE_SINGLEBUTTON,
   MENU_ENUM_LABEL_VALUE_TURBO_MODE_SINGLEBUTTON_HOLD,
   MENU_ENUM_LABEL_HELP_TURBO_MODE_CLASSIC,
   MENU_ENUM_LABEL_HELP_TURBO_MODE_CLASSIC_TOGGLE,
   MENU_ENUM_LABEL_HELP_TURBO_MODE_SINGLEBUTTON,
   MENU_ENUM_LABEL_HELP_TURBO_MODE_SINGLEBUTTON_HOLD,
   MENU_LABEL(INPUT_TURBO_DEFAULT_BUTTON),
   MENU_LABEL(INPUT_ALLOW_TURBO_DPAD),

/* MENU_ENUM_LABEL_INPUT_PLAYER1_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_PLAYER2_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_PLAYER3_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_PLAYER4_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_PLAYER5_JOYPAD_INDEX,*/
   MENU_ENUM_LABEL_INPUT_BIND_DEVICE_TYPE,
   MENU_ENUM_LABEL_INPUT_BIND_DEVICE_INDEX,

   MENU_ENUM_LABEL_INPUT_DRIVER_ANDROID,
   MENU_ENUM_LABEL_INPUT_DRIVER_PS4,
   MENU_ENUM_LABEL_INPUT_DRIVER_PS3,
   MENU_ENUM_LABEL_INPUT_DRIVER_PSP,
   MENU_ENUM_LABEL_INPUT_DRIVER_PS2,
   MENU_ENUM_LABEL_INPUT_DRIVER_CTR,
   MENU_ENUM_LABEL_INPUT_DRIVER_SWITCH,
   MENU_ENUM_LABEL_INPUT_DRIVER_SDL,
   MENU_ENUM_LABEL_INPUT_DRIVER_SDL2,
   MENU_ENUM_LABEL_INPUT_DRIVER_SDL_DINGUX,
   MENU_ENUM_LABEL_INPUT_DRIVER_DINPUT,
   MENU_ENUM_LABEL_INPUT_DRIVER_WINRAW,
   MENU_ENUM_LABEL_INPUT_DRIVER_X,
   MENU_ENUM_LABEL_INPUT_DRIVER_WAYLAND,
   MENU_ENUM_LABEL_INPUT_DRIVER_XENON360,
   MENU_ENUM_LABEL_INPUT_DRIVER_XINPUT,
   MENU_ENUM_LABEL_INPUT_DRIVER_UWP,
   MENU_ENUM_LABEL_INPUT_DRIVER_WII,
   MENU_ENUM_LABEL_INPUT_DRIVER_WIIU,
   MENU_ENUM_LABEL_INPUT_DRIVER_UDEV,
   MENU_ENUM_LABEL_INPUT_DRIVER_LINUXRAW,
   MENU_ENUM_LABEL_INPUT_DRIVER_COCOA,
   MENU_ENUM_LABEL_INPUT_DRIVER_QNX,
   MENU_ENUM_LABEL_INPUT_DRIVER_RWEBINPUT,
   MENU_ENUM_LABEL_INPUT_DRIVER_DOS,
   MENU_ENUM_LABEL_INPUT_DRIVER_NULL,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_ANDROID,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_PS4,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_PS3,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_PSP,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_PS2,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_CTR,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_SWITCH,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_SDL,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_SDL2,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_SDL_DINGUX,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_DINPUT,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_WINRAW,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_X,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_WAYLAND,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_XENON360,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_XINPUT,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_UWP,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_WII,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_WIIU,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_UDEV,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_LINUXRAW,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_COCOA,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_QNX,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_RWEBINPUT,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_DOS,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_NULL,
   MENU_ENUM_LABEL_HELP_INPUT_DRIVER_NO_DETAILS,

   MENU_ENUM_LABEL_JOYPAD_DRIVER_ANDROID,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_CTR,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_DINPUT,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_DOS,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_GX,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_HID,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_LINUXRAW,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_PARPORT,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_PS2,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_PS3,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_PS4,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_PSP,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_QNX,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_RWEBPAD,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_SDL_DINGUX,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_SDL,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_SWITCH,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_UDEV,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_WIIU,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_XDK,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_XINPUT,
   MENU_ENUM_LABEL_JOYPAD_DRIVER_NULL,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_ANDROID,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_CTR,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_DINPUT,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_DOS,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_GX,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_HID,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_LINUXRAW,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_PARPORT,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_PS2,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_PS3,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_PS4,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_PSP,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_QNX,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_RWEBPAD,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_SDL_DINGUX,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_SDL,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_SWITCH,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_UDEV,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_WIIU,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_XDK,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_XINPUT,
   MENU_ENUM_LABEL_HELP_JOYPAD_DRIVER_NULL,

   MENU_ENUM_LABEL_INPUT_USER_1_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_2_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_3_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_4_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_5_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_6_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_7_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_8_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_9_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_10_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_11_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_12_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_13_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_14_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_15_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_16_BINDS,
   MENU_ENUM_LABEL_INPUT_RETROPAD_SETTINGS,
   MENU_ENUM_LABEL_INPUT_HOTKEY_SETTINGS,

   MENU_LABEL(INPUT_REMAPPING_DIRECTORY),

   MENU_ENUM_LABEL_INPUT_OVERLAY,
   MENU_ENUM_LABEL_INPUT_OSK_OVERLAY,

   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_B,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_Y,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_SELECT,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_START,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_UP,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_DOWN,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_LEFT,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_RIGHT,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_A,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_X,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L2,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R2,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L3,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R3,
   MENU_ENUM_LABEL_VALUE_INPUT_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_MOUSE_LEFT,
   MENU_ENUM_LABEL_VALUE_INPUT_MOUSE_RIGHT,
   MENU_ENUM_LABEL_VALUE_INPUT_MOUSE_MIDDLE,
   MENU_ENUM_LABEL_VALUE_INPUT_MOUSE_BUTTON4,
   MENU_ENUM_LABEL_VALUE_INPUT_MOUSE_BUTTON5,
   MENU_ENUM_LABEL_VALUE_INPUT_MOUSE_WHEEL_UP,
   MENU_ENUM_LABEL_VALUE_INPUT_MOUSE_WHEEL_DOWN,
   MENU_ENUM_LABEL_VALUE_INPUT_MOUSE_HORIZ_WHEEL_UP,
   MENU_ENUM_LABEL_VALUE_INPUT_MOUSE_HORIZ_WHEEL_DOWN,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X_MINUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y_MINUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X_MINUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y_MINUS,
   MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_TRIGGER,
   MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_RELOAD,
   MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_A,
   MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_B,
   MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_AUX_C,
   MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_START,
   MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_SELECT,
   MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_UP,
   MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_DOWN,
   MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_LEFT,
   MENU_ENUM_LABEL_VALUE_INPUT_LIGHTGUN_DPAD_RIGHT,
   MENU_ENUM_LABEL_VALUE_INPUT_TURBO_ENABLE,

   MENU_ENUM_LABEL_VALUE_INPUT_META_ENABLE_HOTKEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_MENU_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_QUIT_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_RESTART_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_CLOSE_CONTENT_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_RESET,

   MENU_ENUM_LABEL_VALUE_INPUT_META_FAST_FORWARD_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_FAST_FORWARD_HOLD_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_SLOWMOTION_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_SLOWMOTION_HOLD_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_PAUSE_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_FRAMEADVANCE,

   MENU_ENUM_LABEL_VALUE_INPUT_META_MUTE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_VOLUME_UP,
   MENU_ENUM_LABEL_VALUE_INPUT_META_VOLUME_DOWN,

   MENU_ENUM_LABEL_VALUE_INPUT_META_LOAD_STATE_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_SAVE_STATE_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_STATE_SLOT_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_META_STATE_SLOT_MINUS,

   MENU_ENUM_LABEL_VALUE_INPUT_META_PLAY_REPLAY_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_RECORD_REPLAY_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_HALT_REPLAY_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_REPLAY_SLOT_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_META_REPLAY_SLOT_MINUS,

   MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_EJECT_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_NEXT,
   MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_PREV,

   MENU_ENUM_LABEL_VALUE_INPUT_META_SHADER_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_SHADER_NEXT,
   MENU_ENUM_LABEL_VALUE_INPUT_META_SHADER_PREV,

   MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_INDEX_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_INDEX_MINUS,

   MENU_ENUM_LABEL_VALUE_INPUT_META_SCREENSHOT,
   MENU_ENUM_LABEL_VALUE_INPUT_META_RECORDING_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_STREAMING_TOGGLE,

   MENU_ENUM_LABEL_VALUE_INPUT_META_GRAB_MOUSE_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_GAME_FOCUS_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_FULLSCREEN_TOGGLE_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_UI_COMPANION_TOGGLE,

   MENU_ENUM_LABEL_VALUE_INPUT_META_VRR_RUNLOOP_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_RUNAHEAD_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_PREEMPT_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_FPS_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_STATISTICS_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_AI_SERVICE,

   MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_PING_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_HOST_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_GAME_WATCH,
   MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_PLAYER_CHAT,
   MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_FADE_CHAT_TOGGLE,

   MENU_ENUM_LABEL_VALUE_INPUT_META_OVERLAY_NEXT, /* Hidden */
   MENU_ENUM_LABEL_VALUE_INPUT_META_OSK,
   MENU_ENUM_LABEL_VALUE_INPUT_META_SEND_DEBUG_INFO, /* Deprecated */

   MENU_ENUM_LABEL_VALUE_INPUT_DEVICE_INDEX,
   MENU_ENUM_LABEL_VALUE_INPUT_DEVICE_TYPE,
   MENU_ENUM_LABEL_VALUE_INPUT_ADC_TYPE,
   MENU_ENUM_LABEL_VALUE_INPUT_BIND_ALL,
   MENU_ENUM_LABEL_VALUE_INPUT_BIND_DEFAULT_ALL,
   MENU_ENUM_LABEL_VALUE_INPUT_SAVE_AUTOCONFIG,
   MENU_ENUM_LABEL_VALUE_INPUT_MOUSE_INDEX,
   MENU_ENUM_LABEL_INPUT_JOYPAD_INDEX,
   MENU_ENUM_LABEL_VALUE_INPUT_DEVICE_RESERVED_DEVICE_NAME,
   MENU_ENUM_LABEL_VALUE_INPUT_DEVICE_RESERVATION_TYPE,
   MENU_ENUM_LABEL_VALUE_DEVICE_RESERVATION_NONE,
   MENU_ENUM_LABEL_VALUE_DEVICE_RESERVATION_PREFERRED,
   MENU_ENUM_LABEL_VALUE_DEVICE_RESERVATION_RESERVED,
   MENU_ENUM_LABEL_INPUT_BIND_ALL_INDEX,
   MENU_ENUM_LABEL_INPUT_SAVE_AUTOCONFIG_INDEX,
   MENU_ENUM_LABEL_INPUT_BIND_DEFAULTS_INDEX,
   MENU_ENUM_LABEL_VALUE_INPUT_REMAP_PORT,

   MENU_ENUM_SUBLABEL_INPUT_DEVICE_TYPE,
   MENU_ENUM_SUBLABEL_INPUT_DEVICE_INDEX,
   MENU_ENUM_SUBLABEL_INPUT_DEVICE_RESERVED_DEVICE_NAME,
   MENU_ENUM_SUBLABEL_INPUT_DEVICE_RESERVATION_TYPE,
   MENU_ENUM_LABEL_HELP_INPUT_DEVICE_RESERVATION_TYPE,
   MENU_ENUM_SUBLABEL_INPUT_MOUSE_INDEX,
   MENU_ENUM_SUBLABEL_INPUT_ADC_TYPE,
   MENU_ENUM_LABEL_HELP_INPUT_ADC_TYPE,
   MENU_ENUM_SUBLABEL_INPUT_BIND_ALL,
   MENU_ENUM_SUBLABEL_INPUT_SAVE_AUTOCONFIG,
   MENU_ENUM_SUBLABEL_INPUT_BIND_DEFAULTS,
   MENU_ENUM_SUBLABEL_INPUT_REMAP_PORT,

   MENU_ENUM_SUBLABEL_INPUT_META_ENABLE_HOTKEY,
   MENU_ENUM_SUBLABEL_INPUT_META_MENU_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_QUIT_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_RESTART_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_CLOSE_CONTENT_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_RESET,

   MENU_ENUM_SUBLABEL_INPUT_META_FAST_FORWARD_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_FAST_FORWARD_HOLD_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_SLOWMOTION_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_SLOWMOTION_HOLD_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_REWIND_HOTKEY,
   MENU_ENUM_SUBLABEL_INPUT_META_PAUSE_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_FRAMEADVANCE,

   MENU_ENUM_SUBLABEL_INPUT_META_MUTE,
   MENU_ENUM_SUBLABEL_INPUT_META_VOLUME_UP,
   MENU_ENUM_SUBLABEL_INPUT_META_VOLUME_DOWN,

   MENU_ENUM_SUBLABEL_INPUT_META_LOAD_STATE_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_SAVE_STATE_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_STATE_SLOT_PLUS,
   MENU_ENUM_SUBLABEL_INPUT_META_STATE_SLOT_MINUS,

   MENU_ENUM_SUBLABEL_INPUT_META_PLAY_REPLAY_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_RECORD_REPLAY_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_HALT_REPLAY_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_REPLAY_SLOT_PLUS,
   MENU_ENUM_SUBLABEL_INPUT_META_REPLAY_SLOT_MINUS,

   MENU_ENUM_SUBLABEL_INPUT_META_DISK_EJECT_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_DISK_NEXT,
   MENU_ENUM_SUBLABEL_INPUT_META_DISK_PREV,

   MENU_ENUM_SUBLABEL_INPUT_META_SHADER_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_SHADER_NEXT,
   MENU_ENUM_SUBLABEL_INPUT_META_SHADER_PREV,

   MENU_ENUM_SUBLABEL_INPUT_META_CHEAT_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_CHEAT_INDEX_PLUS,
   MENU_ENUM_SUBLABEL_INPUT_META_CHEAT_INDEX_MINUS,

   MENU_ENUM_SUBLABEL_INPUT_META_SCREENSHOT,
   MENU_ENUM_SUBLABEL_INPUT_META_RECORDING_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_STREAMING_TOGGLE,

   MENU_ENUM_SUBLABEL_INPUT_META_GRAB_MOUSE_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_GAME_FOCUS_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_FULLSCREEN_TOGGLE_KEY,
   MENU_ENUM_SUBLABEL_INPUT_META_UI_COMPANION_TOGGLE,

   MENU_ENUM_SUBLABEL_INPUT_META_VRR_RUNLOOP_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_RUNAHEAD_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_PREEMPT_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_FPS_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_STATISTICS_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_AI_SERVICE,

   MENU_ENUM_SUBLABEL_INPUT_META_NETPLAY_PING_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_NETPLAY_HOST_TOGGLE,
   MENU_ENUM_SUBLABEL_INPUT_META_NETPLAY_GAME_WATCH,
   MENU_ENUM_SUBLABEL_INPUT_META_NETPLAY_PLAYER_CHAT,
   MENU_ENUM_SUBLABEL_INPUT_META_NETPLAY_FADE_CHAT_TOGGLE,

   MENU_ENUM_SUBLABEL_INPUT_META_OVERLAY_NEXT, /* Hidden */
   MENU_ENUM_SUBLABEL_INPUT_META_OSK,
   MENU_ENUM_SUBLABEL_INPUT_META_SEND_DEBUG_INFO, /* Deprecated */

   MENU_ENUM_LABEL_INPUT_DESCRIPTION,
   MENU_ENUM_LABEL_INPUT_DESCRIPTION_KBD,

   MENU_LABEL(INPUT_MAX_USERS),
   MENU_LABEL(INPUT_USER_BINDS),
   MENU_ENUM_SUBLABEL_INPUT_USER_REMAPS,

   MENU_LABEL(INPUT_DUTY_CYCLE),
   MENU_LABEL(INPUT_AUTODETECT_ENABLE),
#if defined(HAVE_DINPUT) || defined(HAVE_WINRAWINPUT)
   MENU_LABEL(INPUT_NOWINKEY_ENABLE),
#endif

#ifdef ANDROID
    MENU_LBL_H(INPUT_SELECT_PHYSICAL_KEYBOARD),
#endif

   MENU_LABEL(INPUT_SENSORS_ENABLE),
   MENU_LABEL(INPUT_AUTO_MOUSE_GRAB),

   MENU_LABEL(INPUT_AUTO_GAME_FOCUS),
   MENU_ENUM_LABEL_VALUE_INPUT_AUTO_GAME_FOCUS_OFF,
   MENU_ENUM_LABEL_VALUE_INPUT_AUTO_GAME_FOCUS_ON,
   MENU_ENUM_LABEL_VALUE_INPUT_AUTO_GAME_FOCUS_DETECT,

   MENU_LABEL(INPUT_DESCRIPTOR_LABEL_SHOW),
   MENU_LABEL(INPUT_DESCRIPTOR_HIDE_UNBOUND),
   MENU_LABEL(INPUT_BUTTON_AXIS_THRESHOLD),
#if defined(GEKKO)
   MENU_LABEL(INPUT_MOUSE_SCALE),
#endif
   MENU_LABEL(INPUT_TOUCH_SCALE),
   MENU_LABEL(INPUT_ANALOG_DEADZONE),
   MENU_LABEL(INPUT_ANALOG_SENSITIVITY),
   MENU_LABEL(INPUT_BIND_TIMEOUT),
   MENU_LABEL(INPUT_BIND_HOLD),
   MENU_LABEL(INPUT_REMAP_BINDS_ENABLE),
   MENU_LABEL(INPUT_REMAP_SORT_BY_CONTROLLER_ENABLE),
   MENU_LABEL(MENU_INPUT_SWAP_OK_CANCEL),
   MENU_LABEL(MENU_INPUT_SWAP_SCROLL),
   MENU_LABEL(INPUT_OVERLAY_ENABLE),
   MENU_LABEL(INPUT_OSK_OVERLAY_ENABLE),
   MENU_LABEL(INPUT_MENU_ENUM_TOGGLE_GAMEPAD_COMBO),
   MENU_LABEL(INPUT_QUIT_GAMEPAD_COMBO),
   MENU_LABEL(INPUT_OVERLAY_BEHIND_MENU),
   MENU_LABEL(INPUT_OVERLAY_HIDE_IN_MENU),
   MENU_LABEL(INPUT_OVERLAY_HIDE_WHEN_GAMEPAD_CONNECTED),
#ifdef UDEV_TOUCH_SUPPORT
   MENU_LABEL(INPUT_TOUCH_VMOUSE_POINTER),
   MENU_LABEL(INPUT_TOUCH_VMOUSE_MOUSE),
   MENU_LABEL(INPUT_TOUCH_VMOUSE_TOUCHPAD),
   MENU_LABEL(INPUT_TOUCH_VMOUSE_TRACKBALL),
   MENU_LABEL(INPUT_TOUCH_VMOUSE_GESTURE),
#endif
#if defined(ANDROID)
   MENU_ENUM_SUBLABEL_INPUT_OVERLAY_HIDE_WHEN_GAMEPAD_CONNECTED_ANDROID,
#endif

   /* Legacy enums - no longer needed, but cannot
    * delete because they are used by Crowdin
    * translations... */
   MENU_LABEL(INPUT_OVERLAY_SHOW_PHYSICAL_INPUTS),
   MENU_LABEL(INPUT_OVERLAY_SHOW_PHYSICAL_INPUTS_PORT),

   MENU_LABEL(INPUT_OVERLAY_SHOW_INPUTS),
   MENU_LABEL(INPUT_OVERLAY_SHOW_INPUTS_PORT),
   MENU_ENUM_LABEL_VALUE_INPUT_OVERLAY_SHOW_INPUTS_NONE,
   MENU_ENUM_LABEL_VALUE_INPUT_OVERLAY_SHOW_INPUTS_TOUCHED,
   MENU_ENUM_LABEL_VALUE_INPUT_OVERLAY_SHOW_INPUTS_PHYSICAL,

   MENU_LABEL(INPUT_OVERLAY_SHOW_MOUSE_CURSOR),
   MENU_LABEL(INPUT_OVERLAY_AUTO_ROTATE),
   MENU_LABEL(INPUT_OVERLAY_AUTO_SCALE),
   MENU_LABEL(INPUT_OSK_OVERLAY_AUTO_SCALE),
   MENU_LABEL(INPUT_OVERLAY_DPAD_DIAGONAL_SENSITIVITY),
   MENU_LABEL(INPUT_OVERLAY_ABXY_DIAGONAL_SENSITIVITY),
   MENU_LABEL(INPUT_OVERLAY_ANALOG_RECENTER_ZONE),
   MENU_LABEL(INPUT_OVERLAY_POINTER_ENABLE),
   MENU_LABEL(INPUT_OVERLAY_LIGHTGUN_PORT),
   MENU_LABEL(INPUT_OVERLAY_LIGHTGUN_TRIGGER_ON_TOUCH),
   MENU_ENUM_LABEL_VALUE_INPUT_OVERLAY_LIGHTGUN_PORT_ANY,
   MENU_LABEL(INPUT_OVERLAY_LIGHTGUN_TRIGGER_DELAY),
   MENU_LABEL(INPUT_OVERLAY_LIGHTGUN_ALLOW_OFFSCREEN),
   MENU_LABEL(INPUT_OVERLAY_LIGHTGUN_TWO_TOUCH_INPUT),
   MENU_LABEL(INPUT_OVERLAY_LIGHTGUN_THREE_TOUCH_INPUT),
   MENU_LABEL(INPUT_OVERLAY_LIGHTGUN_FOUR_TOUCH_INPUT),
   MENU_LABEL(INPUT_OVERLAY_MOUSE_SPEED),
   MENU_LABEL(INPUT_OVERLAY_MOUSE_HOLD_TO_DRAG),
   MENU_LABEL(INPUT_OVERLAY_MOUSE_HOLD_MSEC),
   MENU_LABEL(INPUT_OVERLAY_MOUSE_DTAP_TO_DRAG),
   MENU_LABEL(INPUT_OVERLAY_MOUSE_DTAP_MSEC),
   MENU_LABEL(INPUT_OVERLAY_MOUSE_SWIPE_THRESHOLD),
   MENU_LABEL(INPUT_KEYBOARD_GAMEPAD_MAPPING_TYPE),
   MENU_LABEL(INPUT_SMALL_KEYBOARD_ENABLE),
   MENU_LABEL(INPUT_TOUCH_ENABLE),
   MENU_LBL_H(INPUT_PREFER_FRONT_TOUCH),
   MENU_LABEL(INPUT_ICADE_ENABLE),
   MENU_LABEL(INPUT_ALL_USERS_CONTROL_MENU),
   MENU_LBL_H(INPUT_POLL_TYPE_BEHAVIOR),
   MENU_LABEL(RUNAHEAD_MODE),
#if !(defined(HAVE_DYNAMIC) || defined(HAVE_DYLIB))
   MENU_ENUM_SUBLABEL_RUNAHEAD_MODE_NO_SECOND_INSTANCE,
#endif
   MENU_LABEL(INPUT_UNIFIED_MENU_CONTROLS),
   MENU_LABEL(INPUT_DISABLE_INFO_BUTTON),
   MENU_LABEL(INPUT_DISABLE_SEARCH_BUTTON),
   MENU_LABEL(INPUT_DISABLE_LEFT_ANALOG_IN_MENU),
   MENU_LABEL(INPUT_DISABLE_RIGHT_ANALOG_IN_MENU),
   MENU_LABEL(INPUT_RUMBLE_GAIN),

   MENU_LABEL(QUIT_PRESS_TWICE),
   MENU_LABEL(QUIT_ON_CLOSE_CONTENT),

   MENU_LABEL(ANDROID_INPUT_DISCONNECT_WORKAROUND),

   MENU_ENUM_LABEL_VALUE_QUIT_ON_CLOSE_CONTENT_DISABLED,
   MENU_ENUM_LABEL_VALUE_QUIT_ON_CLOSE_CONTENT_ENABLED,
   MENU_ENUM_LABEL_VALUE_QUIT_ON_CLOSE_CONTENT_CLI,

   /* Video */
   MENU_LABEL(BRIGHTNESS_CONTROL),
   MENU_LABEL(CRT_SWITCH_RESOLUTION),
   MENU_LABEL(CRT_SWITCH_RESOLUTION_SUPER),
   MENU_LABEL(CRT_SWITCH_RESOLUTION_OUTPUT_DISPLAY_ID),
   MENU_LABEL(CRT_SWITCH_HIRES_MENU),
   MENU_LABEL(CRT_SWITCH_RESOLUTION_USE_CUSTOM_REFRESH_RATE),
   MENU_LABEL(CRT_SWITCH_X_AXIS_CENTERING),
   MENU_LABEL(CRT_SWITCH_PORCH_ADJUST),
   MENU_LABEL(VIDEO_FONT_ENABLE),
   MENU_LABEL(VIDEO_FONT_PATH),
   MENU_LABEL(VIDEO_FONT_SIZE),
   MENU_LABEL(VIDEO_MESSAGE_POS_X),
   MENU_LABEL(VIDEO_MESSAGE_POS_Y),
   MENU_LABEL(VIDEO_MESSAGE_COLOR_RED),
   MENU_LABEL(VIDEO_MESSAGE_COLOR_GREEN),
   MENU_LABEL(VIDEO_MESSAGE_COLOR_BLUE),
   MENU_LABEL(VIDEO_MESSAGE_BGCOLOR_ENABLE),
   MENU_LABEL(VIDEO_MESSAGE_BGCOLOR_RED),
   MENU_LABEL(VIDEO_MESSAGE_BGCOLOR_GREEN),
   MENU_LABEL(VIDEO_MESSAGE_BGCOLOR_BLUE),
   MENU_LABEL(VIDEO_MESSAGE_BGCOLOR_OPACITY),
   MENU_LABEL(VIDEO_FILTER_FLICKER),
   MENU_LABEL(VIDEO_SOFT_FILTER),
   MENU_LBL_H(VIDEO_MAX_SWAPCHAIN_IMAGES),
   MENU_LABEL(VIDEO_WAITABLE_SWAPCHAINS),
   MENU_LABEL(VIDEO_MAX_FRAME_LATENCY),
   MENU_LABEL(VIDEO_GPU_SCREENSHOT),
   MENU_LBL_H(VIDEO_BLACK_FRAME_INSERTION),
   MENU_LBL_H(VIDEO_BFI_DARK_FRAMES),
   MENU_LBL_H(VIDEO_SHADER_SUBFRAMES),
   MENU_LBL_H(VIDEO_SCAN_SUBFRAMES),
   MENU_LBL_H(VIDEO_FRAME_DELAY),
   MENU_LBL_H(VIDEO_FRAME_DELAY_AUTO),
   MENU_ENUM_LABEL_VALUE_VIDEO_FRAME_DELAY_AUTOMATIC,
   MENU_ENUM_LABEL_VALUE_VIDEO_FRAME_DELAY_EFFECTIVE,
   MENU_LABEL(VIDEO_SHADER_DELAY),
   MENU_LABEL(VIDEO_VSYNC),
   MENU_LABEL(VIDEO_ADAPTIVE_VSYNC),
   MENU_LABEL(VIDEO_HARD_SYNC),
   MENU_LBL_H(VIDEO_HARD_SYNC_FRAMES),
   MENU_LABEL(VIDEO_WINDOWED_FULLSCREEN),
   MENU_LABEL(VIDEO_AUTOSWITCH_REFRESH_RATE),
   MENU_LABEL(VIDEO_AUTOSWITCH_PAL_THRESHOLD),

   MENU_ENUM_LABEL_VALUE_VIDEO_AUTOSWITCH_REFRESH_RATE_EXCLUSIVE_FULLSCREEN,
   MENU_ENUM_LABEL_VALUE_VIDEO_AUTOSWITCH_REFRESH_RATE_WINDOWED_FULLSCREEN,
   MENU_ENUM_LABEL_VALUE_VIDEO_AUTOSWITCH_REFRESH_RATE_ALL_FULLSCREEN,

   MENU_LABEL(VIDEO_WINDOW_WIDTH),
   MENU_LABEL(VIDEO_WINDOW_HEIGHT),
   MENU_LABEL(VIDEO_WINDOW_AUTO_WIDTH_MAX),
   MENU_LABEL(VIDEO_WINDOW_AUTO_HEIGHT_MAX),
   MENU_LABEL(VIDEO_WINDOW_OPACITY),
   MENU_LABEL(VIDEO_FULLSCREEN_X),
   MENU_LABEL(VIDEO_FULLSCREEN_Y),
   MENU_LABEL(VIDEO_FORCE_RESOLUTION),
   MENU_LABEL(VIDEO_FORCE_SRGB_DISABLE),
   MENU_LABEL(VIDEO_ROTATION),
   MENU_LABEL(SCREEN_ORIENTATION),
   MENU_LABEL(VIDEO_SCALE),
   MENU_LABEL(VIDEO_RECORD_THREADS),
   MENU_LABEL(VIDEO_SMOOTH),
   MENU_LABEL(VIDEO_CTX_SCALING),
#ifdef HAVE_ODROIDGO2
   MENU_LABEL(VIDEO_RGA_SCALING),
#endif

   MENU_LABEL(VIDEO_CROP_OVERSCAN),

   MENU_LABEL(VIDEO_NOTCH_WRITE_OVER),

   MENU_LABEL(VIDEO_SCALE_INTEGER),
   MENU_LABEL(VIDEO_SCALE_INTEGER_AXIS),
   MENU_LABEL(VIDEO_SCALE_INTEGER_SCALING),
   MENU_ENUM_LABEL_VALUE_VIDEO_SCALE_INTEGER_SCALING_UNDERSCALE,
   MENU_ENUM_LABEL_VALUE_VIDEO_SCALE_INTEGER_SCALING_OVERSCALE,
   MENU_ENUM_LABEL_VALUE_VIDEO_SCALE_INTEGER_SCALING_SMART,
   MENU_LABEL(VIDEO_VIEWPORT_CUSTOM_X),
   MENU_LABEL(VIDEO_VIEWPORT_CUSTOM_Y),
   MENU_LABEL(VIDEO_VIEWPORT_CUSTOM_WIDTH),
   MENU_LABEL(VIDEO_VIEWPORT_CUSTOM_HEIGHT),
   MENU_LABEL(VIDEO_GAMMA),

   MENU_LABEL(VIDEO_ALLOW_ROTATE),
   MENU_ENUM_LABEL_VALUE_VIDEO_ROTATION_NORMAL,
   MENU_ENUM_LABEL_VALUE_VIDEO_ROTATION_90_DEG,
   MENU_ENUM_LABEL_VALUE_VIDEO_ROTATION_180_DEG,
   MENU_ENUM_LABEL_VALUE_VIDEO_ROTATION_270_DEG,
   MENU_ENUM_LABEL_VALUE_VIDEO_ORIENTATION_NORMAL,
   MENU_ENUM_LABEL_VALUE_VIDEO_ORIENTATION_VERTICAL,
   MENU_ENUM_LABEL_VALUE_VIDEO_ORIENTATION_FLIPPED,
   MENU_ENUM_LABEL_VALUE_VIDEO_ORIENTATION_FLIPPED_ROTATED,

   MENU_LABEL(VIDEO_SHARED_CONTEXT),
   MENU_LABEL(DRIVER_SWITCH_ENABLE),
   MENU_LBL_H(VIDEO_THREADED),

   MENU_LABEL(VIDEO_SWAP_INTERVAL),
   MENU_ENUM_LABEL_VALUE_VIDEO_SWAP_INTERVAL_AUTO,

   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_120,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_180,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_240,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_300,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_360,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_420,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_480,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_540,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_600,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_660,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_720,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_780,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_840,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_900,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION_VALUE_960,

   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_120,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_180,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_240,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_300,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_360,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_420,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_480,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_540,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_600,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_660,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_720,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_780,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_840,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_900,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_SUBFRAMES_VALUE_960,

   MENU_LABEL(VIDEO_FULLSCREEN),
   MENU_LBL_H(VIDEO_MONITOR_INDEX),
   MENU_LABEL(VIDEO_WIIU_PREFER_DRC),
   MENU_LABEL(VIDEO_WINDOW_SCALE),
   MENU_LABEL(VIDEO_WINDOW_OFFSET_X),
   MENU_LABEL(VIDEO_WINDOW_OFFSET_Y),
   MENU_LABEL(VIDEO_REFRESH_RATE),
   MENU_LBL_H(VIDEO_REFRESH_RATE_AUTO),
   MENU_LABEL(VIDEO_REFRESH_RATE_POLLED),

   MENU_LABEL(VIDEO_HDR_ENABLE),
   MENU_LABEL(VIDEO_HDR_MAX_NITS),
   MENU_LABEL(VIDEO_HDR_PAPER_WHITE_NITS),
   MENU_LABEL(VIDEO_HDR_CONTRAST),
   MENU_LABEL(VIDEO_HDR_EXPAND_GAMUT),

   MENU_LABEL(VIDEO_LAYOUT_ENABLE),
   MENU_LABEL(VIDEO_LAYOUT_PATH),
   MENU_LABEL(VIDEO_LAYOUT_SELECTED_VIEW),

   MENU_LBL_H(PARENT_DIRECTORY),

   MENU_LBL_H(FILE_BROWSER_OPEN_UWP_PERMISSIONS),
   MENU_LABEL(FILE_BROWSER_OPEN_PICKER),

   MENU_ENUM_LABEL_CONTENT_ACTIONS,

   /* Menu settings */
   MENU_LABEL(MENU_SHOW_LOAD_CORE),
   MENU_LABEL(MENU_SHOW_LOAD_CONTENT),
   MENU_LABEL(MENU_SHOW_LOAD_DISC),
   MENU_LABEL(MENU_SHOW_DUMP_DISC),
#ifdef HAVE_LAKKA
   MENU_LABEL(MENU_SHOW_EJECT_DISC),
#endif
   MENU_LABEL(MENU_SHOW_INFORMATION),
   MENU_LABEL(MENU_SHOW_CONFIGURATIONS),
   MENU_LABEL(MENU_SHOW_HELP),
   MENU_LABEL(MENU_SHOW_QUIT_RETROARCH),
   MENU_ENUM_SUBLABEL_QUIT_RETROARCH_NOSAVE,
   MENU_LABEL(MENU_SHOW_RESTART_RETROARCH),
   MENU_LABEL(MENU_SHOW_REBOOT),
   MENU_LABEL(MENU_SHOW_SHUTDOWN),
   MENU_LABEL(MENU_SHOW_ONLINE_UPDATER),
   MENU_LABEL(MENU_SHOW_CORE_UPDATER),
   MENU_LABEL(MENU_SHOW_LEGACY_THUMBNAIL_UPDATER), /* Thumbnailpack removal - deprecated*/
   MENU_LABEL(MENU_SCROLL_FAST),
   MENU_LABEL(MENU_SCROLL_DELAY),
   MENU_LABEL(MENU_ENABLE_KIOSK_MODE),
   MENU_LABEL(MENU_DISABLE_KIOSK_MODE),
   MENU_LABEL(MENU_KIOSK_MODE_PASSWORD),
   MENU_LABEL(RUN_MUSIC),
   MENU_LABEL(RUN),
   MENU_LABEL(MENU_WALLPAPER),
   MENU_LABEL(DYNAMIC_WALLPAPER),
   MENU_LABEL(PAUSE_NONACTIVE),
   MENU_LABEL(PAUSE_ON_DISCONNECT),
   MENU_LABEL(MENU_SCREENSAVER_TIMEOUT),
   MENU_LABEL(MENU_SCREENSAVER_ANIMATION),
   MENU_LABEL(MENU_SCREENSAVER_ANIMATION_SPEED),

   MENU_ENUM_LABEL_VALUE_MENU_SCREENSAVER_ANIMATION_SNOW,
   MENU_ENUM_LABEL_VALUE_MENU_SCREENSAVER_ANIMATION_STARFIELD,
   MENU_ENUM_LABEL_VALUE_MENU_SCREENSAVER_ANIMATION_VORTEX,

   MENU_LABEL(MOUSE_ENABLE),
   MENU_LABEL(POINTER_ENABLE),
   MENU_LABEL(MENU_RGUI_BORDER_FILLER_ENABLE),
   MENU_LABEL(MENU_RGUI_BACKGROUND_FILLER_THICKNESS_ENABLE),
   MENU_LABEL(MENU_RGUI_BORDER_FILLER_THICKNESS_ENABLE),
   MENU_LABEL(MENU_RGUI_INTERNAL_UPSCALE_LEVEL),
   MENU_LABEL(MENU_RGUI_ASPECT_RATIO),
   MENU_LABEL(MENU_RGUI_ASPECT_RATIO_LOCK),
   MENU_LABEL(MENU_RGUI_FULL_WIDTH_LAYOUT),
   MENU_LABEL(MENU_RGUI_TRANSPARENCY),
   MENU_LABEL(MENU_RGUI_SHADOWS),
   MENU_LABEL(MENU_RGUI_PARTICLE_EFFECT),
   MENU_LABEL(MENU_RGUI_PARTICLE_EFFECT_SPEED),
   MENU_LABEL(MENU_RGUI_PARTICLE_EFFECT_SCREENSAVER),
   MENU_LABEL(MENU_RGUI_EXTENDED_ASCII),
   MENU_LABEL(MENU_RGUI_SWITCH_ICONS),
   MENU_LABEL(MENU_LINEAR_FILTER),
   MENU_LABEL(MENU_HORIZONTAL_ANIMATION),
   MENU_LABEL(NAVIGATION_WRAPAROUND),
   MENU_LABEL(SHOW_ADVANCED_SETTINGS),
   MENU_LABEL(THREADED_DATA_RUNLOOP_ENABLE),
   MENU_LABEL(XMB_ALPHA_FACTOR),
   MENU_LABEL(MENU_FONT_COLOR_RED),
   MENU_LABEL(MENU_FONT_COLOR_GREEN),
   MENU_LABEL(MENU_FONT_COLOR_BLUE),
   MENU_LABEL(XMB_FONT),
   MENU_LABEL(XMB_LAYOUT),
   MENU_LABEL(XMB_THEME),
   MENU_LABEL(XMB_SWITCH_ICONS),
   MENU_LABEL(XMB_MAIN_MENU_ENABLE_SETTINGS),
   MENU_LABEL(XMB_SHADOWS_ENABLE),
   MENU_LABEL(CONTENT_SHOW_REWIND),
   MENU_LABEL(CONTENT_SHOW_LATENCY),
   MENU_LABEL(CONTENT_SHOW_OVERLAYS),
   MENU_LABEL(CONTENT_SHOW_VIDEO_LAYOUT),
   MENU_LABEL(CONTENT_SHOW_SETTINGS),
   MENU_LABEL(CONTENT_SHOW_SETTINGS_PASSWORD),
   MENU_LABEL(CONTENT_SHOW_FAVORITES),
   MENU_LABEL(CONTENT_SHOW_IMAGES),
   MENU_LABEL(CONTENT_SHOW_MUSIC),
   MENU_LABEL(CONTENT_SHOW_VIDEO),
   MENU_LABEL(CONTENT_SHOW_NETPLAY),
   MENU_LABEL(CONTENT_SHOW_HISTORY),
   MENU_LABEL(CONTENT_SHOW_ADD),
   MENU_LABEL(CONTENT_SHOW_ADD_ENTRY),
   MENU_LABEL(CONTENT_SHOW_PLAYLISTS),
   MENU_LABEL(CONTENT_SHOW_EXPLORE),
   MENU_LABEL(CONTENT_SHOW_CONTENTLESS_CORES),
   MENU_ENUM_LABEL_VALUE_SHOW_CONTENTLESS_CORES_ALL,
   MENU_ENUM_LABEL_VALUE_SHOW_CONTENTLESS_CORES_SINGLE_PURPOSE,
   MENU_ENUM_LABEL_VALUE_SHOW_CONTENTLESS_CORES_CUSTOM,
   MENU_LABEL(XMB_RIBBON_ENABLE),
   MENU_LABEL(THUMBNAILS),
   MENU_LABEL(THUMBNAILS_RGUI),
   MENU_LABEL(THUMBNAILS_MATERIALUI),
   MENU_LABEL(LEFT_THUMBNAILS),
   MENU_LABEL(LEFT_THUMBNAILS_RGUI),
   MENU_LABEL(LEFT_THUMBNAILS_OZONE),
   MENU_LABEL(LEFT_THUMBNAILS_MATERIALUI),
   MENU_LABEL(ICON_THUMBNAILS),
   MENU_LABEL(XMB_VERTICAL_THUMBNAILS),
   MENU_LABEL(MENU_XMB_THUMBNAIL_SCALE_FACTOR),
   MENU_LABEL(MENU_XMB_VERTICAL_FADE_FACTOR),
   MENU_LABEL(MENU_XMB_SHOW_TITLE_HEADER),
   MENU_LABEL(MENU_XMB_TITLE_MARGIN),
   MENU_LABEL(MENU_XMB_TITLE_MARGIN_HORIZONTAL_OFFSET),
   MENU_LABEL(MENU_THUMBNAIL_UPSCALE_THRESHOLD),
   MENU_LABEL(MENU_RGUI_INLINE_THUMBNAILS),
   MENU_LABEL(MENU_RGUI_SWAP_THUMBNAILS),
   MENU_LABEL(MENU_RGUI_THUMBNAIL_DOWNSCALER),
   MENU_LABEL(MENU_RGUI_THUMBNAIL_DELAY),
   MENU_LABEL(TIMEDATE_ENABLE),
   MENU_LABEL(TIMEDATE_STYLE),
   MENU_LABEL(TIMEDATE_DATE_SEPARATOR),
   MENU_LABEL(BATTERY_LEVEL_ENABLE),
   MENU_LABEL(MENU_SHOW_SUBLABELS),
   MENU_LABEL(RGUI_MENU_COLOR_THEME),
   MENU_LABEL(RGUI_MENU_THEME_PRESET),
   MENU_LABEL(XMB_MENU_COLOR_THEME),
   MENU_LABEL(OZONE_MENU_COLOR_THEME),
   MENU_LABEL(OZONE_COLLAPSE_SIDEBAR),
   MENU_LABEL(OZONE_TRUNCATE_PLAYLIST_NAME),
   MENU_LABEL(OZONE_SORT_AFTER_TRUNCATE_PLAYLIST_NAME),
   MENU_LABEL(OZONE_SCROLL_CONTENT_METADATA),
   MENU_LABEL(OZONE_THUMBNAIL_SCALE_FACTOR),
   MENU_LABEL(MATERIALUI_MENU_COLOR_THEME),
   MENU_LABEL(QUICK_MENU_OVERRIDE_OPTIONS),
   MENU_LABEL(SETTINGS_SHOW_DRIVERS),
   MENU_LABEL(SETTINGS_SHOW_VIDEO),
   MENU_LABEL(SETTINGS_SHOW_AUDIO),
   MENU_LABEL(SETTINGS_SHOW_INPUT),
   MENU_LABEL(SETTINGS_SHOW_LATENCY),
   MENU_LABEL(SETTINGS_SHOW_CORE),
   MENU_LABEL(SETTINGS_SHOW_CONFIGURATION),
   MENU_LABEL(SETTINGS_SHOW_SAVING),
   MENU_LABEL(SETTINGS_SHOW_LOGGING),
   MENU_LABEL(SETTINGS_SHOW_FILE_BROWSER),
   MENU_LABEL(SETTINGS_SHOW_FRAME_THROTTLE),
   MENU_LABEL(SETTINGS_SHOW_RECORDING),
   MENU_LABEL(SETTINGS_SHOW_ONSCREEN_DISPLAY),
   MENU_LABEL(SETTINGS_SHOW_USER_INTERFACE),
   MENU_LABEL(SETTINGS_SHOW_AI_SERVICE),
   MENU_LABEL(SETTINGS_SHOW_ACCESSIBILITY),
   MENU_LABEL(SETTINGS_SHOW_POWER_MANAGEMENT),
   MENU_LABEL(SETTINGS_SHOW_ACHIEVEMENTS),
   MENU_LABEL(SETTINGS_SHOW_NETWORK),
   MENU_LABEL(SETTINGS_SHOW_PLAYLISTS),
   MENU_LABEL(SETTINGS_SHOW_USER),
   MENU_LABEL(SETTINGS_SHOW_DIRECTORY),
   MENU_LABEL(SETTINGS_SHOW_STEAM),
   MENU_LABEL(QUICK_MENU_SHOW_RESUME_CONTENT),
   MENU_LABEL(QUICK_MENU_SHOW_RESTART_CONTENT),
   MENU_LABEL(QUICK_MENU_SHOW_CLOSE_CONTENT),
   MENU_LABEL(QUICK_MENU_SHOW_TAKE_SCREENSHOT),
   MENU_LABEL(QUICK_MENU_SHOW_SAVESTATE_SUBMENU),
   MENU_LABEL(QUICK_MENU_SHOW_SAVE_LOAD_STATE),
   MENU_LABEL(QUICK_MENU_SHOW_UNDO_SAVE_LOAD_STATE),
   MENU_LABEL(QUICK_MENU_SHOW_REPLAY),
   MENU_LABEL(QUICK_MENU_SHOW_ADD_TO_FAVORITES),
   MENU_LABEL(QUICK_MENU_SHOW_ADD_TO_PLAYLIST),
   MENU_LABEL(QUICK_MENU_SHOW_START_RECORDING),
   MENU_LABEL(QUICK_MENU_SHOW_START_STREAMING),
   MENU_LABEL(QUICK_MENU_SHOW_SET_CORE_ASSOCIATION),
   MENU_LABEL(QUICK_MENU_SHOW_RESET_CORE_ASSOCIATION),
   MENU_LABEL(QUICK_MENU_SHOW_OPTIONS),
   MENU_LABEL(QUICK_MENU_SHOW_CORE_OPTIONS_FLUSH),
   MENU_LABEL(QUICK_MENU_SHOW_CONTROLS),
   MENU_LABEL(QUICK_MENU_SHOW_CHEATS),
   MENU_LABEL(QUICK_MENU_SHOW_SHADERS),
   MENU_LABEL(QUICK_MENU_SHOW_SAVE_CORE_OVERRIDES),
   MENU_LABEL(QUICK_MENU_SHOW_SAVE_CONTENT_DIR_OVERRIDES),
   MENU_LABEL(QUICK_MENU_SHOW_SAVE_GAME_OVERRIDES),
   MENU_LABEL(QUICK_MENU_SHOW_INFORMATION),
   MENU_LABEL(QUICK_MENU_START_RECORDING),
   MENU_LABEL(QUICK_MENU_STOP_RECORDING),
   MENU_LABEL(QUICK_MENU_START_STREAMING),
   MENU_LABEL(QUICK_MENU_STOP_STREAMING),
   MENU_LABEL(QUICK_MENU_SHOW_DOWNLOAD_THUMBNAILS),
   MENU_LABEL(MENU_TICKER_TYPE),
   MENU_LABEL(MENU_TICKER_SPEED),
   MENU_LABEL(MENU_TICKER_SMOOTH),

   MENU_ENUM_LABEL_VALUE_MENU_TICKER_TYPE_BOUNCE,
   MENU_ENUM_LABEL_VALUE_MENU_TICKER_TYPE_LOOP,

   MENU_ENUM_LABEL_VALUE_SCROLL_NORMAL,
   MENU_ENUM_LABEL_VALUE_SCROLL_FAST,

   MENU_ENUM_LABEL_VALUE_MENU_ADD_CONTENT_ENTRY_DISPLAY_MAIN_TAB,
   MENU_ENUM_LABEL_VALUE_MENU_ADD_CONTENT_ENTRY_DISPLAY_PLAYLISTS_TAB,

   MENU_LABEL(MENU_REMEMBER_SELECTION),

   MENU_ENUM_LABEL_VALUE_MENU_REMEMBER_SELECTION_ALWAYS,
   MENU_ENUM_LABEL_VALUE_MENU_REMEMBER_SELECTION_PLAYLISTS,
   MENU_ENUM_LABEL_VALUE_MENU_REMEMBER_SELECTION_MAIN,

   /* UI settings */
   MENU_LBL_H(VIDEO_DISABLE_COMPOSITION),
   MENU_LABEL(UI_COMPANION_ENABLE),
   MENU_LBL_H(UI_COMPANION_START_ON_BOOT),
   MENU_LABEL(UI_COMPANION_TOGGLE),
   MENU_LABEL(DESKTOP_MENU_ENABLE),
   MENU_LABEL(UI_MENUBAR_ENABLE),
#ifdef _3DS
   MENU_LABEL(NEW3DS_SPEEDUP_ENABLE),
   MENU_LABEL(VIDEO_3DS_LCD_BOTTOM),
   MENU_LABEL(VIDEO_3DS_DISPLAY_MODE),
   MENU_ENUM_LABEL_VALUE_CTR_VIDEO_MODE_3D,
   MENU_ENUM_LABEL_VALUE_CTR_VIDEO_MODE_2D,
   MENU_ENUM_LABEL_VALUE_CTR_VIDEO_MODE_2D_400X240,
   MENU_ENUM_LABEL_VALUE_CTR_VIDEO_MODE_2D_800X240,
   MENU_LABEL(BOTTOM_ASSETS_DIRECTORY),
   MENU_LABEL(BOTTOM_FONT_ENABLE),
   MENU_LABEL(BOTTOM_FONT_COLOR_RED),
   MENU_LABEL(BOTTOM_FONT_COLOR_GREEN),
   MENU_LABEL(BOTTOM_FONT_COLOR_BLUE),
   MENU_LABEL(BOTTOM_FONT_COLOR_OPACITY),
   MENU_LABEL(BOTTOM_FONT_SCALE),
#endif
   MENU_ENUM_LABEL_FILE_CONFIG,
   MENU_ENUM_LABEL_HELP_FILE_CONFIG,
   MENU_ENUM_LABEL_FILE_BROWSER_COMPRESSED_ARCHIVE,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_COMPRESSED_ARCHIVE,
   MENU_ENUM_LABEL_FILE_BROWSER_CONFIG,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_CONFIG,
   MENU_ENUM_LABEL_FILE_BROWSER_RECORD_CONFIG,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_RECORD_CONFIG,
   MENU_ENUM_LABEL_FILE_BROWSER_CURSOR,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_CURSOR,
   MENU_ENUM_LABEL_FILE_BROWSER_DIRECTORY,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_DIRECTORY,
   MENU_ENUM_LABEL_FILE_BROWSER_PLAIN_FILE,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_PLAIN_FILE,
   MENU_ENUM_LABEL_FILE_BROWSER_SHADER_PRESET,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_SHADER_PRESET,
   MENU_ENUM_LABEL_FILE_BROWSER_SHADER,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_SHADER,
   MENU_ENUM_LABEL_FILE_BROWSER_REMAP,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_REMAP,
   MENU_ENUM_LABEL_FILE_BROWSER_CORE,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_CORE,
   MENU_ENUM_LABEL_FILE_BROWSER_OVERLAY,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_OVERLAY,
   MENU_ENUM_LABEL_FILE_BROWSER_VIDEO_LAYOUT,
   MENU_ENUM_LABEL_FILE_BROWSER_CHEAT,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_CHEAT,
   MENU_ENUM_LABEL_FILE_BROWSER_FONT,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_FONT,
   MENU_ENUM_LABEL_FILE_BROWSER_RDB,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_RDB,
   MENU_ENUM_LABEL_FILE_BROWSER_CORE_SELECT_FROM_COLLECTION,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_CORE_SELECT_FROM_COLLECTION,
   MENU_ENUM_LABEL_FILE_BROWSER_CORE_SELECT_FROM_COLLECTION_CURRENT_CORE,
   MENU_ENUM_LABEL_FILE_BROWSER_CORE_DETECTED,
   MENU_ENUM_LABEL_FILE_BROWSER_IMAGE,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_IMAGE,
   MENU_ENUM_LABEL_FILE_BROWSER_IMAGE_OPEN_WITH_VIEWER,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_IMAGE_OPEN_WITH_VIEWER,
   MENU_ENUM_LABEL_FILE_BROWSER_MOVIE_OPEN,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_MOVIE_OPEN,
   MENU_ENUM_LABEL_FILE_BROWSER_MUSIC_OPEN,
   MENU_ENUM_LABEL_HELP_FILE_BROWSER_MUSIC_OPEN,

   /* Menu file browser */
   MENU_LABEL(NAVIGATION_BROWSER_FILTER_SUPPORTED_EXTENSIONS_ENABLE),

   /* Playlists */
   MENU_LABEL(HISTORY_LIST_ENABLE),
   MENU_LABEL(CONTENT_HISTORY_SIZE),
   MENU_LABEL(CONTENT_FAVORITES_SIZE),
   MENU_LABEL(PLAYLIST_ENTRY_REMOVE),
   MENU_LABEL(PLAYLIST_ENTRY_RENAME),
   MENU_LABEL(GOTO_FAVORITES),
   MENU_LABEL(GOTO_MUSIC),
   MENU_LABEL(GOTO_IMAGES),
   MENU_LABEL(GOTO_VIDEO),
   MENU_LABEL(GOTO_EXPLORE),
   MENU_LABEL(GOTO_CONTENTLESS_CORES),
   MENU_LABEL(ADD_TO_FAVORITES),
   MENU_LABEL(ADD_TO_FAVORITES_PLAYLIST),
   MENU_LABEL(SET_CORE_ASSOCIATION),
   MENU_LABEL(RESET_CORE_ASSOCIATION),

   MENU_LABEL(NO_ACHIEVEMENTS_TO_DISPLAY),
   MENU_LABEL(NOT_LOGGED_IN),
   MENU_LABEL(NETWORK_ERROR),
   MENU_LABEL(UNKNOWN_GAME),
   MENU_LABEL(CANNOT_ACTIVATE_ACHIEVEMENTS_WITH_THIS_CORE),
   MENU_LABEL(NO_ENTRIES_TO_DISPLAY),
   MENU_LABEL(DOWNLOAD_PL_ENTRY_THUMBNAILS),

   /* Help */

   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_SCROLL_UP,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_SCROLL_DOWN,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_CONFIRM,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_OK,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_BACK,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_START,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_INFO,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_TOGGLE_MENU,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_QUIT,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_TOGGLE_KEYBOARD,

   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_SCROLL_UP,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_CONFIRM,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_START,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_INFO,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_TOGGLE_MENU,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_QUIT,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_TOGGLE_KEYBOARD,

   MENU_LABEL(MENU_VIEWS_SETTINGS),
   MENU_LABEL(QUICK_MENU_VIEWS_SETTINGS),
   MENU_LABEL(SETTINGS_VIEWS_SETTINGS),
   MENU_LABEL(MENU_SETTINGS),
   MENU_LABEL(APPICON_SETTINGS),
#ifdef _3DS
   MENU_LABEL(MENU_BOTTOM_SETTINGS),
#endif
   MENU_LABEL(THUMBNAILS_UPDATER_LIST), /* Thumbnailpack removal - deprecated*/
   MENU_LABEL(PL_THUMBNAILS_UPDATER_LIST),
   MENU_LABEL(PL_THUMBNAILS_UPDATER_ENTRY),
   MENU_LABEL(USER_INTERFACE_SETTINGS),
   MENU_LABEL(POWER_MANAGEMENT_SETTINGS),
   MENU_LABEL(RETRO_ACHIEVEMENTS_SETTINGS),
   MENU_LABEL(MENU_FILE_BROWSER_SETTINGS),
   MENU_LABEL(UPDATER_SETTINGS),
   MENU_LABEL(BLUETOOTH_SETTINGS),
   MENU_LABEL(WIFI_SETTINGS),
   MENU_LABEL(WIFI_NETWORKS),
   MENU_LABEL(USER_SETTINGS),
   MENU_LABEL(DIRECTORY_SETTINGS),
   MENU_LABEL(PRIVACY_SETTINGS),
   MENU_LABEL(MIDI_SETTINGS),
   MENU_LABEL(SUBSYSTEM_SETTINGS),
   MENU_ENUM_LABEL_VALUE_SUBSYSTEM_CONTENT_INFO,
   MENU_LABEL(NETWORK_HOSTING_SETTINGS),
   MENU_LABEL(NETWORK_SETTINGS),
   MENU_LABEL(NETPLAY_LOBBY_FILTERS),
   MENU_LABEL(NETPLAY_LAN_SCAN_SETTINGS),
   MENU_LABEL(WIFI_ENABLED),
   MENU_LABEL(WIFI_NETWORK_SCAN),
   MENU_LABEL(WIFI_DISCONNECT),

   MENU_ENUM_LABEL_CONNECT_BLUETOOTH,
   MENU_ENUM_LABEL_CONNECT_WIFI,
   MENU_ENUM_LABEL_CONNECT_NETPLAY_ROOM,
   MENU_ENUM_LABEL_CONNECT_NETPLAY_LAN,

   MENU_LABEL(MENU_ENUM_LINEAR_FILTER),
   MENU_LABEL(MENU_THROTTLE_FRAMERATE),
   MENU_LABEL(MENU_ENUM_THROTTLE_FRAMERATE),
   MENU_LABEL(STATE_SLOT),

   MENU_ENUM_LABEL_PLAYLIST_SETTINGS_BEGIN,

   MENU_ENUM_LABEL_VALUE_CHEEVOS_SETTINGS,

   MENU_LABEL(CHEEVOS_USERNAME),
   MENU_LABEL(CHEEVOS_PASSWORD),

   MENU_ENUM_LABEL_VALUE_ACCOUNTS_CHEEVOS_SETTINGS,
   MENU_ENUM_LABEL_VALUE_ACCOUNTS_CHEEVOS_PASSWORD,

   MENU_LABEL(ACCOUNTS_CHEEVOS_USERNAME),
   MENU_LABEL(CHEEVOS_HARDCORE_MODE_ENABLE),
   MENU_LABEL(CHEEVOS_LEADERBOARDS_ENABLE),
   MENU_LABEL(CHEEVOS_RICHPRESENCE_ENABLE),
   MENU_LABEL(CHEEVOS_BADGES_ENABLE),
   MENU_LABEL(CHEEVOS_TEST_UNOFFICIAL),
   MENU_LABEL(CHEEVOS_VERBOSE_ENABLE),
   MENU_LABEL(CHEEVOS_UNLOCK_SOUND_ENABLE),
   MENU_LABEL(CHEEVOS_AUTO_SCREENSHOT),
   MENU_LABEL(CHEEVOS_START_ACTIVE),
   MENU_LABEL(CHEEVOS_CHALLENGE_INDICATORS),
   MENU_LABEL(CHEEVOS_ENABLE),
   MENU_LABEL(CHEEVOS_DESCRIPTION),

   MENU_LABEL(CHEEVOS_APPEARANCE_SETTINGS),
   MENU_LABEL(CHEEVOS_APPEARANCE_ANCHOR),
   MENU_LABEL(CHEEVOS_APPEARANCE_PADDING_AUTO),
   MENU_LABEL(CHEEVOS_APPEARANCE_PADDING_H),
   MENU_LABEL(CHEEVOS_APPEARANCE_PADDING_V),

   MENU_ENUM_LABEL_VALUE_CHEEVOS_APPEARANCE_ANCHOR_TOPLEFT,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_APPEARANCE_ANCHOR_TOPCENTER,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_APPEARANCE_ANCHOR_TOPRIGHT,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_APPEARANCE_ANCHOR_BOTTOMLEFT,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_APPEARANCE_ANCHOR_BOTTOMCENTER,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_APPEARANCE_ANCHOR_BOTTOMRIGHT,

   MENU_LABEL(CHEEVOS_VISIBILITY_SETTINGS),
   MENU_LABEL(CHEEVOS_VISIBILITY_SUMMARY),
   MENU_LABEL(CHEEVOS_VISIBILITY_UNLOCK),
   MENU_LABEL(CHEEVOS_VISIBILITY_MASTERY),
   MENU_LABEL(CHEEVOS_VISIBILITY_ACCOUNT),
   MENU_LABEL(CHEEVOS_VISIBILITY_LBOARD_START),
   MENU_LABEL(CHEEVOS_VISIBILITY_LBOARD_SUBMIT),
   MENU_LABEL(CHEEVOS_VISIBILITY_LBOARD_CANCEL),
   MENU_LABEL(CHEEVOS_VISIBILITY_LBOARD_TRACKERS),
   MENU_LABEL(CHEEVOS_VISIBILITY_PROGRESS_TRACKER),

   MENU_ENUM_LABEL_VALUE_CHEEVOS_VISIBILITY_SUMMARY_ALLGAMES,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_VISIBILITY_SUMMARY_HASCHEEVOS,

   MENU_LBL_H(ACCOUNTS_RETRO_ACHIEVEMENTS),
   MENU_LABEL(ACCOUNTS_TWITCH),
   MENU_LABEL(ACCOUNTS_YOUTUBE),
   MENU_LABEL(ACCOUNTS_FACEBOOK),

   MENU_LABEL(ACCOUNTS_LIST),

   MENU_ENUM_LABEL_VALUE_ACCOUNTS_LIST_END,

   MENU_ENUM_LABEL_VALUE_MENU_ENUM_CONTROLS_PROLOG,

   MENU_LABEL(HELP_WHAT_IS_A_CORE),
   MENU_LABEL(HELP_LOADING_CONTENT),
   MENU_LABEL(HELP_LIST),
   MENU_LABEL(HELP_CONTROLS),
   MENU_LABEL(HELP_CHEEVOS_DESCRIPTION),

   MENU_ENUM_LABEL_VALUE_EXTRACTING_PLEASE_WAIT,

   MENU_ENUM_LABEL_WELCOME_TO_RETROARCH,

   MENU_LABEL(BROWSE_URL),
   MENU_LABEL(BROWSE_START),
   /* Deferred */
   MENU_ENUM_LABEL_DEFERRED_VIDEO_SHADER_PRESET_REMOVE_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_SHADER_PRESET_SAVE_LIST,
   MENU_ENUM_LABEL_DEFERRED_CDROM_INFO_LIST,
   MENU_ENUM_LABEL_DEFERRED_CDROM_INFO_DETAIL_LIST,
   MENU_ENUM_LABEL_DEFERRED_LOAD_DISC_LIST,
   MENU_ENUM_LABEL_DEFERRED_DUMP_DISC_LIST,
#ifdef HAVE_LAKKA
   MENU_ENUM_LABEL_DEFERRED_EJECT_DISC,
#endif
   MENU_ENUM_LABEL_DEFERRED_REMAP_FILE_MANAGER_LIST,
   MENU_ENUM_LABEL_DEFERRED_REMAPPINGS_PORT_LIST,
   MENU_ENUM_LABEL_DEFERRED_OVERRIDE_FILE_MANAGER_LIST,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_SPECIAL,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_RESOLUTION,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_AUDIO_DEVICE,
#ifdef HAVE_MICROPHONE
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_MICROPHONE_DEVICE,
#endif
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_VIDEO_SHADER_PARAMETER,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_VIDEO_SHADER_PRESET_PARAMETER,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_VIDEO_SHADER_NUM_PASSES,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_PLAYLIST_DEFAULT_CORE,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_PLAYLIST_LABEL_DISPLAY_MODE,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_PLAYLIST_RIGHT_THUMBNAIL_MODE,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_PLAYLIST_LEFT_THUMBNAIL_MODE,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_PLAYLIST_ICON_THUMBNAIL_MODE,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_PLAYLIST_SORT_MODE,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_MANUAL_CONTENT_SCAN_SYSTEM_NAME,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_MANUAL_CONTENT_SCAN_CORE_NAME,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_DISK_INDEX,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_INPUT_DEVICE_TYPE,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_INPUT_DESCRIPTION,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_INPUT_DESCRIPTION_KBD,
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_INPUT_SELECT_RESERVED_DEVICE,
#ifdef ANDROID
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_INPUT_SELECT_PHYSICAL_KEYBOARD,
#endif
   MENU_ENUM_LABEL_DEFERRED_DROPDOWN_BOX_LIST_NETPLAY_MITM_SERVER,
   MENU_ENUM_LABEL_DEFERRED_MIXER_STREAM_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CONFIGURATIONS_LIST,
   MENU_ENUM_LABEL_DEFERRED_FAVORITES_LIST,
   MENU_ENUM_LABEL_DEFERRED_PLAYLIST_LIST,
   MENU_ENUM_LABEL_DEFERRED_IMAGES_LIST,
   MENU_ENUM_LABEL_DEFERRED_MUSIC_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_LIST,
   MENU_ENUM_LABEL_DEFERRED_EXPLORE_LIST,
   MENU_ENUM_LABEL_DEFERRED_CONTENTLESS_CORES_LIST,
   MENU_ENUM_LABEL_DEFERRED_NETPLAY,
   MENU_ENUM_LABEL_DEFERRED_MUSIC,
   MENU_ENUM_LABEL_DEFERRED_BROWSE_URL_START,
   MENU_ENUM_LABEL_DEFERRED_BROWSE_URL_LIST,
   MENU_ENUM_LABEL_DEFERRED_ARCHIVE_ACTION_DETECT_CORE,
   MENU_ENUM_LABEL_DEFERRED_ARCHIVE_ACTION,
   MENU_ENUM_LABEL_DEFERRED_ARCHIVE_OPEN_DETECT_CORE,
   MENU_ENUM_LABEL_DEFERRED_ARCHIVE_OPEN,
   MENU_ENUM_LABEL_DEFERRED_CORE_CONTENT_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_CONTENT_DIRS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_CONTENT_DIRS_SUBDIR_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_SYSTEM_FILES_LIST,
   MENU_ENUM_LABEL_DEFERRED_LAKKA_LIST,
   MENU_ENUM_LABEL_DEFERRED_INPUT_HOTKEY_BINDS_LIST,
   MENU_ENUM_LABEL_DEFERRED_INPUT_RETROPAD_BINDS_LIST,
   MENU_ENUM_LABEL_DEFERRED_DATABASE_MANAGER_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_FILTER,
   MENU_ENUM_LABEL_DEFERRED_CORE_LIST_SET,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_DEVELOPER,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_PUBLISHER,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ORIGIN,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_FRANCHISE,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_EDGE_MAGAZINE_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_EDGE_MAGAZINE_ISSUE,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_FAMITSU_MAGAZINE_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ENHANCEMENT_HW,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_RELEASEMONTH,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_RELEASEYEAR,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ESRB_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ELSPA_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_PEGI_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_CERO_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_BBFC_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_MAX_USERS,
   MENU_ENUM_LABEL_DEFERRED_RDB_ENTRY_DETAIL,
   MENU_ENUM_LABEL_DEFERRED_RPL_ENTRY_ACTIONS,
   MENU_ENUM_LABEL_DEFERRED_CORE_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_UPDATER_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_MANAGER_LIST,
#ifdef HAVE_MIST
   MENU_ENUM_LABEL_DEFERRED_STEAM_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_MANAGER_STEAM_LIST,
#endif
#if 0
/* Thumbnailpack removal */
   MENU_ENUM_LABEL_DEFERRED_THUMBNAILS_UPDATER_LIST,
#endif
   MENU_ENUM_LABEL_DEFERRED_PL_THUMBNAILS_UPDATER_LIST,
   MENU_ENUM_LABEL_DEFERRED_RECORDING_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_PLAYLIST_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_PLAYLIST_MANAGER_LIST,
   MENU_ENUM_LABEL_DEFERRED_PLAYLIST_MANAGER_SETTINGS,
   MENU_ENUM_LABEL_DEFERRED_INPUT_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_INPUT_TURBO_FIRE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_INPUT_HAPTIC_FEEDBACK_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_INPUT_MENU_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_LATENCY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_DRIVER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_WINDOWED_MODE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_FULLSCREEN_MODE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_OUTPUT_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_SYNCHRONIZATION_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_HDR_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_SCALING_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CRT_SWITCHRES_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CONFIGURATION_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_SAVING_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CLOUD_SYNC_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_FRAME_THROTTLE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_REWIND_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_FRAME_TIME_COUNTER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_AI_SERVICE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ACCESSIBILITY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CHEAT_DETAILS_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CHEAT_SEARCH_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ONSCREEN_DISPLAY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ONSCREEN_OVERLAY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_OSK_OVERLAY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_OVERLAY_LIGHTGUN_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_OVERLAY_MOUSE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ONSCREEN_VIDEO_LAYOUT_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ONSCREEN_NOTIFICATIONS_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ONSCREEN_NOTIFICATIONS_VIEWS_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_MENU_VIEWS_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_QUICK_MENU_VIEWS_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_SETTINGS_VIEWS_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_QUICK_MENU_OVERRIDE_OPTIONS,
   MENU_ENUM_LABEL_DEFERRED_MENU_SETTINGS_LIST,
#ifdef _3DS
   MENU_ENUM_LABEL_DEFERRED_MENU_BOTTOM_SETTINGS_LIST,
#endif
   MENU_ENUM_LABEL_DEFERRED_USER_INTERFACE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_POWER_MANAGEMENT_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CPU_PERFPOWER_LIST,
   MENU_ENUM_LABEL_DEFERRED_CPU_POLICY_ENTRY,
   MENU_ENUM_LABEL_DEFERRED_MENU_SOUNDS_LIST,
   MENU_ENUM_LABEL_DEFERRED_MENU_FILE_BROWSER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_RETRO_ACHIEVEMENTS_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CHEEVOS_APPEARANCE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CHEEVOS_VISIBILITY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_UPDATER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_BLUETOOTH_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_WIFI_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_WIFI_NETWORKS_LIST,
   MENU_ENUM_LABEL_DEFERRED_SUBSYSTEM_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_NETWORK_HOSTING_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_NETWORK_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_NETPLAY_LOBBY_FILTERS_LIST,
   MENU_ENUM_LABEL_DEFERRED_NETPLAY_LAN_SCAN_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_LAKKA_SERVICES_LIST,
   MENU_ENUM_LABEL_DEFERRED_LAKKA_SWITCH_OPTIONS_LIST,
   MENU_ENUM_LABEL_DEFERRED_USER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_DIRECTORY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_PRIVACY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_MIDI_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_LOGGING_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_AUDIO_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_AUDIO_RESAMPLER_SETTINGS_LIST, /* deprecated */
   MENU_ENUM_LABEL_DEFERRED_AUDIO_OUTPUT_SETTINGS_LIST,
#ifdef HAVE_MICROPHONE
   MENU_ENUM_LABEL_DEFERRED_MICROPHONE_SETTINGS_LIST,
#endif
   MENU_ENUM_LABEL_DEFERRED_AUDIO_SYNCHRONIZATION_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_AUDIO_MIXER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_INFORMATION_LIST,
#ifdef HAVE_MIST
   MENU_ENUM_LABEL_DEFERRED_CORE_INFORMATION_STEAM_LIST,
#endif
   MENU_ENUM_LABEL_DEFERRED_CORE_RESTORE_BACKUP_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_DELETE_BACKUP_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_OPTION_OVERRIDE_LIST,
   MENU_ENUM_LABEL_DEFERRED_USER_BINDS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ACCOUNTS_CHEEVOS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ACCOUNTS_TWITCH_LIST,
   MENU_ENUM_LABEL_DEFERRED_ACCOUNTS_YOUTUBE_LIST,
   MENU_ENUM_LABEL_DEFERRED_ACCOUNTS_FACEBOOK_LIST,
   MENU_ENUM_LABEL_DEFERRED_ACCOUNTS_LIST,
   MENU_ENUM_LABEL_DEFERRED_INFORMATION,
   MENU_ENUM_LABEL_DEFERRED_MANUAL_CONTENT_SCAN_LIST,

   MENU_LABEL(FILE_DETECT_CORE_LIST_PUSH_DIR),
   MENU_LABEL(DOWNLOADED_FILE_DETECT_CORE_LIST),

   MENU_ENUM_LABEL_VALUE_SEARCH,
   MENU_ENUM_LABEL_VALUE_CYCLE_THUMBNAILS,

   MENU_LABEL(DOWNLOAD_CORE_CONTENT),
   MENU_LABEL(DOWNLOAD_CORE_CONTENT_DIRS),
   MENU_LABEL(DOWNLOAD_CORE_SYSTEM_FILES),
   MENU_LBL_H(SCAN_THIS_DIRECTORY),
   MENU_LABEL(SCAN_DIRECTORY),
   MENU_LABEL(SCAN_FILE),
   MENU_LABEL(NETPLAY_SHOW_ONLY_CONNECTABLE),
   MENU_LABEL(NETPLAY_SHOW_ONLY_INSTALLED_CORES),
   MENU_LABEL(NETPLAY_SHOW_PASSWORDED),
   MENU_LABEL(NETPLAY_REFRESH_ROOMS),
   MENU_LABEL(NETPLAY_REFRESH_LAN),
   MENU_LABEL(NETPLAY_ROOM_NICKNAME),
   MENU_LABEL(NETPLAY_ROOM_NICKNAME_LAN),
   MENU_LABEL(ADD_CONTENT_LIST),
   MENU_LABEL(CONFIGURATIONS_LIST),

   MENU_ENUM_LABEL_VALUE_DONT_CARE,
   MENU_ENUM_LABEL_VALUE_LINEAR,
   MENU_ENUM_LABEL_VALUE_NEAREST,
   MENU_ENUM_LABEL_VALUE_MAIN,
   MENU_ENUM_LABEL_VALUE_CONTENT,
   MENU_ENUM_LABEL_VALUE_UNKNOWN,
   MENU_ENUM_LABEL_VALUE_USER,
   MENU_ENUM_LABEL_VALUE_KEYBOARD,
   MENU_ENUM_LABEL_VALUE_CHEAT,
   MENU_ENUM_LABEL_VALUE_SHADER,
   MENU_ENUM_LABEL_VALUE_DIRECTORY_CONTENT,
   MENU_ENUM_LABEL_VALUE_DIRECTORY_NONE,
   MENU_ENUM_LABEL_VALUE_DIRECTORY_DEFAULT,
   MENU_ENUM_LABEL_VALUE_NOT_AVAILABLE,
   MENU_ENUM_LABEL_VALUE_ASK_ARCHIVE,

   /* Online Updater */

   MENU_LABEL(UPDATE_ASSETS),
   MENU_LABEL(UPDATE_LAKKA),
   MENU_LABEL(UPDATE_CHEATS),
   MENU_LABEL(UPDATE_AUTOCONFIG_PROFILES),
   MENU_LABEL(UPDATE_DATABASES),
   MENU_LABEL(UPDATE_CG_SHADERS),
   MENU_LABEL(UPDATE_OVERLAYS),
   MENU_LABEL(UPDATE_GLSL_SHADERS),
   MENU_LABEL(UPDATE_SLANG_SHADERS),
   MENU_LABEL(UPDATE_CORE_INFO_FILES),

   MENU_LABEL(INFORMATION),
   MENU_LABEL(INFORMATION_LIST),
   MENU_LABEL(USE_BUILTIN_PLAYER),
   MENU_LABEL(NETPLAY_SETTINGS),
   MENU_LABEL(CONTENT_SETTINGS),
   MENU_LBL_H(LOAD_CONTENT_LIST),
   MENU_LABEL(LOAD_CONTENT_SPECIAL),
   MENU_LABEL(NO_SETTINGS_FOUND),
   MENU_LABEL(NO_PRESETS_FOUND),
   MENU_LABEL(NO_BT_DEVICES_FOUND),
   MENU_LABEL(NO_NETWORKS_FOUND),
   MENU_LABEL(NO_PERFORMANCE_COUNTERS),
   MENU_LABEL(FRAME_THROTTLE_SETTINGS),
   MENU_LABEL(FRAME_THROTTLE_ENABLE),
   MENU_LABEL(CORE_ENABLE),

   /* Netplay */
   MENU_LABEL(NETPLAY_ENABLE_HOST),
   MENU_LABEL(NETPLAY_DISABLE_HOST),
   MENU_LABEL(NETPLAY_ENABLE_CLIENT),
   MENU_LABEL(NETPLAY_DISCONNECT),
   MENU_LABEL(NETPLAY_CONNECT_TO),
   MENU_LABEL(NETPLAY_KICK),
   MENU_ENUM_LABEL_DEFERRED_NETPLAY_KICK_LIST,
   MENU_ENUM_LABEL_NETPLAY_KICK_CLIENT,
   MENU_LABEL(NETPLAY_BAN),
   MENU_ENUM_LABEL_DEFERRED_NETPLAY_BAN_LIST,
   MENU_ENUM_LABEL_NETPLAY_BAN_CLIENT,
   MENU_LABEL(NO_NETPLAY_HOSTS_FOUND),
   MENU_LABEL(NO_NETPLAY_CLIENTS_FOUND),

   MENU_ENUM_LABEL_RESET,
   MENU_ENUM_LABEL_SLOWMOTION_HOLD,
   MENU_ENUM_LABEL_HOLD_FAST_FORWARD,
   MENU_ENUM_LABEL_CHEAT_TOGGLE,
   MENU_ENUM_LABEL_PAUSE_TOGGLE,

   MENU_LABEL(PAUSE_LIBRETRO),
   MENU_LABEL(MENU_SAVESTATE_RESUME),
   MENU_LABEL(MENU_INSERT_DISK_RESUME),
   MENU_LABEL(DIRECTORY_NOT_FOUND),
   MENU_LABEL(NO_ITEMS),
   MENU_LABEL(NO_PLAYLISTS),

   MSG_INTERFACE,
   MSG_MEMORY,
   MSG_IN_BYTES,
   MSG_IN_MEGABYTES,
   MSG_IN_GIGABYTES,
   MSG_INTERNAL_STORAGE,
   MSG_REMOVABLE_STORAGE,
   MSG_APPLICATION_DIR,
   MSG_EXTERNAL_APPLICATION_DIR,

   MENU_LABEL(SHADER_OPTIONS),
   MENU_LBL_H(USE_THIS_DIRECTORY),
   MENU_LABEL(SAVESTATE_LIST),
   MENU_LABEL(CORE_OPTIONS),
   MENU_LABEL(NO_SHADER_PARAMETERS),
   MENU_LABEL(NO_CORE_INFORMATION_AVAILABLE),
   MENU_LABEL(NO_CORE_BACKUPS_AVAILABLE),
   MENU_LABEL(NO_CORES_AVAILABLE),

   /* Audio */
   MENU_LABEL(AUDIO_ENABLE),
   MENU_LABEL(AUDIO_ENABLE_MENU),
   MENU_LBL_H(AUDIO_MAX_TIMING_SKEW),
   MENU_LABEL(AUDIO_OUTPUT_RATE),
   MENU_LBL_H(AUDIO_DEVICE),
   MENU_ENUM_LABEL_AUDIO_DEVICE_LIST,
   MENU_ENUM_LABEL_HELP_AUDIO_DEVICE_ALSA,
   MENU_ENUM_LABEL_HELP_AUDIO_DEVICE_OSS,
   MENU_ENUM_LABEL_HELP_AUDIO_DEVICE_JACK,
   MENU_ENUM_LABEL_HELP_AUDIO_DEVICE_RSOUND,
   MENU_LABEL(AUDIO_BLOCK_FRAMES),
   MENU_LABEL(AUDIO_DSP_PLUGIN),
   MENU_LABEL(AUDIO_DSP_PLUGIN_REMOVE),
   MENU_LABEL(AUDIO_MUTE),
   MENU_LABEL(AUDIO_MIXER_MUTE),
   MENU_LABEL(AUDIO_RESPECT_SILENT_MODE),
   MENU_LABEL(AUDIO_FASTFORWARD_MUTE),
   MENU_LABEL(AUDIO_FASTFORWARD_SPEEDUP),
   MENU_LABEL(AUDIO_SYNC),
   MENU_LBL_H(AUDIO_VOLUME),
   MENU_LABEL(AUDIO_MIXER_VOLUME),
   MENU_LBL_H(AUDIO_RATE_CONTROL_DELTA),
   MENU_LABEL(AUDIO_LATENCY),
   MENU_LABEL(AUDIO_RESAMPLER_QUALITY),
   MENU_LABEL(AUDIO_WASAPI_EXCLUSIVE_MODE),
   MENU_LABEL(AUDIO_WASAPI_FLOAT_FORMAT),
   MENU_LABEL(AUDIO_WASAPI_SH_BUFFER_LENGTH),

#ifdef HAVE_MICROPHONE
   /* Microphone */
   MENU_LABEL(MICROPHONE_ENABLE),
   MENU_LABEL(MICROPHONE_INPUT_RATE),
   MENU_LABEL(MICROPHONE_LATENCY),
   MENU_LABEL(MICROPHONE_RESAMPLER_QUALITY),
   MENU_LBL_H(MICROPHONE_DEVICE),
   MENU_ENUM_LABEL_MICROPHONE_DEVICE_LIST,
   MENU_LABEL(MICROPHONE_BLOCK_FRAMES),
   MENU_LABEL(MICROPHONE_WASAPI_EXCLUSIVE_MODE),
   MENU_LABEL(MICROPHONE_WASAPI_FLOAT_FORMAT),
   MENU_LABEL(MICROPHONE_WASAPI_SH_BUFFER_LENGTH),
#endif

   MENU_LABEL(SAVE_STATE),
   MENU_LABEL(LOAD_STATE),
   MENU_LABEL(UNDO_LOAD_STATE),
   MENU_LABEL(UNDO_SAVE_STATE),

   MENU_LABEL(PLAY_REPLAY),
   MENU_LABEL(RECORD_REPLAY),
   MENU_LABEL(HALT_REPLAY),
   MENU_LABEL(REPLAY_SLOT),

   MENU_LABEL(NETPLAY_GAME_WATCH),
   MENU_LABEL(CHEAT_INDEX_MINUS),
   MENU_LABEL(CHEAT_INDEX_PLUS),
   MENU_LABEL(SHADER_NEXT),
   MENU_LABEL(SHADER_PREV),
   MENU_LABEL(SHADER_TOGGLE),
   MENU_LABEL(FRAME_ADVANCE),
   MENU_LABEL(FPS_SHOW),
   MENU_LABEL(FPS_UPDATE_INTERVAL),
   MENU_LABEL(MEMORY_SHOW),
   MENU_LABEL(MEMORY_UPDATE_INTERVAL),
   MENU_LABEL(STATISTICS_SHOW),
   MENU_LABEL(FRAMECOUNT_SHOW),
   MENU_ENUM_LABEL_L_X_PLUS,
   MENU_ENUM_LABEL_L_X_MINUS,
   MENU_ENUM_LABEL_L_Y_PLUS,
   MENU_ENUM_LABEL_L_Y_MINUS,
   MENU_ENUM_LABEL_R_X_PLUS,
   MENU_ENUM_LABEL_R_X_MINUS,
   MENU_ENUM_LABEL_R_Y_MINUS,
   MENU_ENUM_LABEL_R_Y_PLUS,

   MENU_LABEL(BLOCK_SRAM_OVERWRITE),
   MENU_LABEL(GAME_SPECIFIC_OPTIONS),

   MENU_LABEL(CORE_OPTION_OVERRIDE_LIST),
   MENU_LABEL(GAME_SPECIFIC_CORE_OPTIONS_CREATE),
   MENU_LABEL(GAME_SPECIFIC_CORE_OPTIONS_REMOVE),
   MENU_LABEL(FOLDER_SPECIFIC_CORE_OPTIONS_CREATE),
   MENU_LABEL(FOLDER_SPECIFIC_CORE_OPTIONS_REMOVE),
   MENU_LABEL(CORE_OPTION_OVERRIDE_INFO),
   MENU_LABEL(CORE_OPTIONS_RESET),
   MENU_LABEL(CORE_OPTIONS_FLUSH),

   /* Legacy (unused)
    * > Cannot remove these because they are
    *   referenced in the translation files,
    *   which are handled via Crowdin */
   MENU_LABEL(GAME_SPECIFIC_OPTIONS_CREATE),
   MENU_LABEL(GAME_SPECIFIC_OPTIONS_IN_USE),

   MENU_LABEL(AUTO_OVERRIDES_ENABLE),
   MENU_LABEL(AUTO_REMAPS_ENABLE),
   MENU_LABEL(INITIAL_DISK_CHANGE_ENABLE),
   MENU_LABEL(GLOBAL_CORE_OPTIONS),
   MENU_LABEL(AUTO_SHADERS_ENABLE),
   MENU_LABEL(RGUI_SHOW_START_SCREEN),
   MENU_LABEL(SCREENSHOT),
   MENU_LABEL(REWIND),
   MENU_LABEL(REWIND_GRANULARITY),
   MENU_LABEL(REWIND_BUFFER_SIZE),
   MENU_LABEL(REWIND_BUFFER_SIZE_STEP),
   /* TODO/FIXME: INPUT_META_REWIND is incorrectly defined;
    * the LABEL/SUBLABEL enums should be entered 'manually',
    * like all the other hotkeys. Moreover, the resultant
    * MENU_ENUM_SUBLABEL_INPUT_META_REWIND enum is incorrectly
    * used for the MENU_ENUM_LABEL_REWIND_SETTINGS menu entry.
    * Because of this mistake, we now have improper entries
    * in all the translation files, which cannot easily be removed
    * now that everything is handled via Crowdin.
    * To work around this error, we have to use a separate
    * MENU_ENUM_SUBLABEL_INPUT_META_REWIND_HOTKEY enum
    * for the actual rewind hotkey sublabel... */
   MENU_LABEL(INPUT_META_REWIND),
   MENU_LABEL(INPUT_META_CHEAT_DETAILS),
   MENU_LABEL(INPUT_META_CHEAT_SEARCH),

   MENU_LABEL(CHEAT_IDX),
   MENU_LABEL(CHEAT_DESC),
   MENU_LABEL(CHEAT_STATE),
   MENU_LABEL(CHEAT_CODE),
   MENU_LABEL(CHEAT_HANDLER),
   MENU_LABEL(CHEAT_MEMORY_SEARCH_SIZE),
   MENU_LABEL(CHEAT_TYPE),
   MENU_LABEL(CHEAT_VALUE),
   MENU_LABEL(CHEAT_ADDRESS),
   MENU_LABEL(CHEAT_ADDRESS_BIT_POSITION),
   MENU_LABEL(CHEAT_REPEAT_COUNT),
   MENU_LABEL(CHEAT_REPEAT_ADD_TO_VALUE),
   MENU_LABEL(CHEAT_REPEAT_ADD_TO_ADDRESS),
   MENU_LABEL(CHEAT_RUMBLE_TYPE),
   MENU_LABEL(CHEAT_RUMBLE_VALUE),
   MENU_LABEL(CHEAT_RUMBLE_PORT),
   MENU_LABEL(CHEAT_RUMBLE_PRIMARY_STRENGTH),
   MENU_LABEL(CHEAT_RUMBLE_PRIMARY_DURATION),
   MENU_LABEL(CHEAT_RUMBLE_SECONDARY_STRENGTH),
   MENU_LABEL(CHEAT_RUMBLE_SECONDARY_DURATION),
   MENU_LABEL(CHEAT_ADD_NEW_AFTER),
   MENU_LABEL(CHEAT_ADD_NEW_BEFORE),
   MENU_LABEL(CHEAT_COPY_AFTER),
   MENU_LABEL(CHEAT_COPY_BEFORE),
   MENU_LABEL(CHEAT_DELETE),

   MENU_LBL_H(CHEAT_START_OR_CONT),
   MENU_LABEL(CHEAT_START_OR_RESTART),
   MENU_LABEL(CHEAT_SEARCH_EXACT),
   MENU_LABEL(CHEAT_SEARCH_LT),
   MENU_LABEL(CHEAT_SEARCH_GT),
   MENU_LABEL(CHEAT_SEARCH_LTE),
   MENU_LABEL(CHEAT_SEARCH_GTE),
   MENU_LABEL(CHEAT_SEARCH_EQ),
   MENU_LABEL(CHEAT_SEARCH_NEQ),
   MENU_LABEL(CHEAT_SEARCH_EQPLUS),
   MENU_LABEL(CHEAT_SEARCH_EQMINUS),
   MENU_LABEL(CHEAT_ADD_MATCHES),
   MENU_LABEL(CHEAT_CREATE_OPTION),
   MENU_LABEL(CHEAT_DELETE_OPTION),
   MENU_LABEL(CHEAT_ADD_NEW_TOP),
   MENU_LABEL(CHEAT_ADD_NEW_BOTTOM),
   MENU_LABEL(CHEAT_DELETE_ALL),
   MENU_LABEL(CHEAT_RELOAD_CHEATS),
   MENU_LABEL(CHEAT_BIG_ENDIAN),
   MENU_LABEL(CHEAT_MATCH_IDX),
   MENU_LABEL(CHEAT_MATCH),
   MENU_LABEL(CHEAT_BROWSE_MEMORY),
   MENU_LABEL(CHEAT_COPY_MATCH),
   MENU_LABEL(CHEAT_DELETE_MATCH),
   MENU_LABEL(SCREEN_RESOLUTION),

   MSG_SCREEN_RESOLUTION_FORMAT_NO_DESC,
   MSG_SCREEN_RESOLUTION_FORMAT_DESC,
   MSG_SCREEN_RESOLUTION_DEFAULT,
   MSG_SCREEN_RESOLUTION_NO_DESC,
   MSG_SCREEN_RESOLUTION_DESC,
   MSG_SCREEN_RESOLUTION_APPLYING_DEFAULT,
   MSG_SCREEN_RESOLUTION_APPLYING_NO_DESC,
   MSG_SCREEN_RESOLUTION_APPLYING_DESC,
   MSG_SCREEN_RESOLUTION_RESETTING_DEFAULT,
   MSG_SCREEN_RESOLUTION_RESETTING_NO_DESC,
   MSG_SCREEN_RESOLUTION_RESETTING_DESC,

   MENU_LABEL(SAVESTATE_AUTO_INDEX),
   MENU_LABEL(SAVESTATE_MAX_KEEP),
   MENU_LABEL(REPLAY_AUTO_INDEX),
   MENU_LABEL(REPLAY_MAX_KEEP),
   MENU_LABEL(SAVESTATE_AUTO_SAVE),
   MENU_LABEL(SAVESTATE_AUTO_LOAD),
   MENU_LABEL(SAVESTATE_THUMBNAIL_ENABLE),
   MENU_LABEL(SAVE_FILE_COMPRESSION),
   MENU_LABEL(SAVESTATE_FILE_COMPRESSION),

   MENU_LBL_H(SUSPEND_SCREENSAVER_ENABLE),
   MENU_ENUM_LABEL_VOLUME_UP,
   MENU_ENUM_LABEL_VOLUME_DOWN,

   MENU_LABEL(LOG_VERBOSITY),
   MENU_ENUM_LABEL_VALUE_LOG_VERBOSITY_DEBUG,
   MENU_ENUM_LABEL_VALUE_LOG_VERBOSITY_INFO,
   MENU_ENUM_LABEL_VALUE_LOG_VERBOSITY_WARNING,
   MENU_ENUM_LABEL_VALUE_LOG_VERBOSITY_ERROR,
   MENU_LABEL(LOG_TO_FILE),
   MENU_LABEL(LOG_TO_FILE_TIMESTAMP),

   MENU_ENUM_LABEL_OVERLAY_NEXT,

   MENU_LABEL(NETPLAY_ENABLE),
#ifdef HAVE_LAKKA
   MENU_LABEL(SSH_ENABLE),
   MENU_LABEL(SAMBA_ENABLE),
   MENU_LABEL(BLUETOOTH_ENABLE),
   MENU_LABEL(LOCALAP_ENABLE),
   MENU_LBL_H(TIMEZONE),
#endif
#ifdef HAVE_LAKKA_SWITCH
   MENU_LABEL(SWITCH_OC_ENABLE),
   MENU_LABEL(SWITCH_CEC_ENABLE),
   MENU_LABEL(BLUETOOTH_ERTM_DISABLE),
#endif
   MENU_LABEL(NETPLAY_DELAY_FRAMES), /* deprecated */
   MENU_LABEL(NETPLAY_PUBLIC_ANNOUNCE),
   MENU_LBL_H(NETPLAY_START_AS_SPECTATOR),
   MENU_LABEL(NETPLAY_FADE_CHAT),
   MENU_LABEL(NETPLAY_CHAT_COLOR_NAME),
   MENU_LABEL(NETPLAY_CHAT_COLOR_MSG),
   MENU_LABEL(NETPLAY_ALLOW_PAUSING),
   MENU_LABEL(NETPLAY_ALLOW_SLAVES),
   MENU_LABEL(NETPLAY_REQUIRE_SLAVES),
   MENU_LBL_H(NETPLAY_CHECK_FRAMES),
   MENU_LBL_H(NETPLAY_INPUT_LATENCY_FRAMES_MIN),
   MENU_LBL_H(NETPLAY_INPUT_LATENCY_FRAMES_RANGE),
   MENU_LABEL(NETPLAY_SPECTATOR_MODE_ENABLE), /* deprecated */
   MENU_LABEL(NETPLAY_TCP_UDP_PORT),
   MENU_LABEL(NETPLAY_MAX_CONNECTIONS),
   MENU_LABEL(NETPLAY_MAX_PING),
   MENU_LABEL(NETPLAY_NAT_TRAVERSAL),
   MENU_LABEL(NETPLAY_REQUEST_DEVICE_I),
   MENU_LABEL(NETPLAY_PING_SHOW),
   MENU_ENUM_LABEL_NETPLAY_REQUEST_DEVICE_1,
   MENU_ENUM_LABEL_NETPLAY_REQUEST_DEVICE_LAST = MENU_ENUM_LABEL_NETPLAY_REQUEST_DEVICE_1 + MAX_USERS,
   MENU_ENUM_LABEL_VALUE_NETPLAY_SHARE_NONE,
   MENU_ENUM_LABEL_VALUE_NETPLAY_SHARE_NO_PREFERENCE,
   MENU_LABEL(NETPLAY_SHARE_DIGITAL),
   MENU_ENUM_LABEL_VALUE_NETPLAY_SHARE_DIGITAL_OR,
   MENU_ENUM_LABEL_VALUE_NETPLAY_SHARE_DIGITAL_XOR,
   MENU_ENUM_LABEL_VALUE_NETPLAY_SHARE_DIGITAL_VOTE,
   MENU_LABEL(NETPLAY_SHARE_ANALOG),
   MENU_ENUM_LABEL_VALUE_NETPLAY_SHARE_ANALOG_MAX,
   MENU_ENUM_LABEL_VALUE_NETPLAY_SHARE_ANALOG_AVERAGE,

   MENU_LABEL(SORT_SAVEFILES_ENABLE),
   MENU_LABEL(SORT_SAVESTATES_ENABLE),
   MENU_LABEL(SORT_SAVEFILES_BY_CONTENT_ENABLE),
   MENU_LABEL(SORT_SAVESTATES_BY_CONTENT_ENABLE),
   MENU_LABEL(SAVEFILES_IN_CONTENT_DIR_ENABLE),
   MENU_LABEL(SAVESTATES_IN_CONTENT_DIR_ENABLE),
   MENU_LABEL(SYSTEMFILES_IN_CONTENT_DIR_ENABLE),
   MENU_LABEL(SCREENSHOTS_IN_CONTENT_DIR_ENABLE),
   MENU_LABEL(SORT_SCREENSHOTS_BY_CONTENT_ENABLE),
   MENU_LABEL(NETPLAY_IP_ADDRESS),
   MENU_LABEL(NETPLAY_PASSWORD),
   MENU_LABEL(NETPLAY_SPECTATE_PASSWORD),
   MENU_LABEL(NETPLAY_MODE), /* deprecated */
   MENU_LABEL(PERFCNT_ENABLE),
   MENU_LABEL(OVERLAY_SCALE_LANDSCAPE),
   MENU_LABEL(OVERLAY_ASPECT_ADJUST_LANDSCAPE),
   MENU_LABEL(OVERLAY_X_SEPARATION_LANDSCAPE),
   MENU_LABEL(OVERLAY_Y_SEPARATION_LANDSCAPE),
   MENU_LABEL(OVERLAY_X_OFFSET_LANDSCAPE),
   MENU_LABEL(OVERLAY_Y_OFFSET_LANDSCAPE),
   MENU_LABEL(OVERLAY_SCALE_PORTRAIT),
   MENU_LABEL(OVERLAY_ASPECT_ADJUST_PORTRAIT),
   MENU_LABEL(OVERLAY_X_SEPARATION_PORTRAIT),
   MENU_LABEL(OVERLAY_Y_SEPARATION_PORTRAIT),
   MENU_LABEL(OVERLAY_X_OFFSET_PORTRAIT),
   MENU_LABEL(OVERLAY_Y_OFFSET_PORTRAIT),
   MENU_LABEL(OVERLAY_PRESET),
   MENU_LABEL(OSK_OVERLAY_PRESET),
   MENU_LABEL(OVERLAY_OPACITY),
   MENU_LABEL(OSK_OVERLAY_OPACITY),

   /* TODO/FIXME: These legacy enums are no longer
    * required, but we cannot delete them until the
    * corresponding translation file entries have
    * been removed via Crowdin... */
   MENU_LABEL(OVERLAY_SCALE),
   MENU_LABEL(OVERLAY_CENTER_X),
   MENU_LABEL(OVERLAY_CENTER_Y),

   MENU_LBL_H(FASTFORWARD_RATIO),
   MENU_LABEL(FASTFORWARD_FRAMESKIP),
   MENU_LBL_H(VRR_RUNLOOP_ENABLE),
   MENU_LABEL(REWIND_ENABLE),
   MENU_LABEL(CHEAT_APPLY_AFTER_TOGGLE),
   MENU_LABEL(CHEAT_APPLY_AFTER_LOAD),

   MENU_ENUM_LABEL_ENABLE_HOTKEY,
   MENU_ENUM_LABEL_HELP_ENABLE_HOTKEY,
   MENU_ENUM_LABEL_DISK_EJECT_TOGGLE,
   MENU_ENUM_LABEL_DISK_NEXT,
   MENU_ENUM_LABEL_GRAB_MOUSE_TOGGLE,
   MENU_ENUM_LABEL_GAME_FOCUS_TOGGLE,
   MENU_LABEL(STATE_SLOT_DECREASE),
   MENU_LABEL(STATE_SLOT_INCREASE),
   MENU_LABEL(REPLAY_SLOT_DECREASE),
   MENU_LABEL(REPLAY_SLOT_INCREASE),

   MENU_LABEL(FRONTEND_LOG_LEVEL),
   MENU_LBL_H(LIBRETRO_LOG_LEVEL),
   MENU_LBL_H(AUTOSAVE_INTERVAL),
   MENU_LBL_H(REPLAY_CHECKPOINT_INTERVAL),
   MENU_LBL_H(CONFIG_SAVE_ON_EXIT),
   MENU_LABEL(REMAP_SAVE_ON_EXIT),
   MENU_LABEL(CONFIGURATION_LIST),
   MENU_LABEL(CONFIRM_ON_EXIT),
   MENU_LABEL(SHOW_HIDDEN_FILES),
   MENU_LABEL(USE_LAST_START_DIRECTORY),

   /* Driver settings */

   MENU_LABEL(AUDIO_DRIVER),
   MENU_LABEL(JOYPAD_DRIVER),
   MENU_LABEL(MENU_DRIVER),
   MENU_LABEL(LOCATION_DRIVER),
   MENU_LABEL(CAMERA_DRIVER),
   MENU_LABEL(BLUETOOTH_DRIVER),
   MENU_LABEL(WIFI_DRIVER),
   MENU_LABEL(AUDIO_RESAMPLER_DRIVER),
#ifdef HAVE_MICROPHONE
   MENU_LABEL(MICROPHONE_DRIVER),
   MENU_LABEL(MICROPHONE_RESAMPLER_DRIVER),
#endif
   MENU_LABEL(RECORD_DRIVER),
   MENU_LABEL(VIDEO_DRIVER),
   MENU_LABEL(INPUT_DRIVER),
   MENU_LABEL(MIDI_DRIVER),

   MENU_ENUM_LABEL_AUDIO_DRIVER_RSOUND,
   MENU_ENUM_LABEL_AUDIO_DRIVER_AUDIOIO,
   MENU_ENUM_LABEL_AUDIO_DRIVER_OSS,
   MENU_ENUM_LABEL_AUDIO_DRIVER_ALSA,
   MENU_ENUM_LABEL_AUDIO_DRIVER_ALSATHREAD,
   MENU_ENUM_LABEL_AUDIO_DRIVER_TINYALSA,
   MENU_ENUM_LABEL_AUDIO_DRIVER_ROAR,
   MENU_ENUM_LABEL_AUDIO_DRIVER_COREAUDIO,
   MENU_ENUM_LABEL_AUDIO_DRIVER_COREAUDIO3,
   MENU_ENUM_LABEL_AUDIO_DRIVER_AL,
   MENU_ENUM_LABEL_AUDIO_DRIVER_SL,
   MENU_ENUM_LABEL_AUDIO_DRIVER_SDL,
   MENU_ENUM_LABEL_AUDIO_DRIVER_SDL2,
   MENU_ENUM_LABEL_AUDIO_DRIVER_DSOUND,
   MENU_ENUM_LABEL_AUDIO_DRIVER_WASAPI,
   MENU_ENUM_LABEL_AUDIO_DRIVER_XAUDIO,
   MENU_ENUM_LABEL_AUDIO_DRIVER_PULSE,
   MENU_ENUM_LABEL_AUDIO_DRIVER_PIPEWIRE,
   MENU_ENUM_LABEL_AUDIO_DRIVER_EXT,
   MENU_ENUM_LABEL_AUDIO_DRIVER_XENON360,
   MENU_ENUM_LABEL_AUDIO_DRIVER_PS3,
   MENU_ENUM_LABEL_AUDIO_DRIVER_WII,
   MENU_ENUM_LABEL_AUDIO_DRIVER_WIIU,
   MENU_ENUM_LABEL_AUDIO_DRIVER_PSP,
   MENU_ENUM_LABEL_AUDIO_DRIVER_PS2,
   MENU_ENUM_LABEL_AUDIO_DRIVER_CTR,
   MENU_ENUM_LABEL_AUDIO_DRIVER_SWITCH,
   MENU_ENUM_LABEL_AUDIO_DRIVER_RWEBAUDIO,
   MENU_ENUM_LABEL_AUDIO_DRIVER_JACK,
   MENU_ENUM_LABEL_AUDIO_DRIVER_NULL,

   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_RSOUND,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_AUDIOIO,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_OSS,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_ALSA,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_ALSATHREAD,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_TINYALSA,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_ROAR,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_COREAUDIO,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_COREAUDIO3,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_AL,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_SL,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_SDL,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_SDL2,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_DSOUND,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_WASAPI,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_XAUDIO,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_PULSE,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_PIPEWIRE,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_EXT,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_XENON360,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_PS3,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_WII,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_WIIU,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_PSP,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_PS2,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_CTR,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_SWITCH,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_RWEBAUDIO,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_JACK,
   MENU_ENUM_LABEL_HELP_AUDIO_DRIVER_NULL,

   MENU_ENUM_LABEL_VIDEO_DRIVER_GL,
   MENU_ENUM_LABEL_VIDEO_DRIVER_GL1,
   MENU_ENUM_LABEL_VIDEO_DRIVER_GL_CORE,
   MENU_ENUM_LABEL_VIDEO_DRIVER_VULKAN,
   MENU_ENUM_LABEL_VIDEO_DRIVER_METAL,
   MENU_ENUM_LABEL_VIDEO_DRIVER_DRM,
   MENU_ENUM_LABEL_VIDEO_DRIVER_WII,
   MENU_ENUM_LABEL_VIDEO_DRIVER_WIIU,
   MENU_ENUM_LABEL_VIDEO_DRIVER_XENON360,
   MENU_ENUM_LABEL_VIDEO_DRIVER_D3D8,
   MENU_ENUM_LABEL_VIDEO_DRIVER_D3D9_CG,
   MENU_ENUM_LABEL_VIDEO_DRIVER_D3D9_HLSL,
   MENU_ENUM_LABEL_VIDEO_DRIVER_D3D10,
   MENU_ENUM_LABEL_VIDEO_DRIVER_D3D11,
   MENU_ENUM_LABEL_VIDEO_DRIVER_D3D12,
   MENU_ENUM_LABEL_VIDEO_DRIVER_PSP1,
   MENU_ENUM_LABEL_VIDEO_DRIVER_PS2,
   MENU_ENUM_LABEL_VIDEO_DRIVER_VITA2D,
   MENU_ENUM_LABEL_VIDEO_DRIVER_CTR,
   MENU_ENUM_LABEL_VIDEO_DRIVER_SWITCH,
   MENU_ENUM_LABEL_VIDEO_DRIVER_XVIDEO,
   MENU_ENUM_LABEL_VIDEO_DRIVER_SDL_DINGUX,
   MENU_ENUM_LABEL_VIDEO_DRIVER_SDL_RS90,
   MENU_ENUM_LABEL_VIDEO_DRIVER_SDL1,
   MENU_ENUM_LABEL_VIDEO_DRIVER_SDL2,
   MENU_ENUM_LABEL_VIDEO_DRIVER_EXT,
   MENU_ENUM_LABEL_VIDEO_DRIVER_VG,
   MENU_ENUM_LABEL_VIDEO_DRIVER_OMAP,
   MENU_ENUM_LABEL_VIDEO_DRIVER_EXYNOS,
   MENU_ENUM_LABEL_VIDEO_DRIVER_DISPMANX,
   MENU_ENUM_LABEL_VIDEO_DRIVER_SUNXI,
   MENU_ENUM_LABEL_VIDEO_DRIVER_CACA,
   MENU_ENUM_LABEL_VIDEO_DRIVER_GDI,
   MENU_ENUM_LABEL_VIDEO_DRIVER_VGA,
   MENU_ENUM_LABEL_VIDEO_DRIVER_FPGA,
   MENU_ENUM_LABEL_VIDEO_DRIVER_RSX,
   MENU_ENUM_LABEL_VIDEO_DRIVER_NULL,

   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_GL,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_GL1,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_GL_CORE,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_VULKAN,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_METAL,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_DRM,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_WII,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_WIIU,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_XENON360,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_D3D8,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_D3D9_CG,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_D3D9_HLSL,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_D3D10,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_D3D11,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_D3D12,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_PSP1,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_PS2,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_VITA2D,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_CTR,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_SWITCH,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_XVIDEO,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_SDL_DINGUX,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_SDL_RS90,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_SDL1,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_SDL2,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_EXT,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_VG,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_OMAP,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_EXYNOS,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_DISPMANX,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_SUNXI,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_CACA,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_GDI,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_VGA,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_FPGA,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_RSX,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_NULL,
   MENU_ENUM_LABEL_HELP_VIDEO_DRIVER_NO_DETAILS,

   MENU_LABEL(MENU_ENUM_DRIVER),

   MENU_ENUM_LABEL_AUDIO_RESAMPLER_DRIVER_SINC,
   MENU_ENUM_LABEL_AUDIO_RESAMPLER_DRIVER_CC,
   MENU_ENUM_LABEL_AUDIO_RESAMPLER_DRIVER_NEAREST,
   MENU_ENUM_LABEL_AUDIO_RESAMPLER_DRIVER_NULL,
   MENU_ENUM_LABEL_HELP_AUDIO_RESAMPLER_DRIVER_SINC,
   MENU_ENUM_LABEL_HELP_AUDIO_RESAMPLER_DRIVER_CC,
   MENU_ENUM_LABEL_HELP_AUDIO_RESAMPLER_DRIVER_NEAREST,
   MENU_ENUM_LABEL_HELP_AUDIO_RESAMPLER_DRIVER_NULL,

   MENU_ENUM_LABEL_MENU_DRIVER_RGUI,
   MENU_ENUM_LABEL_MENU_DRIVER_OZONE,
   MENU_ENUM_LABEL_MENU_DRIVER_MATERIALUI,
   MENU_ENUM_LABEL_MENU_DRIVER_XMB,
   MENU_ENUM_LABEL_HELP_MENU_DRIVER_RGUI,
   MENU_ENUM_LABEL_HELP_MENU_DRIVER_OZONE,
   MENU_ENUM_LABEL_HELP_MENU_DRIVER_MATERIALUI,
   MENU_ENUM_LABEL_HELP_MENU_DRIVER_XMB,

   MENU_LBL_H(SAVEFILE_DIRECTORY),
   MENU_LABEL(SAVESTATE_DIRECTORY),
   MENU_LABEL(DYNAMIC_WALLPAPERS_DIRECTORY),
   MENU_LABEL(THUMBNAILS_DIRECTORY),

   MENU_LABEL(SLOWMOTION_RATIO),
   MENU_LABEL(RUN_AHEAD_UNSUPPORTED),
   MENU_LABEL(RUN_AHEAD_HIDE_WARNINGS),
   MENU_LABEL(RUN_AHEAD_FRAMES),
   MENU_LABEL(PREEMPT_FRAMES),
   MENU_LABEL(INPUT_BLOCK_TIMEOUT),
   MENU_LABEL(TURBO),

   /* Privacy settings */

   MENU_LABEL(CAMERA_ALLOW),
   MENU_LABEL(DISCORD_ALLOW),
   MENU_LABEL(LOCATION_ALLOW),

   /* RDB Settings */

   MENU_LABEL(RDB_ENTRY_ANALOG),
   MENU_LABEL(RDB_ENTRY_SERIAL),
   MENU_LABEL(RDB_ENTRY_RUMBLE),
   MENU_LABEL(RDB_ENTRY_COOP),
   MENU_LABEL(RDB_ENTRY_START_CONTENT),
   MENU_LABEL(RDB_ENTRY_DESCRIPTION),
   MENU_LABEL(RDB_ENTRY_GENRE),
   MENU_LABEL(RDB_ENTRY_ACHIEVEMENTS),
   MENU_LABEL(RDB_ENTRY_CATEGORY),
   MENU_LABEL(RDB_ENTRY_LANGUAGE),
   MENU_LABEL(RDB_ENTRY_REGION),
   MENU_LABEL(RDB_ENTRY_CONSOLE_EXCLUSIVE),
   MENU_LABEL(RDB_ENTRY_PLATFORM_EXCLUSIVE),
   MENU_LABEL(RDB_ENTRY_SCORE),
   MENU_LABEL(RDB_ENTRY_MEDIA),
   MENU_LABEL(RDB_ENTRY_CONTROLS),
   MENU_LABEL(RDB_ENTRY_ARTSTYLE),
   MENU_LABEL(RDB_ENTRY_GAMEPLAY),
   MENU_LABEL(RDB_ENTRY_NARRATIVE),
   MENU_LABEL(RDB_ENTRY_PACING),
   MENU_LABEL(RDB_ENTRY_PERSPECTIVE),
   MENU_LABEL(RDB_ENTRY_SETTING),
   MENU_LABEL(RDB_ENTRY_VISUAL),
   MENU_LABEL(RDB_ENTRY_VEHICULAR),
   MENU_LABEL(RDB_ENTRY_ENHANCEMENT_HW),
   MENU_LABEL(RDB_ENTRY_FRANCHISE),
   MENU_LABEL(RDB_ENTRY_ORIGIN),
   MENU_LABEL(RDB_ENTRY_DEVELOPER),
   MENU_LABEL(RDB_ENTRY_NAME),
   MENU_LABEL(RDB_ENTRY_PUBLISHER),
   MENU_LABEL(RDB_ENTRY_ESRB_RATING),
   MENU_LABEL(RDB_ENTRY_BBFC_RATING),
   MENU_LABEL(RDB_ENTRY_ELSPA_RATING),
   MENU_LABEL(RDB_ENTRY_PEGI_RATING),
   MENU_LABEL(RDB_ENTRY_CERO_RATING),
   MENU_LABEL(RDB_ENTRY_EDGE_MAGAZINE_RATING),
   MENU_LABEL(RDB_ENTRY_EDGE_MAGAZINE_ISSUE),
   MENU_LABEL(RDB_ENTRY_EDGE_MAGAZINE_REVIEW),
   MENU_LABEL(RDB_ENTRY_FAMITSU_MAGAZINE_RATING),
   MENU_LABEL(RDB_ENTRY_TGDB_RATING),
   MENU_LABEL(RDB_ENTRY_RELEASE_MONTH),
   MENU_LABEL(RDB_ENTRY_RELEASE_YEAR),
   MENU_LABEL(RDB_ENTRY_MAX_USERS),
   MENU_LABEL(RDB_ENTRY_SHA1),
   MENU_LABEL(RDB_ENTRY_MD5),
   MENU_LABEL(RDB_ENTRY_CRC32),
   MENU_LABEL(RDB_ENTRY_DETAIL),

   /* Explore tab */
   MENU_LABEL(EXPLORE_INITIALISING_LIST),
   MENU_ENUM_LABEL_VALUE_EXPLORE_CATEGORY_RELEASE_YEAR,
   MENU_ENUM_LABEL_VALUE_EXPLORE_CATEGORY_PLAYER_COUNT,
   MENU_ENUM_LABEL_VALUE_EXPLORE_CATEGORY_REGION,
   MENU_ENUM_LABEL_VALUE_EXPLORE_CATEGORY_TAG,
   MENU_ENUM_LABEL_VALUE_EXPLORE_SEARCH_NAME,
   MENU_ENUM_LABEL_VALUE_EXPLORE_SHOW_ALL,
   MENU_ENUM_LABEL_VALUE_EXPLORE_ADDITIONAL_FILTER,
   MENU_ENUM_LABEL_VALUE_EXPLORE_ALL,
   MENU_ENUM_LABEL_VALUE_EXPLORE_ADD_ADDITIONAL_FILTER,
   MENU_ENUM_LABEL_VALUE_EXPLORE_ITEMS_COUNT,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_DEVELOPER,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_PUBLISHER,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_RELEASE_YEAR,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_PLAYER_COUNT,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_GENRE,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_ACHIEVEMENTS,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_CATEGORY,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_LANGUAGE,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_CONSOLE_EXCLUSIVE,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_PLATFORM_EXCLUSIVE,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_RUMBLE,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_SCORE,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_MEDIA,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_CONTROLS,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_ARTSTYLE,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_GAMEPLAY,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_NARRATIVE,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_PACING,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_PERSPECTIVE,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_SETTING,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_VISUAL,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_VEHICULAR,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_ORIGIN,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_REGION,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_FRANCHISE,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_TAG,
   MENU_ENUM_LABEL_VALUE_EXPLORE_BY_SYSTEM_NAME,
   MENU_ENUM_LABEL_EXPLORE_RANGE_FILTER,
   MENU_ENUM_LABEL_EXPLORE_VIEW,
   MENU_ENUM_LABEL_EXPLORE_SAVE_VIEW,
   MENU_ENUM_LABEL_EXPLORE_DELETE_VIEW,
   MENU_ENUM_LABEL_EXPLORE_NEW_VIEW,
   MENU_ENUM_LABEL_EXPLORE_VIEW_EXISTS,
   MENU_ENUM_LABEL_EXPLORE_VIEW_SAVED,
   MENU_ENUM_LABEL_EXPLORE_VIEW_DELETED,

   /* Content information settings */
   MENU_LABEL(CONTENT_INFO_LABEL),
   MENU_LABEL(CONTENT_INFO_PATH),
   MENU_LABEL(CONTENT_INFO_ENTRY_IDX),
   MENU_LABEL(CONTENT_INFO_CORE_NAME),
   MENU_LABEL(CONTENT_INFO_DATABASE),
   MENU_LABEL(CONTENT_INFO_RUNTIME),
   MENU_LABEL(CONTENT_INFO_LAST_PLAYED),
   MENU_LABEL(CONTENT_INFO_CHEEVOS_HASH),

   MENU_LABEL(NO_PLAYLIST_ENTRIES_AVAILABLE),

   MENU_ENUM_LABEL_VIDEO_SHADER_DEFAULT_FILTER,
   MENU_ENUM_LABEL_VIDEO_SHADER_FILTER_PASS,
   MENU_ENUM_LABEL_HELP_VIDEO_SHADER_FILTER_PASS,
   MENU_ENUM_LABEL_VIDEO_SHADER_SCALE_PASS,
   MENU_ENUM_LABEL_HELP_VIDEO_SHADER_SCALE_PASS,

   MENU_LBL_H(VIDEO_SHADER_NUM_PASSES),
   MENU_LABEL(CHEAT_NUM_PASSES),

   MENU_LABEL(NO_DISK),

   MENU_ENUM_LABEL_VALUE_MD5,
   MENU_ENUM_LABEL_VALUE_SHA1,
   MENU_ENUM_LABEL_VALUE_CRC,
   MENU_ENUM_LABEL_VALUE_MORE,

   MENU_LABEL(VIDEO_TAB),
   MENU_LABEL(MUSIC_TAB),
   MENU_LABEL(IMAGES_TAB),
   MENU_LABEL(HORIZONTAL_MENU),
   MENU_LABEL(SETTINGS_TAB),
   MENU_LABEL(HISTORY_TAB),
   MENU_LABEL(FAVORITES_TAB),
   MENU_ENUM_LABEL_EXPLORE_TAB,
   MENU_ENUM_LABEL_EXPLORE_ITEM,
   MENU_ENUM_LABEL_VALUE_EXPLORE_TAB,
   MENU_LABEL(CONTENTLESS_CORES_TAB),
   MENU_LABEL(CONTENTLESS_CORE),
   MENU_LABEL(ADD_TAB),
   MENU_LABEL(NETPLAY_TAB),
   MENU_LABEL(PLAYLISTS_TAB),
   MENU_LABEL(MAIN_MENU),
   MENU_LABEL(INPUT_SETTINGS),
   MENU_LABEL(INPUT_MENU_SETTINGS),
   MENU_LABEL(INPUT_TURBO_FIRE_SETTINGS),
   MENU_LABEL(INPUT_HAPTIC_FEEDBACK_SETTINGS),
   MENU_LABEL(ACCESSIBILITY_SETTINGS),
   MENU_LABEL(ACCESSIBILITY_ENABLED),
   MENU_LABEL(ACCESSIBILITY_NARRATOR_SPEECH_SPEED),
   MENU_LABEL(AI_SERVICE_SETTINGS),
   MENU_LABEL(AI_SERVICE_MODE),
   MENU_LABEL(AI_SERVICE_TARGET_LANG),
   MENU_LABEL(AI_SERVICE_SOURCE_LANG),
   MENU_LABEL(AI_SERVICE_URL),
   MENU_LABEL(AI_SERVICE_ENABLE),
   MENU_LABEL(AI_SERVICE_PAUSE),

   MSG_ACCESSIBILITY_STARTUP,
   MSG_AI_SERVICE_STOPPED,

   MENU_LABEL(ON),
   MENU_LABEL(OFF),
   MENU_LABEL(DISABLED),
   MENU_LABEL(ENABLED),
   MENU_ENUM_LABEL_VALUE_TRUE,
   MENU_ENUM_LABEL_VALUE_FALSE,
   MENU_ENUM_LABEL_VALUE_COMP,
   MENU_ENUM_LABEL_VALUE_MUSIC,
   MENU_ENUM_LABEL_VALUE_IMAGE,
   MENU_ENUM_LABEL_VALUE_MOVIE,
   MENU_ENUM_LABEL_VALUE_CORE,
   MENU_ENUM_LABEL_VALUE_CURSOR,
   MENU_ENUM_LABEL_VALUE_FILE,
   MENU_ENUM_LABEL_VALUE_MISSING_REQUIRED,
   MENU_ENUM_LABEL_VALUE_PRESENT_OPTIONAL,
   MENU_ENUM_LABEL_VALUE_MISSING_OPTIONAL,
   MENU_ENUM_LABEL_VALUE_PRESENT_REQUIRED,
   MENU_ENUM_LABEL_VALUE_RDB,
   MENU_ENUM_LABEL_VALUE_DIR,
   MENU_ENUM_LABEL_VALUE_NO_CORE,
   MENU_ENUM_LABEL_VALUE_DETECT,
   MENU_ENUM_LABEL_VALUE_GLSLP,
   MENU_ENUM_LABEL_VALUE_CGP,
   MENU_ENUM_LABEL_VALUE_GLSL,
   MENU_ENUM_LABEL_VALUE_CG,
   MENU_ENUM_LABEL_VALUE_SLANG,
   MENU_ENUM_LABEL_VALUE_SLANGP,

   MENU_ENUM_LABEL_VALUE_RETROPAD,
   MENU_ENUM_LABEL_VALUE_RETROPAD_WITH_ANALOG,
   MENU_ENUM_LABEL_VALUE_RETROKEYBOARD,

   MENU_LABEL(SYSTEM_BGM_ENABLE),

   MENU_LABEL(NETWORK_CMD_ENABLE),
   MENU_LABEL(NETWORK_CMD_PORT),
   MENU_LABEL(STDIN_CMD_ENABLE),
   MENU_LABEL(NETWORK_REMOTE_ENABLE),
   MENU_LABEL(NETWORK_REMOTE_PORT),
   MENU_LABEL(NETWORK_ON_DEMAND_THUMBNAILS),

   MENU_ENUM_LABEL_NETWORK_REMOTE_USER_1_ENABLE,

   MENU_ENUM_LABEL_NETWORK_REMOTE_USER_LAST_ENABLE = MENU_ENUM_LABEL_NETWORK_REMOTE_USER_1_ENABLE + MAX_USERS,

   MENU_LABEL(NETWORK_USER_REMOTE_ENABLE),

   MENU_LBL_H(DUMMY_ON_CORE_SHUTDOWN),
   MENU_LBL_H(CHECK_FOR_MISSING_FIRMWARE),
   MENU_LABEL(CORE_INFO_SAVESTATE_BYPASS),
   MENU_LABEL(CORE_OPTION_CATEGORY_ENABLE),
   MENU_LABEL(CORE_INFO_CACHE_ENABLE),
#ifndef HAVE_DYNAMIC
   MENU_LABEL(ALWAYS_RELOAD_CORE_ON_RUN_CONTENT),
#endif

   MENU_LABEL(DETECT_CORE_LIST_OK_CURRENT_CORE),
   MENU_LABEL(DETECT_CORE_LIST_OK),
   MENU_LABEL(FAVORITES),
   MENU_LABEL(START_CORE),
   MENU_LABEL(CORE_UPDATER_LIST),
   MENU_LABEL(CORE_MANAGER_LIST),
#ifdef HAVE_MIST
   /* Steam settings */
   MENU_LABEL(STEAM_SETTINGS),
   MENU_LABEL(STEAM_RICH_PRESENCE_ENABLE),
   MENU_LABEL(STEAM_RICH_PRESENCE_FORMAT),

   MENU_ENUM_LABEL_VALUE_STEAM_RICH_PRESENCE_FORMAT_CONTENT,
   MENU_ENUM_LABEL_VALUE_STEAM_RICH_PRESENCE_FORMAT_CORE,
   MENU_ENUM_LABEL_VALUE_STEAM_RICH_PRESENCE_FORMAT_SYSTEM,
   MENU_ENUM_LABEL_VALUE_STEAM_RICH_PRESENCE_FORMAT_CONTENT_SYSTEM,
   MENU_ENUM_LABEL_VALUE_STEAM_RICH_PRESENCE_FORMAT_CONTENT_CORE,
   MENU_ENUM_LABEL_VALUE_STEAM_RICH_PRESENCE_FORMAT_CONTENT_SYSTEM_CORE,

   /* Steam Core Manager */
   MENU_LABEL(CORE_MANAGER_STEAM_LIST),
   MENU_LABEL(CORE_STEAM_INSTALL),
   MENU_LABEL(CORE_STEAM_UNINSTALL),
   MENU_LABEL(MENU_SHOW_CORE_MANAGER_STEAM),
   MSG_CORE_STEAM_INSTALLING,
   MSG_CORE_STEAM_UNINSTALLED,
   MSG_CORE_STEAM_CURRENTLY_DOWNLOADING,
#endif
   MENU_LABEL(CORE_UPDATER_AUTO_EXTRACT_ARCHIVE),
   MENU_LABEL(CORE_UPDATER_SHOW_EXPERIMENTAL_CORES),
   MENU_LABEL(CORE_UPDATER_AUTO_BACKUP),
   MENU_LABEL(CORE_UPDATER_AUTO_BACKUP_HISTORY_SIZE),
   MENU_LABEL(CORE_UPDATER_BUILDBOT_URL),
   MENU_LABEL(BUILDBOT_ASSETS_URL),
   MENU_LABEL(CORE_SET_SUPPORTS_NO_CONTENT_ENABLE),
   MENU_LABEL(CLOSE_CONTENT),
   MENU_LABEL(SHOW_WIMP),
   MENU_LBL_H(QUIT_RETROARCH),
   MENU_LABEL(RESTART_RETROARCH),
   MENU_LABEL(SHUTDOWN),
   MENU_LABEL(REBOOT),
   MENU_LABEL(DISK_IMAGE_APPEND),

   MENU_ENUM_SUBLABEL_DISK_IMAGE_APPEND_TRAY_OPEN,

   MENU_LABEL(SUBSYSTEM_ADD),
   MENU_LABEL(SUBSYSTEM_LOAD),
   MENU_LBL_H(CORE_LIST),
   MENU_LABEL(DOWNLOAD_CORE),
   MENU_LABEL(SIDELOAD_CORE_LIST),
   MENU_LABEL(SIDELOAD_CORE_ERROR),
   MENU_LABEL(SIDELOAD_CORE_SUCCESS),
   MENU_LABEL(MANAGEMENT),
   MENU_LABEL(BT_CONNECTED),
   MENU_LABEL(ONLINE),
   MENU_LABEL(ONLINE_UPDATER),
   MENU_LABEL(NETPLAY),
   MENU_LABEL(SETTINGS),
   MENU_LABEL(FRONTEND_COUNTERS),
   MENU_LABEL(CORE_COUNTERS),
   MENU_LBL_H(LOAD_CONTENT_HISTORY),
   MENU_LABEL(LOAD_DISC),
   MENU_LABEL(DUMP_DISC),
#ifdef HAVE_LAKKA
   MENU_LABEL(EJECT_DISC),
#endif
   MENU_LABEL(NETWORK_INFORMATION),
   MENU_LABEL(SYSTEM_INFORMATION),
   MENU_LABEL(ACHIEVEMENT_LIST),
   MENU_LABEL(ACHIEVEMENT_LIST_HARDCORE),
   MENU_LABEL(ACHIEVEMENT_PAUSE_MENU),
   MENU_LABEL(ACHIEVEMENT_PAUSE_CANCEL),
   MENU_LABEL(ACHIEVEMENT_RESUME_CANCEL),
   MENU_LABEL(ACHIEVEMENT_PAUSE),
   MENU_LABEL(ACHIEVEMENT_RESUME),
   MENU_LABEL(ACHIEVEMENT_SERVER_UNREACHABLE),
   MENU_LABEL(CHEEVOS_SERVER_DISCONNECTED),
   MENU_LABEL(CHEEVOS_SERVER_RECONNECTED),
   MENU_LABEL(CHEEVOS_IDENTIFYING_GAME),
   MENU_LABEL(CHEEVOS_FETCHING_GAME_DATA),
   MENU_LABEL(CHEEVOS_STARTING_SESSION),
   MENU_LABEL(CORE_INFORMATION),
   MENU_LABEL(DISC_INFORMATION),
   MENU_LABEL(CORE_LOCK),
   MENU_LABEL(CORE_SET_STANDALONE_EXEMPT),
   MENU_LABEL(CORE_DELETE),

   MSG_CORE_LOCK_FAILED,
   MSG_CORE_UNLOCK_FAILED,
   MSG_CORE_SET_STANDALONE_EXEMPT_FAILED,
   MSG_CORE_UNSET_STANDALONE_EXEMPT_FAILED,
   MSG_CORE_DELETE_DISABLED,

   /* Core updater */
   MENU_LABEL(UPDATE_INSTALLED_CORES),
   MENU_LABEL(SWITCH_INSTALLED_CORES_PFD),

   MSG_FETCHING_CORE_LIST,
   MSG_CORE_LIST_FAILED,
   MSG_LATEST_CORE_INSTALLED,
   MSG_UPDATING_CORE,
   MSG_DOWNLOADING_CORE,
   MSG_EXTRACTING_CORE,
   MSG_CORE_INSTALLED,
   MSG_CORE_INSTALL_FAILED,
   MSG_SCANNING_CORES,
   MSG_CHECKING_CORE,
   MSG_ALL_CORES_UPDATED,
   MSG_ALL_CORES_SWITCHED_PFD,
   MSG_NUM_CORES_UPDATED,
   MSG_NUM_CORES_LOCKED,
   MSG_CORE_UPDATE_DISABLED,

   /* Core backup/restore */
   MENU_LABEL(CORE_CREATE_BACKUP),
   MENU_LABEL(CORE_RESTORE_BACKUP_LIST),
   MENU_LABEL(CORE_DELETE_BACKUP_LIST),

   MENU_ENUM_LABEL_CORE_RESTORE_BACKUP_ENTRY,
   MENU_ENUM_LABEL_CORE_DELETE_BACKUP_ENTRY,
   MENU_ENUM_LABEL_VALUE_CORE_BACKUP_MODE_AUTO,
   MENU_ENUM_LABEL_VALUE_CORE_BACKUP_CRC,

   MSG_CORE_BACKUP_SCANNING_CORE,
   MSG_CORE_BACKUP_ALREADY_EXISTS,
   MSG_BACKING_UP_CORE,
   MSG_PRUNING_CORE_BACKUP_HISTORY,
   MSG_CORE_BACKUP_COMPLETE,
   MSG_CORE_RESTORATION_ALREADY_INSTALLED,
   MSG_RESTORING_CORE,
   MSG_CORE_RESTORATION_COMPLETE,
   MSG_CORE_INSTALLATION_ALREADY_INSTALLED,
   MSG_INSTALLING_CORE,
   MSG_CORE_INSTALLATION_COMPLETE,
   MSG_CORE_RESTORATION_INVALID_CONTENT,
   MSG_CORE_BACKUP_FAILED,
   MSG_CORE_RESTORATION_FAILED,
   MSG_CORE_INSTALLATION_FAILED,
   MSG_CORE_RESTORATION_DISABLED,
   MSG_CORE_INSTALLATION_DISABLED,

   MENU_LABEL(VIDEO_SHADER_PARAMETERS),
   MENU_LABEL(VIDEO_SHADER_PRESET_PARAMETERS),
   MENU_LABEL(DISK_OPTIONS),
   MENU_LABEL(DISK_CYCLE_TRAY_STATUS),
   MENU_LABEL(DISK_TRAY_EJECT),
   MENU_LABEL(DISK_TRAY_INSERT),
   MENU_LABEL(NO_CORE_OPTIONS_AVAILABLE),
   MENU_LABEL(DISK_INDEX),
   MENU_LABEL(CORE_CHEAT_OPTIONS),
   MENU_LABEL(CORE_INPUT_REMAPPING_OPTIONS),
   MENU_LABEL(DATABASE_MANAGER),
   MENU_LABEL(CURSOR_MANAGER),

   MENU_ENUM_LABEL_DATABASE_MANAGER_LIST,
   MENU_ENUM_LABEL_CURSOR_MANAGER_LIST,
   MENU_ENUM_LABEL_VALUE_SUPPORTED_CORES,
   MENU_ENUM_LABEL_VIDEO_SHADER_PASS,
   MENU_ENUM_LABEL_HELP_VIDEO_SHADER_PASS,
   MENU_ENUM_LABEL_VIDEO_SHADER_PRESET_TWO,
   MENU_ENUM_LABEL_VIDEO_SHADER_PRESET_PREPEND_TWO,
   MENU_ENUM_LABEL_VIDEO_SHADER_PRESET_APPEND_TWO,

   MENU_LBL_H(VIDEO_SHADER_PRESET),
   MENU_LABEL(VIDEO_SHADER_PRESET_PREPEND),
   MENU_LABEL(VIDEO_SHADER_PRESET_APPEND),
   MENU_LABEL(CHEAT_FILE_LOAD),
   MENU_LABEL(CHEAT_FILE_LOAD_APPEND),
   MENU_LABEL(CHEAT_FILE_SAVE_AS),

   MENU_ENUM_LABEL_MESSAGE,
   MENU_ENUM_LABEL_INFO_SCREEN,

   MENU_LABEL(CUSTOM_RATIO),
   MENU_LABEL(HELP),
   MENU_ENUM_LABEL_VALUE_CLEAR_SETTING,
   MENU_ENUM_LABEL_VALUE_SCAN_ENTRY,
   MENU_ENUM_LABEL_VALUE_MANAGE,
   MENU_LABEL(CHEAT_DATABASE_PATH),
   MENU_LABEL(OSK_OVERLAY_DIRECTORY),
   MENU_LABEL(RECORDING_OUTPUT_DIRECTORY),
   MENU_LABEL(RECORDING_CONFIG_DIRECTORY),
   MENU_LBL_H(VIDEO_FILTER),
   MENU_ENUM_LABEL_HELP_VIDEO_FILTER_BUILTIN,
   MENU_LABEL(VIDEO_FILTER_REMOVE),
   MENU_LABEL(PAL60_ENABLE),

   MENU_LABEL(CONTENT_HISTORY_PATH),

   MENU_LABEL(RGUI_BROWSER_DIRECTORY),
   MENU_LABEL(CONTENT_DATABASE_DIRECTORY),
   MENU_LABEL(PLAYLIST_DIRECTORY),
   MENU_LABEL(CONTENT_FAVORITES_DIRECTORY),
   MENU_LABEL(CONTENT_HISTORY_DIRECTORY),
   MENU_LABEL(CONTENT_IMAGE_HISTORY_DIRECTORY),
   MENU_LABEL(CONTENT_MUSIC_HISTORY_DIRECTORY),
   MENU_LABEL(CONTENT_VIDEO_HISTORY_DIRECTORY),
   MENU_LABEL(RUNTIME_LOG_DIRECTORY),
   MENU_LABEL(CORE_ASSETS_DIRECTORY),
   MENU_LABEL(SCREENSHOT_DIRECTORY),
   MENU_LABEL(CONTENT_DIRECTORY),
   MENU_LABEL(VIDEO_SHADER_DIR),
   MENU_LABEL(VIDEO_FILTER_DIR),
   MENU_LABEL(AUDIO_FILTER_DIR),
   MENU_LABEL(LOG_DIR),

   MENU_LABEL(TURBO_DEADZONE_LIST),
   MENU_LABEL(LIBRETRO_DIR_PATH),
   MENU_LABEL(LIBRETRO_INFO_PATH),
   MENU_LABEL(RGUI_CONFIG_DIRECTORY),
   MENU_LABEL(OVERLAY_DIRECTORY),
   MENU_LABEL(VIDEO_LAYOUT_DIRECTORY),
   MENU_LABEL(SYSTEM_DIRECTORY),
   MENU_LABEL(ASSETS_DIRECTORY),
   MENU_LABEL(CACHE_DIRECTORY),
   MENU_LABEL(JOYPAD_AUTOCONFIG_DIR),
   MENU_LABEL(DRIVER_SETTINGS),
   MENU_LABEL(VIDEO_SETTINGS),
   MENU_LABEL(VIDEO_WINDOWED_MODE_SETTINGS),
   MENU_LABEL(VIDEO_FULLSCREEN_MODE_SETTINGS),
   MENU_LABEL(VIDEO_OUTPUT_SETTINGS),
   MENU_LABEL(VIDEO_SYNCHRONIZATION_SETTINGS),
   MENU_LABEL(VIDEO_SCALING_SETTINGS),
   MENU_LABEL(VIDEO_HDR_SETTINGS),
   MENU_LABEL(CRT_SWITCHRES_SETTINGS),
   MENU_LABEL(AUDIO_SETTINGS),
   MENU_LABEL(AUDIO_RESAMPLER_SETTINGS), /* deprecated */
   MENU_LABEL(AUDIO_OUTPUT_SETTINGS),
#ifdef HAVE_MICROPHONE
   MENU_LABEL(MICROPHONE_SETTINGS),
#endif
   MENU_LABEL(AUDIO_SYNCHRONIZATION_SETTINGS),
   MENU_LABEL(AUDIO_MIXER_SETTINGS),
   MENU_LABEL(LATENCY_SETTINGS),
   MENU_LABEL(CORE_SETTINGS),
   MENU_LABEL(CONFIGURATION_SETTINGS),
   MENU_LABEL(LOGGING_SETTINGS),
   MENU_LABEL(SAVING_SETTINGS),
   MENU_LABEL(CLOUD_SYNC_SETTINGS),
   MENU_LABEL(CLOUD_SYNC_ENABLE),
   MENU_LABEL(CLOUD_SYNC_DESTRUCTIVE),
   MENU_LABEL(CLOUD_SYNC_SYNC_SAVES),
   MENU_LABEL(CLOUD_SYNC_SYNC_CONFIGS),
   MENU_LABEL(CLOUD_SYNC_SYNC_THUMBS),
   MENU_LABEL(CLOUD_SYNC_SYNC_SYSTEM),
   MENU_LABEL(CLOUD_SYNC_DRIVER),
   MENU_LABEL(CLOUD_SYNC_URL),
   MENU_LABEL(CLOUD_SYNC_USERNAME),
   MENU_LABEL(CLOUD_SYNC_PASSWORD),
   MENU_LABEL(RECORDING_SETTINGS),
   MENU_LABEL(OVERLAY_SETTINGS),
   MENU_LABEL(REWIND_SETTINGS),
   MENU_LABEL(FRAME_TIME_COUNTER_SETTINGS),
   MENU_LABEL(FRAME_TIME_COUNTER_RESET_AFTER_FASTFORWARDING),
   MENU_LABEL(FRAME_TIME_COUNTER_RESET_AFTER_LOAD_STATE),
   MENU_LABEL(FRAME_TIME_COUNTER_RESET_AFTER_SAVE_STATE),
   MENU_LABEL(CHEAT_SETTINGS),
   MENU_LABEL(CHEAT_DETAILS_SETTINGS),
   MENU_LABEL(CHEAT_SEARCH_SETTINGS),

   /* Core option category placeholders for icons */
   MENU_LABEL(HACKS_SETTINGS),
   MENU_LABEL(MAPPING_SETTINGS),
   MENU_LABEL(MEDIA_SETTINGS),
   MENU_LABEL(PERFORMANCE_SETTINGS),
   MENU_LABEL(SOUND_SETTINGS),
   MENU_LABEL(SPECS_SETTINGS),
   MENU_LABEL(STORAGE_SETTINGS),
   MENU_LABEL(SYSTEM_SETTINGS),
   MENU_LABEL(TIMING_SETTINGS),

   MENU_ENUM_LABEL_ONSCREEN_KEYBOARD_OVERLAY_SETTINGS,

   MENU_LABEL(MULTIMEDIA_SETTINGS),
   MENU_LABEL(PLAYLIST_SETTINGS),
   MENU_LABEL(PLAYLIST_MANAGER_LIST),
   MENU_LABEL(PLAYLIST_MANAGER_SETTINGS),
   MENU_LABEL(PLAYLIST_MANAGER_DEFAULT_CORE),
   MENU_LABEL(PLAYLIST_MANAGER_RESET_CORES),

   MSG_PLAYLIST_MANAGER_RESETTING_CORES,
   MSG_PLAYLIST_MANAGER_CORES_RESET,

   MENU_LABEL(PLAYLIST_MANAGER_LABEL_DISPLAY_MODE),

   MENU_ENUM_LABEL_VALUE_PLAYLIST_MANAGER_LABEL_DISPLAY_MODE_DEFAULT,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_MANAGER_LABEL_DISPLAY_MODE_REMOVE_PARENS,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_MANAGER_LABEL_DISPLAY_MODE_REMOVE_BRACKETS,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_MANAGER_LABEL_DISPLAY_MODE_REMOVE_PARENS_AND_BRACKETS,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_MANAGER_LABEL_DISPLAY_MODE_KEEP_REGION,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_MANAGER_LABEL_DISPLAY_MODE_KEEP_DISC_INDEX,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_MANAGER_LABEL_DISPLAY_MODE_KEEP_REGION_AND_DISC_INDEX,

   MENU_LABEL(PLAYLIST_MANAGER_RIGHT_THUMBNAIL_MODE),
   MENU_LABEL(PLAYLIST_MANAGER_LEFT_THUMBNAIL_MODE),

   MENU_ENUM_LABEL_VALUE_PLAYLIST_MANAGER_THUMBNAIL_MODE_DEFAULT,

   MENU_LABEL(PLAYLIST_MANAGER_SORT_MODE),

   MENU_ENUM_LABEL_VALUE_PLAYLIST_MANAGER_SORT_MODE_DEFAULT,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_MANAGER_SORT_MODE_ALPHABETICAL,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_MANAGER_SORT_MODE_OFF,

   MENU_LABEL(PLAYLIST_MANAGER_CLEAN_PLAYLIST),

   MSG_PLAYLIST_MANAGER_CLEANING_PLAYLIST,
   MSG_PLAYLIST_MANAGER_PLAYLIST_CLEANED,

   MENU_LABEL(PLAYLIST_MANAGER_REFRESH_PLAYLIST),

   MSG_PLAYLIST_MANAGER_REFRESH_MISSING_CONFIG,
   MSG_PLAYLIST_MANAGER_REFRESH_INVALID_CONTENT_DIR,
   MSG_PLAYLIST_MANAGER_REFRESH_INVALID_SYSTEM_NAME,
   MSG_PLAYLIST_MANAGER_REFRESH_INVALID_CORE,
   MSG_PLAYLIST_MANAGER_REFRESH_INVALID_DAT_FILE,
   MSG_PLAYLIST_MANAGER_REFRESH_DAT_FILE_TOO_LARGE,

   MENU_LABEL(CORE_UPDATER_SETTINGS),
   MENU_LABEL(LAKKA_SERVICES),
#ifdef HAVE_LAKKA_SWITCH
   MENU_LABEL(LAKKA_SWITCH_OPTIONS),
#endif
   MENU_LBL_H(SHADER_APPLY_CHANGES),
   MENU_LBL_H(SHADER_WATCH_FOR_CHANGES),
   MENU_LABEL(VIDEO_SHADER_REMEMBER_LAST_DIR),
   MENU_LABEL(SAVE_NEW_CONFIG),
   MENU_LABEL(ONSCREEN_DISPLAY_SETTINGS),
   MENU_LABEL(ONSCREEN_OVERLAY_SETTINGS),
   MENU_LABEL(OVERLAY_LIGHTGUN_SETTINGS),
   MENU_LABEL(OVERLAY_MOUSE_SETTINGS),
   MENU_LABEL(OSK_OVERLAY_SETTINGS),
   MENU_LABEL(ONSCREEN_VIDEO_LAYOUT_SETTINGS),
   MENU_LABEL(ONSCREEN_NOTIFICATIONS_SETTINGS),
   MENU_LABEL(ONSCREEN_NOTIFICATIONS_VIEWS_SETTINGS),
   MENU_LABEL(CHEAT_APPLY_CHANGES),
   MENU_LABEL(CHEAT_START_SEARCH),
   MENU_LABEL(CHEAT_CONTINUE_SEARCH),
   MENU_LABEL(CHEAT_VIEW_MATCHES),

   MENU_ENUM_LABEL_COLLECTION,
   MENU_LABEL(CONFIGURATIONS),
   MENU_LABEL(BROWSE_URL_LIST),

   MENU_ENUM_LABEL_CUSTOM_BIND,

   MENU_ENUM_LABEL_CUSTOM_BIND_ALL,

   MENU_ENUM_LABEL_CUSTOM_BIND_DEFAULTS,
   MENU_ENUM_LABEL_EXIT_EMULATOR,
   MENU_ENUM_LABEL_OSK_ENABLE,

   MENU_ENUM_LABEL_VALUE_REMAP_FILE,
   MENU_LABEL(REMAP_FILE_MANAGER_LIST),
   MENU_LABEL(REMAP_FILE_INFO),
   MENU_LABEL(REMAP_FILE_LOAD),
   MENU_LABEL(REMAP_FILE_SAVE_AS),
   MENU_LABEL(REMAP_FILE_SAVE_CORE),
   MENU_LABEL(REMAP_FILE_SAVE_CONTENT_DIR),
   MENU_LABEL(REMAP_FILE_SAVE_GAME),
   MENU_LABEL(REMAP_FILE_REMOVE_CORE),
   MENU_LABEL(REMAP_FILE_REMOVE_CONTENT_DIR),
   MENU_LABEL(REMAP_FILE_REMOVE_GAME),
   MENU_LABEL(REMAP_FILE_RESET),
   MENU_LABEL(REMAP_FILE_FLUSH),

   MENU_LABEL(OVERRIDE_FILE_INFO),
   MENU_LABEL(OVERRIDE_FILE_LOAD),
   MENU_LABEL(OVERRIDE_FILE_SAVE_AS),
   MENU_LABEL(OVERRIDE_UNLOAD),

   MENU_LABEL(RESTART_CONTENT),
   MENU_LABEL(RESUME),
   MENU_LABEL(RESUME_CONTENT),

   MENU_LABEL(DELETE_ENTRY),
   MENU_LABEL(RENAME_ENTRY),

   MENU_LABEL(TAKE_SCREENSHOT),

   MENU_ENUM_LABEL_VALUE_UNABLE_TO_READ_COMPRESSED_FILE,

   MENU_LABEL(VIDEO_SHADER_PRESET_REMOVE),
   MENU_LABEL(VIDEO_SHADER_PRESET_REMOVE_GLOBAL),
   MENU_LABEL(VIDEO_SHADER_PRESET_REMOVE_CORE),
   MENU_LABEL(VIDEO_SHADER_PRESET_REMOVE_PARENT),
   MENU_LABEL(VIDEO_SHADER_PRESET_REMOVE_GAME),
   MENU_LABEL(VIDEO_SHADER_PRESET_SAVE),
   MENU_LABEL(VIDEO_SHADER_PRESET_SAVE_REFERENCE),
   MENU_LABEL(VIDEO_SHADER_PRESET_SAVE_AS),
   MENU_LABEL(VIDEO_SHADER_PRESET_SAVE_GLOBAL),
   MENU_LABEL(VIDEO_SHADER_PRESET_SAVE_CORE),
   MENU_LABEL(VIDEO_SHADER_PRESET_SAVE_PARENT),
   MENU_LABEL(VIDEO_SHADER_PRESET_SAVE_GAME),
   MENU_LBL_H(USER_LANGUAGE),
   MENU_LABEL(NETPLAY_NICKNAME),
   MENU_LABEL(VIDEO_VI_WIDTH),
   MENU_LABEL(VIDEO_OVERSCAN_CORRECTION_TOP),
   MENU_LABEL(VIDEO_OVERSCAN_CORRECTION_BOTTOM),
   MENU_LABEL(VIDEO_ASPECT_RATIO),
   MENU_LABEL(VIDEO_VIEWPORT_BIAS_X),
   MENU_LABEL(VIDEO_VIEWPORT_BIAS_Y),
#if defined(RARCH_MOBILE)
   MENU_LABEL(VIDEO_VIEWPORT_BIAS_PORTRAIT_X),
   MENU_LABEL(VIDEO_VIEWPORT_BIAS_PORTRAIT_Y),
#endif
   MENU_LABEL(VIDEO_FORCE_ASPECT),
   MENU_LABEL(VIDEO_ASPECT_RATIO_AUTO),
   MENU_LABEL(VIDEO_ASPECT_RATIO_INDEX),
   MENU_ENUM_LABEL_VALUE_VIDEO_ASPECT_RATIO_CONFIG,
   MENU_ENUM_LABEL_VALUE_VIDEO_ASPECT_RATIO_SQUARE_PIXEL,
   MENU_ENUM_LABEL_VALUE_VIDEO_ASPECT_RATIO_CORE_PROVIDED,
   MENU_ENUM_LABEL_VALUE_VIDEO_ASPECT_RATIO_CUSTOM,
   MENU_ENUM_LABEL_VALUE_VIDEO_ASPECT_RATIO_FULL,
#if defined(DINGUX)
   MENU_LABEL(VIDEO_DINGUX_IPU_KEEP_ASPECT),
   MENU_LABEL(VIDEO_DINGUX_IPU_FILTER_TYPE),

   MENU_ENUM_LABEL_VALUE_VIDEO_DINGUX_IPU_FILTER_BICUBIC,
   MENU_ENUM_LABEL_VALUE_VIDEO_DINGUX_IPU_FILTER_BILINEAR,
   MENU_ENUM_LABEL_VALUE_VIDEO_DINGUX_IPU_FILTER_NEAREST,
#if defined(DINGUX_BETA)
   MENU_LABEL(VIDEO_DINGUX_REFRESH_RATE),

   MENU_ENUM_LABEL_VALUE_VIDEO_DINGUX_REFRESH_RATE_60HZ,
   MENU_ENUM_LABEL_VALUE_VIDEO_DINGUX_REFRESH_RATE_50HZ,
#endif
#if defined(RS90) || defined(MIYOO)
   MENU_LABEL(VIDEO_DINGUX_RS90_SOFTFILTER_TYPE),

   MENU_ENUM_LABEL_VALUE_VIDEO_DINGUX_RS90_SOFTFILTER_POINT,
   MENU_ENUM_LABEL_VALUE_VIDEO_DINGUX_RS90_SOFTFILTER_BRESENHAM_HORZ,
#endif
#endif
   MENU_LABEL(VIDEO_VFILTER),
   MENU_LABEL(VIDEO_GPU_RECORD),
   MENU_LABEL(RECORD_USE_OUTPUT_DIRECTORY),
   MENU_LABEL(RECORD_CONFIG),
   MENU_LABEL(STREAM_CONFIG),
   MENU_LABEL(RECORD_PATH),
   MENU_LABEL(VIDEO_POST_FILTER_RECORD),
   MENU_LABEL(RECORD_ENABLE),

   MENU_LABEL(SECONDS),
   MENU_LABEL(STATUS),

   MENU_ENUM_LABEL_VALUE_CORE_INFO_CORE_NAME,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_CORE_LABEL,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_CORE_VERSION,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SYSTEM_NAME,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SYSTEM_MANUFACTURER,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_CATEGORIES,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_AUTHORS,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_PERMISSIONS,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_LICENSES,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SUPPORTED_EXTENSIONS,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_FIRMWARE,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_FIRMWARE_IN_CONTENT_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_FIRMWARE_PATH,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_REQUIRED_HW_API,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_CORE_PATH,

   MENU_ENUM_LABEL_VALUE_CORE_INFO_SAVESTATE_SUPPORT_LEVEL,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SAVESTATE_DISABLED,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SAVESTATE_BASIC,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SAVESTATE_SERIALIZED,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SAVESTATE_DETERMINISTIC,

   /* System information */

   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_LAKKA_VERSION,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DYNAMIC_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_BUILD_DATE,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RETROARCH_VERSION,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_GIT_VERSION,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_CPU_MODEL,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_CPU_FEATURES,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FRONTEND_IDENTIFIER,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FRONTEND_NAME,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FRONTEND_OS,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RETRORATING_LEVEL,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE_NO_SOURCE,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE_CHARGING,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE_CHARGED,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE_DISCHARGING,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_VIDEO_CONTEXT_DRIVER,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DISPLAY_METRIC_MM_WIDTH,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DISPLAY_METRIC_MM_HEIGHT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DISPLAY_METRIC_DPI,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_LIBRETRODB_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OVERLAY_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_COMMAND_IFACE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_NETWORK_COMMAND_IFACE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_NETWORK_REMOTE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_COCOA_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RTGA_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RBMP_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RJPEG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RPNG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_SDL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_SDL2_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_GDI_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_D3D8_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_D3D9_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_D3D10_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_D3D11_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_D3D12_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_VULKAN_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_METAL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENGL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENGLES_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_THREADING_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_KMS_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_UDEV_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENVG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_EGL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_X11_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_WAYLAND_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_XVIDEO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_ALSA_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OSS_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENAL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_COREAUDIO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_COREAUDIO3_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENSL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RSOUND_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_ROARAUDIO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_JACK_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_PULSEAUDIO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_PIPEWIRE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DSOUND_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_WASAPI_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_XAUDIO2_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_ZLIB_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_7ZIP_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DYLIB_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_CG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_GLSL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_SLANG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_HLSL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_SDL_IMAGE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FBO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FFMPEG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_MPV_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_CORETEXT_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FREETYPE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_STB_TRUETYPE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_NETPLAY_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_V4L2_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_LIBUSB_SUPPORT,

   MENU_ENUM_LABEL_VALUE_CORE_ASSETS_DIR,

   MENU_LABEL(CONTENT_DIR),
   MENU_LABEL(DATABASE_SELECTION),
   MENU_LABEL(DATABASE_CURSOR_LIST),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_DEVELOPER),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_PUBLISHER),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_ORIGIN),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_FRANCHISE),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_ESRB_RATING),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_ELSPA_RATING),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_PEGI_RATING),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_CERO_RATING),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_BBFC_RATING),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_MAX_USERS),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_EDGE_MAGAZINE_ISSUE),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_EDGE_MAGAZINE_RATING),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_RELEASEDATE_BY_MONTH),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_RELEASEDATE_BY_YEAR),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_DATABASE_INFO),

   MENU_ENUM_LABEL_VALUE_NO,
   MENU_ENUM_LABEL_VALUE_YES,

   MENU_ENUM_LABEL_VALUE_PORT,
   MENU_ENUM_LABEL_VALUE_PORT_DEVICE_NAME,
   MENU_ENUM_LABEL_VALUE_PORT_DEVICE_INFO,

   MENU_ENUM_LABEL_VALUE_LEFT_ANALOG,
   MENU_ENUM_LABEL_VALUE_RIGHT_ANALOG,
   MENU_ENUM_LABEL_VALUE_LEFT_ANALOG_FORCED,
   MENU_ENUM_LABEL_VALUE_RIGHT_ANALOG_FORCED,

   MENU_ENUM_LABEL_VALUE_LANG_ENGLISH,
   MENU_ENUM_LABEL_VALUE_LANG_JAPANESE,
   MENU_ENUM_LABEL_VALUE_LANG_FRENCH,
   MENU_ENUM_LABEL_VALUE_LANG_SPANISH,
   MENU_ENUM_LABEL_VALUE_LANG_GERMAN,
   MENU_ENUM_LABEL_VALUE_LANG_ITALIAN,
   MENU_ENUM_LABEL_VALUE_LANG_DUTCH,
   MENU_ENUM_LABEL_VALUE_LANG_PORTUGUESE_BRAZIL,
   MENU_ENUM_LABEL_VALUE_LANG_PORTUGUESE_PORTUGAL,
   MENU_ENUM_LABEL_VALUE_LANG_RUSSIAN,
   MENU_ENUM_LABEL_VALUE_LANG_KOREAN,
   MENU_ENUM_LABEL_VALUE_LANG_CHINESE_TRADITIONAL,
   MENU_ENUM_LABEL_VALUE_LANG_CHINESE_SIMPLIFIED,
   MENU_ENUM_LABEL_VALUE_LANG_ESPERANTO,
   MENU_ENUM_LABEL_VALUE_LANG_POLISH,
   MENU_ENUM_LABEL_VALUE_LANG_VIETNAMESE,
   MENU_ENUM_LABEL_VALUE_LANG_ARABIC,
   MENU_ENUM_LABEL_VALUE_LANG_GREEK,
   MENU_ENUM_LABEL_VALUE_LANG_TURKISH,

   MENU_ENUM_LABEL_VALUE_LANG_ASTURIAN,
   MENU_ENUM_LABEL_VALUE_LANG_BRITISH_ENGLISH,
   MENU_ENUM_LABEL_VALUE_LANG_CZECH,
   MENU_ENUM_LABEL_VALUE_LANG_DANISH,
   MENU_ENUM_LABEL_VALUE_LANG_SWEDISH,
   MENU_ENUM_LABEL_VALUE_LANG_CROATIAN,
   MENU_ENUM_LABEL_VALUE_LANG_CATALAN,
   MENU_ENUM_LABEL_VALUE_LANG_BULGARIAN,
   MENU_ENUM_LABEL_VALUE_LANG_BENGALI,
   MENU_ENUM_LABEL_VALUE_LANG_BASQUE,
   MENU_ENUM_LABEL_VALUE_LANG_AZERBAIJANI,
   MENU_ENUM_LABEL_VALUE_LANG_ALBANIAN,
   MENU_ENUM_LABEL_VALUE_LANG_AFRIKAANS,
   MENU_ENUM_LABEL_VALUE_LANG_ESTONIAN,
   MENU_ENUM_LABEL_VALUE_LANG_FILIPINO,
   MENU_ENUM_LABEL_VALUE_LANG_FINNISH,
   MENU_ENUM_LABEL_VALUE_LANG_GALICIAN,
   MENU_ENUM_LABEL_VALUE_LANG_GEORGIAN,
   MENU_ENUM_LABEL_VALUE_LANG_GUJARATI,
   MENU_ENUM_LABEL_VALUE_LANG_HAITIAN_CREOLE,
   MENU_ENUM_LABEL_VALUE_LANG_HEBREW,
   MENU_ENUM_LABEL_VALUE_LANG_HINDI,
   MENU_ENUM_LABEL_VALUE_LANG_HUNGARIAN,
   MENU_ENUM_LABEL_VALUE_LANG_ICELANDIC,
   MENU_ENUM_LABEL_VALUE_LANG_INDONESIAN,
   MENU_ENUM_LABEL_VALUE_LANG_IRISH,
   MENU_ENUM_LABEL_VALUE_LANG_KANNADA,
   MENU_ENUM_LABEL_VALUE_LANG_LATIN,
   MENU_ENUM_LABEL_VALUE_LANG_LATVIAN,
   MENU_ENUM_LABEL_VALUE_LANG_LITHUANIAN,
   MENU_ENUM_LABEL_VALUE_LANG_MACEDONIAN,
   MENU_ENUM_LABEL_VALUE_LANG_MALAY,
   MENU_ENUM_LABEL_VALUE_LANG_MALTESE,
   MENU_ENUM_LABEL_VALUE_LANG_NORWEGIAN,
   MENU_ENUM_LABEL_VALUE_LANG_PERSIAN,
   MENU_ENUM_LABEL_VALUE_LANG_ROMANIAN,
   MENU_ENUM_LABEL_VALUE_LANG_SERBIAN,
   MENU_ENUM_LABEL_VALUE_LANG_SLOVAK,
   MENU_ENUM_LABEL_VALUE_LANG_SLOVENIAN,
   MENU_ENUM_LABEL_VALUE_LANG_SWAHILI,
   MENU_ENUM_LABEL_VALUE_LANG_TAMIL,
   MENU_ENUM_LABEL_VALUE_LANG_TELUGU,
   MENU_ENUM_LABEL_VALUE_LANG_THAI,
   MENU_ENUM_LABEL_VALUE_LANG_UKRAINIAN,
   MENU_ENUM_LABEL_VALUE_LANG_BELARUSIAN,
   MENU_ENUM_LABEL_VALUE_LANG_URDU,
   MENU_ENUM_LABEL_VALUE_LANG_CATALAN_VALENCIA,
   MENU_ENUM_LABEL_VALUE_LANG_WELSH,
   MENU_ENUM_LABEL_VALUE_LANG_YIDDISH,
   /* Entries beginning with MENU_ENUM_LABEL_VALUE_LANG will not be uploaded to Crowdin. */
   MENU_ENUM_LABEL_VALUE_LNG_COMPLETION_95_PLUS,
   MENU_ENUM_LABEL_VALUE_LNG_COMPLETION_75_PLUS,
   MENU_ENUM_LABEL_VALUE_LNG_COMPLETION_50_PLUS,
   MENU_ENUM_LABEL_VALUE_LNG_COMPLETION_25_PLUS,
   MENU_ENUM_LABEL_VALUE_LNG_COMPLETION_25_MINUS,
   MENU_ENUM_LABEL_VALUE_AI_SERVICE_IMAGE_MODE,
   MENU_ENUM_LABEL_VALUE_AI_SERVICE_SPEECH_MODE,
   MENU_ENUM_LABEL_VALUE_AI_SERVICE_NARRATOR_MODE,
   MENU_ENUM_LABEL_VALUE_NONE,
   MENU_ENUM_LABEL_VALUE_NO_INFORMATION_AVAILABLE,

   MENU_LABEL(USE_BUILTIN_IMAGE_VIEWER),
   MENU_LABEL(OVERLAY_AUTOLOAD_PREFERRED),
   MENU_LABEL(LOAD_ARCHIVE),
   MENU_LABEL(OPEN_ARCHIVE),
   MENU_ENUM_LABEL_LOAD_ARCHIVE_DETECT_CORE,
   MENU_ENUM_LABEL_OPEN_ARCHIVE_DETECT_CORE,

   MENU_ENUM_LABEL_VALUE_WHAT_IS_A_CORE_DESC,

   MENU_LABEL(HELP_CHANGE_VIRTUAL_GAMEPAD),
   MENU_LABEL(HELP_CHANGE_VIRTUAL_GAMEPAD_DESC),

   MENU_LABEL(HELP_AUDIO_VIDEO_TROUBLESHOOTING),

   MENU_ENUM_LABEL_VALUE_HELP_AUDIO_VIDEO_TROUBLESHOOTING_DESC,

   MENU_LABEL(HELP_SCANNING_CONTENT),

   MENU_ENUM_LABEL_VALUE_HELP_SCANNING_CONTENT_DESC,

   MENU_LABEL(RESET_TO_DEFAULT_CONFIG),
   MENU_LABEL(SAVE_CURRENT_CONFIG),
   MENU_LABEL(SAVE_CURRENT_CONFIG_OVERRIDE_CORE),
   MENU_LABEL(SAVE_CURRENT_CONFIG_OVERRIDE_CONTENT_DIR),
   MENU_LABEL(SAVE_CURRENT_CONFIG_OVERRIDE_GAME),
   MENU_LABEL(REMOVE_CURRENT_CONFIG_OVERRIDE_CORE),
   MENU_LABEL(REMOVE_CURRENT_CONFIG_OVERRIDE_CONTENT_DIR),
   MENU_LABEL(REMOVE_CURRENT_CONFIG_OVERRIDE_GAME),

   MENU_ENUM_LABEL_VALUE_THUMBNAIL_MODE_BOXARTS,
   MENU_ENUM_LABEL_VALUE_THUMBNAIL_MODE_SCREENSHOTS,
   MENU_ENUM_LABEL_VALUE_THUMBNAIL_MODE_TITLE_SCREENS,
   MENU_ENUM_LABEL_VALUE_THUMBNAIL_MODE_LOGOS,

   MENU_ENUM_LABEL_VALUE_RGUI_THUMB_SCALE_POINT,
   MENU_ENUM_LABEL_VALUE_RGUI_THUMB_SCALE_BILINEAR,
   MENU_ENUM_LABEL_VALUE_RGUI_THUMB_SCALE_SINC,

   MENU_ENUM_LABEL_VALUE_RGUI_UPSCALE_NONE,
   MENU_ENUM_LABEL_VALUE_RGUI_UPSCALE_AUTO,
   MENU_ENUM_LABEL_VALUE_RGUI_UPSCALE_X2,
   MENU_ENUM_LABEL_VALUE_RGUI_UPSCALE_X3,
   MENU_ENUM_LABEL_VALUE_RGUI_UPSCALE_X4,
   MENU_ENUM_LABEL_VALUE_RGUI_UPSCALE_X5,
   MENU_ENUM_LABEL_VALUE_RGUI_UPSCALE_X6,
   MENU_ENUM_LABEL_VALUE_RGUI_UPSCALE_X7,
   MENU_ENUM_LABEL_VALUE_RGUI_UPSCALE_X8,
   MENU_ENUM_LABEL_VALUE_RGUI_UPSCALE_X9,

   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_4_3,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_16_9,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_16_9_CENTRE,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_16_10,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_16_10_CENTRE,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_21_9,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_21_9_CENTRE,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_3_2,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_3_2_CENTRE,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_5_3,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_5_3_CENTRE,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_AUTO,

   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_LOCK_NONE,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_LOCK_FIT_SCREEN,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_LOCK_INTEGER,
   MENU_ENUM_LABEL_VALUE_RGUI_ASPECT_RATIO_LOCK_FILL_SCREEN,

   MENU_ENUM_LABEL_VALUE_RGUI_PARTICLE_EFFECT_NONE,
   MENU_ENUM_LABEL_VALUE_RGUI_PARTICLE_EFFECT_SNOW,
   MENU_ENUM_LABEL_VALUE_RGUI_PARTICLE_EFFECT_SNOW_ALT,
   MENU_ENUM_LABEL_VALUE_RGUI_PARTICLE_EFFECT_RAIN,
   MENU_ENUM_LABEL_VALUE_RGUI_PARTICLE_EFFECT_VORTEX,
   MENU_ENUM_LABEL_VALUE_RGUI_PARTICLE_EFFECT_STARFIELD,

   /* Callback strings */
   MENU_ENUM_LABEL_CB_CORE_CONTENT_DIRS_LIST,
   MENU_ENUM_LABEL_CB_CORE_CONTENT_DOWNLOAD,
   MENU_ENUM_LABEL_CB_CORE_CONTENT_LIST,
   MENU_ENUM_LABEL_CB_CORE_SYSTEM_FILES_DOWNLOAD,
   MENU_ENUM_LABEL_CB_CORE_SYSTEM_FILES_LIST,
   MENU_ENUM_LABEL_CB_CORE_THUMBNAILS_DOWNLOAD,
   MENU_ENUM_LABEL_CB_CORE_UPDATER_DOWNLOAD,
   MENU_ENUM_LABEL_CB_CORE_UPDATER_LIST,
   MENU_ENUM_LABEL_CB_DOWNLOAD_URL,
   MENU_ENUM_LABEL_CB_LAKKA_DOWNLOAD,
   MENU_ENUM_LABEL_CB_LAKKA_LIST,
   MENU_ENUM_LABEL_CB_MENU_THUMBNAIL,
   MENU_ENUM_LABEL_CB_MENU_LEFT_THUMBNAIL,
   MENU_ENUM_LABEL_CB_MENU_SAVESTATE_THUMBNAIL,
   MENU_ENUM_LABEL_CB_MENU_WALLPAPER,
   MENU_ENUM_LABEL_CB_PL_THUMBNAILS_DOWNLOAD,
#if 0
/* Thumbnailpack removal */
   MENU_ENUM_LABEL_CB_THUMBNAILS_UPDATER_DOWNLOAD,
   MENU_ENUM_LABEL_CB_THUMBNAILS_UPDATER_LIST,
#endif
   MENU_ENUM_LABEL_CB_UPDATE_ASSETS,
   MENU_ENUM_LABEL_CB_UPDATE_AUTOCONFIG_PROFILES,
   MENU_ENUM_LABEL_CB_UPDATE_CHEATS,
   MENU_ENUM_LABEL_CB_UPDATE_CORE_INFO_FILES,
   MENU_ENUM_LABEL_CB_UPDATE_DATABASES,
   MENU_ENUM_LABEL_CB_UPDATE_OVERLAYS,
   MENU_ENUM_LABEL_CB_UPDATE_SHADERS_CG,
   MENU_ENUM_LABEL_CB_UPDATE_SHADERS_GLSL,
   MENU_ENUM_LABEL_CB_UPDATE_SHADERS_SLANG,
   MENU_ENUM_LABEL_CB_DISCORD_AVATAR,
   MENU_ENUM_LABEL_CB_SINGLE_THUMBNAIL,

   /* Sublabels */
   MENU_LABEL(MIXER_ACTION_PLAY),
   MENU_LABEL(MIXER_ACTION_PLAY_LOOPED),
   MENU_LABEL(MIXER_ACTION_PLAY_SEQUENTIAL),
   MENU_LABEL(MIXER_ACTION_STOP),
   MENU_LABEL(MIXER_ACTION_REMOVE),
   MENU_LABEL(MIXER_ACTION_VOLUME),
   MENU_ENUM_SUBLABEL_INFORMATION_LIST_LIST,
#ifdef HAVE_LAKKA
   MENU_ENUM_SUBLABEL_SERVICES_SETTINGS,
#endif

   MENU_LABEL(MENU_WIDGETS_ENABLE),
   MENU_LABEL(MENU_SHOW_LOAD_CONTENT_ANIMATION),

   MENU_LABEL(NOTIFICATION_SHOW_AUTOCONFIG),
   MENU_LABEL(NOTIFICATION_SHOW_CHEATS_APPLIED),
   MENU_LABEL(NOTIFICATION_SHOW_PATCH_APPLIED),
   MENU_LABEL(NOTIFICATION_SHOW_REMAP_LOAD),
   MENU_LABEL(NOTIFICATION_SHOW_CONFIG_OVERRIDE_LOAD),
   MENU_LABEL(NOTIFICATION_SHOW_SET_INITIAL_DISK),
   MENU_LABEL(NOTIFICATION_SHOW_DISK_CONTROL),
   MENU_LABEL(NOTIFICATION_SHOW_SAVE_STATE),
   MENU_LABEL(NOTIFICATION_SHOW_FAST_FORWARD),
   MENU_LABEL(NOTIFICATION_SHOW_SCREENSHOT),
   MENU_LABEL(NOTIFICATION_SHOW_SCREENSHOT_DURATION),
   MENU_LABEL(NOTIFICATION_SHOW_SCREENSHOT_FLASH),

   MENU_ENUM_LABEL_VALUE_NOTIFICATION_SHOW_SCREENSHOT_DURATION_NORMAL,
   MENU_ENUM_LABEL_VALUE_NOTIFICATION_SHOW_SCREENSHOT_DURATION_FAST,
   MENU_ENUM_LABEL_VALUE_NOTIFICATION_SHOW_SCREENSHOT_DURATION_VERY_FAST,
   MENU_ENUM_LABEL_VALUE_NOTIFICATION_SHOW_SCREENSHOT_DURATION_INSTANT,

   MENU_ENUM_LABEL_VALUE_NOTIFICATION_SHOW_SCREENSHOT_FLASH_NORMAL,
   MENU_ENUM_LABEL_VALUE_NOTIFICATION_SHOW_SCREENSHOT_FLASH_FAST,

   MENU_LABEL(NOTIFICATION_SHOW_REFRESH_RATE),
   MENU_LABEL(NOTIFICATION_SHOW_NETPLAY_EXTRA),
   MENU_LABEL(NOTIFICATION_SHOW_WHEN_MENU_IS_ALIVE),

   MENU_LABEL(SELECT_FILE),
   MENU_LABEL(SELECT_FROM_PLAYLIST),

   MENU_ENUM_LABEL_VALUE_FILTER,
   MENU_ENUM_LABEL_VALUE_SCALE,
   MENU_ENUM_LABEL_VALUE_NETPLAY_START_WHEN_LOADED,
   MENU_ENUM_LABEL_VALUE_NETPLAY_LOAD_CONTENT_MANUALLY,
   MENU_ENUM_LABEL_VALUE_NETPLAY_COMPAT_CONTENT_LOOK,
   MENU_ENUM_LABEL_VALUE_NETPLAY_COMPAT_CONTENT_NO_CORE,
   MENU_ENUM_LABEL_VALUE_NETPLAY_COMPAT_CONTENT_NO_PLAYLISTS,
   MENU_ENUM_LABEL_VALUE_NETPLAY_COMPAT_CONTENT_FOUND,
   MENU_ENUM_LABEL_VALUE_NETPLAY_COMPAT_CONTENT_NOT_FOUND,

   MENU_LABEL(NETPLAY_USE_MITM_SERVER),
   MENU_LABEL(NETPLAY_MITM_SERVER),
   MENU_ENUM_LABEL_NETPLAY_MITM_SERVER_LOCATION,
   MENU_LABEL(NETPLAY_CUSTOM_MITM_SERVER),
   MENU_ENUM_LABEL_VALUE_NETPLAY_MITM_SERVER_LOCATION_1,
   MENU_ENUM_LABEL_VALUE_NETPLAY_MITM_SERVER_LOCATION_2,
   MENU_ENUM_LABEL_VALUE_NETPLAY_MITM_SERVER_LOCATION_3,
   MENU_ENUM_LABEL_VALUE_NETPLAY_MITM_SERVER_LOCATION_4,
   MENU_ENUM_LABEL_VALUE_NETPLAY_MITM_SERVER_LOCATION_5,
   MENU_ENUM_LABEL_VALUE_NETPLAY_MITM_SERVER_LOCATION_CUSTOM,
   MENU_LABEL(VIDEO_WINDOW_SHOW_DECORATIONS),
   MENU_LABEL(VIDEO_WINDOW_SAVE_POSITION),
   MENU_LABEL(VIDEO_WINDOW_CUSTOM_SIZE_ENABLE),

   MENU_ENUM_LABEL_VALUE_QT_INFO,
   MENU_ENUM_LABEL_VALUE_QT_MENU_FILE,
   MENU_ENUM_LABEL_VALUE_QT_MENU_FILE_LOAD_CORE,
   MENU_ENUM_LABEL_VALUE_QT_MENU_FILE_UNLOAD_CORE,
   MENU_ENUM_LABEL_VALUE_QT_MENU_FILE_EXIT,
   MENU_ENUM_LABEL_VALUE_QT_MENU_EDIT,
   MENU_ENUM_LABEL_VALUE_QT_MENU_EDIT_SEARCH,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW,
   MENU_ENUM_LABEL_VALUE_QT_MENU_SEARCH_CLEAR,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_CLOSED_DOCKS,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_SHADER_PARAMS,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_SAVE_DOCK_POSITIONS,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_SAVE_GEOMETRY,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_SAVE_LAST_TAB,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_THEME,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_THEME_SYSTEM_DEFAULT,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_THEME_DARK,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_THEME_CUSTOM,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_TITLE,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_HIGHLIGHT_COLOR,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_SUGGEST_LOADED_CORE_FIRST,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_SHOW_HIDDEN_FILES,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_ALL_PLAYLISTS_LIST_MAX_COUNT,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_ALL_PLAYLISTS_GRID_MAX_COUNT,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_STARTUP_PLAYLIST,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_THUMBNAIL_TYPE,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_THUMBNAIL_CACHE_LIMIT,
   MENU_ENUM_LABEL_VALUE_QT_MENU_VIEW_OPTIONS_THUMBNAIL_DROP_SIZE_LIMIT,
   MENU_ENUM_LABEL_VALUE_QT_MENU_TOOLS,
   MENU_ENUM_LABEL_VALUE_QT_MENU_HELP,
   MENU_ENUM_LABEL_VALUE_QT_MENU_DOCK_CONTENT_BROWSER,
   MENU_ENUM_LABEL_VALUE_QT_THUMBNAIL_BOXART,
   MENU_ENUM_LABEL_VALUE_QT_THUMBNAIL_SCREENSHOT,
   MENU_ENUM_LABEL_VALUE_QT_THUMBNAIL_TITLE_SCREEN,
   MENU_ENUM_LABEL_VALUE_QT_THUMBNAIL_LOGO,
   MENU_ENUM_LABEL_VALUE_QT_LOAD_CORE,
   MENU_ENUM_LABEL_VALUE_QT_LOAD_CUSTOM_CORE,
   MENU_ENUM_LABEL_VALUE_QT_LOADING_CORE,
   MENU_ENUM_LABEL_VALUE_QT_NAME,
   MENU_ENUM_LABEL_VALUE_QT_CORE_VERSION,
   MENU_ENUM_LABEL_VALUE_QT_TAB_PLAYLISTS,
   MENU_ENUM_LABEL_VALUE_QT_TAB_FILE_BROWSER,
   MENU_ENUM_LABEL_VALUE_QT_TAB_FILE_BROWSER_TOP,
   MENU_ENUM_LABEL_VALUE_QT_TAB_FILE_BROWSER_UP,
   MENU_ENUM_LABEL_VALUE_QT_ALL_PLAYLISTS,
   MENU_ENUM_LABEL_VALUE_QT_CORE,
   MENU_ENUM_LABEL_VALUE_QT_CORE_INFO,
   MENU_ENUM_LABEL_VALUE_QT_CORE_SELECTION_ASK,
   MENU_ENUM_LABEL_VALUE_QT_INFORMATION,
   MENU_ENUM_LABEL_VALUE_QT_WARNING,
   MENU_ENUM_LABEL_VALUE_QT_ERROR,
   MENU_ENUM_LABEL_VALUE_QT_RESTART_TO_TAKE_EFFECT,
   MENU_ENUM_LABEL_VALUE_QT_LOG,
   MENU_ENUM_LABEL_VALUE_QT_SCAN_FINISHED,
   MENU_ENUM_LABEL_VALUE_QT_DONT_SHOW_AGAIN,
   MENU_ENUM_LABEL_VALUE_QT_STOP,
   MENU_ENUM_LABEL_VALUE_QT_ASSOCIATE_CORE,
   MENU_ENUM_LABEL_VALUE_QT_HIDDEN_PLAYLISTS,
   MENU_ENUM_LABEL_VALUE_QT_HIDE,
   MENU_ENUM_LABEL_VALUE_QT_CHOOSE,
   MENU_ENUM_LABEL_VALUE_QT_SELECT_COLOR,
   MENU_ENUM_LABEL_VALUE_QT_SELECT_THEME,
   MENU_ENUM_LABEL_VALUE_QT_CUSTOM_THEME,
   MENU_ENUM_LABEL_VALUE_QT_FILE_PATH_IS_BLANK,
   MENU_ENUM_LABEL_VALUE_QT_FILE_IS_EMPTY,
   MENU_ENUM_LABEL_VALUE_QT_FILE_READ_OPEN_FAILED,
   MENU_ENUM_LABEL_VALUE_QT_FILE_WRITE_OPEN_FAILED,
   MENU_ENUM_LABEL_VALUE_QT_FILE_DOES_NOT_EXIST,
   MENU_ENUM_LABEL_VALUE_QT_ZOOM,
   MENU_ENUM_LABEL_VALUE_QT_VIEW,
   MENU_ENUM_LABEL_VALUE_QT_VIEW_TYPE_ICONS,
   MENU_ENUM_LABEL_VALUE_QT_VIEW_TYPE_LIST,
   MENU_ENUM_LABEL_VALUE_QT_PROGRESS,
   MENU_ENUM_LABEL_VALUE_QT_NEW_PLAYLIST,
   MENU_ENUM_LABEL_VALUE_QT_ENTER_NEW_PLAYLIST_NAME,
   MENU_ENUM_LABEL_VALUE_QT_DELETE_PLAYLIST,
   MENU_ENUM_LABEL_VALUE_QT_RENAME_PLAYLIST,
   MENU_ENUM_LABEL_VALUE_QT_CONFIRM_DELETE_PLAYLIST,
   MENU_ENUM_LABEL_VALUE_QT_CONFIRM_DELETE_PLAYLIST_ITEM,
   MENU_ENUM_LABEL_VALUE_QT_QUESTION,
   MENU_ENUM_LABEL_VALUE_QT_COULD_NOT_DELETE_FILE,
   MENU_ENUM_LABEL_VALUE_QT_COULD_NOT_RENAME_FILE,
   MENU_ENUM_LABEL_VALUE_QT_GATHERING_LIST_OF_FILES,
   MENU_ENUM_LABEL_VALUE_QT_ADDING_FILES_TO_PLAYLIST,
   MENU_ENUM_LABEL_VALUE_QT_PLAYLIST_ENTRY,
   MENU_ENUM_LABEL_VALUE_QT_PLAYLIST_ENTRY_NAME,
   MENU_ENUM_LABEL_VALUE_QT_PLAYLIST_ENTRY_PATH,
   MENU_ENUM_LABEL_VALUE_QT_PLAYLIST_ENTRY_CORE,
   MENU_ENUM_LABEL_VALUE_QT_PLAYLIST_ENTRY_DATABASE,
   MENU_ENUM_LABEL_VALUE_QT_PLAYLIST_ENTRY_EXTENSIONS,
   MENU_ENUM_LABEL_VALUE_QT_PLAYLIST_ENTRY_EXTENSIONS_PLACEHOLDER,
   MENU_ENUM_LABEL_VALUE_QT_PLAYLIST_ENTRY_FILTER_INSIDE_ARCHIVES,
   MENU_ENUM_LABEL_VALUE_QT_FOR_THUMBNAILS,
   MENU_ENUM_LABEL_VALUE_QT_CANNOT_ADD_TO_ALL_PLAYLISTS,
   MENU_ENUM_LABEL_VALUE_QT_DELETE,
   MENU_ENUM_LABEL_VALUE_QT_ADD_ENTRY,
   MENU_ENUM_LABEL_VALUE_QT_ADD_FILES,
   MENU_ENUM_LABEL_VALUE_QT_ADD_FOLDER,
   MENU_ENUM_LABEL_VALUE_QT_EDIT,
   MENU_ENUM_LABEL_VALUE_QT_SELECT_FILES,
   MENU_ENUM_LABEL_VALUE_QT_SELECT_FOLDER,
   MENU_ENUM_LABEL_VALUE_QT_FIELD_MULTIPLE,
   MENU_ENUM_LABEL_VALUE_QT_COULD_NOT_UPDATE_PLAYLIST_ENTRY,
   MENU_ENUM_LABEL_VALUE_QT_PLEASE_FILL_OUT_REQUIRED_FIELDS,
   MENU_ENUM_LABEL_VALUE_QT_MENU_HELP_ABOUT,
   MENU_ENUM_LABEL_VALUE_QT_MENU_HELP_ABOUT_CONTRIBUTORS,
   MENU_ENUM_LABEL_VALUE_QT_MENU_HELP_DOCUMENTATION,
   MENU_ENUM_LABEL_VALUE_QT_NETWORK_ERROR,
   MENU_ENUM_LABEL_VALUE_QT_UPDATE_RETROARCH_NIGHTLY,
   MENU_ENUM_LABEL_VALUE_QT_UPDATE_RETROARCH_FINISHED,
   MENU_ENUM_LABEL_VALUE_QT_UPDATE_RETROARCH_FAILED,
   MENU_ENUM_LABEL_VALUE_QT_CURRENT_SHADER,
   MENU_ENUM_LABEL_VALUE_QT_MOVE_DOWN,
   MENU_ENUM_LABEL_VALUE_QT_MOVE_UP,
   MENU_ENUM_LABEL_VALUE_QT_LOAD,
   MENU_ENUM_LABEL_VALUE_QT_SAVE,
   MENU_ENUM_LABEL_VALUE_QT_REMOVE,
   MENU_ENUM_LABEL_VALUE_QT_REMOVE_PASSES,
   MENU_ENUM_LABEL_VALUE_QT_APPLY,
   MENU_ENUM_LABEL_VALUE_QT_SHADER_ADD_PASS,
   MENU_ENUM_LABEL_VALUE_QT_SHADER_CLEAR_ALL_PASSES,
   MENU_ENUM_LABEL_VALUE_QT_SHADER_NO_PASSES,
   MENU_ENUM_LABEL_VALUE_QT_RESET_PASS,
   MENU_ENUM_LABEL_VALUE_QT_RESET_ALL_PASSES,
   MENU_ENUM_LABEL_VALUE_QT_RESET_PARAMETER,
   MENU_ENUM_LABEL_VALUE_QT_DOWNLOAD_THUMBNAIL,
   MENU_ENUM_LABEL_VALUE_QT_DOWNLOAD_ALREADY_IN_PROGRESS,
   MENU_ENUM_LABEL_VALUE_QT_DOWNLOAD_ALL_THUMBNAILS,
   MENU_ENUM_LABEL_VALUE_QT_DOWNLOAD_ALL_THUMBNAILS_ENTIRE_SYSTEM,
   MENU_ENUM_LABEL_VALUE_QT_DOWNLOAD_ALL_THUMBNAILS_THIS_PLAYLIST,
   MENU_ENUM_LABEL_VALUE_QT_THUMBNAIL_PACK_DOWNLOADED_SUCCESSFULLY,
   MENU_ENUM_LABEL_VALUE_QT_DOWNLOAD_PLAYLIST_THUMBNAIL_PROGRESS,
   MENU_ENUM_LABEL_VALUE_QT_CORE_OPTIONS,
   MENU_ENUM_LABEL_VALUE_QT_ITEMS_COUNT,
   MENU_ENUM_LABEL_VALUE_QT_DROP_IMAGE_HERE,
   MENU_ENUM_LABEL_VALUE_QT_RESET,
   MENU_ENUM_LABEL_VALUE_QT_RESET_ALL,

   MENU_LBL_H(MIDI_INPUT),
   MENU_LBL_H(MIDI_OUTPUT),
   MENU_LABEL(MIDI_VOLUME),

   /* Power Management */
   MENU_LABEL(SUSTAINED_PERFORMANCE_MODE),
   MENU_LABEL(CPU_PERF_MODE),
   MENU_LABEL(CPU_PERFPOWER),
   MENU_LABEL(CPU_POLICY_ENTRY),
   MENU_LABEL(CPU_POLICY_MIN_FREQ),
   MENU_LABEL(CPU_POLICY_MAX_FREQ),
   MENU_LABEL(CPU_POLICY_GOVERNOR),
   MENU_LABEL(CPU_POLICY_CORE_GOVERNOR),
   MENU_LABEL(CPU_POLICY_MENU_GOVERNOR),
   MENU_LABEL(CPU_MANAGED_MIN_FREQ),
   MENU_LABEL(CPU_MANAGED_MAX_FREQ),
   MENU_LBL_H(GAMEMODE_ENABLE),
   MENU_ENUM_SUBLABEL_GAMEMODE_ENABLE_LINUX,

   MENU_ENUM_LABEL_VALUE_CPU_PERF_MODE_MANAGED_PERF,
   MENU_ENUM_LABEL_VALUE_CPU_PERF_MODE_MANAGED_PER_CONTEXT,
   MENU_ENUM_LABEL_VALUE_CPU_PERF_MODE_MAX_PERF,
   MENU_ENUM_LABEL_VALUE_CPU_PERF_MODE_MIN_POWER,
   MENU_ENUM_LABEL_VALUE_CPU_PERF_MODE_BALANCED,
   MENU_ENUM_LABEL_VALUE_CPU_PERF_MODE_MANUAL,

   MENU_ENUM_SUBLABEL_VALUE_CPU_PERF_MODE_MANAGED_PERF,
   MENU_ENUM_SUBLABEL_VALUE_CPU_PERF_MODE_MANAGED_PER_CONTEXT,
   MENU_ENUM_SUBLABEL_VALUE_CPU_PERF_MODE_MAX_PERF,
   MENU_ENUM_SUBLABEL_VALUE_CPU_PERF_MODE_MIN_POWER,
   MENU_ENUM_SUBLABEL_VALUE_CPU_PERF_MODE_BALANCED,
   MENU_ENUM_SUBLABEL_VALUE_CPU_PERF_MODE_MANUAL,

   MENU_ENUM_LABEL_CHEAT_HANDLER_TYPE_EMU,
   MENU_ENUM_LABEL_CHEAT_HANDLER_TYPE_RETRO,
   MENU_ENUM_LABEL_CHEAT_TYPE_DISABLED,
   MENU_ENUM_LABEL_CHEAT_TYPE_SET_TO_VALUE,
   MENU_ENUM_LABEL_CHEAT_TYPE_INCREASE_VALUE,
   MENU_ENUM_LABEL_CHEAT_TYPE_DECREASE_VALUE,
   MENU_ENUM_LABEL_CHEAT_TYPE_RUN_NEXT_IF_EQ,
   MENU_ENUM_LABEL_CHEAT_TYPE_RUN_NEXT_IF_NEQ,
   MENU_ENUM_LABEL_CHEAT_TYPE_RUN_NEXT_IF_LT,
   MENU_ENUM_LABEL_CHEAT_TYPE_RUN_NEXT_IF_GT,
   MENU_ENUM_LABEL_RUMBLE_TYPE_DISABLED,
   MENU_ENUM_LABEL_RUMBLE_TYPE_CHANGES,
   MENU_ENUM_LABEL_RUMBLE_TYPE_DOES_NOT_CHANGE,
   MENU_ENUM_LABEL_RUMBLE_TYPE_INCREASE,
   MENU_ENUM_LABEL_RUMBLE_TYPE_DECREASE,
   MENU_ENUM_LABEL_RUMBLE_TYPE_EQ_VALUE,
   MENU_ENUM_LABEL_RUMBLE_TYPE_NEQ_VALUE,
   MENU_ENUM_LABEL_RUMBLE_TYPE_LT_VALUE,
   MENU_ENUM_LABEL_RUMBLE_TYPE_GT_VALUE,
   MENU_ENUM_LABEL_RUMBLE_TYPE_INCREASE_BY_VALUE,
   MENU_ENUM_LABEL_RUMBLE_TYPE_DECREASE_BY_VALUE,
   MENU_ENUM_LABEL_CHEAT_MEMORY_SIZE_1,
   MENU_ENUM_LABEL_CHEAT_MEMORY_SIZE_2,
   MENU_ENUM_LABEL_CHEAT_MEMORY_SIZE_4,
   MENU_ENUM_LABEL_CHEAT_MEMORY_SIZE_8,
   MENU_ENUM_LABEL_CHEAT_MEMORY_SIZE_16,
   MENU_ENUM_LABEL_CHEAT_MEMORY_SIZE_32,
   MENU_ENUM_LABEL_RUMBLE_PORT_0,
   MENU_ENUM_LABEL_RUMBLE_PORT_1,
   MENU_ENUM_LABEL_RUMBLE_PORT_2,
   MENU_ENUM_LABEL_RUMBLE_PORT_3,
   MENU_ENUM_LABEL_RUMBLE_PORT_4,
   MENU_ENUM_LABEL_RUMBLE_PORT_5,
   MENU_ENUM_LABEL_RUMBLE_PORT_6,
   MENU_ENUM_LABEL_RUMBLE_PORT_7,
   MENU_ENUM_LABEL_RUMBLE_PORT_8,
   MENU_ENUM_LABEL_RUMBLE_PORT_9,
   MENU_ENUM_LABEL_RUMBLE_PORT_10,
   MENU_ENUM_LABEL_RUMBLE_PORT_11,
   MENU_ENUM_LABEL_RUMBLE_PORT_12,
   MENU_ENUM_LABEL_RUMBLE_PORT_13,
   MENU_ENUM_LABEL_RUMBLE_PORT_14,
   MENU_ENUM_LABEL_RUMBLE_PORT_15,
   MENU_ENUM_LABEL_RUMBLE_PORT_16,
   MENU_ENUM_LABEL_CHEAT_SEARCH_EXACT_VAL,
   MENU_ENUM_LABEL_CHEAT_SEARCH_LT_VAL,
   MENU_ENUM_LABEL_CHEAT_SEARCH_LTE_VAL,
   MENU_ENUM_LABEL_CHEAT_SEARCH_GT_VAL,
   MENU_ENUM_LABEL_CHEAT_SEARCH_GTE_VAL,
   MENU_ENUM_LABEL_CHEAT_SEARCH_EQ_VAL,
   MENU_ENUM_LABEL_CHEAT_SEARCH_NEQ_VAL,
   MENU_ENUM_LABEL_CHEAT_SEARCH_EQPLUS_VAL,
   MENU_ENUM_LABEL_CHEAT_SEARCH_EQMINUS_VAL,
   MSG_CHEAT_INIT_SUCCESS,
   MSG_CHEAT_INIT_FAIL,
   MSG_CHEAT_SEARCH_NOT_INITIALIZED,
   MSG_CHEAT_SEARCH_FOUND_MATCHES,
   MSG_CHEAT_SEARCH_ADDED_MATCHES_SUCCESS,
   MSG_CHEAT_SEARCH_ADDED_MATCHES_FAIL,
   MSG_CHEAT_SEARCH_ADDED_MATCHES_TOO_MANY,
   MSG_CHEAT_DELETE_ALL_INSTRUCTIONS,
   MSG_CHEAT_ADD_TOP_SUCCESS,
   MSG_CHEAT_ADD_BOTTOM_SUCCESS,
   MSG_CHEAT_DELETE_ALL_SUCCESS,
   MSG_CHEAT_ADD_AFTER_SUCCESS,
   MSG_CHEAT_ADD_BEFORE_SUCCESS,
   MSG_CHEAT_COPY_AFTER_SUCCESS,
   MSG_CHEAT_COPY_BEFORE_SUCCESS,
   MSG_CHEAT_DELETE_SUCCESS,
   MSG_CHEAT_SEARCH_ADD_MATCH_SUCCESS,
   MSG_CHEAT_SEARCH_ADD_MATCH_FAIL,
   MSG_CHEAT_SEARCH_DELETE_MATCH_SUCCESS,
   MSG_CHEEVOS_LOGGED_IN_AS_USER,
   MSG_CHEEVOS_LOAD_STATE_PREVENTED_BY_HARDCORE_MODE,
   MSG_CHEEVOS_HARDCORE_MODE_DISABLED,
   MSG_CHEEVOS_HARDCORE_MODE_DISABLED_CHEAT,
   MSG_CHEEVOS_MASTERED_GAME,
   MSG_CHEEVOS_COMPLETED_GAME,
   MSG_CHEEVOS_HARDCORE_MODE_ENABLE,
   MSG_CHEEVOS_GAME_HAS_NO_ACHIEVEMENTS,
   MSG_CHEEVOS_ALL_ACHIEVEMENTS_ACTIVATED,
   MSG_CHEEVOS_UNOFFICIAL_ACHIEVEMENTS_ACTIVATED,
   MSG_CHEEVOS_NUMBER_ACHIEVEMENTS_UNLOCKED,
   MSG_CHEEVOS_UNSUPPORTED_COUNT,
   MSG_CHEEVOS_RICH_PRESENCE_SPECTATING,
   MSG_CHEEVOS_HARDCORE_PAUSED_MANUAL_FRAME_DELAY,
   MSG_CHEEVOS_HARDCORE_PAUSED_VSYNC_SWAP_INTERVAL,
   MSG_CHEEVOS_HARDCORE_PAUSED_BLACK_FRAME_INSERTION,
   MSG_CHEEVOS_HARDCORE_PAUSED_SETTING_NOT_ALLOWED,
   MSG_CHEEVOS_HARDCORE_PAUSED_SYSTEM_NOT_FOR_CORE,
   MSG_CHEEVOS_GAME_NOT_IDENTIFIED,
   MSG_CHEEVOS_GAME_LOAD_FAILED,
   MSG_CHEEVOS_CHANGE_MEDIA_FAILED,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_YMD_HMS,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_YMD_HM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_YMD,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_YM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_MDYYYY_HMS,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_MDYYYY_HM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_MD_HM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_MDYYYY,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_MD,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_DDMMYYYY_HMS,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_DDMMYYYY_HM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_DDMM_HM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_DDMMYYYY,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_DDMM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_HMS,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_HM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_YMD_HMS_AMPM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_YMD_HM_AMPM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_MDYYYY_HMS_AMPM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_MDYYYY_HM_AMPM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_MD_HM_AMPM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_DDMMYYYY_HMS_AMPM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_DDMMYYYY_HM_AMPM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_DDMM_HM_AMPM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_HMS_AMPM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_HM_AMPM,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_AGO,

   MENU_LABEL(SWITCH_GPU_PROFILE),
   MENU_LABEL(SWITCH_CPU_PROFILE),

   MENU_ENUM_LABEL_VALUE_DOWN_Y_L_R,
   MENU_ENUM_LABEL_VALUE_L3_R3,
   MENU_ENUM_LABEL_VALUE_L1_R1_START_SELECT,
   MENU_ENUM_LABEL_VALUE_START_SELECT,
   MENU_ENUM_LABEL_VALUE_L3_R,
   MENU_ENUM_LABEL_VALUE_L_R,
   MENU_ENUM_LABEL_VALUE_HOLD_START,
   MENU_ENUM_LABEL_VALUE_HOLD_SELECT,
   MENU_ENUM_LABEL_VALUE_DOWN_SELECT,
   MENU_ENUM_LABEL_VALUE_L2_R2,

   MENU_LABEL(PLAYLIST_USE_OLD_FORMAT),
   MENU_LABEL(PLAYLIST_COMPRESSION),
   MENU_LABEL(MENU_SOUNDS),
   MENU_LABEL(MENU_SOUND_OK),
   MENU_LABEL(MENU_SOUND_CANCEL),
   MENU_LABEL(MENU_SOUND_NOTICE),
   MENU_LABEL(MENU_SOUND_BGM),
   MENU_LABEL(MENU_SOUND_SCROLL),
   MENU_ENUM_LABEL_VALUE_VIDEO_DRIVER_FALLBACK,
   MENU_LABEL(CONTENT_RUNTIME_LOG),
   MENU_LABEL(CONTENT_RUNTIME_LOG_AGGREGATE),

   MENU_LABEL(PLAYLIST_SHOW_INLINE_CORE_NAME),
   MENU_LABEL(PLAYLIST_SORT_ALPHABETICAL),
   MENU_LABEL(PLAYLIST_SHOW_SUBLABELS),
   MENU_LABEL(PLAYLIST_SHOW_HISTORY_ICONS),
   MENU_LABEL(PLAYLIST_SHOW_ENTRY_IDX),
   MENU_LABEL(PLAYLIST_FUZZY_ARCHIVE_MATCH),
   MENU_LABEL(PLAYLIST_SUBLABEL_RUNTIME_TYPE),
   MENU_LABEL(PLAYLIST_SUBLABEL_LAST_PLAYED_STYLE),
   MENU_LABEL(PLAYLIST_PORTABLE_PATHS),
   MENU_LABEL(PLAYLIST_USE_FILENAME),
   MENU_LABEL(PLAYLIST_ALLOW_NON_PNG),

   MENU_ENUM_LABEL_VALUE_PLAYLIST_INLINE_CORE_DISPLAY_HIST_FAV,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_INLINE_CORE_DISPLAY_ALWAYS,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_INLINE_CORE_DISPLAY_NEVER,

   MENU_ENUM_LABEL_VALUE_PLAYLIST_ENTRY_REMOVE_ENABLE_HIST_FAV,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_ENTRY_REMOVE_ENABLE_ALL,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_ENTRY_REMOVE_ENABLE_NONE,

   MENU_ENUM_LABEL_VALUE_PLAYLIST_SUBLABEL_CORE,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_SUBLABEL_RUNTIME,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_SUBLABEL_LAST_PLAYED,

   MENU_ENUM_LABEL_VALUE_PLAYLIST_RUNTIME_PER_CORE,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_RUNTIME_AGGREGATE,

   MENU_ENUM_LABEL_VALUE_TIME_UNIT_SECONDS_SINGLE,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_SECONDS_PLURAL,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_MINUTES_SINGLE,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_MINUTES_PLURAL,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_HOURS_SINGLE,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_HOURS_PLURAL,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_DAYS_SINGLE,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_DAYS_PLURAL,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_WEEKS_SINGLE,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_WEEKS_PLURAL,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_MONTHS_SINGLE,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_MONTHS_PLURAL,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_YEARS_SINGLE,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_YEARS_PLURAL,
   MENU_ENUM_LABEL_VALUE_TIME_UNIT_AGO,

   MENU_LABEL(HELP_SEND_DEBUG_INFO),
   MENU_ENUM_LABEL_VALUE_HELP_SEND_DEBUG_INFO_DESC,

   MSG_FAILED_TO_SAVE_DEBUG_INFO,
   MSG_FAILED_TO_SEND_DEBUG_INFO,
   MSG_SENDING_DEBUG_INFO,
   MSG_SENT_DEBUG_INFO,
   MSG_PRESS_TWO_MORE_TIMES_TO_SEND_DEBUG_INFO,
   MSG_PRESS_ONE_MORE_TIME_TO_SEND_DEBUG_INFO,

   MENU_LABEL(VIBRATE_ON_KEYPRESS),
   MENU_LABEL(ENABLE_DEVICE_VIBRATION),
   MENU_LABEL(VIDEO_GPU_INDEX),

   MSG_DUMPING_DISC,
   MSG_DRIVE_NUMBER,
   MSG_LOAD_CORE_FIRST,
   MSG_DISC_DUMP_FAILED_TO_READ_FROM_DRIVE,
   MSG_DISC_DUMP_FAILED_TO_WRITE_TO_DISK,
   MSG_NO_DISC_INSERTED,
   MENU_LABEL(DELETE_PLAYLIST),

   /* Manual content scan */
   MENU_LABEL(MANUAL_CONTENT_SCAN_LIST),
   MENU_LABEL(MANUAL_CONTENT_SCAN_DIR),
   MENU_LABEL(MANUAL_CONTENT_SCAN_SYSTEM_NAME),
   MENU_LABEL(MANUAL_CONTENT_SCAN_SYSTEM_NAME_CUSTOM),
   MENU_LABEL(MANUAL_CONTENT_SCAN_CORE_NAME),
   MENU_LABEL(MANUAL_CONTENT_SCAN_FILE_EXTS),
   MENU_LABEL(MANUAL_CONTENT_SCAN_SEARCH_RECURSIVELY),
   MENU_LABEL(MANUAL_CONTENT_SCAN_SEARCH_ARCHIVES),
   MENU_LABEL(MANUAL_CONTENT_SCAN_DAT_FILE),
   MENU_LABEL(MANUAL_CONTENT_SCAN_DAT_FILE_FILTER),
   MENU_LABEL(MANUAL_CONTENT_SCAN_OVERWRITE),
   MENU_LABEL(MANUAL_CONTENT_SCAN_VALIDATE_ENTRIES),
   MENU_LABEL(MANUAL_CONTENT_SCAN_START),

   MENU_ENUM_LABEL_VALUE_MANUAL_CONTENT_SCAN_SYSTEM_NAME_USE_CONTENT_DIR,
   MENU_ENUM_LABEL_VALUE_MANUAL_CONTENT_SCAN_SYSTEM_NAME_USE_CUSTOM,

   MENU_ENUM_LABEL_VALUE_MANUAL_CONTENT_SCAN_CORE_NAME_DETECT,

   MSG_MANUAL_CONTENT_SCAN_DAT_FILE_INVALID,
   MSG_MANUAL_CONTENT_SCAN_DAT_FILE_TOO_LARGE,
   MSG_MANUAL_CONTENT_SCAN_DAT_FILE_LOAD_ERROR,
   MSG_MANUAL_CONTENT_SCAN_INVALID_CONFIG,
   MSG_MANUAL_CONTENT_SCAN_INVALID_CONTENT,
   MSG_MANUAL_CONTENT_SCAN_START,
   MSG_MANUAL_CONTENT_SCAN_PLAYLIST_CLEANUP,
   MSG_MANUAL_CONTENT_SCAN_IN_PROGRESS,
   MSG_MANUAL_CONTENT_SCAN_M3U_CLEANUP,
   MSG_MANUAL_CONTENT_SCAN_END,

   MSG_3DS_BOTTOM_MENU_DEFAULT,
   MSG_3DS_BOTTOM_MENU_ASSET_NOT_FOUND,
   MSG_3DS_BOTTOM_MENU_NO_STATE_DATA,
   MSG_3DS_BOTTOM_MENU_NO_STATE_THUMBNAIL,
   MSG_3DS_BOTTOM_MENU_RESUME,
   MSG_3DS_BOTTOM_MENU_SAVE_STATE,
   MSG_3DS_BOTTOM_MENU_LOAD_STATE,

   MSG_LAST,

   /* Ensure sizeof(enum) == sizeof(int) */
   MSG_DUMMY          = INT_MAX
};

/* Callback strings */

const char *msg_hash_to_str(enum msg_hash_enums msg);

const char *msg_hash_to_str_us(enum msg_hash_enums msg);
int msg_hash_get_help_us_enum(enum msg_hash_enums msg, char *s, size_t len);

int msg_hash_get_help_enum(enum msg_hash_enums msg, char *s, size_t len);

enum msg_file_type msg_hash_to_file_type(uint32_t hash);

unsigned *msg_hash_get_uint(enum msg_hash_action type);

void msg_hash_set_uint(enum msg_hash_action type, unsigned val);

/* Latin languages typically consist of regular
 * alpha numeric characters with a 'standard'
 * on-screen pixel width.
 * Non-Latin languages (e.g. CJK) typically consist
 * of so-called 'wide' Unicode glyphs, which may have
 * an on-screen pixel width several times that of Latin
 * characters.
 * In order to determine efficiently the on-screen width
 * of a text string (e.g. when word wrapping), it is
 * therefore necessary to:
 * - Identify which languages make use of 'wide' Unicode
 *   glyphs
 * - For each of these languages, provide a mechanism for
 *   measuring the typical on-screen pixel width of
 *   language-specific 'wide' Unicode glyphs
 * As such, msg_hash_get_wideglyph_str() returns a pointer
 * to a 'wide' Unicode character of typical on-screen pixel
 * width for the currently set user language.
 * - If msg_hash_get_wideglyph_str() returns NULL, the current
 *   language is assumed to be Latin-based, with no usage
 *   of 'wide' Unicode glyphs
 * - If msg_hash_get_wideglyph_str() returns a valid pointer,
 *   actual 'wide' glyph width for the current language may
 *   be found by passing said pointer to the current font
 *   rendering implementation */
const char *msg_hash_get_wideglyph_str(void);

uint32_t msg_hash_calculate(const char *s);

const char *get_user_language_iso639_1(bool limit);

RETRO_END_DECLS

#endif
