% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{AIRRDb}
\alias{AIRRDb}
\title{Example human immune repertoire data}
\format{
A \code{data.frame} where rows correspond to unique V(D)J sequences and
columns include:
\itemize{
  \item \code{"sequence_alignment"}: IMGT-gapped V(D)J nucleotide sequence.
  \item \code{"v_call"}: IMGT/HighV-QUEST V segment allele calls.
  \item \code{"d_call"}: IMGT/HighV-QUEST D segment allele calls.
  \item \code{"j_call"}: IMGT/HighV-QUEST J segment allele calls.
  \item \code{"junction_length"}: Junction region length.
}
}
\description{
A \code{data.frame} of example V(D)J immunoglobulin sequences derived from a 
single individual (PGP1), sequenced on the Roche 454 platform, and assigned by
IMGT/HighV-QUEST to IGHV1 family alleles.
}
\references{
\enumerate{
  \item Gadala-Maria, et al. (2015) Automated analysis of high-throughput B cell 
        sequencing data reveals a high frequency of novel immunoglobulin V gene 
        segment alleles. PNAS. 112(8):E862-70.
}
}
\seealso{
See \link{SampleDb} for Change-O formatted version of \code{AIRRDb}.
}
\keyword{data}
