% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thematic.R
\name{sequential_gradient}
\alias{sequential_gradient}
\title{Control parameters of the sequential colorscale}
\usage{
sequential_gradient(fg_weight = 0.9, bg_weight = 0, fg_low = TRUE, n = 30)
}
\arguments{
\item{fg_weight}{a number (between 0 and 1) defining much of the \code{fg}
color should be mixed into the colorscale.}

\item{bg_weight}{a number (between 0 and 1) defining much of the \code{bg}
color should be mixed into the colorscale.}

\item{fg_low}{if \code{TRUE} (the default), the \code{fg} color is used for the
low end of the colorscale (rather than the high end).}

\item{n}{number of color codes.}
}
\value{
a list of options for passing to the \code{sequential} argument of \code{\link[=thematic_on]{thematic_on()}}.
}
\description{
Controls the default weighting and direction of the color gradient
derived from the \code{fg}, \code{bg}, and \code{accent} color (defined in \code{thematic_on()}).
}
\examples{

# Gradient from fg to accent
fg <- sequential_gradient(1, 0)
thematic_on("black", "white", "salmon", sequential = fg)
ggplot2::qplot(1:10, 1:10, color = 1:10)

# Gradient from accent -> bg
bg <- sequential_gradient(0, 1)
thematic_on("black", "white", "salmon", sequential = bg)
ggplot2::qplot(1:10, 1:10, color = 1:10)

# Gradient from mix(accent, fg, 0.5) -> mix(accent, bg, 0.5)
mix <- sequential_gradient(0.5, 0.5)
thematic_on("black", "white", "salmon", sequential = mix)
ggplot2::qplot(1:10, 1:10, color = 1:10)

# Use fg (instead of bg) for high end of scale
mix_flip <- sequential_gradient(0.5, 0.5, fg_low = FALSE)
thematic_on("black", "white", "salmon", sequential = mix_flip)
ggplot2::qplot(1:10, 1:10, color = 1:10)

}
