% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_ThermalQuenching.R
\name{fit_ThermalQuenching}
\alias{fit_ThermalQuenching}
\title{Fitting Thermal Quenching Data}
\usage{
fit_ThermalQuenching(
  data,
  start_param = list(),
  method_control = list(),
  n.MC = 100,
  verbose = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{data}{\link{data.frame} (\strong{required}): input data with three columns, the first column contains
temperature values in deg. C, columns 2 and 3 the dependent values with its error}

\item{start_param}{\link{list} (\emph{optional}): option to provide the start
parameters for the fitting, see details}

\item{method_control}{\link{list} (\emph{optional}): further options to fine tune
the fitting, see details for
further information}

\item{n.MC}{\link{numeric} (\emph{with default}): number of Monte Carlo runs for the error estimation. If \code{n.MC} is
\code{NULL} or \verb{<=1}, the error estimation is skipped}

\item{verbose}{\link{logical} (\emph{with default}): enable/disable output to the
terminal.}

\item{plot}{\link{logical} (\emph{with default}): enable/disable the plot output.}

\item{...}{further arguments that can be passed to control the plotting, support are \code{main}, \code{pch},
\code{col_fit}, \code{col_points}, \code{lty}, \code{lwd}, \code{xlab}, \code{ylab}, \code{xlim}, \code{ylim}, \code{xaxt}}
}
\value{
The function returns numerical output and an (\emph{optional}) plot.

-----------------------------------\cr
\verb{[ NUMERICAL OUTPUT ]}\cr
-----------------------------------\cr

\strong{\code{RLum.Results}}-object

\strong{slot:} \strong{\verb{@data}}

\verb{[.. $data : data.frame]}\cr

A table with all fitting parameters and the number of Monte Carlo runs used for the error estimation.

\verb{[.. $fit : nls object]} \cr

The nls \link[stats:nls]{stats::nls} object returned by the function \link[minpack.lm:nlsLM]{minpack.lm::nlsLM}. This object
can be further passed to other functions supporting an nls object (cf. details section
in \link[stats:nls]{stats::nls})

\strong{slot:} \strong{\verb{@info}}

\verb{[.. $call : call]}\cr

The original function call.

-----------------------------------\cr
\verb{[ GAPHICAL OUTPUT ]}\cr
-----------------------------------\cr

Plotted are temperature against the signal and their uncertainties.
The fit is shown as dashed-line (can be modified). Please note that for the fitting the absolute
temperature values are used but are re-calculated to deg. C for the plot.
}
\description{
Applying a nls-fitting to thermal quenching data.
}
\details{
\strong{Used equation}\cr

The equation used for the fitting is

\deqn{y = (A / (1 + C * (exp(-W / (k * x))))) + c}

\emph{W} is the energy depth in eV and \emph{C} is dimensionless constant. \emph{A} and \emph{c} are used to
adjust the curve for the given signal. \emph{k} is the Boltzmann in eV/K and \emph{x} is the absolute
temperature in K.

\strong{Error estimation}\cr

The error estimation is done be varying the input parameters using the given uncertainties in
a Monte Carlo simulation. Errors are assumed to follow a normal distribution.

\strong{\code{start_param}} \cr

The function allows the injection of own start parameters via the argument \code{start_param}. The
parameters needs to be provided as names list. The names are the parameters to be optimised.
Examples: \code{start_param = list(A = 1, C = 1e+5, W = 0.5, c = 0)}

\strong{\code{method_control}} \cr

The following arguments can be provided via \code{method_control}. Please note that arguments provided
via \code{method_control} are not further tested, i.e., if the function crashes your input was probably
wrong.

\tabular{lll}{
\strong{ARGUMENT} \tab \strong{TYPE} \tab \strong{DESCRIPTION}\cr
\code{upper} \tab named \link{vector} \tab sets upper fitting boundaries, if provided boundaries for all arguments
are required, e.g., \code{c(A = 0, C = 0, W = 0, c = 0)} \cr
\code{lower} \tab names \link{vector} \tab set lower fitting boundaries (see \code{upper} for details) \cr
\code{trace}   \tab \link{logical} \tab enable/disable progression trace for \link[minpack.lm:nlsLM]{minpack.lm::nlsLM}\cr
\code{weights} \tab \link{numeric} \tab option to provide own weights for the fitting, the length of this
vector needs to be equal to the number for rows of the input \code{data.frame}. If set to \code{NULL} no weights
are applied. The weights are defined by the third column of the input \code{data.frame}.
}
}
\section{Function version}{
 0.1.0
}

\examples{

##create short example dataset
data <- data.frame(
  T = c(25, 40, 50, 60, 70, 80, 90, 100, 110),
  V = c(0.06, 0.058, 0.052, 0.051, 0.041, 0.034, 0.035, 0.033, 0.032),
  V_X = c(0.012, 0.009, 0.008, 0.008, 0.007, 0.006, 0.005, 0.005, 0.004))

##fit
fit_ThermalQuenching(
 data = data,
 n.MC = NULL)

} 

\section{How to cite}{
Kreutzer, S., 2025. fit_ThermalQuenching(): Fitting Thermal Quenching Data. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.0.1. https://r-lum.github.io/Luminescence/
}

\references{
Wintle, A.G., 1975. Thermal Quenching of Thermoluminescence in Quartz. Geophys. J. R. astr. Soc. 41, 107–113.
}
\seealso{
\link[minpack.lm:nlsLM]{minpack.lm::nlsLM}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
