% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NestorowaHSCData.R
\name{NestorowaHSCData}
\alias{NestorowaHSCData}
\title{Obtain the Nestorowa HSC data}
\usage{
NestorowaHSCData(remove.htseq = TRUE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{remove.htseq}{Logical scalar indicating whether HT-seq alignment statistics should be removed.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Obtain the mouse haematopoietic stem cell single-cell RNA-seq data from Nestorowa et al. (2015).
}
\details{
Rows corresponding to HT-seq's alignment statistics are removed by default.
These can be retained by setting \code{remove.htseq=FALSE}.

Column metadata includes the cell type mapping, as described on the website (see References),
and the FACS expression levels of selected markers.
Note that these are stored as nested matrices within the \code{\link{colData}}.

Diffusion map components are provided as the \code{"diffusion"} entry in the \code{\link{reducedDims}}.

Counts for ERCC spike-ins are stored in the \code{"ERCC"} entry in the \code{\link{altExps}}.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/nestorowa-hsc}.
}
\examples{
sce <- NestorowaHSCData()

}
\references{
Nestorowa S et al. (2016). 
A single-cell resolution map of mouse hematopoietic stem and progenitor cell differentiation
\emph{Blood} 128, e20-e31.

Gene and protein expression in adult haematopoiesis: Data.
\url{http://blood.stemcells.cam.ac.uk/single_cell_atlas.html#data}.
}
\author{
Aaron Lun
}
