# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers.aio import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPILogicAppsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.logic_apps.get(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            api_version="2024-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_create_or_update(self, resource_group):
        response = await self.client.logic_apps.create_or_update(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            resource={
                "id": "str",
                "name": "str",
                "properties": {},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2024-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delete(self, resource_group):
        response = await self.client.logic_apps.delete(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            api_version="2024-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_workflows(self, resource_group):
        response = self.client.logic_apps.list_workflows(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            api_version="2024-08-02-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_workflow(self, resource_group):
        response = await self.client.logic_apps.get_workflow(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            workflow_name="str",
            api_version="2024-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deploy_workflow_artifacts(self, resource_group):
        response = await self.client.logic_apps.deploy_workflow_artifacts(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            api_version="2024-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_workflows_connections(self, resource_group):
        response = await self.client.logic_apps.list_workflows_connections(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            api_version="2024-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_invoke(self, resource_group):
        response = await self.client.logic_apps.invoke(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            x_ms_logic_apps_proxy_path="str",
            x_ms_logic_apps_proxy_method="str",
            api_version="2024-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...
